/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.refactor;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.introduce.inplace.InplaceVariableIntroducer;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.intellij.grammar.psi.BnfExpression;
import org.intellij.grammar.psi.BnfRule;
import org.intellij.grammar.psi.impl.GrammarUtil;

public class BnfIntroduceRulePopup
extends InplaceVariableIntroducer<BnfExpression> {
    private static final String PRIVATE = "private ";
    private final JPanel myPanel = new JPanel(new GridBagLayout());
    private final JCheckBox myCheckBox = new NonFocusableCheckBox("Declare private");

    public BnfIntroduceRulePopup(Project project, Editor editor, BnfRule rule, BnfExpression expr) {
        super((PsiNamedElement)rule, editor, project, "Introduce Rule", (PsiElement[])GrammarUtil.EMPTY_EXPRESSIONS_ARRAY, (PsiElement)expr);
        this.myCheckBox.setSelected(true);
        this.myCheckBox.setMnemonic('p');
        this.myPanel.setBorder(null);
        this.myPanel.add((Component)this.myCheckBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insets((int)5), 0, 0));
        this.myPanel.add((Component)Box.createVerticalBox(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, (Insets)JBUI.emptyInsets(), 0, 0));
    }

    protected void moveOffsetAfter(boolean success) {
        RangeMarker exprMarker = this.getExprMarker();
        WriteAction.run(() -> {
            Document document = this.myEditor.getDocument();
            PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(document);
            if (exprMarker != null && exprMarker.isValid()) {
                this.myEditor.getCaretModel().moveToOffset(exprMarker.getStartOffset());
                this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
                exprMarker.dispose();
            }
        });
    }

    protected JComponent getComponent() {
        this.myCheckBox.addActionListener(e -> WriteCommandAction.writeCommandAction((Project)this.myProject).withName("Extract Rule").run(() -> this.perform(this.myCheckBox.isSelected())));
        return this.myPanel;
    }

    public void perform(boolean generatePrivate) {
        Runnable runnable = () -> {
            DocumentEx document = (DocumentEx)this.myEditor.getDocument();
            int exprOffset = this.myExprMarker.getStartOffset();
            int lineOffset = BnfIntroduceRulePopup.getLineOffset((Document)document, exprOffset);
            if (generatePrivate) {
                ArrayList<RangeMarker> leftGreedyMarker = new ArrayList<RangeMarker>();
                ArrayList<RangeMarker> emptyMarkers = new ArrayList<RangeMarker>();
                for (RangeHighlighter rangeHighlighter : this.myEditor.getMarkupModel().getAllHighlighters()) {
                    BnfIntroduceRulePopup.collectRangeMarker((RangeMarker)rangeHighlighter, lineOffset, leftGreedyMarker, emptyMarkers);
                }
                document.processRangeMarkers(rangeMarker -> {
                    BnfIntroduceRulePopup.collectRangeMarker(rangeMarker, lineOffset, leftGreedyMarker, emptyMarkers);
                    return true;
                });
                BnfIntroduceRulePopup.setLeftGreedy(leftGreedyMarker, false);
                BnfIntroduceRulePopup.setRightGreedy(emptyMarkers, true);
                document.insertString(lineOffset, (CharSequence)" ");
                document.insertString(lineOffset, (CharSequence)PRIVATE);
                document.deleteString(lineOffset + PRIVATE.length(), lineOffset + PRIVATE.length() + 1);
                BnfIntroduceRulePopup.setLeftGreedy(leftGreedyMarker, true);
                BnfIntroduceRulePopup.setRightGreedy(emptyMarkers, false);
            } else {
                int idx = document.getText().indexOf(PRIVATE, lineOffset);
                if (idx > -1 && idx < exprOffset) {
                    document.deleteString(idx, idx + PRIVATE.length());
                }
            }
            PsiDocumentManager.getInstance((Project)this.myProject).commitDocument((Document)document);
        };
        LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup((Editor)this.myEditor);
        if (lookup != null) {
            lookup.performGuardedChange(runnable);
        } else {
            runnable.run();
        }
    }

    private static void setRightGreedy(Collection<RangeMarker> rightRestore, boolean greedyToRight) {
        for (RangeMarker rangeMarker : rightRestore) {
            rangeMarker.setGreedyToRight(greedyToRight);
        }
    }

    private static void setLeftGreedy(Collection<RangeMarker> leftRestore, boolean greedyToLeft) {
        for (RangeMarker rangeMarker : leftRestore) {
            rangeMarker.setGreedyToLeft(greedyToLeft);
        }
    }

    private static void collectRangeMarker(RangeMarker rangeMarker, int lineOffset, Collection<RangeMarker> leftGreedyMarkers, Collection<RangeMarker> emptyMarkers) {
        if (rangeMarker.getStartOffset() == lineOffset && rangeMarker.isGreedyToLeft()) {
            leftGreedyMarkers.add(rangeMarker);
        }
        if (rangeMarker.getStartOffset() == lineOffset && rangeMarker.getEndOffset() == lineOffset && !rangeMarker.isGreedyToRight()) {
            emptyMarkers.add(rangeMarker);
        }
    }

    private static int getLineOffset(Document document, int offset) {
        return 0 <= offset && offset < document.getTextLength() ? document.getLineStartOffset(document.getLineNumber(offset)) : 0;
    }
}

