/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.refactor;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.codeInsight.template.impl.TextExpression;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.FinishMarkAction;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.intellij.grammar.KnownAttribute;
import org.intellij.grammar.generator.ParserGeneratorUtil;
import org.intellij.grammar.generator.RuleGraphHelper;
import org.intellij.grammar.psi.BnfAttr;
import org.intellij.grammar.psi.BnfAttrs;
import org.intellij.grammar.psi.BnfExpression;
import org.intellij.grammar.psi.BnfFile;
import org.intellij.grammar.psi.BnfListEntry;
import org.intellij.grammar.psi.BnfReferenceOrToken;
import org.intellij.grammar.psi.BnfStringLiteralExpression;
import org.intellij.grammar.psi.BnfValueList;
import org.intellij.grammar.psi.BnfVisitor;
import org.intellij.grammar.psi.impl.BnfElementFactory;
import org.intellij.grammar.psi.impl.GrammarUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BnfIntroduceTokenHandler
implements RefactoringActionHandler {
    public static final String REFACTORING_NAME = "Introduce Token";

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
    }

    public void invoke(final @NotNull Project project, final Editor editor, final PsiFile file, @Nullable DataContext dataContext) {
        Object tokenText;
        String tokenName;
        if (!(file instanceof BnfFile)) {
            return;
        }
        final BnfFile bnfFile = (BnfFile)file;
        Map<String, String> tokenNameMap = RuleGraphHelper.getTokenNameToTextMap(bnfFile);
        Map<String, String> tokenTextMap = RuleGraphHelper.getTokenTextToNameMap(bnfFile);
        BnfExpression target = (BnfExpression)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), (Class[])new Class[]{BnfReferenceOrToken.class, BnfStringLiteralExpression.class});
        if (target instanceof BnfReferenceOrToken) {
            if (bnfFile.getRule(target.getText()) != null) {
                return;
            }
            if (GrammarUtil.isExternalReference(target)) {
                return;
            }
            tokenName = target.getText();
            tokenText = "\"" + StringUtil.notNullize((String)tokenNameMap.get(tokenName), (String)tokenName) + "\"";
        } else if (target instanceof BnfStringLiteralExpression) {
            if (PsiTreeUtil.getParentOfType((PsiElement)target, BnfAttrs.class) != null) {
                return;
            }
            tokenText = target.getText();
            tokenName = tokenTextMap.get(GrammarUtil.unquote((String)tokenText));
        } else {
            return;
        }
        ArrayList allOccurrences = new ArrayList();
        final LinkedHashMap<OccurrencesChooser.ReplaceChoice, List<BnfExpression>> occurrencesMap = new LinkedHashMap<OccurrencesChooser.ReplaceChoice, List<BnfExpression>>();
        occurrencesMap.put(OccurrencesChooser.ReplaceChoice.NO, Collections.singletonList(target));
        occurrencesMap.put(OccurrencesChooser.ReplaceChoice.ALL, allOccurrences);
        BnfVisitor<Void> visitor = new BnfVisitor<Void>((String)tokenText, allOccurrences, tokenName){
            final /* synthetic */ String val$tokenText;
            final /* synthetic */ List val$allOccurrences;
            final /* synthetic */ String val$tokenName;
            {
                this.val$tokenText = string;
                this.val$allOccurrences = list;
                this.val$tokenName = string2;
            }

            @Override
            public Void visitStringLiteralExpression(@NotNull BnfStringLiteralExpression o) {
                if (Objects.equals(this.val$tokenText, o.getText())) {
                    this.val$allOccurrences.add(o);
                }
                return null;
            }

            @Override
            public Void visitReferenceOrToken(@NotNull BnfReferenceOrToken o) {
                if (GrammarUtil.isExternalReference(o)) {
                    return null;
                }
                if (this.val$tokenName != null && this.val$tokenName.equals(o.getText())) {
                    this.val$allOccurrences.add(o);
                }
                return null;
            }
        };
        for (PsiElement o : GrammarUtil.bnfTraverserNoAttrs((PsiElement)file)) {
            o.accept((PsiElementVisitor)visitor);
        }
        if (((List)occurrencesMap.get(OccurrencesChooser.ReplaceChoice.ALL)).size() <= 1 && !ApplicationManager.getApplication().isUnitTestMode()) {
            occurrencesMap.remove(OccurrencesChooser.ReplaceChoice.ALL);
        }
        Pass<OccurrencesChooser.ReplaceChoice> callback = new Pass<OccurrencesChooser.ReplaceChoice>((String)tokenText, tokenNameMap){
            final /* synthetic */ String val$tokenText;
            final /* synthetic */ Map val$tokenNameMap;
            {
                this.val$tokenText = string2;
                this.val$tokenNameMap = map2;
            }

            public void pass(OccurrencesChooser.ReplaceChoice choice) {
                WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{file}).withName(BnfIntroduceTokenHandler.REFACTORING_NAME).run(() -> {
                    try {
                        BnfIntroduceTokenHandler.buildTemplateAndRun(project, editor, bnfFile, (List)occurrencesMap.get(choice), tokenName, this.val$tokenText, this.val$tokenNameMap.keySet());
                    }
                    catch (StartMarkAction.AlreadyStartedException e) {
                        ExceptionUtil.rethrowAllAsUnchecked((Throwable)e);
                    }
                });
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            callback.pass((Object)OccurrencesChooser.ReplaceChoice.ALL);
        } else {
            new OccurrencesChooser<BnfExpression>(editor){

                protected TextRange getOccurrenceRange(BnfExpression occurrence) {
                    return occurrence.getTextRange();
                }
            }.showChooser((Pass)callback, occurrencesMap);
        }
    }

    private static void buildTemplateAndRun(final Project project, final Editor editor, BnfFile bnfFile, List<BnfExpression> occurrences, String tokenName, String tokenText, Set<String> tokenNames) throws StartMarkAction.AlreadyStartedException {
        final StartMarkAction startAction = StartMarkAction.start((Editor)editor, (Project)project, (String)REFACTORING_NAME);
        BnfListEntry entry = BnfIntroduceTokenHandler.addTokenDefinition(project, bnfFile, tokenName, tokenText, tokenNames);
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)bnfFile);
        PsiElement tokenId = Objects.requireNonNull(entry.getId());
        PsiElement tokenValue = Objects.requireNonNull(entry.getLiteralExpression());
        if (tokenName == null) {
            builder.replaceElement(tokenId, "TokenName", (Expression)new TextExpression(tokenId.getText()), true);
        }
        builder.replaceElement(tokenValue, "TokenText", (Expression)new TextExpression(tokenValue.getText()), true);
        for (BnfExpression occurrence : occurrences) {
            builder.replaceElement((PsiElement)occurrence, "Other", new Expression(){

                @Nullable
                public Result calculateResult(ExpressionContext context) {
                    TemplateState state = TemplateManagerImpl.getTemplateState((Editor)context.getEditor());
                    assert (state != null);
                    TextResult text = Objects.requireNonNull(state.getVariableValue("TokenText"));
                    String curText = GrammarUtil.unquote(text.getText());
                    if (ParserGeneratorUtil.isRegexpToken(curText)) {
                        return state.getVariableValue("TokenName");
                    }
                    return new TextResult("'" + curText + "'");
                }

                @Nullable
                public Result calculateQuickResult(ExpressionContext context) {
                    return this.calculateResult(context);
                }

                public LookupElement[] calculateLookupItems(ExpressionContext context) {
                    return LookupElement.EMPTY_ARRAY;
                }
            }, false);
        }
        final RangeMarker caretMarker = editor.getDocument().createRangeMarker(0, editor.getCaretModel().getOffset());
        caretMarker.setGreedyToRight(true);
        editor.getCaretModel().moveToOffset(0);
        Template template = builder.buildInlineTemplate();
        template.setToShortenLongNames(false);
        template.setToReformat(false);
        TemplateManager.getInstance((Project)project).startTemplate(editor, template, (TemplateEditingListener)new TemplateEditingAdapter(){

            public void templateFinished(@NotNull Template template, boolean brokenOff) {
                BnfIntroduceTokenHandler.handleTemplateFinished(project, editor, caretMarker, startAction);
            }

            public void templateCancelled(Template template) {
                BnfIntroduceTokenHandler.handleTemplateFinished(project, editor, caretMarker, startAction);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleTemplateFinished(Project project, Editor editor, RangeMarker caretMarker, StartMarkAction startAction) {
        try {
            editor.getCaretModel().moveToOffset(caretMarker.getEndOffset());
            editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        }
        finally {
            FinishMarkAction.finish((Project)project, (Editor)editor, (StartMarkAction)startAction);
        }
    }

    private static BnfListEntry addTokenDefinition(Project project, BnfFile bnfFile, String tokenName, String tokenText, Set<String> tokenNames) {
        List<BnfListEntry> entryList;
        String fixedTokenName = new UniqueNameGenerator(tokenNames, null).generateUniqueName(StringUtil.notNullize((String)tokenName, (String)"token"));
        String newAttrText = "tokens = [\n    " + fixedTokenName + "=" + StringUtil.notNullize((String)tokenText, (String)"\"\"") + "\n  ]";
        BnfAttr newAttr = BnfElementFactory.createAttributeFromText(project, newAttrText);
        BnfAttrs attrs = (BnfAttrs)ContainerUtil.getFirstItem(bnfFile.getAttributes());
        BnfAttr tokensAttr = null;
        if (attrs == null) {
            attrs = (BnfAttrs)bnfFile.addAfter(newAttr.getParent(), null);
            bnfFile.addAfter(BnfElementFactory.createLeafFromText(project, "\n"), attrs);
            tokensAttr = attrs.getAttrList().get(0);
            BnfValueList attrExpr = (BnfValueList)Objects.requireNonNull(tokensAttr.getExpression());
            return attrExpr.getListEntryList().get(0);
        }
        for (BnfAttr attr : attrs.getAttrList()) {
            if (!KnownAttribute.TOKENS.getName().equals(attr.getName())) continue;
            tokensAttr = attr;
        }
        if (tokensAttr == null) {
            List<BnfAttr> attrList = attrs.getAttrList();
            PsiElement anchor = attrList.isEmpty() ? attrs.getFirstChild() : (PsiElement)attrList.get(attrList.size() - 1);
            newAttr = (BnfAttr)attrs.addAfter(newAttr, anchor);
            attrs.addAfter(BnfElementFactory.createLeafFromText(project, "\n  "), anchor);
            BnfValueList attrExpr = (BnfValueList)Objects.requireNonNull(newAttr.getExpression());
            return attrExpr.getListEntryList().get(0);
        }
        BnfExpression expression = tokensAttr.getExpression();
        List<BnfListEntry> list = entryList = expression instanceof BnfValueList ? ((BnfValueList)expression).getListEntryList() : null;
        if (entryList == null || entryList.isEmpty()) {
            tokensAttr = (BnfAttr)tokensAttr.replace(newAttr);
            BnfValueList attrExpr = (BnfValueList)Objects.requireNonNull(tokensAttr.getExpression());
            return attrExpr.getListEntryList().get(0);
        }
        for (BnfListEntry entry : entryList) {
            PsiElement id = entry.getId();
            if (id == null || !id.getText().equals(tokenName)) continue;
            return entry;
        }
        BnfValueList attrExpr = (BnfValueList)Objects.requireNonNull(newAttr.getExpression());
        BnfListEntry newValue = attrExpr.getListEntryList().get(0);
        PsiElement anchor = entryList.get(entryList.size() - 1);
        newValue = (BnfListEntry)expression.addAfter(newValue, anchor);
        expression.addAfter(BnfElementFactory.createLeafFromText(project, "\n    "), anchor);
        return newValue;
    }
}

