/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.refactor;

import com.intellij.BundleBase;
import com.intellij.openapi.project.Project;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.inline.InlineOptionsDialog;
import com.intellij.usageView.UsageViewNodeTextLocation;
import org.intellij.grammar.psi.BnfRule;
import org.intellij.grammar.refactor.BnfInlineRuleProcessor;

public class InlineRuleDialog
extends InlineOptionsDialog {
    private final PsiReference myReference;
    private final BnfRule myRule;

    public InlineRuleDialog(Project project, BnfRule rule, PsiReference ref) {
        super(project, true, (PsiElement)rule);
        this.myRule = rule;
        this.myReference = ref;
        this.myInvokedOnReference = this.myReference != null;
        this.setTitle("Inline Rule");
        this.init();
    }

    protected String getNameLabelText() {
        return ElementDescriptionUtil.getElementDescription((PsiElement)this.myElement, (ElementDescriptionLocation)UsageViewNodeTextLocation.INSTANCE);
    }

    protected String getBorderTitle() {
        return "Inline";
    }

    protected String getInlineThisText() {
        return BundleBase.replaceMnemonicAmpersand((String)"&This reference only and keep the rule");
    }

    protected String getInlineAllText() {
        return BundleBase.replaceMnemonicAmpersand((String)"&All references and remove the rule");
    }

    protected boolean isInlineThis() {
        return false;
    }

    protected void doAction() {
        this.invokeRefactoring(new BnfInlineRuleProcessor(this.myRule, this.getProject(), this.myReference, this.isInlineThisOnly()));
    }

    protected void doHelpAction() {
    }
}

