/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.jflex.editor;

import com.intellij.lang.ASTNode;
import com.intellij.lang.cacheBuilder.WordsScanner;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionProvider;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.usageView.UsageViewLongNameLocation;
import com.intellij.usageView.UsageViewNodeTextLocation;
import com.intellij.usageView.UsageViewShortNameLocation;
import com.intellij.usageView.UsageViewTypeLocation;
import java.util.Collection;
import org.apache.xmlbeans.impl.common.NameUtil;
import org.intellij.jflex.psi.JFlexComposite;
import org.intellij.jflex.psi.JFlexMacroDefinition;
import org.intellij.jflex.psi.JFlexStateDefinition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JFlexFindUsagesProvider
implements FindUsagesProvider,
ElementDescriptionProvider {
    public WordsScanner getWordsScanner() {
        return null;
    }

    public boolean canFindUsagesFor(@NotNull PsiElement psiElement) {
        return psiElement instanceof JFlexComposite && psiElement instanceof PsiNamedElement;
    }

    public String getHelpId(@NotNull PsiElement psiElement) {
        return null;
    }

    @NotNull
    public String getType(@NotNull PsiElement element) {
        return ElementDescriptionUtil.getElementDescription((PsiElement)element, (ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE);
    }

    @NotNull
    public String getDescriptiveName(@NotNull PsiElement element) {
        return ElementDescriptionUtil.getElementDescription((PsiElement)element, (ElementDescriptionLocation)UsageViewLongNameLocation.INSTANCE);
    }

    @NotNull
    public String getNodeText(@NotNull PsiElement element, boolean useFullName) {
        return ElementDescriptionUtil.getElementDescription((PsiElement)element, (ElementDescriptionLocation)UsageViewNodeTextLocation.INSTANCE);
    }

    @Nullable
    public String getElementDescription(@NotNull PsiElement psiElement, @NotNull ElementDescriptionLocation location) {
        if (location == UsageViewNodeTextLocation.INSTANCE && psiElement instanceof JFlexComposite) {
            return this.getElementDescription(psiElement, (ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE) + " '" + this.getElementDescription(psiElement, (ElementDescriptionLocation)UsageViewShortNameLocation.INSTANCE) + "'";
        }
        if (psiElement instanceof JFlexMacroDefinition) {
            if (location == UsageViewTypeLocation.INSTANCE) {
                return "Macro Definition";
            }
            return ((JFlexMacroDefinition)psiElement).getName();
        }
        if (psiElement instanceof JFlexStateDefinition) {
            if (location == UsageViewTypeLocation.INSTANCE) {
                return "State Definition";
            }
            return ((JFlexStateDefinition)psiElement).getName();
        }
        if (psiElement instanceof JFlexComposite) {
            if (location == UsageViewTypeLocation.INSTANCE) {
                ASTNode node = psiElement.getNode();
                return node == null ? "Initial State" : StringUtil.join((Collection)NameUtil.splitWords((String)node.getElementType().toString(), (boolean)false), (String)" ");
            }
            return psiElement instanceof PsiNamedElement ? ((PsiNamedElement)psiElement).getName() : psiElement.getClass().getSimpleName();
        }
        return null;
    }
}

