/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.jflex.psi.impl;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.intellij.grammar.config.Options;
import org.intellij.jflex.psi.JFlexDeclarationsSection;
import org.intellij.jflex.psi.JFlexJavaCode;
import org.intellij.jflex.psi.JFlexOption;
import org.intellij.jflex.psi.JFlexRule;
import org.intellij.jflex.psi.JFlexStateDefinition;
import org.intellij.jflex.psi.JFlexTypes;
import org.intellij.jflex.psi.JFlexUserCodeSection;
import org.intellij.jflex.psi.impl.JFlexJavaCodeInjectionHostImpl;
import org.intellij.jflex.psi.impl.JFlexLexicalRulesSectionImpl;
import org.jetbrains.annotations.NotNull;

public class JFlexJavaCodeInjector
implements MultiHostInjector {
    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        return Collections.singletonList(JFlexJavaCode.class);
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        if (!(context instanceof JFlexJavaCodeInjectionHostImpl)) {
            return;
        }
        if (!((Boolean)Options.INJECT_JAVA_IN_JFLEX.get()).booleanValue()) {
            return;
        }
        PsiFile file = context.getContainingFile();
        Map<IElementType, String> options = JFlexJavaCodeInjector.collectOptions(file);
        boolean isPublic = options.containsKey(JFlexTypes.FLEX_OPT_PUBLIC);
        boolean isFinal = options.containsKey(JFlexTypes.FLEX_OPT_FINAL);
        String lexerClass = (String)ObjectUtils.notNull((Object)StringUtil.nullize((String)options.get(JFlexTypes.FLEX_OPT_CLASS)), (Object)"Lexer");
        String returnType = (String)ObjectUtils.notNull((Object)StringUtil.nullize((String)options.get(JFlexTypes.FLEX_OPT_TYPE)), (Object)"int");
        String implementsStr = (String)ObjectUtils.notNull((Object)StringUtil.nullize((String)options.get(JFlexTypes.FLEX_OPT_IMPLEMENTS)), (Object)"");
        JFlexRule lastRule = (JFlexRule)((SyntaxTraverser)SyntaxTraverser.revPsiTraverser().withRoot((Object)PsiTreeUtil.findChildOfType((PsiElement)file, JFlexLexicalRulesSectionImpl.class))).filter(JFlexRule.class).filter(o -> o.getJavaCode() != null).first();
        int ruleCount = 0;
        registrar.startInjecting((Language)JavaLanguage.INSTANCE);
        JBIterable s = SyntaxTraverser.psiTraverser((PsiElement)file).filter(JFlexJavaCodeInjectionHostImpl.class);
        for (JFlexJavaCodeInjectionHostImpl host : s) {
            PsiElement hostParent = host.getParent();
            if (hostParent instanceof JFlexUserCodeSection) {
                StringBuilder sb = new StringBuilder("\n");
                sb.append("/** @noinspection ALL*/");
                if (isPublic) {
                    sb.append("public ");
                }
                if (isFinal) {
                    sb.append("final ");
                }
                sb.append("class ").append(lexerClass);
                if (implementsStr.isEmpty()) {
                    sb.append(" implements ").append(implementsStr);
                }
                sb.append(" {\n\n");
                JBIterable states = SyntaxTraverser.psiTraverser((PsiElement)PsiTreeUtil.findChildOfType((PsiElement)file, JFlexDeclarationsSection.class)).filter(JFlexStateDefinition.class);
                sb.append("  public static final int YYINITIAL = 0;\n");
                int i = 1;
                for (JFlexStateDefinition element : states) {
                    sb.append("  public static final int ").append(element.getName()).append(" = ").append(i += 2).append(";\n");
                }
                sb.append("\n");
                sb.append("  public ").append(lexerClass).append("(java.io.Reader in) {}\n");
                sb.append("  private int zzState, zzLexicalState;\n");
                sb.append("  private int zzStartRead, zzEndRead, zzCurrentPos, zzMarkedPos;\n");
                sb.append("  private void yybegin(int state) {}\n");
                sb.append("  private void yypushback(int pos) {}\n");
                sb.append("  private int yystate() { return 0; }\n");
                sb.append("  private int yylength() { return 0; }\n");
                sb.append("  private char yycharat(int pos) { return 0; }\n");
                sb.append("\n");
                registrar.addPlace(null, sb.toString(), (PsiLanguageInjectionHost)host, new TextRange(0, host.getTextLength()));
                continue;
            }
            if (hostParent instanceof JFlexOption) {
                IElementType optionType = PsiUtilCore.getElementType((PsiElement)hostParent.getFirstChild());
                if (optionType == JFlexTypes.FLEX_OPT_CODE1) {
                    registrar.addPlace(null, null, (PsiLanguageInjectionHost)host, new TextRange(0, host.getTextLength()));
                    continue;
                }
                if (optionType == JFlexTypes.FLEX_OPT_INIT1) {
                    registrar.addPlace("\n  {\n", "\n  }\n", (PsiLanguageInjectionHost)host, new TextRange(0, host.getTextLength()));
                    continue;
                }
                if (optionType != JFlexTypes.FLEX_OPT_EOF1 && optionType != JFlexTypes.FLEX_OPT_EOFVAL1) continue;
                registrar.addPlace("\n  void yy_do_eof() {\n", "\n  }\n", (PsiLanguageInjectionHost)host, new TextRange(0, host.getTextLength()));
                continue;
            }
            if (!(hostParent instanceof JFlexRule)) continue;
            Object prefix = ruleCount == 0 ? "\n  public " + returnType + " advance() throws java.io.IOException {\n    switch(zzLexicalState) {" : "";
            String suffix = hostParent == lastRule ? "\n    }\n    return null;\n  }\n}" : null;
            registrar.addPlace((String)prefix + "\n    case " + ++ruleCount + ":\n      ", suffix, (PsiLanguageInjectionHost)host, new TextRange(0, host.getTextLength()));
        }
        registrar.doneInjecting();
    }

    @NotNull
    private static Map<IElementType, String> collectOptions(@NotNull PsiFile file) {
        PsiElement declarationsSection = PsiTreeUtil.findChildOfType((PsiElement)file, JFlexDeclarationsSection.class);
        if (declarationsSection == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<IElementType, String> result = new LinkedHashMap<IElementType, String>();
        for (JFlexOption o : SyntaxTraverser.psiApi().children((Object)declarationsSection).filter(JFlexOption.class)) {
            IElementType key = PsiUtilCore.getElementType((PsiElement)o.getFirstChild());
            String value = TextRange.create((int)o.getFirstChild().getTextLength(), (int)o.getTextLength()).substring(o.getText()).trim();
            String prevValue = StringUtil.nullize((String)((String)result.get(key)));
            result.put(key, (String)(prevValue == null ? value : (value.isEmpty() ? prevValue : prevValue + ", " + value)));
        }
        return result;
    }
}

