/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.jflex.psi.impl;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.intellij.jflex.psi.JFlexLexicalRulesSection;
import org.intellij.jflex.psi.JFlexMacroDefinition;
import org.intellij.jflex.psi.JFlexMacroReference;
import org.intellij.jflex.psi.JFlexPsiElementFactory;
import org.intellij.jflex.psi.JFlexStateDefinition;
import org.intellij.jflex.psi.JFlexStateReference;
import org.intellij.jflex.psi.JFlexUserCodeSection;
import org.intellij.jflex.psi.impl.JavaRefHelper;
import org.intellij.jflex.psi.impl.StateRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JFlexPsiImplUtil
extends JavaRefHelper {
    @NotNull
    public static String getName(PsiNameIdentifierOwner o) {
        return Objects.requireNonNull(o.getNameIdentifier()).getText();
    }

    @NotNull
    public static PsiNameIdentifierOwner setName(PsiNameIdentifierOwner o, String newName) {
        Objects.requireNonNull(o.getNameIdentifier()).replace(JFlexPsiElementFactory.createIdFromText(o.getProject(), newName));
        return o;
    }

    @NotNull
    public static PsiElement getNameIdentifier(JFlexMacroDefinition o) {
        return o.getId();
    }

    @NotNull
    public static PsiReference getReference(JFlexMacroReference o) {
        return new PsiReferenceBase<JFlexMacroReference>(o, TextRange.from((int)0, (int)o.getTextRange().getLength())){

            @Nullable
            public PsiElement resolve() {
                final String name = ((JFlexMacroReference)this.getElement()).getId().getText();
                CommonProcessors.FindFirstProcessor<JFlexMacroDefinition> processor = new CommonProcessors.FindFirstProcessor<JFlexMacroDefinition>(){

                    protected boolean accept(JFlexMacroDefinition o) {
                        return Objects.equals(o.getName(), name);
                    }
                };
                JFlexPsiImplUtil.processMacroVariants(this.getElement(), (Processor<JFlexMacroDefinition>)processor);
                return (PsiElement)processor.getFoundValue();
            }

            public Object @NotNull [] getVariants() {
                CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
                JFlexPsiImplUtil.processMacroVariants(this.getElement(), (Processor<JFlexMacroDefinition>)processor);
                return ArrayUtil.toObjectArray((Collection)processor.getResults());
            }

            public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
                return ((JFlexMacroReference)this.getElement()).getId().replace(JFlexPsiElementFactory.createIdFromText(((JFlexMacroReference)this.getElement()).getProject(), newElementName));
            }
        };
    }

    private static boolean processMacroVariants(PsiElement context, Processor<JFlexMacroDefinition> processor) {
        PsiFile containingFile = context.getContainingFile();
        List macros = (List)CachedValuesManager.getCachedValue((PsiElement)containingFile, () -> CachedValueProvider.Result.create(JFlexPsiImplUtil.computeDefinitions(containingFile, JFlexMacroDefinition.class), (Object[])new Object[]{containingFile}));
        return ContainerUtil.process((List)macros, processor);
    }

    public static <T> List<T> computeDefinitions(PsiFile psiFile, final Class<T> clazz) {
        final ArrayList result = new ArrayList();
        psiFile.acceptChildren((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (clazz.isInstance(element)) {
                    result.add(element);
                } else if (!(element instanceof JFlexLexicalRulesSection) && !(element instanceof JFlexUserCodeSection)) {
                    super.visitElement(element);
                }
            }
        });
        return result;
    }

    @NotNull
    public static PsiElement getNameIdentifier(JFlexStateDefinition o) {
        return o.getId();
    }

    @NotNull
    public static PsiReference getReference(JFlexStateReference o) {
        return new StateRef(o);
    }

    public static boolean isYYINITIAL(String s) {
        return "YYINITIAL".equals(s);
    }
}

