/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.jflex.psi.impl;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.TreeTraversal;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.jflex.psi.JFlexJavaCode;
import org.intellij.jflex.psi.JFlexJavaType;
import org.intellij.jflex.psi.JFlexPsiElementFactory;
import org.intellij.jflex.psi.JFlexRule;
import org.intellij.jflex.psi.JFlexUserCodeSection;
import org.intellij.jflex.psi.impl.StateRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaRefHelper {
    private static final Pattern RETURN_PAT = Pattern.compile("return\\s+([^;}]+)");
    private static final Pattern YYBEGIN_PAT = Pattern.compile("yybegin\\s*\\(\\s*([^)]+)\\)");

    public static PsiReference[] getReferences(JFlexJavaCode o) {
        PsiElement parent = o.getParent();
        if (parent instanceof JFlexRule) {
            return JavaRefHelper.getRuleReferences(o);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static PsiReference @NotNull [] getRuleReferences(@NotNull JFlexJavaCode o) {
        String text = o.getText();
        SmartList list = new SmartList();
        Matcher matcher = YYBEGIN_PAT.matcher(text);
        int offset = 0;
        while (matcher.find(offset)) {
            list.add(new StateRef(o, TextRange.create((int)matcher.start(1), (int)matcher.end(1))));
            offset = matcher.end() + 1;
        }
        matcher = RETURN_PAT.matcher(text);
        offset = 0;
        while (matcher.find(offset)) {
            String refText = matcher.group(1);
            PsiFile javaFile = JavaRefHelper.createJavaFileForExpr("return " + refText + ";", o);
            ContainerUtil.addAll((Collection)list, (Object[])JavaRefHelper.wrapJavaReferences(o, matcher.start(1), javaFile, refText));
            offset = matcher.end() + 1;
        }
        return list.isEmpty() ? PsiReference.EMPTY_ARRAY : list.toArray(PsiReference.EMPTY_ARRAY);
    }

    public static PsiReference @NotNull [] getReferences(@NotNull JFlexJavaType o) {
        String refText = o.getText();
        PsiFile javaFile = JavaRefHelper.createJavaFileForExpr(refText + " val", o);
        return JavaRefHelper.wrapJavaReferences(o, 0, javaFile, refText);
    }

    private static PsiReference[] wrapJavaReferences(@NotNull PsiElement o, int javaOffset, PsiFile javaFile, String targetText) {
        int start = javaFile.getText().lastIndexOf(targetText);
        int end = start + targetText.length();
        SmartList list = new SmartList();
        for (PsiElement e : SyntaxTraverser.psiTraverser((PsiElement)javaFile).traverse(TreeTraversal.LEAVES_BFS)) {
            PsiReference ref;
            TextRange r = e.getTextRange();
            if (!r.intersects(start, end) || (ref = javaFile.findReferenceAt(r.getStartOffset())) == null) continue;
            TextRange rr = ref.getRangeInElement();
            TextRange er = ref.getElement().getTextRange();
            list.add(new PsiReferenceBase<PsiElement>(o, rr.shiftRight(javaOffset + er.getStartOffset() - start)){

                @Nullable
                public PsiElement resolve() {
                    return ref.resolve();
                }

                public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
                    PsiElement e = this.getElement();
                    String text = StringUtil.replaceSubstring((String)e.getText(), (TextRange)this.getRangeInElement(), (String)newElementName);
                    return e.replace(JFlexPsiElementFactory.createJavaTypeFromText(e.getProject(), text));
                }

                public Object @NotNull [] getVariants() {
                    return ArrayUtil.EMPTY_OBJECT_ARRAY;
                }
            });
        }
        return list.isEmpty() ? PsiReference.EMPTY_ARRAY : list.toArray(PsiReference.EMPTY_ARRAY);
    }

    @NotNull
    public static PsiFile createJavaFileForExpr(String text, PsiElement context) {
        JFlexJavaCode userCode = (JFlexJavaCode)SyntaxTraverser.psiTraverser((PsiElement)context.getContainingFile()).filter(JFlexJavaCode.class).first();
        String imports = userCode == null || !(userCode.getParent() instanceof JFlexUserCodeSection) ? "" : userCode.getText();
        String fileText = imports + "\nclass A { void f() { " + text + " } }";
        FileType javaType = FileTypeManager.getInstance().getFileTypeByExtension("java");
        return PsiFileFactory.getInstance((Project)context.getProject()).createFileFromText("a.java", javaType, (CharSequence)fileText);
    }
}

