/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.jflex.psi.impl;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.intellij.jflex.psi.JFlexComposite;
import org.intellij.jflex.psi.JFlexJavaCode;
import org.intellij.jflex.psi.JFlexPsiElementFactory;
import org.intellij.jflex.psi.JFlexStateDefinition;
import org.intellij.jflex.psi.JFlexStateReference;
import org.intellij.jflex.psi.impl.JFlexPsiImplUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StateRef
extends PsiReferenceBase<PsiElement> {
    private static final Key<YYINITIALElement> YYINITIAL_ELEMENT = Key.create((String)"YYINITIAL_ELEMENT");

    StateRef(JFlexStateReference o) {
        super((PsiElement)o, TextRange.from((int)0, (int)o.getTextRange().getLength()));
    }

    StateRef(JFlexJavaCode o, TextRange range) {
        super((PsiElement)o, range);
    }

    @Nullable
    public PsiElement resolve() {
        final String name = this.getRangeInElement().substring(this.getElement().getText());
        if (JFlexPsiImplUtil.isYYINITIAL(name)) {
            return StateRef.resolveYYINITIAL(this.getElement());
        }
        CommonProcessors.FindFirstProcessor<JFlexStateDefinition> processor = new CommonProcessors.FindFirstProcessor<JFlexStateDefinition>(){

            protected boolean accept(JFlexStateDefinition o) {
                return Objects.equals(o.getName(), name);
            }
        };
        StateRef.processStateVariants(this.getElement(), (Processor<? super JFlexStateDefinition>)processor);
        return (PsiElement)processor.getFoundValue();
    }

    public Object @NotNull [] getVariants() {
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        processor.process((Object)StateRef.resolveYYINITIAL(this.getElement()));
        StateRef.processStateVariants(this.getElement(), (Processor<? super JFlexStateDefinition>)processor);
        return ArrayUtil.toObjectArray((Collection)processor.getResults());
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        PsiElement e = this.getElement();
        if (e instanceof JFlexStateReference) {
            return ((JFlexStateReference)e).getId().replace(JFlexPsiElementFactory.createIdFromText(e.getProject(), newElementName));
        }
        if (e instanceof JFlexJavaCode) {
            String text = StringUtil.replaceSubstring((String)e.getText(), (TextRange)this.getRangeInElement(), (String)newElementName);
            return e.replace(JFlexPsiElementFactory.createJavaCodeFromText(e.getProject(), text));
        }
        throw new UnsupportedOperationException(e.toString());
    }

    private static boolean processStateVariants(PsiElement context, Processor<? super JFlexStateDefinition> processor) {
        PsiFile containingFile = context.getContainingFile();
        List macros = (List)CachedValuesManager.getCachedValue((PsiElement)containingFile, () -> CachedValueProvider.Result.create(JFlexPsiImplUtil.computeDefinitions(containingFile, JFlexStateDefinition.class), (Object[])new Object[]{containingFile}));
        return ContainerUtil.process((List)macros, processor);
    }

    private static YYINITIALElement resolveYYINITIAL(PsiElement element) {
        PsiFile containingFile = element.getContainingFile();
        return (YYINITIALElement)((UserDataHolderEx)containingFile).putUserDataIfAbsent(YYINITIAL_ELEMENT, (Object)new YYINITIALElement(containingFile));
    }

    private static class YYINITIALElement
    extends RenameableFakePsiElement
    implements JFlexComposite,
    PsiNameIdentifierOwner {
        YYINITIALElement(PsiFile containingFile) {
            super((PsiElement)containingFile);
        }

        public String getName() {
            return "YYINITIAL";
        }

        public void navigate(boolean requestFocus) {
        }

        public String getTypeName() {
            return "Initial State";
        }

        @Nullable
        public Icon getIcon() {
            return null;
        }

        @Nullable
        public PsiElement getNameIdentifier() {
            return null;
        }
    }
}

