/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.intellij.grammar.BnfIcons;
import org.intellij.grammar.BnfLanguage;
import org.intellij.grammar.KnownAttribute;
import org.intellij.grammar.generator.ParserGeneratorUtil;
import org.intellij.grammar.generator.RuleGraphHelper;
import org.intellij.grammar.java.JavaHelper;
import org.intellij.grammar.parser.GeneratedParserUtilBase;
import org.intellij.grammar.psi.BnfAttr;
import org.intellij.grammar.psi.BnfAttrs;
import org.intellij.grammar.psi.BnfComposite;
import org.intellij.grammar.psi.BnfExpression;
import org.intellij.grammar.psi.BnfFile;
import org.intellij.grammar.psi.BnfParenExpression;
import org.intellij.grammar.psi.BnfReferenceOrToken;
import org.intellij.grammar.psi.BnfRule;
import org.intellij.grammar.psi.BnfTypes;
import org.intellij.grammar.psi.impl.BnfReferenceImpl;
import org.intellij.grammar.psi.impl.GrammarUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BnfCompletionContributor
extends CompletionContributor {
    public BnfCompletionContributor() {
        PsiElementPattern.Capture placePattern = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().inFile((ElementPattern)StandardPatterns.instanceOf(BnfFile.class))).andNot((ElementPattern)PlatformPatterns.psiElement().inside(PsiComment.class));
        this.extend(CompletionType.BASIC, (ElementPattern)placePattern, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                BnfAttr attr;
                PsiElement position = parameters.getPosition();
                BnfComposite parent = (BnfComposite)PsiTreeUtil.getParentOfType((PsiElement)position, (Class[])new Class[]{BnfAttrs.class, BnfAttr.class, BnfParenExpression.class});
                boolean attrCompletion = parent instanceof BnfAttrs || BnfCompletionContributor.isPossibleEmptyAttrs(parent) ? true : (parent instanceof BnfAttr ? position == (attr = (BnfAttr)parent).getId() || BnfCompletionContributor.isOneAfterAnother(attr.getExpression(), position) : false);
                if (attrCompletion) {
                    boolean inRule = PsiTreeUtil.getParentOfType((PsiElement)parent, BnfRule.class) != null;
                    ASTNode closingBrace = TreeUtil.findSiblingBackward((ASTNode)parent.getNode().getLastChildNode(), (IElementType)BnfTypes.BNF_RIGHT_BRACE);
                    boolean bl = attrCompletion = closingBrace == null || position.getTextOffset() <= closingBrace.getStartOffset();
                    if (attrCompletion) {
                        for (KnownAttribute<?> attribute : KnownAttribute.getAttributes()) {
                            if (inRule && attribute.isGlobal()) continue;
                            result.addElement((LookupElement)LookupElementBuilder.create((String)attribute.getName()).withIcon(BnfIcons.ATTRIBUTE));
                        }
                    }
                }
                if (!attrCompletion && parameters.getInvocationCount() < 2) {
                    for (String keywords : BnfCompletionContributor.suggestKeywords(parameters.getPosition())) {
                        result.addElement((LookupElement)TailTypeDecorator.withTail((LookupElement)LookupElementBuilder.create((String)keywords), (TailType)TailType.SPACE));
                    }
                }
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)placePattern.andNot((ElementPattern)PlatformPatterns.psiElement().inside(false, (ElementPattern)PlatformPatterns.psiElement(BnfAttr.class))), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                BnfFile file = (BnfFile)parameters.getOriginalFile();
                PsiElement positionRefOrToken = PsiTreeUtil.getParentOfType((PsiElement)parameters.getOriginalPosition(), BnfReferenceOrToken.class);
                Set<String> explicitTokens = RuleGraphHelper.getTokenNameToTextMap(file).keySet();
                for (String s : explicitTokens) {
                    result.addElement((LookupElement)LookupElementBuilder.create((String)s));
                }
                for (BnfRule rule : file.getRules()) {
                    for (BnfReferenceOrToken element : SyntaxTraverser.psiTraverser((PsiElement)rule.getExpression()).filter(BnfReferenceOrToken.class)) {
                        if (element == positionRefOrToken || element.resolveRule() != null) continue;
                        result.addElement((LookupElement)LookupElementBuilder.create((String)element.getText()));
                    }
                }
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)placePattern.withParent((ElementPattern)PlatformPatterns.psiElement(BnfExpression.class).withReference(BnfReferenceImpl.class)), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                BnfRule rule2;
                BnfFile bnfFile = (BnfFile)parameters.getOriginalFile();
                PsiElement posExpression = PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), BnfExpression.class);
                boolean isExternal = GrammarUtil.isExternalReference(posExpression);
                for (BnfRule rule2 : bnfFile.getRules()) {
                    boolean fakeRule = ParserGeneratorUtil.Rule.isFake(rule2);
                    boolean privateRule = ParserGeneratorUtil.Rule.isPrivate(rule2);
                    if (isExternal && !ParserGeneratorUtil.Rule.isMeta(rule2)) continue;
                    String idText = rule2.getId().getText();
                    LookupElementBuilder e = LookupElementBuilder.create((Object)rule2, (String)idText).withIcon(rule2.getIcon(0)).withBoldness(!privateRule).withStrikeoutness(fakeRule);
                    if (!Objects.equals(idText, rule2.getName())) {
                        e = e.withLookupString(rule2.getName());
                    }
                    result.addElement((LookupElement)e);
                }
                if (!isExternal) {
                    return;
                }
                BnfRule posRule = (BnfRule)PsiTreeUtil.getParentOfType((PsiElement)posExpression, BnfRule.class);
                BnfRule bnfRule = rule2 = posRule == null ? null : (BnfRule)CompletionUtil.getOriginalElement((PsiElement)posRule);
                if (rule2 == null) {
                    return;
                }
                String parserClass = ParserGeneratorUtil.getAttribute(rule2, KnownAttribute.PARSER_UTIL_CLASS);
                if (StringUtil.isNotEmpty((String)parserClass)) {
                    JavaHelper helper = JavaHelper.getJavaHelper(rule2);
                    String className = parserClass;
                    while (className != null) {
                        for (NavigatablePsiElement element : helper.findClassMethods(className, JavaHelper.MethodType.STATIC, "*", -1, "com.intellij.lang.PsiBuilder", "int")) {
                            List<String> methodTypes = helper.getMethodTypes(element);
                            if (!"boolean".equals(ContainerUtil.getFirstItem(methodTypes))) continue;
                            result.addElement((LookupElement)LookupElementBuilder.createWithIcon((PsiNamedElement)((PsiNamedElement)element)));
                        }
                        className = helper.getSuperClassName(className);
                    }
                }
            }
        });
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        BnfFile file = (BnfFile)ObjectUtils.tryCast((Object)context.getFile(), BnfFile.class);
        if (file == null) {
            return;
        }
        int offset = context.getStartOffset();
        PsiElement element = file.findElementAt(offset);
        if (PsiUtilCore.getElementType((PsiElement)element) == BnfTypes.BNF_ID) {
            context.setDummyIdentifier("");
        }
    }

    @Contract(value="null -> false")
    private static boolean isPossibleEmptyAttrs(PsiElement attrs) {
        if (!(attrs instanceof BnfParenExpression)) {
            return false;
        }
        if (attrs.getFirstChild().getNode().getElementType() != BnfTypes.BNF_LEFT_BRACE) {
            return false;
        }
        if (!(((BnfParenExpression)attrs).getExpression() instanceof BnfReferenceOrToken)) {
            return false;
        }
        return BnfCompletionContributor.isLastInRuleOrFree(attrs);
    }

    private static boolean isOneAfterAnother(@Nullable PsiElement e1, @Nullable PsiElement e2) {
        if (e1 == null || e2 == null) {
            return false;
        }
        return e1.getTextRange().getEndOffset() < e2.getTextRange().getStartOffset();
    }

    private static boolean isLastInRuleOrFree(PsiElement element) {
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{BnfRule.class, GeneratedParserUtilBase.DummyBlock.class});
        if (parent instanceof GeneratedParserUtilBase.DummyBlock) {
            return true;
        }
        if (!(parent instanceof BnfRule)) {
            return false;
        }
        PsiElement cur = element;
        PsiElement next = cur.getNextSibling();
        while (next == null || next instanceof PsiComment || next instanceof PsiWhiteSpace) {
            if (next == null) {
                PsiElement curParent;
                for (curParent = cur.getParent(); next == null && curParent != parent; curParent = curParent.getParent()) {
                    next = curParent.getNextSibling();
                }
                if (curParent == parent) {
                    return true;
                }
                next = PsiTreeUtil.getDeepestFirst((PsiElement)next);
            }
            cur = next;
            next = cur.getNextSibling();
        }
        return false;
    }

    private static Collection<String> suggestKeywords(PsiElement position) {
        TextRange range;
        TextRange posRange = position.getTextRange();
        BnfFile posFile = (BnfFile)position.getContainingFile();
        BnfRule statement = (BnfRule)PsiTreeUtil.getTopmostParentOfType((PsiElement)position, BnfRule.class);
        if (statement != null) {
            range = new TextRange(statement.getTextRange().getStartOffset(), posRange.getStartOffset());
        } else {
            int offset = posRange.getStartOffset();
            PsiElement cur = GrammarUtil.getDummyAwarePrevSibling(position);
            while (cur != null) {
                if (cur instanceof BnfAttrs) {
                    offset = cur.getTextRange().getEndOffset();
                    break;
                }
                if (cur instanceof BnfRule) {
                    offset = cur.getTextRange().getStartOffset();
                    break;
                }
                cur = GrammarUtil.getDummyAwarePrevSibling(cur);
            }
            range = new TextRange(offset, posRange.getStartOffset());
        }
        String headText = range.substring(posFile.getText());
        int completionOffset = StringUtil.isEmptyOrSpaces((String)headText) ? 0 : headText.length();
        String text = completionOffset == 0 ? "IntellijIdeaRulezzz " : headText;
        GeneratedParserUtilBase.CompletionState state = new GeneratedParserUtilBase.CompletionState(completionOffset){

            @Override
            public String convertItem(Object o) {
                return o instanceof String ? (String)o : null;
            }
        };
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)posFile.getProject());
        PsiFile file = psiFileFactory.createFileFromText("a.bnf", (Language)BnfLanguage.INSTANCE, (CharSequence)text, true, false);
        file.putUserData(GeneratedParserUtilBase.COMPLETION_STATE_KEY, (Object)state);
        TreeUtil.ensureParsed((ASTNode)file.getNode());
        if (completionOffset != 0) {
            TextRange altRange = TextRange.create((int)posRange.getEndOffset(), (int)Math.min(posRange.getEndOffset() + 100, posFile.getTextLength()));
            String tailText = altRange.substring(posFile.getText());
            String text2 = text + (StringUtil.isEmptyOrSpaces((String)tailText) ? "a ::= " : tailText);
            PsiFile file2 = psiFileFactory.createFileFromText("a.bnf", (Language)BnfLanguage.INSTANCE, (CharSequence)text2, true, false);
            file2.putUserData(GeneratedParserUtilBase.COMPLETION_STATE_KEY, (Object)state);
            TreeUtil.ensureParsed((ASTNode)file2.getNode());
        }
        return state.items;
    }
}

