/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.usageView.UsageViewNodeTextLocation;
import com.intellij.usageView.UsageViewShortNameLocation;
import com.intellij.usageView.UsageViewTypeLocation;
import java.util.Collection;
import org.apache.xmlbeans.impl.common.NameUtil;
import org.intellij.grammar.psi.BnfAttr;
import org.intellij.grammar.psi.BnfComposite;
import org.intellij.grammar.psi.BnfRule;
import org.jetbrains.annotations.NotNull;

public class BnfDescriptionProvider
implements ElementDescriptionProvider {
    public String getElementDescription(@NotNull PsiElement psiElement, @NotNull ElementDescriptionLocation location) {
        if (location == UsageViewNodeTextLocation.INSTANCE && psiElement instanceof BnfComposite) {
            return this.getElementDescription(psiElement, (ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE) + " '" + this.getElementDescription(psiElement, (ElementDescriptionLocation)UsageViewShortNameLocation.INSTANCE) + "'";
        }
        if (psiElement instanceof BnfRule) {
            if (location == UsageViewTypeLocation.INSTANCE) {
                return "Grammar Rule";
            }
            return ((BnfRule)psiElement).getName();
        }
        if (psiElement instanceof BnfAttr) {
            if (location == UsageViewTypeLocation.INSTANCE) {
                BnfRule rule = (BnfRule)PsiTreeUtil.getParentOfType((PsiElement)psiElement, BnfRule.class);
                return (rule == null ? "Grammar" : "Rule") + " Attribute";
            }
            return ((BnfAttr)psiElement).getName();
        }
        if (psiElement instanceof BnfComposite) {
            if (location == UsageViewTypeLocation.INSTANCE) {
                IElementType elementType = PsiUtilCore.getElementType((PsiElement)psiElement);
                return elementType == null ? null : StringUtil.join((Collection)NameUtil.splitWords((String)elementType.toString(), (boolean)false), (String)" ");
            }
            return psiElement instanceof PsiNamedElement ? ((PsiNamedElement)psiElement).getName() : psiElement.getClass().getSimpleName();
        }
        return null;
    }
}

