/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar;

import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PairConsumer;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.intellij.grammar.KnownAttribute;
import org.intellij.grammar.analysis.BnfFirstNextAnalyzer;
import org.intellij.grammar.generator.ExpressionHelper;
import org.intellij.grammar.generator.ParserGeneratorUtil;
import org.intellij.grammar.generator.RuleGraphHelper;
import org.intellij.grammar.psi.BnfAttr;
import org.intellij.grammar.psi.BnfExpression;
import org.intellij.grammar.psi.BnfFile;
import org.intellij.grammar.psi.BnfRule;
import org.jetbrains.annotations.Nullable;

public class BnfDocumentationProvider
implements DocumentationProvider {
    @Nullable
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        return null;
    }

    @Nullable
    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        return null;
    }

    @Nullable
    public String generateDoc(PsiElement element, PsiElement originalElement) {
        KnownAttribute<?> attribute;
        if (element instanceof BnfRule) {
            BnfRule rule = (BnfRule)element;
            BnfFirstNextAnalyzer analyzer = BnfFirstNextAnalyzer.createAnalyzer(false);
            Set<String> first = BnfFirstNextAnalyzer.asStrings(analyzer.calcFirst(rule));
            Set<String> next = BnfFirstNextAnalyzer.asStrings(analyzer.calcNext(rule).keySet());
            StringBuilder docBuilder = new StringBuilder();
            Object[] firstS = ArrayUtil.toStringArray(first);
            Arrays.sort(firstS);
            docBuilder.append("<h1>Starts with:</h1>");
            docBuilder.append("<code>").append(StringUtil.escapeXmlEntities((String)StringUtil.join((String[])firstS, (String)" | "))).append("</code>");
            Object[] nextS = ArrayUtil.toStringArray(next);
            Arrays.sort(nextS);
            docBuilder.append("<br><h1>Followed by:</h1>");
            docBuilder.append("<code>").append(StringUtil.escapeXmlEntities((String)StringUtil.join((String[])nextS, (String)" | "))).append("</code>");
            BnfFile file = (BnfFile)rule.getContainingFile();
            String recover = file.findAttributeValue(rule, KnownAttribute.RECOVER_WHILE, null);
            if ("#auto".equals(recover)) {
                docBuilder.append("<br><h1>#auto recovery predicate:</h1>");
                docBuilder.append("<code>");
                docBuilder.append("private ").append(rule.getName()).append("_recover ::= !(");
                boolean f = true;
                for (Object s : nextS) {
                    if (((String)s).startsWith("-") || ((String)s).startsWith("<") || file.getRule((String)s) != null) continue;
                    if (f) {
                        f = false;
                    } else {
                        docBuilder.append(" | ");
                    }
                    docBuilder.append(StringUtil.escapeXmlEntities((String)s));
                }
                docBuilder.append(")");
                docBuilder.append("</code>");
            }
            BnfDocumentationProvider.dumpPriorityTable(docBuilder, rule, file);
            BnfDocumentationProvider.dumpContents(docBuilder, rule, file);
            return docBuilder.toString();
        }
        if (element instanceof BnfAttr && (attribute = KnownAttribute.getAttribute(((BnfAttr)element).getName())) != null) {
            return attribute.getDescription();
        }
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object obj5ect, PsiElement element) {
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        return null;
    }

    private static void dumpContents(StringBuilder docBuilder, BnfRule rule, BnfFile file) {
        Map<PsiElement, RuleGraphHelper.Cardinality> map = RuleGraphHelper.getCached(file).getFor(rule);
        Collection<BnfRule> sortedPublicRules = ParserGeneratorUtil.getSortedPublicRules(map.keySet());
        Collection<BnfExpression> sortedTokens = ParserGeneratorUtil.getSortedTokens(map.keySet());
        Collection<LeafPsiElement> sortedExternalRules = ParserGeneratorUtil.getSortedExternalRules(map.keySet());
        if (sortedPublicRules.isEmpty() && sortedTokens.isEmpty()) {
            docBuilder.append("\n<br><h1>Contains no public rules and no tokens</h1>");
        } else {
            if (sortedPublicRules.size() > 0) {
                BnfDocumentationProvider.printElements(map, sortedPublicRules, docBuilder.append("\n<br><h1>Contains public rules:</h1>"));
            } else {
                docBuilder.append("<h2>Contains no public rules</h2>");
            }
            if (sortedTokens.size() > 0) {
                BnfDocumentationProvider.printElements(map, sortedTokens, docBuilder.append("\n<br><h1>Contains tokens:</h1>"));
            } else {
                docBuilder.append("<h2>Contains no tokens</h2>");
            }
        }
        if (!sortedExternalRules.isEmpty()) {
            BnfDocumentationProvider.printElements(map, sortedExternalRules, docBuilder.append("\n<br><h1>Contains external rules:</h1>"));
        }
    }

    private static void dumpPriorityTable(StringBuilder docBuilder, BnfRule rule, BnfFile file) {
        ExpressionHelper.ExpressionInfo expressionInfo = ExpressionHelper.getCached(file).getExpressionInfo(rule);
        if (expressionInfo == null) {
            return;
        }
        ExpressionHelper.OperatorInfo ruleOperator = expressionInfo.operatorMap.get(rule);
        int priority = expressionInfo.getPriority(rule);
        docBuilder.append("\n<br><h1>Priority table:");
        BnfDocumentationProvider.appendColored(docBuilder, String.format(" %s (%s)", ruleOperator != null ? ruleOperator.type : "priority group", priority));
        docBuilder.append("</h1>");
        expressionInfo.dumpPriorityTable(docBuilder.append("<code><pre>"), (PairConsumer<? super StringBuilder, ? super ExpressionHelper.OperatorInfo>)((PairConsumer)(sb, operatorInfo) -> {
            if (ruleOperator == operatorInfo || ruleOperator == null && Comparing.equal((Object)expressionInfo.getPriority(operatorInfo.rule), (Object)priority)) {
                BnfDocumentationProvider.appendColored(sb, operatorInfo);
            } else {
                sb.append(operatorInfo);
            }
        })).append("</pre></code>");
    }

    private static void appendColored(StringBuilder sb, Object o) {
        sb.append("<font").append(" color=\"#").append(ColorUtil.toHex((Color)JBColor.BLUE)).append("\">");
        sb.append(o);
        sb.append("</font>");
    }

    public static void printElements(Map<PsiElement, RuleGraphHelper.Cardinality> map, Collection<? extends PsiElement> collection, StringBuilder sb) {
        for (PsiElement psiElement : collection) {
            String text = psiElement instanceof PsiNamedElement ? ((PsiNamedElement)psiElement).getName() : psiElement.getText();
            sb.append(" ");
            sb.append(StringUtil.escapeXmlEntities((String)StringUtil.notNullize((String)text, (String)"?")));
            sb.append(RuleGraphHelper.getCardinalityText(map.get(psiElement)));
        }
    }
}

