/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar;

import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewModelBase;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.util.treeView.smartTree.SortableTreeElement;
import com.intellij.lang.PsiStructureViewFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.intellij.grammar.psi.BnfAttr;
import org.intellij.grammar.psi.BnfAttrPattern;
import org.intellij.grammar.psi.BnfAttrs;
import org.intellij.grammar.psi.BnfExpression;
import org.intellij.grammar.psi.BnfFile;
import org.intellij.grammar.psi.BnfRule;
import org.intellij.grammar.psi.BnfValueList;
import org.intellij.grammar.psi.impl.BnfFileImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BnfStructureViewFactory
implements PsiStructureViewFactory {
    public StructureViewBuilder getStructureViewBuilder(final @NotNull PsiFile psiFile) {
        return new TreeBasedStructureViewBuilder(){

            @NotNull
            public StructureViewModel createStructureViewModel(@Nullable Editor editor) {
                return new MyModel(psiFile);
            }

            public boolean isRootNodeShown() {
                return false;
            }
        };
    }

    public static class MyElement
    extends PsiTreeElementBase<PsiElement>
    implements SortableTreeElement {
        public MyElement(PsiElement element) {
            super(element);
        }

        @NotNull
        public String getAlphaSortKey() {
            return this.getPresentableText();
        }

        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            ArrayList<StructureViewTreeElement> result;
            block5: {
                PsiElement element;
                block4: {
                    element = this.getElement();
                    if (element instanceof BnfRule || element instanceof BnfAttr) {
                        return Collections.emptyList();
                    }
                    result = new ArrayList<StructureViewTreeElement>();
                    if (!(element instanceof BnfFile)) break block4;
                    for (BnfAttrs bnfAttrs : ((BnfFile)element).getAttributes()) {
                        result.add((StructureViewTreeElement)new MyElement(bnfAttrs));
                    }
                    for (BnfRule bnfRule : ((BnfFile)element).getRules()) {
                        result.add((StructureViewTreeElement)new MyElement(bnfRule));
                    }
                    break block5;
                }
                if (!(element instanceof BnfAttrs)) break block5;
                for (BnfAttr bnfAttr : ((BnfAttrs)element).getAttrList()) {
                    result.add((StructureViewTreeElement)new MyElement(bnfAttr));
                }
            }
            return result;
        }

        @NotNull
        public String getPresentableText() {
            PsiElement element = this.getElement();
            if (element instanceof BnfRule) {
                return StringUtil.notNullize((String)((PsiNamedElement)element).getName());
            }
            if (element instanceof BnfAttr) {
                return MyElement.getAttrDisplayName((BnfAttr)element);
            }
            if (element instanceof BnfAttrs) {
                List<BnfAttr> attrList = ((BnfAttrs)element).getAttrList();
                BnfAttr firstAttr = (BnfAttr)ContainerUtil.getFirstItem(attrList);
                if (firstAttr == null) {
                    return "Attributes { <empty> }";
                }
                String suffix = attrList.size() > 1 ? " & " + attrList.size() + " more..." : " ";
                return "Attributes { " + MyElement.getAttrDisplayName(firstAttr) + suffix + "}";
            }
            if (element instanceof BnfFileImpl) {
                return ((BnfFileImpl)element).getName();
            }
            return String.valueOf(element);
        }

        private static String getAttrDisplayName(BnfAttr attr) {
            BnfAttrPattern attrPattern = attr.getAttrPattern();
            BnfExpression attrValue = attr.getExpression();
            String attrValueText = attrValue == null ? "" : (attrValue instanceof BnfValueList ? "[ ... ]" : attrValue.getText());
            return attr.getName() + (attrPattern == null ? "" : attrPattern.getText()) + " = " + attrValueText;
        }

        public Icon getIcon(boolean open) {
            PsiElement element = this.getElement();
            if (element == null) {
                return null;
            }
            return element instanceof BnfAttrs ? PlatformIcons.PACKAGE_ICON : element.getIcon(0);
        }
    }

    public static class MyModel
    extends StructureViewModelBase
    implements StructureViewModel.ElementInfoProvider {
        protected MyModel(@NotNull PsiFile psiFile) {
            super(psiFile, (StructureViewTreeElement)new MyElement((PsiElement)psiFile));
            this.withSuitableClasses(new Class[]{BnfFile.class, BnfRule.class, BnfAttrs.class, BnfAttr.class});
        }

        public boolean isAlwaysShowsPlus(StructureViewTreeElement element) {
            return element.getValue() instanceof BnfAttrs;
        }

        public boolean isAlwaysLeaf(StructureViewTreeElement element) {
            Object value = element.getValue();
            return value instanceof BnfRule || value instanceof BnfAttr;
        }

        public boolean shouldEnterElement(Object element) {
            return false;
        }

        protected boolean isSuitable(PsiElement element) {
            return element instanceof BnfAttrs || element instanceof BnfRule;
        }
    }
}

