/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KnownAttribute<T> {
    private static final Map<String, KnownAttribute<?>> ourAttributes = new TreeMap();
    private static final ListValue EMPTY_LIST = new ListValue();
    public static final KnownAttribute<String> CLASS_HEADER = KnownAttribute.create(true, String.class, "classHeader", "// This is a generated file. Not intended for manual editing.");
    public static final KnownAttribute<ListValue> GENERATE = KnownAttribute.create(true, ListValue.class, "generate", EMPTY_LIST);
    public static final KnownAttribute<Boolean> GENERATE_PSI = KnownAttribute.create(true, Boolean.class, "generatePsi", true);
    public static final KnownAttribute<Boolean> GENERATE_TOKENS = KnownAttribute.create(true, Boolean.class, "generateTokens", true);
    public static final KnownAttribute<Boolean> GENERATE_TOKEN_ACCESSORS = KnownAttribute.create(true, Boolean.class, "generateTokenAccessors", false);
    public static final KnownAttribute<Integer> GENERATE_FIRST_CHECK = KnownAttribute.create(true, Integer.class, "generateFirstCheck", 2);
    public static final KnownAttribute<Boolean> EXTENDED_PIN = KnownAttribute.create(true, Boolean.class, "extendedPin", true);
    public static final KnownAttribute<ListValue> PARSER_IMPORTS = KnownAttribute.create(true, ListValue.class, "parserImports", EMPTY_LIST);
    public static final KnownAttribute<String> PSI_CLASS_PREFIX = KnownAttribute.create(true, String.class, "psiClassPrefix", "");
    public static final KnownAttribute<String> PSI_IMPL_CLASS_SUFFIX = KnownAttribute.create(true, String.class, "psiImplClassSuffix", "Impl");
    public static final KnownAttribute<String> PSI_TREE_UTIL_CLASS = KnownAttribute.create(true, String.class, "psiTreeUtilClass", "com.intellij.psi.util.PsiTreeUtil");
    public static final KnownAttribute<String> PSI_PACKAGE = KnownAttribute.create(true, String.class, "psiPackage", "generated.psi");
    public static final KnownAttribute<String> PSI_IMPL_PACKAGE = KnownAttribute.create(true, String.class, "psiImplPackage", "generated.psi.impl");
    public static final KnownAttribute<String> PSI_VISITOR_NAME = KnownAttribute.create(true, String.class, "psiVisitorName", "Visitor");
    public static final KnownAttribute<String> PSI_IMPL_UTIL_CLASS = KnownAttribute.create(true, String.class, "psiImplUtilClass", null);
    public static final KnownAttribute<String> TOKEN_TYPE_CLASS = KnownAttribute.create(true, String.class, "tokenTypeClass", "com.intellij.psi.tree.IElementType");
    public static final KnownAttribute<String> PARSER_CLASS = KnownAttribute.create(true, String.class, "parserClass", "generated.GeneratedParser");
    public static final KnownAttribute<String> PARSER_UTIL_CLASS = KnownAttribute.create(true, String.class, "parserUtilClass", "com.intellij.lang.parser.GeneratedParserUtilBase");
    public static final KnownAttribute<String> ELEMENT_TYPE_HOLDER_CLASS = KnownAttribute.create(true, String.class, "elementTypeHolderClass", "generated.GeneratedTypes");
    public static final KnownAttribute<String> ELEMENT_TYPE_PREFIX = KnownAttribute.create(true, String.class, "elementTypePrefix", "");
    public static final KnownAttribute<String> TOKEN_TYPE_FACTORY = KnownAttribute.create(true, String.class, "tokenTypeFactory", null);
    public static final KnownAttribute<String> EXTENDS = KnownAttribute.create(false, String.class, "extends", "com.intellij.extapi.psi.ASTWrapperPsiElement");
    public static final KnownAttribute<ListValue> IMPLEMENTS = KnownAttribute.create(false, ListValue.class, "implements", ListValue.singleValue(null, "com.intellij.psi.PsiElement"));
    public static final KnownAttribute<String> ELEMENT_TYPE = KnownAttribute.create(false, String.class, "elementType", null);
    public static final KnownAttribute<String> ELEMENT_TYPE_CLASS = KnownAttribute.create(false, String.class, "elementTypeClass", "com.intellij.psi.tree.IElementType");
    public static final KnownAttribute<String> ELEMENT_TYPE_FACTORY = KnownAttribute.create(false, String.class, "elementTypeFactory", null);
    public static final KnownAttribute<Object> PIN = KnownAttribute.create(false, Object.class, "pin", -1);
    public static final KnownAttribute<String> MIXIN = KnownAttribute.create(false, String.class, "mixin", null);
    public static final KnownAttribute<String> RECOVER_WHILE = KnownAttribute.create(false, String.class, "recoverWhile", null);
    public static final KnownAttribute<String> NAME = KnownAttribute.create(false, String.class, "name", null);
    public static final KnownAttribute<Boolean> EXTRA_ROOT = KnownAttribute.create(false, Boolean.class, "extraRoot", false);
    public static final KnownAttribute<Boolean> RIGHT_ASSOCIATIVE = KnownAttribute.create(false, Boolean.class, "rightAssociative", false);
    public static final KnownAttribute<String> CONSUME_TOKEN_METHOD = KnownAttribute.create(false, String.class, "consumeTokenMethod", "consumeToken");
    public static final KnownAttribute<String> STUB_CLASS = KnownAttribute.create(false, String.class, "stubClass", null);
    public static final KnownAttribute<ListValue> METHODS = KnownAttribute.create(false, ListValue.class, "methods", EMPTY_LIST);
    public static final KnownAttribute<ListValue> HOOKS = KnownAttribute.create(false, ListValue.class, "hooks", EMPTY_LIST);
    public static final KnownAttribute<ListValue> TOKENS = KnownAttribute.create(true, ListValue.class, "tokens", EMPTY_LIST);
    private final boolean myGlobal;
    private final String myName;
    private final Class<T> myClazz;
    private final T myDefaultValue;

    @NotNull
    public static Collection<KnownAttribute<?>> getAttributes() {
        return Collections.unmodifiableCollection(ourAttributes.values());
    }

    @Nullable
    public static KnownAttribute<?> getAttribute(@Nullable String name) {
        return name == null ? null : ourAttributes.get(name);
    }

    private static <T> KnownAttribute<T> create(boolean global, Class<T> clazz, String name, @Nullable T defaultValue) {
        return new KnownAttribute<T>(global, name, clazz, defaultValue);
    }

    private KnownAttribute(boolean global, String name, Class<T> clazz, T defaultValue) {
        this.myName = name;
        this.myClazz = clazz;
        this.myDefaultValue = defaultValue;
        this.myGlobal = global;
        KnownAttribute prev = ourAttributes.put(name, this);
        assert (prev == null) : name + " attribute already defined";
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    public boolean isGlobal() {
        return this.myGlobal;
    }

    public T getDefaultValue() {
        return this.myDefaultValue;
    }

    public T ensureValue(Object o) {
        if (o == null) {
            return this.getDefaultValue();
        }
        if (this.myClazz == ListValue.class && o instanceof String) {
            return (T)ListValue.singleValue(null, (String)o);
        }
        if (this.myClazz.isInstance(o)) {
            return (T)o;
        }
        return this.getDefaultValue();
    }

    public String toString() {
        return this.myName;
    }

    public String getDescription() {
        try {
            InputStream resourceAsStream = this.getClass().getResourceAsStream("/messages/attributeDescriptions/" + this.getName() + ".html");
            return resourceAsStream == null ? null : FileUtil.loadTextAndClose((InputStream)resourceAsStream);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Nullable
    public static KnownAttribute<?> getCompatibleAttribute(String name) {
        return KnownAttribute.getAttribute(name);
    }

    public static class ListValue
    extends LinkedList<Pair<String, String>> {
        @NotNull
        public static ListValue singleValue(String s1, String s2) {
            ListValue t = new ListValue();
            t.add(Pair.create((Object)s1, (Object)s2));
            return t;
        }

        @NotNull
        public List<String> asStrings() {
            ArrayList<String> t = new ArrayList<String>();
            for (Pair pair : this) {
                if (pair.first != null) {
                    t.add((String)pair.first);
                    continue;
                }
                if (pair.second == null) continue;
                t.add((String)pair.second);
            }
            return t;
        }

        @NotNull
        public Map<String, String> asMap() {
            return this.asMap(false);
        }

        @NotNull
        public Map<String, String> asInverseMap() {
            return this.asMap(true);
        }

        @NotNull
        private Map<String, String> asMap(boolean inverse) {
            LinkedHashMap<String, String> t = new LinkedHashMap<String, String>();
            for (Pair pair : this) {
                String value;
                String key = inverse ? (String)pair.second : (String)pair.first;
                String string = value = inverse ? (String)pair.first : (String)pair.second;
                if (key == null) continue;
                t.put(key, value);
            }
            return Collections.unmodifiableMap(t);
        }
    }
}

