/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.actions;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.intellij.grammar.KnownAttribute;
import org.intellij.grammar.actions.BnfGenerateParserUtilAction;
import org.intellij.grammar.generator.Case;
import org.intellij.grammar.generator.ParserGeneratorUtil;
import org.intellij.grammar.generator.RuleGraphHelper;
import org.intellij.grammar.psi.BnfAttrs;
import org.intellij.grammar.psi.BnfFile;
import org.intellij.grammar.psi.BnfReferenceOrToken;
import org.intellij.grammar.psi.impl.GrammarUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.helpers.NOPLogger;

public class BnfGenerateLexerAction
extends AnAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(AnActionEvent e) {
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        e.getPresentation().setEnabledAndVisible(file instanceof BnfFile);
    }

    public void actionPerformed(AnActionEvent e) {
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (!(file instanceof BnfFile)) {
            return;
        }
        Project project = file.getProject();
        BnfFile bnfFile = (BnfFile)file;
        String flexFileName = BnfGenerateLexerAction.getFlexFileName(bnfFile);
        Collection files = FilenameIndex.getVirtualFilesByName((String)flexFileName, (GlobalSearchScope)ProjectScope.getAllScope((Project)project));
        VirtualFile firstItem = (VirtualFile)ContainerUtil.getFirstItem((Collection)files);
        FileSaverDescriptor descriptor = new FileSaverDescriptor("Save JFlex Lexer", "", new String[]{"flex"});
        VirtualFile baseDir = firstItem != null ? firstItem.getParent() : bnfFile.getVirtualFile().getParent();
        VirtualFileWrapper fileWrapper = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, project).save(baseDir, firstItem != null ? firstItem.getName() : flexFileName);
        if (fileWrapper == null) {
            return;
        }
        VirtualFile virtualFile = fileWrapper.getVirtualFile(true);
        if (virtualFile == null) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)project, (String)e.getPresentation().getText(), null, () -> {
            try {
                PsiDirectory psiDirectory = PsiManager.getInstance((Project)project).findDirectory(virtualFile.getParent());
                assert (psiDirectory != null);
                PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(psiDirectory);
                String packageName = aPackage == null ? null : aPackage.getQualifiedName();
                String text = this.generateLexerText(bnfFile, packageName);
                VfsUtil.saveText((VirtualFile)virtualFile, (String)text);
                Notifications.Bus.notify((Notification)new Notification("Grammar Generator", virtualFile.getName() + " generated", "to " + virtualFile.getParent().getPath(), NotificationType.INFORMATION), (Project)project);
                BnfGenerateLexerAction.associateFileTypeAndNavigate(project, virtualFile);
            }
            catch (IncorrectOperationException | IOException ex) {
                ApplicationManager.getApplication().invokeLater(() -> BnfGenerateLexerAction.lambda$actionPerformed$0(project, flexFileName, (Exception)ex));
            }
        }, (PsiFile[])new PsiFile[0]);
    }

    private static void associateFileTypeAndNavigate(Project project, VirtualFile virtualFile) {
        String extension = virtualFile.getExtension();
        FileTypeManagerEx fileTypeManagerEx = FileTypeManagerEx.getInstanceEx();
        if (extension != null && fileTypeManagerEx.getFileTypeByExtension(extension) == FileTypes.UNKNOWN) {
            fileTypeManagerEx.associateExtension((FileType)PlainTextFileType.INSTANCE, "flex");
        }
        FileEditorManager.getInstance((Project)project).openFile(virtualFile, false, true);
    }

    private String generateLexerText(final BnfFile bnfFile, @Nullable String packageName) {
        Map<String, String> tokenMap = RuleGraphHelper.getTokenNameToTextMap(bnfFile);
        final int[] maxLen = new int[]{"{WHITE_SPACE}".length()};
        final LinkedHashMap simpleTokens = new LinkedHashMap();
        final LinkedHashMap<String, String> regexpTokens = new LinkedHashMap<String, String>();
        for (String name : tokenMap.keySet()) {
            String token = tokenMap.get(name);
            if (name == null || token == null) continue;
            String pattern = BnfGenerateLexerAction.token2JFlex(token);
            boolean isRE = ParserGeneratorUtil.isRegexpToken(token);
            (isRE ? regexpTokens : simpleTokens).put(Case.UPPER.apply(name), pattern);
            maxLen[0] = Math.max((isRE ? name : pattern).length() + 2, maxLen[0]);
        }
        bnfFile.acceptChildren((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                String name;
                String text;
                if (element instanceof BnfAttrs) {
                    return;
                }
                if (GrammarUtil.isExternalReference(element)) {
                    return;
                }
                String string = text = element instanceof BnfReferenceOrToken ? element.getText() : null;
                if (text != null && bnfFile.getRule(text) == null && !simpleTokens.containsKey(name = Case.UPPER.apply(text)) && !regexpTokens.containsKey(name)) {
                    simpleTokens.put(name, BnfGenerateLexerAction.text2JFlex(text, false));
                    maxLen[0] = Math.max(text.length(), maxLen[0]);
                }
                super.visitElement(element);
            }
        });
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty("runtime.log.instance", (Object)NOPLogger.NOP_LOGGER);
        try {
            Class<?> chuteClass = Class.forName("org.apache.velocity.runtime.log.NullLogChute");
            ve.setProperty("runtime.log.logsystem", chuteClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Throwable chuteClass) {
            // empty catch block
        }
        ve.init();
        VelocityContext context = new VelocityContext();
        context.put("lexerClass", (Object)BnfGenerateLexerAction.getLexerName(bnfFile));
        context.put("packageName", (Object)StringUtil.notNullize((String)packageName, (String)StringUtil.getPackageName((String)ParserGeneratorUtil.getRootAttribute((PsiElement)bnfFile, KnownAttribute.PARSER_CLASS))));
        context.put("tokenPrefix", (Object)ParserGeneratorUtil.getRootAttribute((PsiElement)bnfFile, KnownAttribute.ELEMENT_TYPE_PREFIX));
        context.put("typesClass", (Object)ParserGeneratorUtil.getRootAttribute((PsiElement)bnfFile, KnownAttribute.ELEMENT_TYPE_HOLDER_CLASS));
        context.put("tokenPrefix", (Object)ParserGeneratorUtil.getRootAttribute((PsiElement)bnfFile, KnownAttribute.ELEMENT_TYPE_PREFIX));
        context.put("simpleTokens", simpleTokens);
        context.put("regexpTokens", regexpTokens);
        context.put("StringUtil", StringUtil.class);
        context.put("maxTokenLength", (Object)maxLen[0]);
        StringWriter out = new StringWriter();
        InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream("/templates/lexer.flex.template");
        ve.evaluate((Context)context, (Writer)out, "lexer.flex.template", (Reader)new InputStreamReader(stream));
        return StringUtil.convertLineSeparators((String)out.toString());
    }

    @NotNull
    public static String token2JFlex(@NotNull String tokenText) {
        if (ParserGeneratorUtil.isRegexpToken(tokenText)) {
            return BnfGenerateLexerAction.javaPattern2JFlex(ParserGeneratorUtil.getRegexpTokenRegexp(tokenText));
        }
        return BnfGenerateLexerAction.text2JFlex(tokenText, false);
    }

    private static String javaPattern2JFlex(String javaRegexp) {
        Matcher m = Pattern.compile("\\[(?:[^]\\\\]|\\\\.)*]").matcher(javaRegexp);
        int start = 0;
        StringBuilder sb = new StringBuilder();
        while (m.find(start)) {
            sb.append(BnfGenerateLexerAction.text2JFlex(javaRegexp.substring(start, m.start()), true));
            sb.append(javaRegexp.substring(m.start(), m.end()).replaceAll("\"", "\\\\\""));
            start = m.end();
        }
        sb.append(BnfGenerateLexerAction.text2JFlex(javaRegexp.substring(start), true));
        return sb.toString();
    }

    private static String text2JFlex(String text, boolean isRegexp) {
        String s;
        if (!isRegexp) {
            s = text.replaceAll("([\"\\\\])", "\\\\$1");
        } else {
            String spaces = " \\\\t\\\\n\\\\x0B\\\\f\\\\r";
            s = text.replaceAll("\"", "\\\\\"");
            s = s.replaceAll("(/+)", "\"$1\"");
            s = s.replaceAll("\\\\d", "[0-9]");
            s = s.replaceAll("\\\\D", "[^0-9]");
            s = s.replaceAll("\\\\s", "[" + spaces + "]");
            s = s.replaceAll("\\\\S", "[^" + spaces + "]");
            s = s.replaceAll("\\\\w", "[a-zA-Z_0-9]");
            s = s.replaceAll("\\\\W", "[^a-zA-Z_0-9]");
            s = s.replaceAll("\\\\p\\{Space}", "[" + spaces + "]");
            s = s.replaceAll("\\\\p\\{Digit}", "[:digit:]");
            s = s.replaceAll("\\\\p\\{Alpha}", "[:letter:]");
            s = s.replaceAll("\\\\p\\{Lower}", "[:lowercase:]");
            s = s.replaceAll("\\\\p\\{Upper}", "[:uppercase:]");
            s = s.replaceAll("\\\\p\\{Alnum}", "([:letter:]|[:digit:])");
            s = s.replaceAll("\\\\p\\{ASCII}", "[\\x00-\\x7F]");
        }
        return s;
    }

    static String getFlexFileName(BnfFile bnfFile) {
        return BnfGenerateLexerAction.getLexerName(bnfFile) + ".flex";
    }

    private static String getLexerName(BnfFile bnfFile) {
        return "_" + BnfGenerateParserUtilAction.getGrammarName(bnfFile) + "Lexer";
    }

    private static /* synthetic */ void lambda$actionPerformed$0(Project project, String flexFileName, Exception ex) {
        Messages.showErrorDialog((Project)project, (String)("Unable to create file " + flexFileName + "\n" + ex.getLocalizedMessage()), (String)"Create JFlex Lexer");
    }
}

