/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.MessageView;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.intellij.grammar.actions.FileGeneratorUtil;
import org.intellij.grammar.config.Options;
import org.intellij.jflex.parser.JFlexFileType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BnfRunJFlexAction
extends DumbAwareAction {
    private static final String JFLEX_URL = "https://cache-redirector.jetbrains.com/intellij-dependencies/org/jetbrains/intellij/deps/jflex/jflex/1.9.1/jflex-1.9.1.jar";
    private static final String SKEL_NAME = "idea-flex.skeleton";
    private static final String JFLEX_JAR_PREFIX = "jflex-";
    private static final String LIB_NAME = "JFlex & idea-flex.skeleton";
    private static final Key<Pair<String, OSProcessHandler>> BATCH_ID_KEY = Key.create((String)"BnfRunJFlexAction.batchId");

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        List<VirtualFile> files = BnfRunJFlexAction.getFiles(e);
        e.getPresentation().setEnabledAndVisible(project != null && !files.isEmpty());
    }

    private static List<VirtualFile> getFiles(@NotNull AnActionEvent e) {
        return JBIterable.of((Object[])((VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY))).filter(file -> {
            FileType fileType = file.getFileType();
            return fileType == JFlexFileType.INSTANCE || !fileType.isBinary() && file.getName().endsWith(".flex");
        }).toList();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        final Project project = BnfRunJFlexAction.getEventProject((AnActionEvent)e);
        final List<VirtualFile> files = BnfRunJFlexAction.getFiles(e);
        if (project == null || files.isEmpty()) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        FileDocumentManager.getInstance().saveAllDocuments();
        final Couple<File> flexFiles = BnfRunJFlexAction.getOrDownload(project);
        if (flexFiles == null) {
            FileGeneratorUtil.fail(project, "JFlex jar not found", "Create global library with jflex-xxx.jar and idea-flex.skeleton file to fix.");
            return;
        }
        final String batchId = "jflex@" + System.nanoTime();
        new Runnable(){
            final Iterator<VirtualFile> it;
            {
                this.it = files.iterator();
            }

            @Override
            public void run() {
                if (this.it.hasNext()) {
                    BnfRunJFlexAction.doGenerate(project, this.it.next(), (Couple<File>)flexFiles, batchId).doWhenProcessed((Runnable)this);
                }
            }
        }.run();
    }

    public static ActionCallback doGenerate(final @NotNull Project project, @NotNull VirtualFile flexFile, @NotNull Couple<File> jflex, @NotNull String batchId) {
        String lexerPackage;
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Document document = fileDocumentManager.getDocument(flexFile);
        if (document == null) {
            return ActionCallback.REJECTED;
        }
        String text = document.getText();
        Matcher matcherClass = Pattern.compile("%class\\s+(\\w+)").matcher(text);
        String lexerClassName = matcherClass.find() ? matcherClass.group(1) : null;
        Matcher matcherPackage = Pattern.compile("package\\s+([^;]+);|(%%)").matcher(text);
        String string = lexerPackage = matcherPackage.find() ? StringUtil.trim((String)matcherPackage.group(1)) : null;
        if (lexerClassName == null) {
            String content = "Lexer class name option not found, use <pre>%class LexerClassName</pre>";
            FileGeneratorUtil.fail(project, flexFile, content);
            return ActionCallback.REJECTED;
        }
        try {
            final VirtualFile virtualDir = FileGeneratorUtil.getTargetDirectoryFor(project, flexFile, lexerClassName + ".java", lexerPackage, false);
            File workingDir = VfsUtilCore.virtualToIoFile((VirtualFile)flexFile).getParentFile().getAbsoluteFile();
            Sdk sdk = new SimpleJavaSdkType().createJdk("tmp", SystemProperties.getJavaHome());
            SimpleJavaParameters javaParameters = new SimpleJavaParameters();
            javaParameters.setCharset(flexFile.getCharset());
            javaParameters.setWorkingDirectory(workingDir);
            javaParameters.setJdk(sdk);
            javaParameters.setJarPath(((File)jflex.first).getAbsolutePath());
            javaParameters.getVMParametersList().add("-Xmx512m");
            javaParameters.getProgramParametersList().addParametersString(StringUtil.nullize((String)((String)Options.GEN_JFLEX_ARGS.get())));
            if (jflex.second != null) {
                javaParameters.getProgramParametersList().add("-skel", ((File)jflex.second).getAbsolutePath());
            }
            javaParameters.getProgramParametersList().add("-d", VfsUtilCore.virtualToIoFile((VirtualFile)virtualDir).getAbsolutePath());
            javaParameters.getProgramParametersList().add(flexFile.getName());
            OSProcessHandler processHandler = javaParameters.createOSProcessHandler();
            BnfRunJFlexAction.showConsole(project, "JFlex", batchId, processHandler);
            final ActionCallback callback = new ActionCallback();
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    Runnable runnable = event.getExitCode() == 0 ? () -> ((ActionCallback)callback).setDone() : () -> ((ActionCallback)callback).setRejected();
                    ApplicationManager.getApplication().invokeLater(runnable, project.getDisposed());
                    VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)true, (VirtualFile[])new VirtualFile[]{virtualDir});
                }
            });
            processHandler.startNotify();
            return callback;
        }
        catch (ExecutionException ex) {
            Messages.showErrorDialog((Project)project, (String)("Unable to run JFlex\n" + ex.getLocalizedMessage()), (String)"JFlex");
            return ActionCallback.REJECTED;
        }
    }

    public static void showConsole(@NotNull Project project, @NotNull String title, @NotNull String batchId, @NotNull OSProcessHandler processHandler) {
        ConsoleView consoleView;
        MessageView messageView = MessageView.getInstance((Project)project);
        Content batchContent = null;
        Content stoppedContent = null;
        for (Content c : messageView.getContentManager().getContents()) {
            AnAction[] data = (AnAction[])c.getUserData(BATCH_ID_KEY);
            if (data == null) continue;
            if (((String)data.first).equals(batchId)) {
                batchContent = c;
                continue;
            }
            if (!((OSProcessHandler)data.second).isProcessTerminated() && !((OSProcessHandler)data.second).isProcessTerminating() || c.isPinned()) continue;
            stoppedContent = c;
        }
        Content content = (Content)ObjectUtils.chooseNotNull(batchContent, stoppedContent);
        ConsoleView consoleView2 = consoleView = content == null ? null : (ConsoleView)UIUtil.uiTraverser((Component)content.getComponent()).filter(ConsoleView.class).first();
        if (content != null && consoleView != null) {
            if (content == batchContent) {
                consoleView.print("\n\n\n", ConsoleViewContentType.SYSTEM_OUTPUT);
            } else {
                consoleView.clear();
            }
            BnfRunJFlexAction.attachAndActivate(project, batchId, processHandler, content, consoleView);
            return;
        }
        consoleView = TextConsoleBuilderFactory.getInstance().createBuilder(project).getConsole();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)consoleView.getComponent(), "Center");
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        for (AnAction action : consoleView.createConsoleActions()) {
            toolbarActions.add(action);
        }
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)toolbarActions, false);
        toolbar.setTargetComponent(consoleView.getComponent());
        panel.add((Component)toolbar.getComponent(), "West");
        content = ContentFactory.getInstance().createContent((JComponent)panel, title, true);
        messageView.getContentManager().addContent(content);
        Disposer.register((Disposable)content, (Disposable)consoleView);
        BnfRunJFlexAction.attachAndActivate(project, batchId, processHandler, content, consoleView);
    }

    private static void attachAndActivate(@NotNull Project project, @NotNull String batchId, @NotNull OSProcessHandler processHandler, @NotNull Content content, @NotNull ConsoleView consoleView) {
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Messages");
        content.putUserData(BATCH_ID_KEY, (Object)Pair.create((Object)batchId, (Object)processHandler));
        consoleView.attachToProcess((ProcessHandler)processHandler);
        if (toolWindow != null) {
            toolWindow.activate(() -> toolWindow.getContentManager().setSelectedContent(content), false, false);
        }
    }

    @Nullable
    private static Couple<File> getOrDownload(@NotNull Project project) {
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable();
        for (Library library : libraryTable.getLibraries()) {
            Couple<File> result = BnfRunJFlexAction.findInUrls(library.getUrls(OrderRootType.CLASSES));
            if (result == null) continue;
            return result;
        }
        File jarFile = BnfRunJFlexAction.downloadJFlex(project);
        if (jarFile == null) {
            return null;
        }
        File skelFile = new File(jarFile.getParent(), SKEL_NAME);
        VirtualFile skel = JarFileSystem.getInstance().findFileByPath(jarFile.getPath() + "!//jflex/idea-flex.skeleton");
        if (!skelFile.exists() && skel != null && !skel.isDirectory()) {
            try {
                FileUtil.writeToFile((File)skelFile, (byte[])skel.contentsToByteArray());
            }
            catch (IOException e) {
                FileGeneratorUtil.fail(project, "Writing idea-flex.skeleton failed", e.toString());
                skelFile = null;
            }
        }
        Couple result = Couple.of((Object)jarFile, (Object)skelFile);
        WriteAction.run(() -> BnfRunJFlexAction.createOrUpdateLibrary((Couple<File>)result));
        return result;
    }

    @Nullable
    private static Couple<File> findInUrls(String ... rootUrls) {
        File jarFile = null;
        File skelFile = null;
        for (String root : rootUrls) {
            boolean isJar;
            root = StringUtil.trimEnd((String)root, (String)"!/");
            String rootName = root.substring(root.lastIndexOf("/") + 1);
            if (jarFile == null && rootName.startsWith(JFLEX_JAR_PREFIX) && rootName.endsWith(".jar")) {
                isJar = true;
            } else {
                if (skelFile != null || !rootName.equals(SKEL_NAME)) continue;
                isJar = false;
            }
            File file = new File(FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)root)));
            if (!file.exists() || !file.isFile()) continue;
            if (isJar) {
                jarFile = file;
                continue;
            }
            skelFile = file;
        }
        return jarFile != null ? Couple.of(jarFile, skelFile) : null;
    }

    @Nullable
    private static File downloadJFlex(@NotNull Project project) {
        String url = JFLEX_URL;
        DownloadableFileService service = DownloadableFileService.getInstance();
        ArrayList<DownloadableFileDescription> descriptions = new ArrayList<DownloadableFileDescription>();
        descriptions.add(service.createFileDescription(url, url.substring(url.lastIndexOf("/") + 1)));
        Pair pair = (Pair)ContainerUtil.getFirstItem((List)service.createDownloader(descriptions, LIB_NAME).downloadWithProgress(null, project, null));
        File file = pair == null ? null : VfsUtil.virtualToIoFile((VirtualFile)((VirtualFile)pair.first));
        return file != null && file.exists() && file.isFile() ? file : null;
    }

    private static void createOrUpdateLibrary(@NotNull Couple<File> files) {
        LibraryTable.ModifiableModel modifiableModel;
        String libraryName = LIB_NAME;
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable();
        Library library = libraryTable.getLibraryByName(libraryName);
        if (library == null) {
            modifiableModel = libraryTable.getModifiableModel();
            library = modifiableModel.createLibrary(libraryName);
            modifiableModel.commit();
        }
        modifiableModel = library.getModifiableModel();
        modifiableModel.addRoot(VfsUtil.fileToUrl((File)((File)files.first)), OrderRootType.CLASSES);
        if (files.second != null) {
            modifiableModel.addRoot(VfsUtil.fileToUrl((File)((File)files.second)), OrderRootType.CLASSES);
        }
        modifiableModel.commit();
    }
}

