/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.actions;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.intellij.grammar.BnfFileType;
import org.intellij.grammar.config.Options;
import org.intellij.jflex.parser.JFlexFileType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileGeneratorUtil {
    @NotNull
    public static VirtualFile getTargetDirectoryFor(@NotNull Project project, @NotNull VirtualFile sourceFile, @Nullable String targetFile, @Nullable String targetPackage, boolean returnRoot) {
        VirtualFile virtualRoot;
        boolean hasPackage = StringUtil.isNotEmpty((String)targetPackage);
        ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)project);
        PackageIndex packageIndex = PackageIndex.getInstance((Project)project);
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project);
        VirtualFile existingFile = null;
        if (targetFile != null) {
            Collection fromIndex = FilenameIndex.getVirtualFilesByName((String)targetFile, (GlobalSearchScope)ProjectScope.getProjectScope((Project)project));
            ArrayList files = new ArrayList(fromIndex);
            files.sort((f1, f2) -> {
                boolean b2;
                boolean b1 = fileIndex.isInSource(f1);
                if (b1 != (b2 = fileIndex.isInSource(f2))) {
                    return b1 ? -1 : 1;
                }
                return Integer.compare(f1.getPath().length(), f2.getPath().length());
            });
            for (VirtualFile file : files) {
                String existingFilePackage = packageIndex.getPackageNameByDirectory(file.getParent());
                if (hasPackage && existingFilePackage != null && !targetPackage.equals(existingFilePackage)) continue;
                existingFile = file;
                break;
            }
        }
        VirtualFile existingFileRoot = existingFile == null ? null : (fileIndex.isInSourceContent(existingFile) ? fileIndex.getSourceRootForFile(existingFile) : (fileIndex.isInContent(existingFile) ? fileIndex.getContentRootForFile(existingFile) : null));
        boolean preferGenRoot = sourceFile.getFileType() == BnfFileType.INSTANCE || sourceFile.getFileType() == JFlexFileType.INSTANCE;
        boolean preferSourceRoot = hasPackage && !preferGenRoot;
        VirtualFile[] sourceRoots = rootManager.getContentSourceRoots();
        Object[] contentRoots = rootManager.getContentRoots();
        VirtualFile virtualFile = existingFileRoot != null ? existingFileRoot : (preferSourceRoot && fileIndex.isInSource(sourceFile) ? fileIndex.getSourceRootForFile(sourceFile) : (fileIndex.isInContent(sourceFile) ? fileIndex.getContentRootForFile(sourceFile) : (virtualRoot = (VirtualFile)ArrayUtil.getFirstElement((Object[])(preferSourceRoot && sourceRoots.length > 0 ? sourceRoots : contentRoots)))));
        if (virtualRoot == null) {
            FileGeneratorUtil.fail(project, sourceFile, "Unable to guess target source root");
            throw new ProcessCanceledException();
        }
        try {
            boolean newGenRoot;
            String packagePrefix = StringUtil.notNullize((String)packageIndex.getPackageNameByDirectory(virtualRoot));
            String genDirName = (String)Options.GEN_DIR.get();
            boolean bl = newGenRoot = !fileIndex.isInSourceContent(virtualRoot);
            String relativePath = ((String)(hasPackage && newGenRoot ? genDirName + "/" + targetPackage : (hasPackage ? StringUtil.trimStart((String)StringUtil.trimStart((String)targetPackage, (String)packagePrefix), (String)".") : (newGenRoot ? genDirName : "")))).replace('.', '/');
            if (relativePath.isEmpty()) {
                return virtualRoot;
            }
            VirtualFile result = (VirtualFile)WriteAction.compute(() -> VfsUtil.createDirectoryIfMissing((VirtualFile)virtualRoot, (String)relativePath));
            VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{result});
            return returnRoot && newGenRoot ? Objects.requireNonNull(virtualRoot.findChild(genDirName)) : (returnRoot ? virtualRoot : result);
        }
        catch (ProcessCanceledException ex) {
            throw ex;
        }
        catch (Exception ex) {
            FileGeneratorUtil.fail(project, sourceFile, ex.getMessage());
            throw new ProcessCanceledException();
        }
    }

    static void fail(@NotNull Project project, @NotNull VirtualFile sourceFile, @NotNull String message) {
        FileGeneratorUtil.fail(project, sourceFile.getName(), message);
    }

    static void fail(@NotNull Project project, @NotNull String title, @NotNull String message) {
        Notifications.Bus.notify((Notification)new Notification("Grammar Generator", title, message, NotificationType.ERROR), (Project)project);
        throw new ProcessCanceledException();
    }
}

