/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.actions;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiFile;
import java.util.List;
import java.util.Objects;
import org.intellij.grammar.livePreview.GrammarAtCaretPassFactory;
import org.intellij.grammar.livePreview.LivePreviewLanguage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightGrammarAtCaretAction
extends AnAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    @Nullable
    private static Editor getPreviewEditor(@NotNull AnActionEvent e) {
        LivePreviewLanguage livePreviewLanguage;
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        Language language = psiFile == null ? null : psiFile.getLanguage();
        LivePreviewLanguage livePreviewLanguage2 = livePreviewLanguage = language instanceof LivePreviewLanguage ? (LivePreviewLanguage)language : null;
        if (livePreviewLanguage == null) {
            return null;
        }
        List<Editor> editors = livePreviewLanguage.getGrammarEditors(psiFile.getProject());
        return editors.isEmpty() ? null : editor;
    }

    public void update(@NotNull AnActionEvent e) {
        boolean enabled;
        Editor editor = HighlightGrammarAtCaretAction.getPreviewEditor(e);
        boolean bl = enabled = editor != null;
        String command = !enabled ? "" : (GrammarAtCaretPassFactory.GRAMMAR_AT_CARET_KEY.get((UserDataHolder)editor) != null ? "Stop " : "Start ");
        e.getPresentation().setText(command + this.getTemplatePresentation().getText());
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Editor editor = HighlightGrammarAtCaretAction.getPreviewEditor(e);
        if (editor == null) {
            return;
        }
        Boolean value = (Boolean)GrammarAtCaretPassFactory.GRAMMAR_AT_CARET_KEY.get((UserDataHolder)editor);
        GrammarAtCaretPassFactory.GRAMMAR_AT_CARET_KEY.set((UserDataHolder)editor, (Object)(value == null ? Boolean.TRUE : null));
        Project project = Objects.requireNonNull(e.getProject());
        DaemonCodeAnalyzer.getInstance((Project)project).restart();
    }
}

