/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.analysis;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.intellij.grammar.KnownAttribute;
import org.intellij.grammar.generator.ParserGeneratorUtil;
import org.intellij.grammar.generator.RuleGraphHelper;
import org.intellij.grammar.psi.BnfAttr;
import org.intellij.grammar.psi.BnfChoice;
import org.intellij.grammar.psi.BnfExpression;
import org.intellij.grammar.psi.BnfExternalExpression;
import org.intellij.grammar.psi.BnfFile;
import org.intellij.grammar.psi.BnfLiteralExpression;
import org.intellij.grammar.psi.BnfParenOptExpression;
import org.intellij.grammar.psi.BnfParenthesized;
import org.intellij.grammar.psi.BnfPredicate;
import org.intellij.grammar.psi.BnfQuantified;
import org.intellij.grammar.psi.BnfReferenceOrToken;
import org.intellij.grammar.psi.BnfRule;
import org.intellij.grammar.psi.BnfSequence;
import org.intellij.grammar.psi.BnfStringLiteralExpression;
import org.intellij.grammar.psi.BnfTypes;
import org.intellij.grammar.psi.impl.GrammarUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BnfFirstNextAnalyzer {
    private static final Logger LOG = Logger.getInstance(BnfFirstNextAnalyzer.class);
    public static final String MATCHES_EOF = "-eof-";
    public static final String MATCHES_NOTHING = "-never-matches-";
    public static final String MATCHES_ANY = "-any-";
    public static final BnfExpression BNF_MATCHES_EOF = new GrammarUtil.FakeBnfExpression("-eof-");
    public static final BnfExpression BNF_MATCHES_NOTHING = new GrammarUtil.FakeBnfExpression("-never-matches-");
    public static final BnfExpression BNF_MATCHES_ANY = new GrammarUtil.FakeBnfExpression("-any-");
    private final boolean myBackward;
    private final boolean myPublicRuleOpaque;
    private final boolean myPredicateLookAhead;
    private final Condition<PsiElement> myParentFilter;
    private final Map<BnfExpression, Map<BnfExpression, BnfExpression>> myNextCache = new HashMap<BnfExpression, Map<BnfExpression, BnfExpression>>();

    public static BnfFirstNextAnalyzer createAnalyzer(boolean predicateLookAhead) {
        return new BnfFirstNextAnalyzer(false, false, predicateLookAhead, null);
    }

    public static BnfFirstNextAnalyzer createAnalyzer(boolean predicateLookAhead, boolean publicRuleOpaque, Condition<PsiElement> parentFilter) {
        return new BnfFirstNextAnalyzer(false, publicRuleOpaque, predicateLookAhead, parentFilter);
    }

    public static BnfFirstNextAnalyzer createBackwardAnalyzer(boolean publicRuleOpaque) {
        return new BnfFirstNextAnalyzer(true, publicRuleOpaque, false, null);
    }

    private BnfFirstNextAnalyzer(boolean backward, boolean publicRuleOpaque, boolean predicateLookAhead, Condition<PsiElement> parentFilter) {
        this.myBackward = backward;
        this.myPublicRuleOpaque = publicRuleOpaque;
        this.myPredicateLookAhead = predicateLookAhead;
        this.myParentFilter = parentFilter;
    }

    public Set<BnfExpression> calcFirst(@NotNull BnfRule rule) {
        HashSet<BnfExpression> visited = new HashSet<BnfExpression>();
        BnfExpression expression = rule.getExpression();
        visited.add(expression);
        return this.calcFirstInner(expression, new HashSet<BnfExpression>(), visited);
    }

    public Set<BnfExpression> calcFirst(@NotNull BnfExpression expression) {
        return this.calcFirstInner(expression, new HashSet<BnfExpression>(), new HashSet<BnfExpression>());
    }

    public Map<BnfExpression, BnfExpression> calcNext(@NotNull BnfRule targetRule) {
        return this.calcNextInner(targetRule.getExpression(), new HashMap<BnfExpression, BnfExpression>(), new HashSet<BnfExpression>());
    }

    public Map<BnfExpression, BnfExpression> calcNext(@NotNull BnfExpression targetExpression) {
        return this.calcNextInner(targetExpression, new HashMap<BnfExpression, BnfExpression>(), new HashSet<BnfExpression>());
    }

    private Map<BnfExpression, BnfExpression> calcNextInner(@NotNull BnfExpression targetExpression, Map<BnfExpression, BnfExpression> result, Set<BnfExpression> visited) {
        Map<BnfExpression, BnfExpression> cached = this.myNextCache.get(targetExpression);
        if (cached != null) {
            return cached;
        }
        LinkedList<BnfExpression> stack = new LinkedList<BnfExpression>();
        HashSet<BnfRule> totalVisited = new HashSet<BnfRule>();
        HashSet<BnfExpression> curResult = new HashSet<BnfExpression>();
        stack.add(targetExpression);
        block0: while (!stack.isEmpty()) {
            PsiElement cur = (PsiElement)stack.removeLast();
            BnfExpression startingExpr = cur instanceof BnfReferenceOrToken ? (BnfExpression)cur : null;
            PsiElement parent = cur.getParent();
            while (parent instanceof BnfExpression && (this.myParentFilter == null || this.myParentFilter.value((Object)parent))) {
                IElementType effectiveType;
                curResult.clear();
                PsiElement grandPa = parent.getParent();
                if (grandPa instanceof BnfRule && ParserGeneratorUtil.Rule.isExternal((BnfRule)grandPa) || grandPa instanceof BnfExternalExpression) {
                    result.put(BNF_MATCHES_ANY, startingExpr);
                    break;
                }
                if (parent instanceof BnfSequence) {
                    List<BnfExpression> children = ((BnfSequence)parent).getExpressionList();
                    int idx = children.indexOf(cur);
                    List<BnfExpression> sublist = this.myBackward ? children.subList(0, idx) : children.subList(idx + 1, children.size());
                    this.calcSequenceFirstInner(sublist, curResult, visited);
                    boolean skipResolve = !curResult.contains(BNF_MATCHES_EOF);
                    for (BnfExpression e : curResult) {
                        result.put(e, startingExpr);
                    }
                    if (skipResolve) {
                        continue block0;
                    }
                } else if (parent instanceof BnfQuantified && ((effectiveType = ParserGeneratorUtil.getEffectiveType(parent)) == BnfTypes.BNF_OP_ZEROMORE || effectiveType == BnfTypes.BNF_OP_ONEMORE)) {
                    this.calcFirstInner((BnfExpression)parent, curResult, visited);
                    for (BnfExpression e : curResult) {
                        result.put(e, startingExpr);
                    }
                }
                cur = parent;
                parent = grandPa;
            }
            if (!(parent instanceof BnfRule) || this.myParentFilter != null && !this.myParentFilter.value((Object)parent) || !totalVisited.add((BnfRule)parent)) continue;
            BnfRule rule = (BnfRule)parent;
            for (PsiReference reference : ReferencesSearch.search((PsiElement)rule, (SearchScope)rule.getUseScope()).findAll()) {
                PsiElement element = reference.getElement();
                if (!(element instanceof BnfExpression) || PsiTreeUtil.getParentOfType((PsiElement)element, BnfPredicate.class) != null) continue;
                BnfAttr attr = (BnfAttr)PsiTreeUtil.getParentOfType((PsiElement)element, BnfAttr.class);
                if (attr != null) {
                    if (KnownAttribute.getCompatibleAttribute(attr.getName()) != KnownAttribute.RECOVER_WHILE) continue;
                    result.put(BNF_MATCHES_ANY, startingExpr);
                    continue;
                }
                stack.add((BnfExpression)element);
            }
        }
        if (result.isEmpty()) {
            result.put(BNF_MATCHES_EOF, null);
        }
        this.myNextCache.put(targetExpression, result);
        return result;
    }

    private Set<BnfExpression> calcSequenceFirstInner(List<BnfExpression> expressions, Set<BnfExpression> result, Set<BnfExpression> visited) {
        Set pinned;
        boolean matchesEof = !result.add(BNF_MATCHES_EOF);
        boolean pinApplied = false;
        if (!this.myBackward) {
            BnfExpression firstItem = (BnfExpression)ContainerUtil.getFirstItem(expressions);
            if (firstItem == null) {
                return result;
            }
            BnfRule rule = ParserGeneratorUtil.Rule.of(firstItem);
            pinned = new HashSet();
            GrammarUtil.processPinnedExpressions(rule, (Processor<? super BnfExpression>)new CommonProcessors.CollectProcessor(pinned));
            if (firstItem.getParent() instanceof BnfSequence) {
                for (BnfExpression e : ((BnfSequence)firstItem.getParent()).getExpressionList()) {
                    if (e == firstItem) break;
                    pinApplied |= pinned.contains(e);
                }
            }
        } else {
            pinned = Collections.emptySet();
        }
        List list = this.myBackward ? ContainerUtil.reverse(expressions) : expressions;
        int size = list.size();
        for (int i = 0; i < size && result.remove(BNF_MATCHES_EOF); ++i) {
            BnfExpression e;
            matchesEof |= pinApplied;
            e = (BnfExpression)list.get(i);
            this.calcFirstInner(e, result, visited, i < size - 1 ? Pair.create((Object)pinned.contains(e), list.subList(i + 1, size)) : null);
            pinApplied |= pinned.contains(e);
        }
        if (matchesEof) {
            result.add(BNF_MATCHES_EOF);
        }
        return result;
    }

    public Set<BnfExpression> calcFirstInner(BnfExpression expression, Set<BnfExpression> result, Set<BnfExpression> visited) {
        return this.calcFirstInner(expression, result, visited, null);
    }

    public Set<BnfExpression> calcFirstInner(BnfExpression expression, Set<BnfExpression> result, Set<BnfExpression> visited, @Nullable Pair<Boolean, List<BnfExpression>> forcedNext) {
        BnfFile file = (BnfFile)expression.getContainingFile();
        if (expression instanceof BnfLiteralExpression) {
            result.add(expression);
        } else if (expression instanceof BnfReferenceOrToken) {
            BnfRule rule = file.getRule(expression.getText());
            if (rule != null) {
                BnfExpression callExpr;
                if (ParserGeneratorUtil.Rule.isExternal(rule) && (callExpr = (BnfExpression)ContainerUtil.getFirstItem(GrammarUtil.getExternalRuleExpressions(rule))) instanceof BnfReferenceOrToken && file.getRule(callExpr.getText()) == null) {
                    result.add(callExpr);
                    return result;
                }
                BnfExpression ruleExpression = rule.getExpression();
                if (this.myPublicRuleOpaque && !ParserGeneratorUtil.Rule.isPrivate(rule) || !visited.add(ruleExpression)) {
                    if (!(ParserGeneratorUtil.Rule.firstNotTrivial(rule) instanceof BnfPredicate)) {
                        result.add(expression);
                    }
                } else {
                    this.calcFirstInner(ruleExpression, result, visited, forcedNext);
                    boolean removed = visited.remove(ruleExpression);
                    LOG.assertTrue(removed, (Object)("path corruption detected: " + ruleExpression.getText()));
                }
            } else {
                result.add(expression);
            }
        } else if (expression instanceof BnfParenthesized) {
            this.calcFirstInner(((BnfParenthesized)expression).getExpression(), result, visited, forcedNext);
            if (expression instanceof BnfParenOptExpression) {
                result.add(BNF_MATCHES_EOF);
            }
        } else if (expression instanceof BnfChoice) {
            boolean matchesNothing = result.remove(BNF_MATCHES_NOTHING);
            boolean matchesSomething = false;
            for (BnfExpression child : ((BnfChoice)expression).getExpressionList()) {
                this.calcFirstInner(child, result, visited, forcedNext);
                matchesSomething |= !result.remove(BNF_MATCHES_NOTHING);
            }
            if (!matchesSomething || matchesNothing) {
                result.add(BNF_MATCHES_NOTHING);
            }
        } else if (expression instanceof BnfSequence) {
            this.calcSequenceFirstInner(((BnfSequence)expression).getExpressionList(), result, visited);
        } else if (expression instanceof BnfQuantified) {
            this.calcFirstInner(((BnfQuantified)expression).getExpression(), result, visited, forcedNext);
            IElementType effectiveType = ParserGeneratorUtil.getEffectiveType(expression);
            if (effectiveType == BnfTypes.BNF_OP_OPT || effectiveType == BnfTypes.BNF_OP_ZEROMORE) {
                result.add(BNF_MATCHES_EOF);
            }
        } else if (expression instanceof BnfExternalExpression) {
            BnfExternalExpression externalExpression = (BnfExternalExpression)expression;
            List<BnfExpression> arguments = externalExpression.getArguments();
            if (arguments.isEmpty() && ParserGeneratorUtil.Rule.isMeta(ParserGeneratorUtil.Rule.of(expression))) {
                result.add(expression);
            } else {
                BnfExpression ruleRef = externalExpression.getRefElement();
                Set<BnfExpression> metaResults = this.calcFirstInner(ruleRef, new LinkedHashSet<BnfExpression>(), visited, forcedNext);
                List<String> params = null;
                for (BnfExpression e : metaResults) {
                    if (e instanceof BnfExternalExpression) {
                        int idx;
                        if (params == null) {
                            BnfRule metaRule = (BnfRule)ruleRef.getReference().resolve();
                            if (metaRule == null) {
                                LOG.error("ruleRef:" + ruleRef.getText() + ", metaResult:" + metaResults);
                                continue;
                            }
                            params = GrammarUtil.collectMetaParameters(metaRule, metaRule.getExpression());
                        }
                        if ((idx = params.indexOf(e.getText())) <= -1 || idx >= arguments.size()) continue;
                        this.calcFirstInner(arguments.get(idx), result, visited, null);
                        continue;
                    }
                    result.add(e);
                }
            }
        } else if ((this.myBackward || !this.myPredicateLookAhead) && expression instanceof BnfPredicate) {
            result.add(BNF_MATCHES_EOF);
        } else if (expression instanceof BnfPredicate) {
            Set<BnfExpression> mixed;
            Set<BnfExpression> next;
            IElementType elementType = ((BnfPredicate)expression).getPredicateSign().getFirstChild().getNode().getElementType();
            BnfExpression predicateExpression = ParserGeneratorUtil.getNonTrivialNode(((BnfPredicate)expression).getExpression());
            boolean skip = predicateExpression instanceof BnfSequence && ((BnfSequence)predicateExpression).getExpressionList().size() > 1;
            Set<BnfExpression> conditions = this.calcFirstInner(predicateExpression, BnfFirstNextAnalyzer.newExprSet(), visited, null);
            List<BnfExpression> externalCond = Collections.emptyList();
            List<Object> externalNext = Collections.emptyList();
            if (!visited.add(predicateExpression)) {
                skip = true;
                next = Collections.emptySet();
            } else {
                next = forcedNext == null ? this.calcNextInner(expression, new HashMap<BnfExpression, BnfExpression>(), visited).keySet() : this.calcSequenceFirstInner((List)forcedNext.second, BnfFirstNextAnalyzer.newExprSet(), visited);
                visited.remove(predicateExpression);
                externalCond = BnfFirstNextAnalyzer.filterExternalMethods(conditions);
                externalNext = BnfFirstNextAnalyzer.filterExternalMethods(next);
                if (!skip) {
                    boolean bl = skip = !externalCond.isEmpty();
                }
            }
            if (elementType == BnfTypes.BNF_OP_AND) {
                if (forcedNext != null && ((Boolean)forcedNext.first).booleanValue()) {
                    mixed = BnfFirstNextAnalyzer.newExprSet(conditions);
                } else if (skip) {
                    mixed = BnfFirstNextAnalyzer.exprSetUnion(next, externalCond);
                    mixed.remove(BNF_MATCHES_EOF);
                } else if (!conditions.contains(BNF_MATCHES_EOF)) {
                    if (next.contains(BNF_MATCHES_ANY)) {
                        mixed = BnfFirstNextAnalyzer.newExprSet(conditions);
                    } else if (externalNext.isEmpty()) {
                        mixed = BnfFirstNextAnalyzer.exprSetIntersection(conditions, next);
                        if (mixed.isEmpty() && !BnfFirstNextAnalyzer.involvesTextMatching(conditions)) {
                            mixed.add(BNF_MATCHES_NOTHING);
                        }
                    } else {
                        mixed = BnfFirstNextAnalyzer.newExprSet(conditions);
                    }
                } else {
                    mixed = BnfFirstNextAnalyzer.newExprSet(next);
                }
            } else if (skip) {
                mixed = BnfFirstNextAnalyzer.exprSetUnion(next, externalCond);
                mixed.remove(BNF_MATCHES_EOF);
            } else if (!conditions.contains(BNF_MATCHES_EOF)) {
                mixed = BnfFirstNextAnalyzer.exprSetDifference(next, conditions);
                if (mixed.isEmpty() && !BnfFirstNextAnalyzer.involvesTextMatching(conditions)) {
                    mixed.add(BNF_MATCHES_NOTHING);
                }
            } else {
                mixed = Collections.singleton(BNF_MATCHES_NOTHING);
            }
            result.addAll(mixed);
        }
        return result;
    }

    private static List<BnfExpression> filterExternalMethods(Set<BnfExpression> set) {
        if (set.removeIf(o -> "<<eof>>".equals(o.getText()))) {
            set.add(BNF_MATCHES_EOF);
        }
        return JBIterable.from(set).filter(GrammarUtil::isExternalReference).toList();
    }

    private static boolean involvesTextMatching(Set<BnfExpression> set) {
        for (BnfExpression o : set) {
            if (!(o instanceof BnfStringLiteralExpression) || RuleGraphHelper.getTokenTextToNameMap((BnfFile)o.getContainingFile()).containsKey(ParserGeneratorUtil.getLiteralValue((BnfStringLiteralExpression)o))) continue;
            return true;
        }
        return false;
    }

    public static Set<String> asStrings(Set<BnfExpression> expressions) {
        TreeSet<String> result = new TreeSet<String>();
        for (BnfExpression expression : expressions) {
            result.add(BnfFirstNextAnalyzer.asString(expression));
        }
        return result;
    }

    @NotNull
    public static String asString(@NotNull BnfExpression expression) {
        if (expression instanceof BnfLiteralExpression) {
            String text = expression.getText();
            return StringUtil.isQuotedString((String)text) ? "'" + GrammarUtil.unquote(text) + "'" : text;
        }
        if (GrammarUtil.isExternalReference(expression)) {
            return "#" + expression.getText();
        }
        return expression.getText();
    }

    @NotNull
    private static Set<BnfExpression> newExprSet() {
        return new ObjectOpenCustomHashSet(ParserGeneratorUtil.textStrategy());
    }

    @NotNull
    private static Set<BnfExpression> newExprSet(Collection<BnfExpression> expressions) {
        return new ObjectOpenCustomHashSet(expressions, ParserGeneratorUtil.textStrategy());
    }

    @NotNull
    private static Set<BnfExpression> exprSetUnion(Collection<BnfExpression> a, Collection<BnfExpression> b) {
        Set<BnfExpression> result = BnfFirstNextAnalyzer.newExprSet(a);
        result.addAll(b);
        return result;
    }

    @NotNull
    private static Set<BnfExpression> exprSetIntersection(@NotNull Set<BnfExpression> a, @NotNull Set<BnfExpression> b) {
        Set<BnfExpression> filter = BnfFirstNextAnalyzer.newExprSet(a);
        filter.retainAll(BnfFirstNextAnalyzer.newExprSet(b));
        Set result = ContainerUtil.union(a, b);
        result.retainAll(filter);
        return result;
    }

    @NotNull
    private static Set<BnfExpression> exprSetDifference(@NotNull Set<BnfExpression> a, @NotNull Set<BnfExpression> b) {
        Set<BnfExpression> filter = BnfFirstNextAnalyzer.newExprSet(a);
        filter.removeAll(BnfFirstNextAnalyzer.newExprSet(b));
        Set result = ContainerUtil.union(a, b);
        result.retainAll(filter);
        return result;
    }
}

