/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.editor;

import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.intellij.grammar.BnfIcons;
import org.intellij.grammar.GrammarKitBundle;
import org.intellij.grammar.editor.BnfSyntaxHighlighter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class BnfColorSettingsPage
implements ColorSettingsPage {
    private static final AttributesDescriptor[] ATTRS = new AttributesDescriptor[]{new AttributesDescriptor("Illegal character", BnfSyntaxHighlighter.ILLEGAL), new AttributesDescriptor("Comment", BnfSyntaxHighlighter.COMMENT), new AttributesDescriptor("String", BnfSyntaxHighlighter.STRING), new AttributesDescriptor("Number", BnfSyntaxHighlighter.NUMBER), new AttributesDescriptor("Keyword", BnfSyntaxHighlighter.KEYWORD), new AttributesDescriptor("Token", BnfSyntaxHighlighter.TOKEN), new AttributesDescriptor("Rule", BnfSyntaxHighlighter.RULE), new AttributesDescriptor("Attribute", BnfSyntaxHighlighter.ATTRIBUTE), new AttributesDescriptor("Meta rule", BnfSyntaxHighlighter.META_RULE), new AttributesDescriptor("Meta rule parameter", BnfSyntaxHighlighter.META_PARAM), new AttributesDescriptor("Pattern", BnfSyntaxHighlighter.PATTERN), new AttributesDescriptor("External", BnfSyntaxHighlighter.EXTERNAL), new AttributesDescriptor("Parenthesis", BnfSyntaxHighlighter.PARENTHS), new AttributesDescriptor("Braces", BnfSyntaxHighlighter.BRACES), new AttributesDescriptor("Brackets", BnfSyntaxHighlighter.BRACKETS), new AttributesDescriptor("Angles", BnfSyntaxHighlighter.ANGLES), new AttributesDescriptor("Operation sign", BnfSyntaxHighlighter.OP_SIGN), new AttributesDescriptor("Pin marker", BnfSyntaxHighlighter.PIN_MARKER), new AttributesDescriptor("Recover marker", BnfSyntaxHighlighter.RECOVER_MARKER)};

    @NotNull
    public String getDisplayName() {
        return GrammarKitBundle.message("language.name.bnf", new Object[0]);
    }

    public Icon getIcon() {
        return BnfIcons.FILE;
    }

    public AttributesDescriptor @NotNull [] getAttributeDescriptors() {
        return ATTRS;
    }

    public ColorDescriptor @NotNull [] getColorDescriptors() {
        return ColorDescriptor.EMPTY_ARRAY;
    }

    @NotNull
    public SyntaxHighlighter getHighlighter() {
        return new BnfSyntaxHighlighter();
    }

    @NotNull
    public String getDemoText() {
        return "/*\n * Sample grammar\n */\n{\n  <a>generatePsi</a>=<k>false</k>\n  <a>classHeader</a>=<pa>\"header.txt\"</pa>\n  <a>parserClass</a>=<pa>\"org.MyParser\"</pa>\n  <a>pin</a>(<pa>\".*_list(?:_\\d.*)?\"</pa>)=1\n  <a>tokens</a>=[\n    <a>COMMA</a>=<pa>\",\"</pa>\n    <a>LEFT_PAREN</a>=<pa>\"(\"</pa>\n    <a>RIGHT_PAREN</a>=<pa>\")\"</pa>\n  ]\n}\n// Grammar rules\n<r>root</r> ::= <r>header</r> <r>content</r>\n<r>header</r> ::= <t>DECLARE</t> <r>reference</r>\n<k>external</k> <r>reference</r> ::= <e>parseReference</e>\n<k>private</k> <k>meta</k> <mr>comma_list</mr> ::= <pin><s>'('</s></pin> <mp><<p>></mp> (<pin><s>','</s></pin> <mp><<p>></mp>) * ')'\n<k>private</k> <r>content</r> ::= <pin><t>AS</t></pin> <<<mr>comma_list</mr> <ru><r>element</r></ru>>> {<a>pin</a>=1}\n<ru><r>element</r></ru> ::= <r>reference</r> [ {<pa>'+'</pa> | <pa>'-'</pa>} <r>reference</r> <t>ONLY</t>?] {<a>recoverWhile</a>=<r>element_recover</r>}\n<k>private</k> <r>element_recover</r> ::= !(',' | ')')\n\n";
    }

    public Map<String, TextAttributesKey> getAdditionalHighlightingTagToDescriptorMap() {
        @NonNls HashMap<String, TextAttributesKey> map = new HashMap<String, TextAttributesKey>();
        map.put("r", BnfSyntaxHighlighter.RULE);
        map.put("mr", BnfSyntaxHighlighter.META_RULE);
        map.put("a", BnfSyntaxHighlighter.ATTRIBUTE);
        map.put("pa", BnfSyntaxHighlighter.PATTERN);
        map.put("t", BnfSyntaxHighlighter.TOKEN);
        map.put("k", BnfSyntaxHighlighter.KEYWORD);
        map.put("e", BnfSyntaxHighlighter.EXTERNAL);
        map.put("pin", BnfSyntaxHighlighter.PIN_MARKER);
        map.put("s", BnfSyntaxHighlighter.STRING);
        map.put("ru", BnfSyntaxHighlighter.RECOVER_MARKER);
        map.put("mp", BnfSyntaxHighlighter.META_PARAM);
        return map;
    }
}

