/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.editor;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PairProcessor;
import java.util.ArrayList;
import org.intellij.grammar.KnownAttribute;
import org.intellij.grammar.editor.BnfSyntaxHighlighter;
import org.intellij.grammar.generator.ExpressionGeneratorHelper;
import org.intellij.grammar.generator.ExpressionHelper;
import org.intellij.grammar.generator.ParserGeneratorUtil;
import org.intellij.grammar.psi.BnfAttr;
import org.intellij.grammar.psi.BnfExpression;
import org.intellij.grammar.psi.BnfFile;
import org.intellij.grammar.psi.BnfRule;
import org.intellij.grammar.psi.impl.GrammarUtil;
import org.jetbrains.annotations.NotNull;

public class BnfPinMarkerAnnotator
implements Annotator,
DumbAware {
    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder annotationHolder) {
        if (!(psiElement instanceof BnfRule)) {
            return;
        }
        BnfRule rule = (BnfRule)psiElement;
        BnfFile bnfFile = (BnfFile)rule.getContainingFile();
        ExpressionHelper exprHelper = ExpressionHelper.getCached(bnfFile);
        boolean isExprParsing = ExpressionGeneratorHelper.getInfoForExpressionParsing(exprHelper, rule) != null;
        ArrayList pinned = new ArrayList();
        GrammarUtil.processPinnedExpressions(rule, (PairProcessor<? super BnfExpression, ? super ParserGeneratorUtil.PinMatcher>)((PairProcessor)(expr, pinMatcher) -> {
            if (isExprParsing && expr.getParent().getParent() == rule) {
                return true;
            }
            BnfAttr attr = bnfFile.findAttribute(pinMatcher.rule, KnownAttribute.PIN, pinMatcher.funcName);
            pinned.add(Pair.create((Object)expr, (Object)attr));
            return true;
        }));
        int len = pinned.size();
        for (int i = 0; i < len; ++i) {
            TextRange infoRange;
            BnfExpression e = (BnfExpression)((Pair)pinned.get((int)i)).first;
            BnfExpression prev = i == 0 ? null : (BnfExpression)((Pair)pinned.get((int)(i - 1))).first;
            BnfAttr attr = (BnfAttr)((Pair)pinned.get((int)i)).second;
            boolean fullRange = prev == null || !PsiTreeUtil.isAncestor((PsiElement)e, (PsiElement)prev, (boolean)true);
            TextRange textRange = e.getTextRange();
            TextRange textRange2 = infoRange = fullRange ? textRange : TextRange.create((int)(prev.getTextRange().getEndOffset() + 1), (int)textRange.getEndOffset());
            String message = attr == null ? (fullRange ? "Pinned" : "Pinned again") : attr.getText();
            annotationHolder.newAnnotation(HighlightSeverity.INFORMATION, message).range(infoRange).textAttributes(BnfSyntaxHighlighter.PIN_MARKER).create();
        }
    }
}

