/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.generator;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.intellij.grammar.KnownAttribute;
import org.intellij.grammar.generator.ExpressionHelper;
import org.intellij.grammar.generator.ParserGenerator;
import org.intellij.grammar.generator.ParserGeneratorUtil;
import org.intellij.grammar.psi.BnfExpression;
import org.intellij.grammar.psi.BnfRule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpressionGeneratorHelper {
    private static final ParserGeneratorUtil.ConsumeType CONSUME_TYPE_OVERRIDE = ParserGeneratorUtil.ConsumeType.SMART;

    @NotNull
    private static Map<String, List<ExpressionHelper.OperatorInfo>> buildCallMap(ExpressionHelper.ExpressionInfo info, ParserGenerator g) {
        LinkedHashMap<String, List<ExpressionHelper.OperatorInfo>> opCalls = new LinkedHashMap<String, List<ExpressionHelper.OperatorInfo>>();
        for (BnfRule rule : info.priorityMap.keySet()) {
            ExpressionHelper.OperatorInfo operator = info.operatorMap.get(rule);
            String opCall = g.generateNodeCall(info.rootRule, operator.operator, ParserGeneratorUtil.getNextName(ParserGeneratorUtil.getFuncName(operator.rule), 0), CONSUME_TYPE_OVERRIDE).render(g.N);
            opCalls.computeIfAbsent(opCall, k -> new ArrayList(2)).add(operator);
        }
        return opCalls;
    }

    public static void generateExpressionRoot(ExpressionHelper.ExpressionInfo info, ParserGenerator g) {
        ExpressionHelper.OperatorInfo operator;
        List<ExpressionHelper.OperatorInfo> operators;
        Map<String, List<ExpressionHelper.OperatorInfo>> opCalls = ExpressionGeneratorHelper.buildCallMap(info, g);
        Set<String> sortedOpCalls = opCalls.keySet();
        for (String s : info.toString().split("\n")) {
            g.out("// " + s);
        }
        String methodName = ParserGeneratorUtil.getFuncName(info.rootRule);
        String kernelMethodName = ParserGeneratorUtil.getNextName(methodName, 0);
        String frameName = ParserGeneratorUtil.quote(ParserGeneratorUtil.getRuleDisplayName(info.rootRule, true));
        String shortPB = g.shorten("com.intellij.lang.PsiBuilder");
        String shortMarker = !g.G.generateFQN ? "Marker" : "com.intellij.lang.PsiBuilder.Marker";
        g.out("public static boolean %s(%s %s, int %s, int %s) {", methodName, shortPB, g.N.builder, g.N.level, g.N.priority);
        g.out("if (!recursion_guard_(%s, %s, \"%s\")) return false;", g.N.builder, g.N.level, methodName);
        if (frameName != null) {
            g.out("addVariant(%s, %s);", g.N.builder, frameName);
        }
        g.generateFirstCheck(info.rootRule, frameName, true);
        g.out("boolean %s, %s;", g.N.result, g.N.pinned);
        g.out("%s %s = enter_section_(%s, %s, _NONE_, %s);", shortMarker, g.N.marker, g.N.builder, g.N.level, frameName);
        boolean first = true;
        for (String opCall : sortedOpCalls) {
            operators = ExpressionGeneratorHelper.findOperators((Collection<ExpressionHelper.OperatorInfo>)opCalls.get(opCall), ExpressionHelper.OperatorType.ATOM, ExpressionHelper.OperatorType.PREFIX);
            if (operators.isEmpty()) continue;
            operator = operators.get(0);
            if (operators.size() > 1) {
                g.addWarning("only first definition will be used for '" + operator.operator.getText() + "': " + operators);
            }
            String nodeCall = g.generateNodeCall(operator.rule, null, operator.rule.getName()).render(g.N);
            g.out("%s%s = %s;", first ? "" : String.format("if (!%s) ", g.N.result), g.N.result, nodeCall);
            first = false;
        }
        g.out("%s = %s;", g.N.pinned, g.N.result);
        g.out("%s = %s && %s(%s, %s + 1, %s);", g.N.result, g.N.result, kernelMethodName, g.N.builder, g.N.level, g.N.priority);
        g.out("exit_section_(%s, %s, %s, null, %s, %s, null);", g.N.builder, g.N.level, g.N.marker, g.N.result, g.N.pinned);
        g.out("return %s || %s;", g.N.result, g.N.pinned);
        g.out("}");
        g.newLine();
        g.out("public static boolean %s(%s %s, int %s, int %s) {", kernelMethodName, shortPB, g.N.builder, g.N.level, g.N.priority);
        g.out("if (!recursion_guard_(%s, %s, \"%s\")) return false;", g.N.builder, g.N.level, kernelMethodName);
        g.out("boolean %s = true;", g.N.result);
        g.out("while (true) {");
        g.out("%s %s = enter_section_(%s, %s, _LEFT_, null);", shortMarker, g.N.marker, g.N.builder, g.N.level);
        first = true;
        for (String opCall : sortedOpCalls) {
            String tailCall;
            operators = ExpressionGeneratorHelper.findOperators((Collection<ExpressionHelper.OperatorInfo>)opCalls.get(opCall), ExpressionHelper.OperatorType.BINARY, ExpressionHelper.OperatorType.N_ARY, ExpressionHelper.OperatorType.POSTFIX);
            if (operators.isEmpty()) continue;
            operator = operators.get(0);
            if (operators.size() > 1) {
                g.addWarning("only first definition will be used for '" + operator.operator.getText() + "': " + operators);
            }
            int priority = info.getPriority(operator.rule);
            int arg2Priority = operator.arg2 == null ? -1 : info.getPriority(operator.arg2);
            int argPriority = arg2Priority == -1 ? priority : arg2Priority - 1;
            String substCheck = "";
            if (operator.arg1 != null) {
                substCheck = String.format(" && leftMarkerIs(%s, %s)", g.N.builder, g.getElementType(operator.arg1));
            }
            g.out("%sif (%s < %d%s && %s) {", first ? "" : "else ", g.N.priority, priority, substCheck, opCall);
            first = false;
            String elementType = g.getElementType(operator.rule);
            boolean rightAssociative = ParserGeneratorUtil.getAttribute(operator.rule, KnownAttribute.RIGHT_ASSOCIATIVE);
            String string = tailCall = operator.tail == null ? null : g.generateNodeCall(operator.rule, operator.tail, ParserGeneratorUtil.getNextName(ParserGeneratorUtil.getFuncName(operator.rule), 1), ParserGeneratorUtil.ConsumeType.DEFAULT).render(g.N);
            if (operator.type == ExpressionHelper.OperatorType.BINARY) {
                String argCall = String.format("%s(%s, %s, %d)", methodName, g.N.builder, g.N.level, rightAssociative ? argPriority - 1 : argPriority);
                g.out("%s = %s;", g.N.result, tailCall == null ? argCall : String.format("report_error_(%s, %s)", g.N.builder, argCall));
                if (tailCall != null) {
                    g.out("%s = %s && %s;", g.N.result, tailCall, g.N.result);
                }
            } else if (operator.type == ExpressionHelper.OperatorType.N_ARY) {
                boolean checkEmpty = info.checkEmpty.contains(operator);
                if (checkEmpty) {
                    g.out("int %s = current_position_(%s);", g.N.pos, g.N.builder);
                }
                g.out("while (true) {");
                g.out("%s = report_error_(%s, %s(%s, %s, %d));", g.N.result, g.N.builder, methodName, g.N.builder, g.N.level, argPriority);
                if (tailCall != null) {
                    g.out("%s = %s && %s;", g.N.result, tailCall, g.N.result);
                }
                g.out("if (!%s) break;", opCall);
                if (checkEmpty) {
                    g.out("if (!empty_element_parsed_guard_(%s, \"%s\", %s)) break;", g.N.builder, operator.rule.getName(), g.N.pos);
                    g.out("%s = current_position_(%s);", g.N.pos, g.N.builder);
                }
                g.out("}");
            } else if (operator.type == ExpressionHelper.OperatorType.POSTFIX) {
                g.out("%s = true;", g.N.result);
            }
            g.out("exit_section_(%s, %s, %s, %s, %s, true, null);", g.N.builder, g.N.level, g.N.marker, elementType, g.N.result);
            g.out("}");
        }
        if (first) {
            g.out("// no BINARY or POSTFIX operators present");
            g.out("break;");
        } else {
            g.out("else {");
            g.out("exit_section_(%s, %s, %s, null, false, false, null);", g.N.builder, g.N.level, g.N.marker);
            g.out("break;");
            g.out("}");
        }
        g.out("}");
        g.out("return %s;", g.N.result);
        g.out("}");
        HashSet<BnfExpression> visited = new HashSet<BnfExpression>();
        for (String opCall : sortedOpCalls) {
            for (ExpressionHelper.OperatorInfo operator2 : opCalls.get(opCall)) {
                if (operator2.type == ExpressionHelper.OperatorType.ATOM) {
                    if (ParserGeneratorUtil.Rule.isExternal(operator2.rule)) continue;
                    g.newLine();
                    g.generateNode(operator2.rule, operator2.rule.getExpression(), ParserGeneratorUtil.getFuncName(operator2.rule), visited);
                    continue;
                }
                if (operator2.type == ExpressionHelper.OperatorType.PREFIX) {
                    int arg1Priority;
                    g.newLine();
                    String operatorFuncName = operator2.rule.getName();
                    g.out("public static boolean %s(%s %s, int %s) {", operatorFuncName, shortPB, g.N.builder, g.N.level);
                    g.out("if (!recursion_guard_(%s, %s, \"%s\")) return false;", g.N.builder, g.N.level, operatorFuncName);
                    g.generateFirstCheck(operator2.rule, frameName, false);
                    g.out("boolean %s, %s;", g.N.result, g.N.pinned);
                    g.out("%s %s = enter_section_(%s, %s, _NONE_, null);", shortMarker, g.N.marker, g.N.builder, g.N.level);
                    String elementType = g.getElementType(operator2.rule);
                    String tailCall = operator2.tail == null ? null : g.generateNodeCall(operator2.rule, operator2.tail, ParserGeneratorUtil.getNextName(ParserGeneratorUtil.getFuncName(operator2.rule), 1), ParserGeneratorUtil.ConsumeType.DEFAULT).render(g.N);
                    g.out("%s = %s;", g.N.result, opCall);
                    g.out("%s = %s;", g.N.pinned, g.N.result);
                    int priority = info.getPriority(operator2.rule);
                    int n = arg1Priority = operator2.arg1 == null ? -1 : info.getPriority(operator2.arg1);
                    int argPriority = arg1Priority == -1 ? (priority == info.nextPriority - 1 ? -1 : priority) : arg1Priority - 1;
                    g.out("%s = %s && %s(%s, %s, %d);", g.N.result, g.N.pinned, methodName, g.N.builder, g.N.level, argPriority);
                    if (tailCall != null) {
                        g.out("%s = %s && report_error_(%s, %s) && %s;", g.N.result, g.N.pinned, g.N.builder, tailCall, g.N.result);
                    }
                    String elementTypeRef = StringUtil.isNotEmpty((String)elementType) ? elementType : "null";
                    g.out("exit_section_(%s, %s, %s, %s, %s, %s, null);", g.N.builder, g.N.level, g.N.marker, elementTypeRef, g.N.result, g.N.pinned);
                    g.out("return %s || %s;", g.N.result, g.N.pinned);
                    g.out("}");
                }
                g.generateNodeChild(operator2.rule, operator2.operator, ParserGeneratorUtil.getFuncName(operator2.rule), 0, visited);
                if (operator2.tail == null) continue;
                g.generateNodeChild(operator2.rule, operator2.tail, operator2.rule.getName(), 1, visited);
            }
        }
    }

    @NotNull
    public static List<ExpressionHelper.OperatorInfo> findOperators(Collection<ExpressionHelper.OperatorInfo> list, ExpressionHelper.OperatorType ... types) {
        SmartList result = new SmartList();
        for (ExpressionHelper.OperatorInfo o : list) {
            if (!ArrayUtil.contains((Object)((Object)o.type), (Object[])types)) continue;
            result.add(o);
        }
        return result;
    }

    @Nullable
    public static ExpressionHelper.ExpressionInfo getInfoForExpressionParsing(ExpressionHelper expressionHelper, BnfRule rule) {
        ExpressionHelper.OperatorInfo operatorInfo;
        ExpressionHelper.ExpressionInfo expressionInfo = expressionHelper.getExpressionInfo(rule);
        ExpressionHelper.OperatorInfo operatorInfo2 = operatorInfo = expressionInfo == null ? null : expressionInfo.operatorMap.get(rule);
        if (expressionInfo != null && (operatorInfo == null || operatorInfo.type != ExpressionHelper.OperatorType.ATOM && operatorInfo.type != ExpressionHelper.OperatorType.PREFIX)) {
            return expressionInfo;
        }
        return null;
    }

    @Nullable
    public static ParserGeneratorUtil.ConsumeType fixForcedConsumeType(@NotNull ExpressionHelper expressionHelper, @NotNull BnfRule rule, @Nullable BnfExpression node, @Nullable ParserGeneratorUtil.ConsumeType defValue) {
        ExpressionHelper.OperatorInfo operatorInfo;
        if (defValue != null) {
            return defValue;
        }
        ExpressionHelper.ExpressionInfo expressionInfo = expressionHelper.getExpressionInfo(rule);
        ExpressionHelper.OperatorInfo operatorInfo2 = operatorInfo = expressionInfo == null ? null : expressionInfo.operatorMap.get(rule);
        if (operatorInfo != null) {
            if (node == null) {
                return operatorInfo.type == ExpressionHelper.OperatorType.PREFIX || operatorInfo.type == ExpressionHelper.OperatorType.ATOM ? CONSUME_TYPE_OVERRIDE : null;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)operatorInfo.operator, (PsiElement)node, (boolean)false)) {
                return CONSUME_TYPE_OVERRIDE;
            }
            for (BnfExpression o : ExpressionHelper.getOriginalExpressions(operatorInfo.operator)) {
                if (!PsiTreeUtil.isAncestor((PsiElement)o, (PsiElement)node, (boolean)false)) continue;
                return CONSUME_TYPE_OVERRIDE;
            }
        }
        return null;
    }
}

