/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.generator;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.Map;
import org.intellij.grammar.KnownAttribute;
import org.intellij.grammar.generator.Case;
import org.intellij.grammar.generator.Names;
import org.intellij.grammar.generator.ParserGeneratorUtil;
import org.intellij.grammar.psi.BnfFile;

public class GenOptions {
    public final Names names;
    public final int generateFirstCheck;
    public final boolean generateTokenTypes;
    public final boolean generateTokenSets;
    public final boolean generateElementTypes;
    public final String generateExactTypes;
    public final boolean generateExtendedPin;
    public final boolean generatePsi;
    public final boolean generatePsiFactory;
    public final boolean generatePsiClassesMap;
    public final boolean generateVisitor;
    public final String visitorValue;
    public final boolean generateFQN;
    public final Case generateTokenCase;
    public final Case generateElementCase;
    public final boolean generateTokenAccessors;
    public final boolean generateTokenAccessorsSet;
    public final int javaVersion;

    public GenOptions(BnfFile myFile) {
        Map<String, String> genOptions = ParserGeneratorUtil.getRootAttribute((PsiElement)myFile, KnownAttribute.GENERATE).asMap();
        this.names = Names.forName(genOptions.get("names"));
        this.generatePsi = ParserGeneratorUtil.getGenerateOption((PsiElement)myFile, KnownAttribute.GENERATE_PSI, genOptions, "psi");
        this.generatePsiFactory = !"no".equals(genOptions.get("psi-factory"));
        this.generatePsiClassesMap = "yes".equals(genOptions.get("psi-classes-map"));
        this.generateTokenTypes = ParserGeneratorUtil.getGenerateOption((PsiElement)myFile, KnownAttribute.GENERATE_TOKENS, genOptions, "tokens");
        this.generateTokenSets = this.generateTokenTypes && "yes".equals(genOptions.get("token-sets"));
        this.generateElementTypes = !"no".equals(genOptions.get("elements"));
        this.generateExactTypes = StringUtil.notNullize((String)genOptions.get("exact-types"));
        this.generateFirstCheck = ParserGeneratorUtil.getGenerateOption((PsiElement)myFile, KnownAttribute.GENERATE_FIRST_CHECK, genOptions, "first-check", "firstCheck");
        this.generateExtendedPin = ParserGeneratorUtil.getGenerateOption((PsiElement)myFile, KnownAttribute.EXTENDED_PIN, genOptions, "extended-pin", "extendedPin");
        this.generateTokenAccessors = ParserGeneratorUtil.getGenerateOption((PsiElement)myFile, KnownAttribute.GENERATE_TOKEN_ACCESSORS, genOptions, "token-accessors", "tokenAccessors");
        this.generateTokenAccessorsSet = genOptions.containsKey("token-accessors") || genOptions.containsKey("tokenAccessors");
        this.generateVisitor = !"no".equals(genOptions.get("visitor"));
        this.visitorValue = "void".equals(genOptions.get("visitor-value")) ? null : StringUtil.nullize((String)genOptions.get("visitor-value"));
        this.generateFQN = "yes".equals(genOptions.get("fqn"));
        this.generateTokenCase = ParserGeneratorUtil.enumFromString(genOptions.get("token-case"), Case.UPPER);
        this.generateElementCase = ParserGeneratorUtil.enumFromString(genOptions.get("element-case"), Case.UPPER);
        this.javaVersion = StringUtil.parseInt((String)genOptions.get("java"), (int)11);
    }
}

