/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.generator;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.intellij.grammar.generator.Names;
import org.intellij.grammar.generator.ParserGeneratorUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeCalls {
    private NodeCalls() {
    }

    static class MetaParameterArgument
    extends TextArgument {
        MetaParameterArgument(@NotNull String text) {
            super(text);
        }

        @Override
        public boolean referencesMetaParameter() {
            return true;
        }
    }

    static class TextArgument
    implements NodeArgument {
        final String text;

        TextArgument(@NotNull String text) {
            this.text = text;
        }

        @Override
        @NotNull
        public String render() {
            return this.text;
        }
    }

    static class MethodCallWithArguments
    implements NodeCall {
        final String methodName;
        final List<NodeArgument> arguments;

        MethodCallWithArguments(@NotNull String methodName, @NotNull List<NodeArgument> arguments) {
            this.methodName = methodName;
            this.arguments = Collections.unmodifiableList(arguments);
        }

        @NotNull
        protected String getMethodRef() {
            return this.methodName;
        }

        @Override
        @NotNull
        public String render(@NotNull Names names) {
            String argumentStr = this.arguments.stream().map(NodeArgument::render).map(it -> ", " + it).collect(Collectors.joining());
            return String.format("%s(%s, %s + 1%s)", this.getMethodRef(), names.builder, names.level, argumentStr);
        }
    }

    static class MethodCall
    implements NodeCall {
        final boolean renderClass;
        final String className;
        final String methodName;

        MethodCall(boolean renderClass, @NotNull String className, @NotNull String methodName) {
            this.renderClass = renderClass;
            this.className = className;
            this.methodName = methodName;
        }

        @NotNull
        String getMethodName() {
            return this.methodName;
        }

        @NotNull
        String getClassName() {
            return this.className;
        }

        @Override
        @NotNull
        public String render(@NotNull Names names) {
            if (this.renderClass) {
                return String.format("%s.%s(%s, %s + 1)", this.className, this.methodName, names.builder, names.level);
            }
            return String.format("%s(%s, %s + 1)", this.methodName, names.builder, names.level);
        }
    }

    static class MetaParameterCall
    implements NodeCall {
        final String metaParameterName;

        MetaParameterCall(@NotNull String metaParameterName) {
            this.metaParameterName = metaParameterName;
        }

        @Override
        @NotNull
        public String render(@NotNull Names names) {
            return String.format("%s.parse(%s, %s)", this.metaParameterName, names.builder, names.level);
        }
    }

    static class MetaMethodCallArgument
    implements NodeArgument {
        final MetaMethodCall call;

        MetaMethodCallArgument(@NotNull MetaMethodCall call) {
            this.call = call;
        }

        @Override
        public boolean referencesMetaParameter() {
            return true;
        }

        @NotNull
        private String getMethodRef() {
            String ref = ParserGeneratorUtil.getWrapperParserMetaMethodName(this.call.methodName);
            String className = this.call.getTargetClassName();
            return className == null ? ref : String.format("%s.%s", className, ref);
        }

        @Override
        @NotNull
        public String render() {
            String arguments = String.join((CharSequence)", ", ContainerUtil.map((Collection)this.call.arguments, NodeArgument::render));
            return String.format("%s(%s)", this.getMethodRef(), arguments);
        }
    }

    static class MetaMethodCall
    extends MethodCallWithArguments {
        @Nullable
        final String targetClassName;

        MetaMethodCall(@Nullable String targetClassName, @NotNull String methodName, @NotNull List<NodeArgument> arguments) {
            super(methodName, arguments);
            this.targetClassName = targetClassName;
        }

        boolean referencesMetaParameter() {
            return ContainerUtil.exists((Iterable)this.arguments, NodeArgument::referencesMetaParameter);
        }

        @Nullable
        String getTargetClassName() {
            return this.targetClassName;
        }

        @Override
        @NotNull
        protected String getMethodRef() {
            String ref = super.getMethodRef();
            return this.targetClassName == null ? ref : String.format("%s.%s", this.targetClassName, ref);
        }
    }

    static class ExpressionMethodCall
    implements NodeCall {
        final String methodName;
        final int priority;

        ExpressionMethodCall(@NotNull String methodName, int priority) {
            this.methodName = methodName;
            this.priority = priority;
        }

        @Override
        @NotNull
        public String render(@NotNull Names names) {
            return String.format("%s(%s, %s + 1, %d)", this.methodName, names.builder, names.level, this.priority);
        }
    }

    static class ConsumeTokensCall
    implements NodeCall {
        final String methodName;
        final int pin;
        final List<String> tokens;

        ConsumeTokensCall(@NotNull String methodName, int pin, @NotNull List<String> tokens) {
            this.methodName = methodName;
            this.pin = pin;
            this.tokens = Collections.unmodifiableList(tokens);
        }

        @Override
        @NotNull
        public String render(@NotNull Names names) {
            return String.format("%s(%s, %d, %s)", this.methodName, names.builder, this.pin, StringUtil.join(this.tokens, (String)", "));
        }
    }

    static class ConsumeTokenChoiceCall
    implements NodeCall {
        final ParserGeneratorUtil.ConsumeType consumeType;
        final String tokenSetName;

        ConsumeTokenChoiceCall(@NotNull ParserGeneratorUtil.ConsumeType consumeType, @NotNull String tokenSetName) {
            this.consumeType = consumeType;
            this.tokenSetName = tokenSetName;
        }

        @Override
        @NotNull
        public String render(@NotNull Names names) {
            return String.format("%s(%s, %s)", this.consumeType.getMethodName(), names.builder, this.tokenSetName);
        }
    }

    static class ConsumeTokenCall
    implements NodeCall {
        final ParserGeneratorUtil.ConsumeType consumeType;
        final String token;

        ConsumeTokenCall(@NotNull ParserGeneratorUtil.ConsumeType consumeType, @NotNull String token) {
            this.consumeType = consumeType;
            this.token = token;
        }

        @Override
        @NotNull
        public String render(@NotNull Names names) {
            return String.format("%s(%s, %s)", this.consumeType.getMethodName(), names.builder, this.token);
        }
    }

    static interface NodeArgument {
        default public boolean referencesMetaParameter() {
            return false;
        }

        @NotNull
        public String render();
    }

    static interface NodeCall {
        @NotNull
        public String render(@NotNull Names var1);
    }
}

