/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.generator;

import com.intellij.notification.NotificationGroupManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.TreeTraversal;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.intellij.grammar.KnownAttribute;
import org.intellij.grammar.analysis.BnfFirstNextAnalyzer;
import org.intellij.grammar.generator.Case;
import org.intellij.grammar.generator.ExpressionGeneratorHelper;
import org.intellij.grammar.generator.ExpressionHelper;
import org.intellij.grammar.generator.GenOptions;
import org.intellij.grammar.generator.NameShortener;
import org.intellij.grammar.generator.Names;
import org.intellij.grammar.generator.NodeCalls;
import org.intellij.grammar.generator.ParserGeneratorUtil;
import org.intellij.grammar.generator.RuleGraphHelper;
import org.intellij.grammar.generator.RuleMethodsHelper;
import org.intellij.grammar.java.JavaHelper;
import org.intellij.grammar.psi.BnfExpression;
import org.intellij.grammar.psi.BnfExternalExpression;
import org.intellij.grammar.psi.BnfFile;
import org.intellij.grammar.psi.BnfLiteralExpression;
import org.intellij.grammar.psi.BnfReferenceOrToken;
import org.intellij.grammar.psi.BnfRule;
import org.intellij.grammar.psi.BnfSequence;
import org.intellij.grammar.psi.BnfStringLiteralExpression;
import org.intellij.grammar.psi.BnfTypes;
import org.intellij.grammar.psi.impl.GrammarUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParserGenerator {
    public static final Logger LOG = Logger.getInstance(ParserGenerator.class);
    private final Map<String, RuleInfo> myRuleInfos = new TreeMap<String, RuleInfo>();
    private final Map<String, String> myParserLambdas = new HashMap<String, String>();
    private final Map<String, String> myRenderedLambdas = new HashMap<String, String>();
    private final Set<String> myInlinedChildNodes = new HashSet<String>();
    private final Map<String, String> myMetaMethodFields = new HashMap<String, String>();
    private final Map<String, Collection<String>> myTokenSets = new TreeMap<String, Collection<String>>();
    private final Map<String, String> mySimpleTokens;
    private final Set<String> myTokensUsedInGrammar = new LinkedHashSet<String>();
    private final boolean myNoStubs;
    private final BnfFile myFile;
    private final String mySourcePath;
    private final String myOutputPath;
    private final String myPackagePrefix;
    private final String myGrammarRoot;
    private final String myGrammarRootParser;
    private final String myParserUtilClass;
    private final String myPsiImplUtilClass;
    private final String myPsiTreeUtilClass;
    private final ParserGeneratorUtil.NameFormat myIntfClassFormat;
    private final ParserGeneratorUtil.NameFormat myImplClassFormat;
    private final String myVisitorClassName;
    private final String myTypeHolderClass;
    private int myOffset;
    private PrintWriter myOut;
    private NameShortener myShortener;
    private final RuleGraphHelper myGraphHelper;
    private final ExpressionHelper myExpressionHelper;
    private final RuleMethodsHelper myRulesMethodsHelper;
    private final BnfFirstNextAnalyzer myFirstNextAnalyzer;
    private final JavaHelper myJavaHelper;
    final Names N;
    final GenOptions G;

    @NotNull
    RuleInfo ruleInfo(BnfRule rule) {
        return Objects.requireNonNull(this.myRuleInfos.get(rule.getName()));
    }

    public ParserGenerator(@NotNull BnfFile psiFile, @NotNull String sourcePath, @NotNull String outputPath, @NotNull String packagePrefix) {
        this.myFile = psiFile;
        this.mySourcePath = sourcePath;
        this.myOutputPath = outputPath;
        this.myPackagePrefix = packagePrefix;
        this.G = new GenOptions(this.myFile);
        this.N = this.G.names;
        this.myIntfClassFormat = ParserGeneratorUtil.getPsiClassFormat(this.myFile);
        this.myImplClassFormat = ParserGeneratorUtil.getPsiImplClassFormat(this.myFile);
        this.myParserUtilClass = ParserGeneratorUtil.getRootAttribute((PsiElement)this.myFile, KnownAttribute.PARSER_UTIL_CLASS);
        this.myPsiImplUtilClass = ParserGeneratorUtil.getRootAttribute((PsiElement)this.myFile, KnownAttribute.PSI_IMPL_UTIL_CLASS);
        this.myPsiTreeUtilClass = ParserGeneratorUtil.getRootAttribute((PsiElement)this.myFile, KnownAttribute.PSI_TREE_UTIL_CLASS);
        String tmpVisitorClass = ParserGeneratorUtil.getRootAttribute((PsiElement)this.myFile, KnownAttribute.PSI_VISITOR_NAME);
        tmpVisitorClass = !this.G.generateVisitor || StringUtil.isEmpty((String)tmpVisitorClass) ? null : (!tmpVisitorClass.equals(this.myIntfClassFormat.strip(tmpVisitorClass)) ? tmpVisitorClass : this.myIntfClassFormat.apply("") + tmpVisitorClass);
        this.myVisitorClassName = tmpVisitorClass == null || !tmpVisitorClass.equals(StringUtil.getShortName((String)tmpVisitorClass)) ? tmpVisitorClass : ParserGeneratorUtil.getRootAttribute((PsiElement)this.myFile, KnownAttribute.PSI_PACKAGE) + "." + tmpVisitorClass;
        this.myTypeHolderClass = ParserGeneratorUtil.getRootAttribute((PsiElement)this.myFile, KnownAttribute.ELEMENT_TYPE_HOLDER_CLASS);
        this.mySimpleTokens = new LinkedHashMap<String, String>(RuleGraphHelper.getTokenTextToNameMap(this.myFile));
        this.myGraphHelper = RuleGraphHelper.getCached(this.myFile);
        this.myExpressionHelper = new ExpressionHelper(this.myFile, this.myGraphHelper, this::addWarning);
        this.myRulesMethodsHelper = new RuleMethodsHelper(this.myGraphHelper, this.myExpressionHelper, this.mySimpleTokens, this.G);
        this.myFirstNextAnalyzer = BnfFirstNextAnalyzer.createAnalyzer(true);
        this.myJavaHelper = JavaHelper.getJavaHelper((PsiElement)this.myFile);
        List<BnfRule> rules = psiFile.getRules();
        BnfRule rootRule = rules.isEmpty() ? null : rules.get(0);
        this.myGrammarRoot = rootRule == null ? null : rootRule.getName();
        for (BnfRule r : rules) {
            String ruleName = r.getName();
            boolean noPsi = !RuleGraphHelper.hasPsiClass(r);
            this.myRuleInfos.put(ruleName, new RuleInfo(ruleName, ParserGeneratorUtil.Rule.isFake(r), this.getElementType(r), ParserGeneratorUtil.getAttribute(r, KnownAttribute.PARSER_CLASS), noPsi ? null : ParserGeneratorUtil.getAttribute(r, KnownAttribute.PSI_PACKAGE), noPsi ? null : ParserGeneratorUtil.getAttribute(r, KnownAttribute.PSI_IMPL_PACKAGE), noPsi ? null : ParserGeneratorUtil.getRulePsiClassName(r, this.myIntfClassFormat), noPsi ? null : ParserGeneratorUtil.getRulePsiClassName(r, this.myImplClassFormat), noPsi ? null : ParserGeneratorUtil.getAttribute(r, KnownAttribute.MIXIN), noPsi ? null : ParserGeneratorUtil.getAttribute(r, KnownAttribute.STUB_CLASS)));
        }
        this.myGrammarRootParser = rootRule == null ? null : this.ruleInfo((BnfRule)rootRule).parserClass;
        this.myNoStubs = JBIterable.from(this.myRuleInfos.values()).find(o -> o.stub != null) == null;
        this.calcFakeRulesWithType();
        this.calcRulesStubNames();
        this.calcAbstractRules();
    }

    private void calcAbstractRules() {
        HashSet<String> reusedRules = new HashSet<String>();
        for (BnfRule rule : this.myFile.getRules()) {
            String elementType = ParserGeneratorUtil.getAttribute(rule, KnownAttribute.ELEMENT_TYPE);
            BnfRule r = elementType != null ? this.myFile.getRule(elementType) : null;
            if (r == null || r == rule) continue;
            reusedRules.add(r.getName());
        }
        for (BnfRule rule : this.myFile.getRules()) {
            if (reusedRules.contains(rule.getName()) || this.myGrammarRoot.equals(rule.getName()) || !rule.getModifierList().isEmpty() || ParserGeneratorUtil.getAttribute(rule, KnownAttribute.RECOVER_WHILE) != null || !ParserGeneratorUtil.getAttribute(rule, KnownAttribute.HOOKS).isEmpty() || !this.myGraphHelper.canCollapse(rule) || !this.myGraphHelper.getFor(rule).isEmpty()) continue;
            this.ruleInfo((BnfRule)rule).isAbstract = true;
        }
    }

    private void calcFakeRulesWithType() {
        for (BnfRule rule : this.myFile.getRules()) {
            BnfRule r = this.myFile.getRule(ParserGeneratorUtil.getAttribute(rule, KnownAttribute.ELEMENT_TYPE));
            if (r == null) continue;
            this.ruleInfo((BnfRule)r).isInElementType = true;
        }
    }

    private void calcRulesStubNames() {
        for (BnfRule rule : this.myFile.getRules()) {
            BnfRule topSuper;
            RuleInfo info = this.ruleInfo(rule);
            String stubClass = info.stub;
            if (stubClass == null) {
                topSuper = ParserGeneratorUtil.getEffectiveSuperRule(this.myFile, rule);
                String string = stubClass = topSuper == null ? null : this.ruleInfo((BnfRule)topSuper).stub;
            }
            String superRuleClass = (topSuper = ParserGeneratorUtil.getEffectiveSuperRule(this.myFile, rule)) == null ? ParserGeneratorUtil.getRootAttribute((PsiElement)this.myFile, KnownAttribute.EXTENDS) : (topSuper == rule ? ParserGeneratorUtil.getAttribute(rule, KnownAttribute.EXTENDS) : this.ruleInfo((BnfRule)topSuper).intfClass);
            String implSuper = StringUtil.notNullize((String)info.mixin, (String)superRuleClass);
            String implSuperRaw = NameShortener.getRawClassName(implSuper);
            String stubName = StringUtil.isNotEmpty((String)stubClass) ? stubClass : (implSuper.indexOf("<") < implSuper.indexOf(">") && !this.myJavaHelper.findClassMethods(implSuperRaw, JavaHelper.MethodType.INSTANCE, "getParentByStub", 0, new String[0]).isEmpty() ? implSuper.substring(implSuper.indexOf("<") + 1, implSuper.indexOf(">")) : null);
            if (!StringUtil.isNotEmpty((String)stubName)) continue;
            info.realStubClass = stubClass;
        }
    }

    private void calcRealSuperClasses(Map<String, BnfRule> sortedPsiRules) {
        HashMap<BnfRule, BnfRule> supers = new HashMap<BnfRule, BnfRule>();
        for (BnfRule rule : sortedPsiRules.values()) {
            supers.put(rule, ParserGeneratorUtil.getEffectiveSuperRule(this.myFile, rule));
        }
        JBTreeTraverser ordered = (JBTreeTraverser)((JBTreeTraverser)((JBTreeTraverser)new JBTreeTraverser(key -> JBIterable.of((Object)((BnfRule)supers.get(key)))).withRoots(sortedPsiRules.values())).withTraversal(TreeTraversal.POST_ORDER_DFS)).unique();
        for (BnfRule rule : ordered) {
            RuleInfo topInfo;
            RuleInfo info = this.ruleInfo(rule);
            BnfRule topSuper = (BnfRule)supers.get(rule);
            RuleInfo ruleInfo = topInfo = topSuper == null || topSuper == rule ? null : this.ruleInfo(topSuper);
            String superRuleClass = topSuper == null ? ParserGeneratorUtil.getRootAttribute((PsiElement)this.myFile, KnownAttribute.EXTENDS) : (topSuper == rule ? ParserGeneratorUtil.getAttribute(rule, KnownAttribute.EXTENDS) : topInfo.implClass);
            String stubName = info.realStubClass;
            String adjustedSuperRuleClass = StringUtil.isEmpty((String)stubName) ? superRuleClass : ("com.intellij.extapi.psi.ASTWrapperPsiElement".equals(superRuleClass) ? "com.intellij.extapi.psi.StubBasedPsiElementBase<" + stubName + ">" : (superRuleClass.contains("?") ? superRuleClass.replaceAll("\\?", stubName) : superRuleClass));
            info.realSuperClass = StringUtil.notNullize((String)info.mixin, (String)adjustedSuperRuleClass);
            info.mixedAST = topInfo != null ? topInfo.mixedAST : JBIterable.of((Object[])new String[]{superRuleClass, info.realSuperClass}).map(NameShortener::getRawClassName).flatMap(s -> ((JBTreeTraverser)JBTreeTraverser.from(o -> JBIterable.of((Object)this.myJavaHelper.getSuperClassName((String)o))).withRoot(s)).unique()).find("com.intellij.psi.impl.source.tree.CompositePsiElement"::equals) != null;
        }
    }

    public void addWarning(String text) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            System.out.println(text);
        } else {
            NotificationGroupManager.getInstance().getNotificationGroup("grammarkit.parser.generator.log").createNotification(text, MessageType.WARNING).notify(this.myFile.getProject());
        }
    }

    private void openOutput(String className) throws IOException {
        String classNameAdjusted = this.myPackagePrefix.isEmpty() ? className : StringUtil.trimStart((String)className, (String)(this.myPackagePrefix + "."));
        File file = new File(this.myOutputPath, classNameAdjusted.replace('.', File.separatorChar) + ".java");
        this.myOut = this.openOutputInner(className, file);
    }

    protected PrintWriter openOutputInner(String className, File file) throws IOException {
        file.getParentFile().mkdirs();
        return new PrintWriter(new FileOutputStream(file), false, this.myFile.getVirtualFile().getCharset());
    }

    private void closeOutput() {
        this.myOut.close();
    }

    public void out(String s, Object ... args) {
        this.out(String.format(s, args));
    }

    public void out(String s) {
        int length = s.length();
        if (length == 0) {
            this.myOut.println();
            return;
        }
        boolean newStatement = true;
        int start = 0;
        while (start < length) {
            boolean isComment = s.startsWith("//", start);
            int end = StringUtil.indexOf((CharSequence)s, (char)'\n', (int)start, (int)length);
            if (end == -1) {
                end = length;
            }
            String substring = s.substring(start, end);
            if (!isComment && (substring.startsWith("}") || substring.startsWith(")"))) {
                --this.myOffset;
                newStatement = true;
            }
            if (this.myOffset > 0) {
                this.myOut.print(StringUtil.repeat((String)"  ", (int)(newStatement ? this.myOffset : this.myOffset + 1)));
            }
            this.myOut.println(substring);
            if (isComment) {
                newStatement = true;
            } else if (substring.endsWith("{")) {
                ++this.myOffset;
                newStatement = true;
            } else if (substring.endsWith("(")) {
                ++this.myOffset;
                newStatement = false;
            } else {
                newStatement = substring.endsWith(";") || substring.endsWith("}");
            }
            start = end + 1;
        }
    }

    public void newLine() {
        this.out("");
    }

    @NotNull
    public String shorten(@NotNull String s) {
        return this.myShortener.shorten(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() throws IOException {
        RuleInfo info;
        this.generateParser();
        TreeMap<String, BnfRule> sortedCompositeTypes = new TreeMap<String, BnfRule>();
        TreeMap<String, BnfRule> sortedPsiRules = new TreeMap<String, BnfRule>();
        for (BnfRule rule : this.myFile.getRules()) {
            String elementType;
            info = this.ruleInfo(rule);
            if (info.intfPackage == null || StringUtil.isEmpty((String)(elementType = info.elementType)) || sortedCompositeTypes.containsKey(elementType)) continue;
            if (!info.isFake || info.isInElementType) {
                sortedCompositeTypes.put(elementType, rule);
            }
            sortedPsiRules.put(rule.getName(), rule);
            info.superInterfaces = new LinkedHashSet<String>(ParserGeneratorUtil.getSuperInterfaceNames(this.myFile, rule, this.myIntfClassFormat));
        }
        if (this.G.generatePsi) {
            this.calcRealSuperClasses(sortedPsiRules);
        }
        if (this.myGrammarRoot != null && (this.G.generateTokenTypes || this.G.generateElementTypes || this.G.generatePsi && this.G.generatePsiFactory)) {
            this.openOutput(this.myTypeHolderClass);
            try {
                this.generateElementTypesHolder(this.myTypeHolderClass, sortedCompositeTypes);
            }
            finally {
                this.closeOutput();
            }
        }
        if (this.G.generatePsi) {
            this.checkClassAvailability(this.myPsiImplUtilClass, "PSI method signatures will not be detected");
            this.myRulesMethodsHelper.buildMaps(sortedPsiRules.values());
            for (BnfRule rule : sortedPsiRules.values()) {
                info = this.ruleInfo(rule);
                this.openOutput(info.intfClass);
                try {
                    this.generatePsiIntf(rule, info);
                }
                finally {
                    this.closeOutput();
                }
            }
            for (BnfRule rule : sortedPsiRules.values()) {
                info = this.ruleInfo(rule);
                this.openOutput(info.implClass);
                try {
                    this.generatePsiImpl(rule, info);
                }
                finally {
                    this.closeOutput();
                }
            }
            if (this.myVisitorClassName != null && this.myGrammarRoot != null) {
                this.openOutput(this.myVisitorClassName);
                try {
                    this.generateVisitor(this.myVisitorClassName, sortedPsiRules);
                }
                finally {
                    this.closeOutput();
                }
            }
        }
    }

    private void checkClassAvailability(@Nullable String className, @Nullable String description) {
        if (StringUtil.isEmpty((String)className)) {
            return;
        }
        if (this.myJavaHelper.findClass(className) == null) {
            Object tail = StringUtil.isEmpty((String)description) ? "" : " (" + description + ")";
            this.addWarning(className + " class not found" + (String)tail);
        }
    }

    private void generateVisitor(String psiClass, Map<String, BnfRule> sortedRules) {
        String methodName;
        String superIntf = (String)((Pair)ObjectUtils.notNull((Object)((Pair)ContainerUtil.getFirstItem((List)((List)ParserGeneratorUtil.getRootAttribute((PsiElement)this.myFile, KnownAttribute.IMPLEMENTS)))), (Object)((Pair)KnownAttribute.IMPLEMENTS.getDefaultValue().get((int)0)))).second;
        LinkedHashSet<String> imports = new LinkedHashSet<String>(Arrays.asList("org.jetbrains.annotations.*", "com.intellij.psi.PsiElementVisitor", superIntf));
        MultiMap supers = new MultiMap();
        for (BnfRule rule : sortedRules.values()) {
            supers.putValues((Object)rule.getName(), ParserGeneratorUtil.getSuperInterfaceNames(this.myFile, rule, this.myIntfClassFormat));
        }
        HashMap<String, String> replacements = new HashMap<String, String>();
        HashSet<String> visited = new HashSet<String>();
        for (String s : supers.values()) {
            NavigatablePsiElement aClass;
            if (!visited.add(s) || (aClass = this.myJavaHelper.findClass(s)) == null || this.myJavaHelper.isPublic(aClass)) continue;
            replacements.put(s, superIntf);
        }
        for (String key : supers.keySet()) {
            ListIterator<String> it = ((List)supers.get((Object)key)).listIterator();
            while (it.hasNext()) {
                String s = (String)replacements.get(it.next());
                if (s == null) continue;
                if (s.isEmpty()) {
                    it.remove();
                    continue;
                }
                it.set(s);
            }
        }
        imports.addAll(ContainerUtil.sorted((Collection)JBIterable.from(sortedRules.values()).map(this::ruleInfo).map(o -> o.intfPackage + ".*").toSet()));
        imports.addAll(supers.values());
        String r = this.G.visitorValue != null ? "<" + this.G.visitorValue + ">" : "";
        String t = this.G.visitorValue != null ? this.G.visitorValue : "void";
        String ret = this.G.visitorValue != null ? "return " : "";
        this.generateClassHeader(psiClass + r, imports, "", Java.CLASS, "com.intellij.psi.PsiElementVisitor");
        HashSet<String> visited2 = new HashSet<String>();
        TreeSet<String> all = new TreeSet<String>();
        for (BnfRule rule : sortedRules.values()) {
            methodName = ParserGeneratorUtil.getRulePsiClassName(rule, null);
            visited2.add(methodName);
            this.out("public %s visit%s(%s %s o) {", t, methodName, this.shorten("@org.jetbrains.annotations.NotNull"), ParserGeneratorUtil.getRulePsiClassName(rule, this.myIntfClassFormat));
            boolean first = true;
            for (String top : supers.get((Object)rule.getName())) {
                if (!first && top.equals(superIntf)) continue;
                top = NameShortener.getRawClassName(top);
                if (first) {
                    all.add(top);
                }
                String text = "visit" + this.myIntfClassFormat.strip(StringUtil.getShortName((String)top)) + "(o);";
                if (first) {
                    this.out(ret + text);
                } else {
                    this.out("// " + text);
                }
                if (!first) continue;
                first = false;
            }
            this.out("}");
            this.newLine();
        }
        all.remove(superIntf);
        for (String top : JBIterable.from(all).append((Object)superIntf)) {
            methodName = this.myIntfClassFormat.strip(StringUtil.getShortName((String)top));
            if (visited2.contains(methodName)) continue;
            this.out("public %s visit%s(%s %s o) {", t, methodName, this.shorten("@org.jetbrains.annotations.NotNull"), this.shorten(top));
            if (!methodName.equals(StringUtil.getShortName((String)top)) && !top.equals(superIntf)) {
                this.out(ret + "visit" + this.myIntfClassFormat.strip(StringUtil.getShortName((String)superIntf)) + "(o);");
            } else {
                String superPrefix = methodName.equals("Element") ? "super." : "";
                this.out(superPrefix + "visitElement(o);");
                if (this.G.visitorValue != null) {
                    this.out(ret + "null;");
                }
            }
            this.out("}");
            this.newLine();
        }
        this.out("}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateParser() throws IOException {
        Map classified = ContainerUtil.classify(this.myRuleInfos.values().iterator(), o -> o.parserClass);
        for (String className : ContainerUtil.sorted(classified.keySet())) {
            this.openOutput(className);
            try {
                this.generateParser(className, ContainerUtil.map((Collection)((Collection)classified.get(className)), it -> it.name));
            }
            finally {
                this.closeOutput();
            }
        }
    }

    public void generateParser(String parserClass, Collection<String> ownRuleNames) {
        BnfRule rule;
        List<String> parserImports = ParserGeneratorUtil.getRootAttribute((PsiElement)this.myFile, KnownAttribute.PARSER_IMPORTS).asStrings();
        boolean rootParser = parserClass.equals(this.myGrammarRootParser);
        LinkedHashSet<String> imports = new LinkedHashSet<String>();
        if (!this.G.generateFQN) {
            imports.add("com.intellij.lang.PsiBuilder");
            imports.add("com.intellij.lang.PsiBuilder.Marker");
        } else {
            imports.add("#forced");
        }
        imports.add(ParserGeneratorUtil.staticStarImport(this.myTypeHolderClass));
        if (this.G.generateTokenSets && ParserGeneratorUtil.hasAtLeastOneTokenChoice(this.myFile, ownRuleNames)) {
            imports.add(ParserGeneratorUtil.staticStarImport(this.myTypeHolderClass + ".TokenSets"));
        }
        if (StringUtil.isNotEmpty((String)this.myParserUtilClass)) {
            imports.add(ParserGeneratorUtil.staticStarImport(this.myParserUtilClass));
        }
        if (!rootParser) {
            imports.add(ParserGeneratorUtil.staticStarImport(this.myGrammarRootParser));
        } else if (!this.G.generateFQN) {
            imports.addAll(Arrays.asList("com.intellij.psi.tree.IElementType", "com.intellij.lang.ASTNode", "com.intellij.psi.tree.TokenSet", "com.intellij.lang.PsiParser", "com.intellij.lang.LightPsiParser"));
        }
        imports.addAll(parserImports);
        this.generateClassHeader(parserClass, imports, "@java.lang.SuppressWarnings({\"SimplifiableIfStatement\", \"UnusedAssignment\"})", Java.CLASS, "", rootParser ? "com.intellij.lang.PsiParser" : "", rootParser ? "com.intellij.lang.LightPsiParser" : "");
        if (rootParser) {
            this.generateRootParserContent();
        }
        for (String ruleName : ownRuleNames) {
            rule = Objects.requireNonNull(this.myFile.getRule(ruleName));
            if (ParserGeneratorUtil.Rule.isExternal(rule) || ParserGeneratorUtil.Rule.isFake(rule) || this.myExpressionHelper.getExpressionInfo(rule) != null) continue;
            this.out("/* ********************************************************** */");
            this.generateNode(rule, rule.getExpression(), ParserGeneratorUtil.getFuncName(rule), new HashSet<BnfExpression>());
            this.newLine();
        }
        for (String ruleName : ownRuleNames) {
            rule = this.myFile.getRule(ruleName);
            ExpressionHelper.ExpressionInfo info = this.myExpressionHelper.getExpressionInfo(rule);
            if (info == null || info.rootRule != rule) continue;
            this.out("/* ********************************************************** */");
            ExpressionGeneratorHelper.generateExpressionRoot(info, this);
            this.newLine();
        }
        boolean addNewLine = !this.myParserLambdas.isEmpty() && !this.myMetaMethodFields.isEmpty();
        this.generateParserLambdas(parserClass);
        if (addNewLine) {
            this.newLine();
        }
        this.generateMetaMethodFields();
        this.out("}");
    }

    private void generateParserLambdas(@NotNull String parserClass) {
        HashMap reversedLambdas = new HashMap();
        ParserGeneratorUtil.take(this.myParserLambdas).forEach((name, body) -> {
            String call = (String)reversedLambdas.get(body);
            if (call == null) {
                call = this.generateParserInstance((String)body);
                reversedLambdas.put(body, name);
            }
            this.out("static final Parser " + name + " = " + call + ";");
            this.myRenderedLambdas.put((String)name, parserClass);
        });
    }

    @NotNull
    private String generateParserInstance(@NotNull String body) {
        return this.G.javaVersion > 6 ? String.format("(%s, %s) -> %s", this.N.builder, this.N.level, body) : String.format("new Parser() {\npublic boolean parse(%s %s, int %s) {\nreturn %s;\n}\n}", this.shorten("com.intellij.lang.PsiBuilder"), this.N.builder, this.N.level, body);
    }

    private void generateMetaMethodFields() {
        ParserGeneratorUtil.take(this.myMetaMethodFields).forEach((field, call) -> this.out("private static final Parser " + field + " = " + call + ";"));
    }

    private void generateRootParserContent() {
        BnfRule rootRule = this.myFile.getRule(this.myGrammarRoot);
        ArrayList<BnfRule> extraRoots = new ArrayList<BnfRule>();
        for (String ruleName : this.myRuleInfos.keySet()) {
            ExpressionHelper.ExpressionInfo info;
            BnfRule rule = Objects.requireNonNull(this.myFile.getRule(ruleName));
            if (ParserGeneratorUtil.getAttribute(rule, KnownAttribute.ELEMENT_TYPE) != null || !RuleGraphHelper.hasElementType(rule) || ParserGeneratorUtil.Rule.isFake(rule) || ParserGeneratorUtil.Rule.isMeta(rule) || (info = this.myExpressionHelper.getExpressionInfo(rule)) != null && info.rootRule != rule || !Boolean.TRUE.equals(ParserGeneratorUtil.getAttribute(rule, KnownAttribute.EXTRA_ROOT))) continue;
            extraRoots.add(rule);
        }
        List<Set<String>> extendsSet = this.buildExtendsSet(this.myGraphHelper.getRuleExtendsMap());
        boolean generateExtendsSets = !extendsSet.isEmpty();
        String shortET = this.shorten("com.intellij.psi.tree.IElementType");
        String shortAN = this.shorten("com.intellij.lang.ASTNode");
        String shortPB = this.shorten("com.intellij.lang.PsiBuilder");
        String shortTS = this.shorten("com.intellij.psi.tree.TokenSet");
        String shortMarker = !this.G.generateFQN ? "Marker" : "com.intellij.lang.PsiBuilder.Marker";
        this.out("public %s parse(%s %s, %s %s) {", shortAN, shortET, this.N.root, shortPB, this.N.builder);
        this.out("parseLight(%s, %s);", this.N.root, this.N.builder);
        this.out("return %s.getTreeBuilt();", this.N.builder);
        this.out("}");
        this.newLine();
        this.out("public void parseLight(%s %s, %s %s) {", shortET, this.N.root, shortPB, this.N.builder);
        this.out("boolean %s;", this.N.result);
        this.out("%s = adapt_builder_(%s, %s, this, %s);", this.N.builder, this.N.root, this.N.builder, generateExtendsSets ? "EXTENDS_SETS_" : null);
        this.out("%s %s = enter_section_(%s, 0, _COLLAPSE_, null);", shortMarker, this.N.marker, this.N.builder);
        this.out("%s = parse_root_(%s, %s);", this.N.result, this.N.root, this.N.builder);
        this.out("exit_section_(%s, 0, %s, %s, %s, true, TRUE_CONDITION);", this.N.builder, this.N.marker, this.N.root, this.N.result);
        this.out("}");
        this.newLine();
        this.out("protected boolean parse_root_(%s %s, %s %s) {", shortET, this.N.root, shortPB, this.N.builder);
        this.out("return parse_root_(%s, %s, 0);", this.N.root, this.N.builder);
        this.out("}");
        this.newLine();
        this.out("static boolean parse_root_(%s %s, %s %s, int %s) {", shortET, this.N.root, shortPB, this.N.builder, this.N.level);
        if (extraRoots.isEmpty()) {
            this.out("return %s;", rootRule == null ? "false" : this.generateNodeCall(rootRule, null, this.myGrammarRoot).render(this.N));
        } else {
            boolean first = true;
            this.out("boolean %s;", this.N.result);
            for (BnfRule bnfRule : extraRoots) {
                String elementType = this.getElementType(bnfRule);
                this.out("%sif (%s == %s) {", first ? "" : "else ", this.N.root, elementType);
                String nodeCall = this.generateNodeCall((BnfRule)ObjectUtils.notNull((Object)rootRule, (Object)bnfRule), null, bnfRule.getName()).render(this.N);
                this.out("%s = %s;", this.N.result, nodeCall);
                this.out("}");
                if (!first) continue;
                first = false;
            }
            this.out("else {");
            this.out("%s = %s;", this.N.result, rootRule == null ? "false" : this.generateNodeCall(rootRule, null, this.myGrammarRoot).render(this.N));
            this.out("}");
            this.out("return %s;", this.N.result);
        }
        this.out("}");
        this.newLine();
        if (generateExtendsSets) {
            this.out("public static final %s[] EXTENDS_SETS_ = new %s[] {", shortTS, shortTS);
            StringBuilder sb = new StringBuilder();
            for (Set set : extendsSet) {
                int i = 0;
                for (String elementType : set) {
                    if (i > 0) {
                        sb.append(i % 4 == 0 ? ",\n" : ", ");
                    }
                    sb.append(elementType);
                    ++i;
                }
                this.out("create_token_set_(%s),", sb);
                sb.setLength(0);
            }
            this.out("};");
            this.newLine();
        }
    }

    @NotNull
    private List<Set<String>> buildExtendsSet(@NotNull MultiMap<BnfRule, BnfRule> map) {
        if (map.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Set<String>> result = new ArrayList<Set<String>>();
        for (Map.Entry entry : map.entrySet()) {
            TreeSet<String> set = null;
            for (BnfRule rule : (Collection)entry.getValue()) {
                String elementType;
                RuleInfo info = this.ruleInfo(rule);
                if (!RuleGraphHelper.hasElementType(rule) || StringUtil.isEmpty((String)(elementType = info.isFake && !info.isInElementType || RuleGraphHelper.getSynonymTargetOrSelf(rule) != rule ? null : info.elementType))) continue;
                if (set == null) {
                    set = new TreeSet<String>();
                }
                set.add(elementType);
            }
            if (set == null || set.size() <= 1) continue;
            result.add((Set<String>)set);
        }
        result.sort(Comparator.comparingInt(Set::size));
        ListIterator it = result.listIterator();
        block2: while (it.hasNext()) {
            Set smaller = (Set)it.next();
            for (Set bigger : result.subList(it.nextIndex(), result.size())) {
                if (!bigger.containsAll(smaller)) continue;
                it.remove();
                continue block2;
            }
        }
        return result;
    }

    private void generateClassHeader(String className, Set<String> imports, String annos, Java javaType, String ... supers) {
        this.generateFileHeader(className);
        String packageName = StringUtil.getPackageName((String)className);
        String shortClassName = StringUtil.getShortName((String)className);
        this.out("package %s;", packageName);
        this.newLine();
        Set includedPackages = JBIterable.from(imports).filter(o -> !o.startsWith("static") && o.endsWith(".*")).map(o -> StringUtil.trimEnd((String)o, (String)".*")).append((Object)packageName).toSet();
        HashSet<String> includedClasses = new HashSet<String>();
        for (RuleInfo ruleInfo : this.myRuleInfos.values()) {
            if (includedPackages.contains(ruleInfo.intfPackage)) {
                includedClasses.add(StringUtil.getShortName((String)ruleInfo.intfClass));
            }
            if (!includedPackages.contains(ruleInfo.implPackage)) continue;
            includedClasses.add(StringUtil.getShortName((String)ruleInfo.implClass));
        }
        NameShortener shortener = new NameShortener(packageName, !this.G.generateFQN);
        shortener.addImports(imports, includedClasses);
        for (String s : shortener.getImports()) {
            this.out("import %s;", s);
        }
        if (this.G.generateFQN && imports.contains("#forced")) {
            for (String s : JBIterable.from(imports).filter(o -> !"#forced".equals(o))) {
                this.out("import %s;", s);
            }
        }
        this.newLine();
        StringBuilder stringBuilder = new StringBuilder();
        int supersLength = supers.length;
        for (int i = 0; i < supersLength; ++i) {
            String aSuper = supers[i];
            if (StringUtil.isEmpty((String)aSuper)) continue;
            if (imports.contains(aSuper + ";")) {
                aSuper = StringUtil.getShortName((String)aSuper);
            }
            if (i == 0) {
                stringBuilder.append(" extends ").append(shortener.shorten(aSuper));
                continue;
            }
            if (javaType != Java.INTERFACE && i == 1) {
                stringBuilder.append(" implements ").append(shortener.shorten(aSuper));
                continue;
            }
            stringBuilder.append(", ").append(shortener.shorten(aSuper));
        }
        if (StringUtil.isNotEmpty((String)annos)) {
            this.out(shortener.shorten(annos));
        }
        this.out("public %s %s%s {", Case.LOWER.apply(javaType.name()).replace('_', ' '), shortClassName, stringBuilder.toString());
        this.newLine();
        this.myShortener = shortener;
    }

    private void generateFileHeader(String className) {
        String text;
        String header = ParserGeneratorUtil.getRootAttribute((PsiElement)this.myFile, KnownAttribute.CLASS_HEADER, className);
        String string = text = StringUtil.isEmpty((String)header) ? "" : this.getStringOrFile(header);
        if (StringUtil.isNotEmpty((String)text)) {
            this.out(text);
        }
        this.myOffset = 0;
    }

    private String getStringOrFile(String classHeader) {
        try {
            File file = new File(this.mySourcePath, classHeader);
            if (file.exists()) {
                return FileUtil.loadFile((File)file);
            }
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex);
        }
        return classHeader.startsWith("//") || classHeader.startsWith("/*") ? classHeader : (StringUtil.countNewLines((CharSequence)classHeader) > 0 ? "/*\n" + classHeader + "\n*/" : "// " + classHeader);
    }

    private void generateMetaMethod(@NotNull String methodName, @NotNull List<String> parameterNames, boolean isRule) {
        String parameterList = parameterNames.stream().map(it -> "Parser " + it).collect(Collectors.joining(", "));
        String argumentList = String.join((CharSequence)", ", parameterNames);
        String metaParserMethodName = ParserGeneratorUtil.getWrapperParserMetaMethodName(methodName);
        String call = String.format("%s(%s, %s + 1, %s)", methodName, this.N.builder, this.N.level, argumentList);
        this.out("%sstatic Parser %s(%s) {", isRule ? "" : "private ", metaParserMethodName, parameterList);
        this.out("return %s;", this.generateParserInstance(call));
        this.out("}");
    }

    void generateNode(BnfRule rule, BnfExpression initialNode, String funcName, Set<BnfExpression> visited) {
        String shortMarker;
        boolean pinned;
        List<BnfExpression> children;
        boolean isRule = initialNode.getParent() == rule;
        BnfExpression node = ParserGeneratorUtil.getNonTrivialNode(initialNode);
        List<String> metaParameters = this.collectMetaParametersFormatted(rule, node);
        if (!metaParameters.isEmpty() && (isRule && ParserGeneratorUtil.isUsedAsArgument(rule) || !isRule && ParserGeneratorUtil.isArgument(initialNode))) {
            this.generateMetaMethod(funcName, metaParameters, isRule);
            this.newLine();
        }
        IElementType type = ParserGeneratorUtil.getEffectiveType(node);
        for (String s : StringUtil.split((String)(StringUtil.isEmpty((String)node.getText()) ? initialNode : node).getText(), (String)"\n")) {
            this.out("// " + s);
        }
        boolean firstNonTrivial = node == ParserGeneratorUtil.Rule.firstNotTrivial(rule);
        boolean isPrivate = !isRule && !firstNonTrivial || ParserGeneratorUtil.Rule.isPrivate(rule) || this.myGrammarRoot.equals(rule.getName());
        boolean isLeft = firstNonTrivial && ParserGeneratorUtil.Rule.isLeft(rule);
        boolean isLeftInner = isLeft && (isPrivate || ParserGeneratorUtil.Rule.isInner(rule));
        boolean isUpper = !isPrivate && ParserGeneratorUtil.Rule.isUpper(rule);
        String recoverWhile = !firstNonTrivial ? null : ParserGeneratorUtil.getAttribute(rule, KnownAttribute.RECOVER_WHILE);
        Map hooks = firstNonTrivial ? ParserGeneratorUtil.getAttribute(rule, KnownAttribute.HOOKS).asMap() : Collections.emptyMap();
        boolean canCollapse = !isPrivate && (!isLeft || isLeftInner) && firstNonTrivial && this.myGraphHelper.canCollapse(rule);
        String elementType = this.getElementType(rule);
        String elementTypeRef = !isPrivate && StringUtil.isNotEmpty((String)elementType) ? elementType : null;
        boolean isSingleNode = node instanceof BnfReferenceOrToken || node instanceof BnfLiteralExpression || node instanceof BnfExternalExpression;
        List<BnfExpression> list = children = isSingleNode ? Collections.singletonList(node) : ParserGeneratorUtil.getChildExpressions(node);
        String frameName = !children.isEmpty() && firstNonTrivial && !ParserGeneratorUtil.Rule.isMeta(rule) ? ParserGeneratorUtil.quote(ParserGeneratorUtil.getRuleDisplayName(rule, !isPrivate)) : null;
        String extraParameters = metaParameters.stream().map(it -> ", Parser " + it).collect(Collectors.joining());
        this.out("%sstatic boolean %s(%s %s, int %s%s) {", !isRule ? "private " : (isPrivate ? "" : "public "), funcName, this.shorten("com.intellij.lang.PsiBuilder"), this.N.builder, this.N.level, extraParameters);
        if (isSingleNode) {
            if (isPrivate && !isLeftInner && recoverWhile == null && frameName == null) {
                String nodeCall = this.generateNodeCall(rule, node, ParserGeneratorUtil.getNextName(funcName, 0)).render(this.N);
                this.out("return %s;", nodeCall);
                this.out("}");
                if (node instanceof BnfExternalExpression && ((BnfExternalExpression)node).getExpressionList().size() > 1) {
                    this.generateNodeChildren(rule, funcName, children, visited);
                }
                return;
            }
            type = BnfTypes.BNF_SEQUENCE;
        }
        if (!children.isEmpty()) {
            this.out("if (!recursion_guard_(%s, %s, \"%s\")) return false;", this.N.builder, this.N.level, funcName);
        }
        if (recoverWhile == null && (isRule || firstNonTrivial)) {
            frameName = this.generateFirstCheck(rule, frameName, ParserGeneratorUtil.getAttribute(rule, KnownAttribute.NAME) == null);
        }
        ParserGeneratorUtil.PinMatcher pinMatcher = new ParserGeneratorUtil.PinMatcher(rule, type, firstNonTrivial ? rule.getName() : funcName);
        boolean pinApplied = false;
        boolean alwaysTrue = children.isEmpty() || type == BnfTypes.BNF_OP_OPT || type == BnfTypes.BNF_OP_ZEROMORE;
        boolean bl = pinned = pinMatcher.active() && pinMatcher.shouldGenerate(children);
        if (!alwaysTrue) {
            this.out("boolean %s%s%s;", this.N.result, children.isEmpty() ? " = true" : "", pinned ? String.format(", %s", this.N.pinned) : "");
        }
        SmartList modifierList = new SmartList();
        if (canCollapse) {
            modifierList.add("_COLLAPSE_");
        }
        if (isLeftInner) {
            modifierList.add("_LEFT_INNER_");
        } else if (isLeft) {
            modifierList.add("_LEFT_");
        }
        if (type == BnfTypes.BNF_OP_AND) {
            modifierList.add("_AND_");
        } else if (type == BnfTypes.BNF_OP_NOT) {
            modifierList.add("_NOT_");
        }
        if (isUpper) {
            modifierList.add("_UPPER_");
        }
        if (modifierList.isEmpty() && (pinned || frameName != null)) {
            modifierList.add("_NONE_");
        }
        boolean sectionRequired = !alwaysTrue || !isPrivate || isLeft || recoverWhile != null;
        boolean sectionRequiredSimple = sectionRequired && modifierList.isEmpty() && recoverWhile == null && frameName == null;
        boolean sectionMaybeDropped = sectionRequiredSimple && type == BnfTypes.BNF_CHOICE && elementTypeRef == null && !ContainerUtil.exists(children, o -> ParserGeneratorUtil.isRollbackRequired(o, this.myFile));
        String modifiers = modifierList.isEmpty() ? "_NONE_" : StringUtil.join((Collection)modifierList, (String)" | ");
        String string = shortMarker = !this.G.generateFQN ? "Marker" : "com.intellij.lang.PsiBuilder.Marker";
        if (sectionRequiredSimple) {
            if (!sectionMaybeDropped) {
                this.out("%s %s = enter_section_(%s);", shortMarker, this.N.marker, this.N.builder);
            }
        } else if (sectionRequired) {
            boolean shortVersion;
            boolean bl2 = shortVersion = frameName == null && elementTypeRef == null;
            if (shortVersion) {
                this.out("%s %s = enter_section_(%s, %s, %s);", shortMarker, this.N.marker, this.N.builder, this.N.level, modifiers);
            } else {
                this.out("%s %s = enter_section_(%s, %s, %s, %s, %s);", shortMarker, this.N.marker, this.N.builder, this.N.level, modifiers, elementTypeRef, frameName);
            }
        }
        int[] skip = new int[]{0};
        int p = 0;
        int childrenSize = children.size();
        for (int i = 0; i < childrenSize; ++i) {
            ParserGeneratorUtil.ConsumeType consumeType;
            BnfExpression child = children.get(i);
            NodeCalls.NodeCall nodeCall = this.generateNodeCall(rule, child, ParserGeneratorUtil.getNextName(funcName, i));
            if (type == BnfTypes.BNF_CHOICE) {
                NodeCalls.NodeCall tokenChoice;
                if (isRule && i == 0 && this.G.generateTokenSets && (tokenChoice = this.generateTokenChoiceCall(children, consumeType = this.getEffectiveConsumeType(rule, node, null), funcName)) != null) {
                    this.out("%s = %s;", this.N.result, tokenChoice.render(this.N));
                    break;
                }
                this.out("%s%s = %s;", i > 0 ? String.format("if (!%s) ", this.N.result) : "", this.N.result, nodeCall.render(this.N));
                continue;
            }
            if (type == BnfTypes.BNF_SEQUENCE) {
                if (skip[0] == 0) {
                    consumeType = this.getEffectiveConsumeType(rule, node, null);
                    nodeCall = this.generateTokenSequenceCall(children, i, pinMatcher, pinApplied, skip, nodeCall, false, consumeType);
                    if (i == 0) {
                        this.out("%s = %s;", this.N.result, nodeCall.render(this.N));
                    } else if (pinApplied && this.G.generateExtendedPin) {
                        if (i == childrenSize - 1) {
                            if (i == p + 1) {
                                this.out("%s = %s && %s;", this.N.result, this.N.result, nodeCall.render(this.N));
                            } else {
                                this.out("%s = %s && %s && %s;", this.N.result, this.N.pinned, nodeCall.render(this.N), this.N.result);
                            }
                        } else if (i == p + 1) {
                            this.out("%s = %s && report_error_(%s, %s);", this.N.result, this.N.result, this.N.builder, nodeCall.render(this.N));
                        } else {
                            this.out("%s = %s && report_error_(%s, %s) && %s;", this.N.result, this.N.pinned, this.N.builder, nodeCall.render(this.N), this.N.result);
                        }
                    } else {
                        this.out("%s = %s && %s;", this.N.result, this.N.result, nodeCall.render(this.N));
                    }
                } else {
                    skip[0] = skip[0] - 1;
                    if (pinApplied && i == p + 1) {
                        ++p;
                    }
                }
                if (!pinned || pinApplied || !pinMatcher.matches(i, child)) continue;
                pinApplied = true;
                p = i;
                this.out("%s = %s; // pin = %s", this.N.pinned, this.N.result, pinMatcher.pinValue);
                continue;
            }
            if (type == BnfTypes.BNF_OP_OPT) {
                this.out(nodeCall.render(this.N) + ";");
                continue;
            }
            if (type == BnfTypes.BNF_OP_ONEMORE || type == BnfTypes.BNF_OP_ZEROMORE) {
                if (type == BnfTypes.BNF_OP_ONEMORE) {
                    this.out("%s = %s;", this.N.result, nodeCall.render(this.N));
                }
                this.out("while (%s) {", alwaysTrue ? "true" : this.N.result);
                this.out("int %s = current_position_(%s);", this.N.pos, this.N.builder);
                this.out("if (!%s) break;", nodeCall.render(this.N));
                this.out("if (!empty_element_parsed_guard_(%s, \"%s\", %s)) break;", this.N.builder, funcName, this.N.pos);
                this.out("}");
                continue;
            }
            if (type == BnfTypes.BNF_OP_AND) {
                this.out("%s = %s;", this.N.result, nodeCall.render(this.N));
                continue;
            }
            if (type == BnfTypes.BNF_OP_NOT) {
                this.out("%s = !%s;", this.N.result, nodeCall.render(this.N));
                continue;
            }
            this.addWarning("unexpected: " + type);
        }
        if (sectionRequired) {
            String resultRef;
            String string2 = resultRef = alwaysTrue ? "true" : this.N.result;
            if (!hooks.isEmpty()) {
                for (Map.Entry entry : hooks.entrySet()) {
                    String hookName = ParserGeneratorUtil.toIdentifier((String)entry.getKey(), null, Case.UPPER);
                    this.out("register_hook_(%s, %s, %s);", this.N.builder, hookName, entry.getValue());
                }
            }
            if (sectionRequiredSimple) {
                if (!sectionMaybeDropped) {
                    this.out("exit_section_(%s, %s, %s, %s);", this.N.builder, this.N.marker, elementTypeRef, resultRef);
                }
            } else {
                String recoverCall;
                String pinnedRef;
                String string3 = pinnedRef = pinned ? this.N.pinned : "false";
                if (recoverWhile != null) {
                    BnfRule predicateRule = this.myFile.getRule(recoverWhile);
                    recoverCall = "#auto".equals(recoverWhile) ? this.generateAutoRecoverCall(rule) : (ParserGeneratorUtil.Rule.isMeta(rule) && GrammarUtil.isDoubleAngles(recoverWhile) ? this.formatMetaParamName(recoverWhile.substring(2, recoverWhile.length() - 2)) : (predicateRule == null ? null : this.generateWrappedNodeCall(rule, null, predicateRule.getName()).render()));
                } else {
                    recoverCall = null;
                }
                this.out("exit_section_(%s, %s, %s, %s, %s, %s);", this.N.builder, this.N.level, this.N.marker, resultRef, pinnedRef, recoverCall);
            }
        }
        this.out("return %s;", alwaysTrue ? "true" : this.N.result + (pinned ? String.format(" || %s", this.N.pinned) : ""));
        this.out("}");
        this.generateNodeChildren(rule, funcName, children, visited);
    }

    private String generateAutoRecoverCall(BnfRule rule) {
        Set<BnfExpression> nextExprSet = this.myFirstNextAnalyzer.calcNext(rule).keySet();
        Set<String> nextSet = BnfFirstNextAnalyzer.asStrings(nextExprSet);
        ArrayList<String> tokenTypes = new ArrayList<String>(nextSet.size());
        for (String s : nextSet) {
            String t;
            if (this.myFile.getRule(s) != null || s == "-eof-" || s == "-never-matches-") continue;
            boolean unknown = s == "-any-";
            String string = t = unknown ? null : this.firstToElementType(s);
            if (t != null) {
                tokenTypes.add(t);
                continue;
            }
            tokenTypes.clear();
            this.addWarning(rule.getName() + " #auto recovery generation failed: " + s);
            break;
        }
        StringBuilder sb = new StringBuilder(String.format("!nextTokenIsFast(%s, ", this.N.builder));
        ParserGeneratorUtil.appendTokenTypes(sb, tokenTypes);
        sb.append(")");
        String constantName = rule.getName() + "_auto_recover_";
        this.myParserLambdas.put(constantName, sb.toString());
        return constantName;
    }

    public String generateFirstCheck(BnfRule rule, String frameName, boolean skipIfOne) {
        boolean dropFrameName;
        if (this.G.generateFirstCheck <= 0) {
            return frameName;
        }
        Set<BnfExpression> firstSet = this.myFirstNextAnalyzer.calcFirst(rule);
        ParserGeneratorUtil.ConsumeType ruleConsumeType = this.getRuleConsumeType(rule, null);
        TreeMap<String, ParserGeneratorUtil.ConsumeType> firstElementTypes = new TreeMap<String, ParserGeneratorUtil.ConsumeType>();
        for (BnfExpression expression : firstSet) {
            if (expression == BnfFirstNextAnalyzer.BNF_MATCHES_EOF || expression == BnfFirstNextAnalyzer.BNF_MATCHES_ANY) {
                return frameName;
            }
            String expressionString = BnfFirstNextAnalyzer.asString(expression);
            if (this.myFile.getRule(expressionString) != null) continue;
            String t = this.firstToElementType(expressionString);
            if (t == null) {
                return frameName;
            }
            ParserGeneratorUtil.ConsumeType childConsumeType = this.getRuleConsumeType(Objects.requireNonNull(ParserGeneratorUtil.Rule.of(expression)), rule);
            ParserGeneratorUtil.ConsumeType consumeType = ParserGeneratorUtil.ConsumeType.min(ruleConsumeType, childConsumeType);
            ParserGeneratorUtil.ConsumeType existing = (ParserGeneratorUtil.ConsumeType)((Object)firstElementTypes.get(t));
            firstElementTypes.put(t, ParserGeneratorUtil.ConsumeType.max(existing, consumeType));
        }
        if (firstElementTypes.isEmpty()) {
            return frameName;
        }
        int allTokensCount = firstElementTypes.size();
        boolean bl = dropFrameName = skipIfOne && allTokensCount == 1;
        if (allTokensCount <= this.G.generateFirstCheck) {
            Map grouped = firstElementTypes.entrySet().stream().collect(Collectors.groupingBy(Map.Entry::getValue, () -> new EnumMap(ParserGeneratorUtil.ConsumeType.class), Collectors.mapping(Map.Entry::getKey, Collectors.toList())));
            String condition = grouped.entrySet().stream().map(entry -> {
                ParserGeneratorUtil.ConsumeType consumeType = (ParserGeneratorUtil.ConsumeType)((Object)((Object)entry.getKey()));
                List tokenTypes = (List)entry.getValue();
                StringBuilder sb = new StringBuilder("!");
                sb.append("nextTokenIs").append(consumeType.getMethodSuffix()).append("(").append(this.N.builder).append(", ");
                if (!dropFrameName && consumeType == ParserGeneratorUtil.ConsumeType.DEFAULT) {
                    sb.append(StringUtil.notNullize((String)frameName, (String)"\"\"")).append(", ");
                }
                ParserGeneratorUtil.appendTokenTypes(sb, tokenTypes);
                sb.append(")");
                return sb;
            }).collect(Collectors.joining(" &&\n  ", "if (", ") return false;"));
            this.out(condition);
        }
        return dropFrameName && StringUtil.isEmpty((String)ParserGeneratorUtil.getAttribute(rule, KnownAttribute.NAME)) ? null : frameName;
    }

    @NotNull
    private ParserGeneratorUtil.ConsumeType getRuleConsumeType(@NotNull BnfRule rule, @Nullable BnfRule contextRule) {
        ParserGeneratorUtil.ConsumeType forcedConsumeType = ExpressionGeneratorHelper.fixForcedConsumeType(this.myExpressionHelper, rule, null, null);
        if (forcedConsumeType != null && contextRule != null && this.myExpressionHelper.getExpressionInfo(contextRule) == null) {
            forcedConsumeType = null;
        }
        return (ParserGeneratorUtil.ConsumeType)((Object)ObjectUtils.chooseNotNull((Object)((Object)forcedConsumeType), (Object)((Object)ParserGeneratorUtil.ConsumeType.forRule(rule))));
    }

    void generateNodeChildren(BnfRule rule, String funcName, List<BnfExpression> children, Set<BnfExpression> visited) {
        int len = children.size();
        for (int i = 0; i < len; ++i) {
            this.generateNodeChild(rule, children.get(i), funcName, i, visited);
        }
    }

    void generateNodeChild(BnfRule rule, BnfExpression child, String funcName, int index, Set<BnfExpression> visited) {
        String nextName;
        if (child instanceof BnfExternalExpression) {
            List<BnfExpression> expressions = ((BnfExternalExpression)child).getExpressionList();
            int size = expressions.size();
            for (int j = 1; j < size; ++j) {
                BnfExpression expression = expressions.get(j);
                if (GrammarUtil.isAtomicExpression(expression)) continue;
                if (expression instanceof BnfExternalExpression) {
                    this.generateNodeChild(rule, expression, ParserGeneratorUtil.getNextName(funcName, index), j - 1, visited);
                    continue;
                }
                String nextName2 = ParserGeneratorUtil.getNextName(ParserGeneratorUtil.getNextName(funcName, index), j - 1);
                if (!this.shallGenerateNodeChild(nextName2)) continue;
                this.newLine();
                this.generateNode(rule, expression, nextName2, visited);
            }
        } else if (!GrammarUtil.isAtomicExpression(child) && !ParserGeneratorUtil.isTokenSequence(rule, child) && this.shallGenerateNodeChild(nextName = ParserGeneratorUtil.getNextName(funcName, index))) {
            this.newLine();
            this.generateNode(rule, child, nextName, visited);
        }
    }

    @NotNull
    private List<String> collectMetaParametersFormatted(@NotNull BnfRule rule, @Nullable BnfExpression expression) {
        if (expression == null) {
            return Collections.emptyList();
        }
        return ContainerUtil.map(GrammarUtil.collectMetaParameters(rule, expression), it -> this.formatMetaParamName(it.substring(2, it.length() - 2)));
    }

    @NotNull
    private String formatMetaParamName(@NotNull String s) {
        String argName = s.trim();
        return this.N.metaParamPrefix + (this.N.metaParamPrefix.isEmpty() || "_".equals(this.N.metaParamPrefix) ? argName : StringUtil.capitalize((String)argName));
    }

    @Nullable
    private String firstToElementType(String first) {
        if (first.startsWith("#") || first.startsWith("-") || first.startsWith("<<")) {
            return null;
        }
        String value = GrammarUtil.unquote(first);
        if (first != value) {
            String attributeName = this.getTokenName(value);
            if (attributeName != null && !first.startsWith("\"")) {
                return this.getElementType(attributeName);
            }
            return null;
        }
        return this.getElementType(first);
    }

    @Nullable
    private String getTokenName(String value) {
        return this.mySimpleTokens.get(value);
    }

    @NotNull
    private NodeCalls.NodeCall generateTokenSequenceCall(List<BnfExpression> children, int startIndex, ParserGeneratorUtil.PinMatcher pinMatcher, boolean pinApplied, int[] skip, @NotNull NodeCalls.NodeCall nodeCall, boolean rollbackOnFail, ParserGeneratorUtil.ConsumeType consumeType) {
        if (startIndex == children.size() - 1 || !(nodeCall instanceof NodeCalls.ConsumeTokenCall)) {
            return nodeCall;
        }
        ArrayList<String> list = new ArrayList<String>();
        int pin = pinApplied ? -1 : 0;
        int len = children.size();
        for (int i = startIndex; i < len; ++i) {
            String tokenName;
            BnfExpression child = children.get(i);
            String text = child.getText();
            String string = child instanceof BnfStringLiteralExpression ? this.getTokenName(GrammarUtil.unquote(text)) : (tokenName = child instanceof BnfReferenceOrToken && this.myFile.getRule(text) == null ? text : null);
            if (tokenName == null) break;
            list.add(this.getElementType(tokenName));
            if (pinApplied || !pinMatcher.matches(i, child)) continue;
            pin = i - startIndex + 1;
            pinApplied = true;
        }
        if (list.size() < 2) {
            return nodeCall;
        }
        skip[0] = list.size() - 1;
        String consumeMethodName = (rollbackOnFail ? "parseTokens" : "consumeTokens") + (consumeType == ParserGeneratorUtil.ConsumeType.SMART ? consumeType.getMethodSuffix() : "");
        return new NodeCalls.ConsumeTokensCall(consumeMethodName, pin, list);
    }

    @Nullable
    private NodeCalls.NodeCall generateTokenChoiceCall(@NotNull List<BnfExpression> children, @NotNull ParserGeneratorUtil.ConsumeType consumeType, @NotNull String funcName) {
        Collection<String> tokenNames = ParserGeneratorUtil.getTokenNames(this.myFile, children, 2);
        if (tokenNames == null) {
            return null;
        }
        TreeSet<String> tokens = new TreeSet<String>();
        for (String tokenName : tokenNames) {
            if (!this.mySimpleTokens.containsKey(tokenName) && !this.mySimpleTokens.containsValue(tokenName)) {
                this.mySimpleTokens.put(tokenName, null);
            }
            tokens.add(this.getElementType(tokenName));
        }
        String tokenSetName = ParserGeneratorUtil.getTokenSetConstantName(funcName);
        this.myTokenSets.put(tokenSetName, tokens);
        return new NodeCalls.ConsumeTokenChoiceCall(consumeType, tokenSetName);
    }

    @NotNull
    NodeCalls.NodeCall generateNodeCall(@NotNull BnfRule rule, @Nullable BnfExpression node, @NotNull String nextName) {
        return this.generateNodeCall(rule, node, nextName, null);
    }

    @NotNull
    NodeCalls.NodeCall generateNodeCall(@NotNull BnfRule rule, @Nullable BnfExpression node, @NotNull String nextName, @Nullable ParserGeneratorUtil.ConsumeType forcedConsumeType) {
        String text;
        IElementType type = node == null ? BnfTypes.BNF_REFERENCE_OR_TOKEN : ParserGeneratorUtil.getEffectiveType(node);
        String string = text = node == null ? nextName : node.getText();
        if (type == BnfTypes.BNF_STRING) {
            String value = GrammarUtil.unquote(text);
            String attributeName = this.getTokenName(value);
            ParserGeneratorUtil.ConsumeType consumeType = this.getEffectiveConsumeType(rule, node, forcedConsumeType);
            if (attributeName != null) {
                return this.generateConsumeToken(consumeType, attributeName);
            }
            return ParserGenerator.generateConsumeTextToken(consumeType, text.startsWith("\"") ? value : StringUtil.escapeStringCharacters((String)value));
        }
        if (type == BnfTypes.BNF_NUMBER) {
            ParserGeneratorUtil.ConsumeType consumeType = this.getEffectiveConsumeType(rule, node, forcedConsumeType);
            return ParserGenerator.generateConsumeTextToken(consumeType, text);
        }
        if (type == BnfTypes.BNF_REFERENCE_OR_TOKEN) {
            String value = GrammarUtil.stripQuotesAroundId(text);
            BnfRule subRule = this.myFile.getRule(value);
            if (subRule != null) {
                boolean renderClass;
                if (ParserGeneratorUtil.Rule.isExternal(subRule)) {
                    return this.generateExternalCall(rule, GrammarUtil.getExternalRuleExpressions(subRule), nextName);
                }
                ExpressionHelper.ExpressionInfo info = ExpressionGeneratorHelper.getInfoForExpressionParsing(this.myExpressionHelper, subRule);
                BnfRule rr = info != null ? info.rootRule : subRule;
                String method = ParserGeneratorUtil.getFuncName(rr);
                String parserClass = this.ruleInfo((BnfRule)rr).parserClass;
                String string2 = StringUtil.getShortName((String)parserClass);
                boolean bl = renderClass = !parserClass.equals(this.myGrammarRootParser) && !parserClass.equals(this.ruleInfo((BnfRule)rule).parserClass);
                if (info == null) {
                    return new NodeCalls.MethodCall(renderClass, string2, method);
                }
                if (renderClass) {
                    method = StringUtil.getQualifiedName((String)string2, (String)method);
                }
                return new NodeCalls.ExpressionMethodCall(method, info.getPriority(subRule) - 1);
            }
            if (!this.mySimpleTokens.containsKey(text) && !this.mySimpleTokens.containsValue(text)) {
                this.mySimpleTokens.put(text, null);
            }
            ParserGeneratorUtil.ConsumeType consumeType = this.getEffectiveConsumeType(rule, node, forcedConsumeType);
            return this.generateConsumeToken(consumeType, text);
        }
        if (ParserGeneratorUtil.isTokenSequence(rule, node)) {
            ParserGeneratorUtil.ConsumeType consumeType = this.getEffectiveConsumeType(rule, node, forcedConsumeType);
            ParserGeneratorUtil.PinMatcher pinMatcher = new ParserGeneratorUtil.PinMatcher(rule, type, nextName);
            List<BnfExpression> childExpressions = ParserGeneratorUtil.getChildExpressions(node);
            BnfExpression firstElement = (BnfExpression)ContainerUtil.getFirstItem(childExpressions);
            NodeCalls.NodeCall nodeCall = this.generateNodeCall(rule, firstElement, ParserGeneratorUtil.getNextName(nextName, 0), consumeType);
            for (PsiElement psiElement : childExpressions) {
                String t = psiElement instanceof BnfStringLiteralExpression ? GrammarUtil.unquote(psiElement.getText()) : psiElement.getText();
                if (this.mySimpleTokens.containsKey(t) || this.mySimpleTokens.containsValue(t)) continue;
                this.mySimpleTokens.put(t, null);
            }
            return this.generateTokenSequenceCall(childExpressions, 0, pinMatcher, false, new int[]{0}, nodeCall, true, consumeType);
        }
        if (type == BnfTypes.BNF_EXTERNAL_EXPRESSION) {
            List<BnfExpression> expressions = ((BnfExternalExpression)node).getExpressionList();
            if (expressions.size() == 1 && ParserGeneratorUtil.Rule.isMeta(rule)) {
                return new NodeCalls.MetaParameterCall(this.formatMetaParamName(expressions.get(0).getText()));
            }
            return this.generateExternalCall(rule, expressions, nextName);
        }
        List<String> extraArguments = this.collectMetaParametersFormatted(rule, node);
        if (extraArguments.isEmpty()) {
            return new NodeCalls.MethodCall(false, StringUtil.getShortName((String)this.ruleInfo((BnfRule)rule).parserClass), nextName);
        }
        return new NodeCalls.MetaMethodCall(null, nextName, ContainerUtil.map(extraArguments, NodeCalls.MetaParameterArgument::new));
    }

    @NotNull
    private ParserGeneratorUtil.ConsumeType getEffectiveConsumeType(@NotNull BnfRule rule, @Nullable BnfExpression node, @Nullable ParserGeneratorUtil.ConsumeType forcedConsumeType) {
        Set<BnfExpression> expressions;
        PsiElement parent;
        if (forcedConsumeType == ParserGeneratorUtil.ConsumeType.DEFAULT) {
            return ParserGeneratorUtil.ConsumeType.DEFAULT;
        }
        PsiElement psiElement = parent = node == null ? null : node.getParent();
        if (forcedConsumeType == null && parent instanceof BnfSequence && ContainerUtil.getFirstItem(((BnfSequence)parent).getExpressionList()) != node && ((expressions = BnfFirstNextAnalyzer.createAnalyzer(false, false, (Condition<PsiElement>)((Condition)o -> o != parent)).calcFirst((BnfExpression)parent)).size() != 1 || expressions.iterator().next() != node)) {
            return ParserGeneratorUtil.ConsumeType.DEFAULT;
        }
        ParserGeneratorUtil.ConsumeType fixed = ExpressionGeneratorHelper.fixForcedConsumeType(this.myExpressionHelper, rule, node, forcedConsumeType);
        return fixed != null ? fixed : ParserGeneratorUtil.ConsumeType.forRule(rule);
    }

    @NotNull
    private NodeCalls.NodeCall generateExternalCall(@NotNull BnfRule rule, @NotNull List<BnfExpression> expressions, @NotNull String nextName) {
        BnfRule targetRule;
        List callParameters = expressions;
        List<Object> metaParameterNames = Collections.emptyList();
        String method = expressions.size() > 0 ? expressions.get(0).getText() : null;
        String targetClassName = null;
        BnfRule bnfRule = targetRule = method == null ? null : this.myFile.getRule(method);
        if (targetRule != null) {
            if (ParserGeneratorUtil.Rule.isExternal(targetRule)) {
                metaParameterNames = GrammarUtil.collectMetaParameters(targetRule, targetRule.getExpression());
                callParameters = GrammarUtil.getExternalRuleExpressions(targetRule);
                method = callParameters.get(0).getText();
                if (metaParameterNames.size() < expressions.size() - 1) {
                    callParameters = ContainerUtil.concat(callParameters, expressions.subList(metaParameterNames.size() + 1, expressions.size()));
                }
            } else {
                String parserClass = this.ruleInfo((BnfRule)targetRule).parserClass;
                if (!parserClass.equals(this.myGrammarRootParser) && !parserClass.equals(this.ruleInfo((BnfRule)rule).parserClass)) {
                    targetClassName = StringUtil.getShortName((String)parserClass);
                }
            }
        }
        method = String.valueOf(method);
        ArrayList<NodeCalls.NodeArgument> arguments = new ArrayList<NodeCalls.NodeArgument>();
        if (callParameters.size() > 1) {
            int len = callParameters.size();
            for (int i = 1; i < len; ++i) {
                String argNextName;
                int metaIdx;
                BnfExpression nested = callParameters.get(i);
                String argument = nested.getText();
                if (argument.startsWith("<<") && (metaIdx = metaParameterNames.indexOf(argument)) > -1) {
                    nested = (BnfExpression)expressions.get(metaIdx + 1);
                    argument = nested.getText();
                    argNextName = ParserGeneratorUtil.getNextName(nextName, metaIdx);
                } else {
                    argNextName = ParserGeneratorUtil.getNextName(nextName, i - 1);
                }
                if (nested instanceof BnfReferenceOrToken) {
                    if (this.myFile.getRule(argument) != null) {
                        arguments.add(this.generateWrappedNodeCall(rule, nested, argument));
                        continue;
                    }
                    String tokenType = this.getElementType(argument);
                    arguments.add(this.generateWrappedNodeCall(rule, nested, tokenType));
                    continue;
                }
                if (nested instanceof BnfLiteralExpression) {
                    String attributeName = this.getTokenName(GrammarUtil.unquote(argument));
                    if (attributeName != null) {
                        arguments.add(this.generateWrappedNodeCall(rule, nested, attributeName));
                        continue;
                    }
                    arguments.add(new NodeCalls.TextArgument(argument.startsWith("'") ? GrammarUtil.unquote(argument) : argument));
                    continue;
                }
                if (nested instanceof BnfExternalExpression) {
                    List<BnfExpression> expressionList = ((BnfExternalExpression)nested).getExpressionList();
                    if (expressionList.size() == 1 && ParserGeneratorUtil.Rule.isMeta(rule)) {
                        arguments.add(new NodeCalls.MetaParameterArgument(this.formatMetaParamName(expressionList.get(0).getText())));
                        continue;
                    }
                    arguments.add(this.generateWrappedNodeCall(rule, nested, argNextName));
                    continue;
                }
                arguments.add(this.generateWrappedNodeCall(rule, nested, argNextName));
            }
        }
        return ParserGeneratorUtil.Rule.isMeta(targetRule) ? new NodeCalls.MetaMethodCall(targetClassName, method, arguments) : new NodeCalls.MethodCallWithArguments(method, arguments);
    }

    @NotNull
    private NodeCalls.NodeArgument generateWrappedNodeCall(@NotNull BnfRule rule, @Nullable BnfExpression nested, @NotNull String nextName) {
        NodeCalls.NodeCall nodeCall = this.generateNodeCall(rule, nested, nextName);
        if (nodeCall instanceof NodeCalls.MetaMethodCall) {
            NodeCalls.MetaMethodCall metaCall = (NodeCalls.MetaMethodCall)nodeCall;
            NodeCalls.MetaMethodCallArgument argument = new NodeCalls.MetaMethodCallArgument(metaCall);
            if (metaCall.referencesMetaParameter()) {
                return argument;
            }
            return () -> this.getMetaMethodFieldRef(argument.render(), nextName);
        }
        if (nodeCall instanceof NodeCalls.MethodCall && this.G.javaVersion > 6) {
            NodeCalls.MethodCall methodCall = (NodeCalls.MethodCall)nodeCall;
            return () -> String.format("%s::%s", methodCall.getClassName(), methodCall.getMethodName());
        }
        return () -> this.getParserLambdaRef(nodeCall, nextName);
    }

    private String getMetaMethodFieldRef(@NotNull String call, @NotNull String nextName) {
        String fieldName = ParserGeneratorUtil.getWrapperParserConstantName(nextName);
        this.myMetaMethodFields.putIfAbsent(fieldName, call);
        return fieldName;
    }

    @NotNull
    private String getParserLambdaRef(@NotNull NodeCalls.NodeCall nodeCall, @NotNull String nextName) {
        String constantName = ParserGeneratorUtil.getWrapperParserConstantName(nextName);
        String targetClass = this.myRenderedLambdas.get(constantName);
        if (targetClass != null) {
            return StringUtil.getShortName((String)targetClass) + "." + constantName;
        }
        if (!this.myParserLambdas.containsKey(constantName)) {
            String call = nodeCall.render(this.N);
            this.myParserLambdas.put(constantName, call);
            if (!call.startsWith(nextName + "(")) {
                this.myInlinedChildNodes.add(nextName);
            }
        }
        return constantName;
    }

    private boolean shallGenerateNodeChild(String funcName) {
        return !this.myInlinedChildNodes.contains(funcName);
    }

    @NotNull
    private NodeCalls.NodeCall generateConsumeToken(@NotNull ParserGeneratorUtil.ConsumeType consumeType, @NotNull String tokenName) {
        this.myTokensUsedInGrammar.add(tokenName);
        return new NodeCalls.ConsumeTokenCall(consumeType, this.getElementType(tokenName));
    }

    @NotNull
    public static NodeCalls.NodeCall generateConsumeTextToken(@NotNull ParserGeneratorUtil.ConsumeType consumeType, @NotNull String tokenText) {
        return new NodeCalls.ConsumeTokenCall(consumeType, "\"" + tokenText + "\"");
    }

    private String getElementType(String token) {
        return ParserGeneratorUtil.getTokenType(this.myFile, token, this.G.generateTokenCase);
    }

    String getElementType(BnfRule r) {
        return ParserGeneratorUtil.getElementType(r, this.G.generateElementCase);
    }

    private void generateElementTypesHolder(String className, Map<String, BnfRule> sortedCompositeTypes) {
        String tokenTypeClass = ParserGeneratorUtil.getRootAttribute((PsiElement)this.myFile, KnownAttribute.TOKEN_TYPE_CLASS);
        String tokenTypeFactory = ParserGeneratorUtil.getRootAttribute((PsiElement)this.myFile, KnownAttribute.TOKEN_TYPE_FACTORY);
        LinkedHashSet<String> imports = new LinkedHashSet<String>();
        imports.add("com.intellij.psi.tree.IElementType");
        if (this.G.generatePsi) {
            imports.add("com.intellij.psi.PsiElement");
            imports.add("com.intellij.lang.ASTNode");
        }
        if (this.G.generateTokenSets && !this.myTokenSets.isEmpty()) {
            imports.add("com.intellij.psi.tree.TokenSet");
        }
        boolean useExactElements = "all".equals(this.G.generateExactTypes) || this.G.generateExactTypes.contains("elements");
        boolean useExactTokens = "all".equals(this.G.generateExactTypes) || this.G.generateExactTypes.contains("tokens");
        HashMap<String, Trinity> compositeToClassAndFactoryMap = new HashMap<String, Trinity>();
        for (String elementType : sortedCompositeTypes.keySet()) {
            BnfRule rule = sortedCompositeTypes.get(elementType);
            RuleInfo ruleInfo = this.ruleInfo(rule);
            String elementTypeClass = ParserGeneratorUtil.getAttribute(rule, KnownAttribute.ELEMENT_TYPE_CLASS);
            String elementTypeFactory = ParserGeneratorUtil.getAttribute(rule, KnownAttribute.ELEMENT_TYPE_FACTORY);
            compositeToClassAndFactoryMap.put(elementType, Trinity.create((Object)elementTypeClass, (Object)elementTypeFactory, (Object)ruleInfo));
            if (elementTypeFactory != null) {
                imports.add(StringUtil.getPackageName((String)elementTypeFactory));
                continue;
            }
            ContainerUtil.addIfNotNull(imports, (Object)elementTypeClass);
        }
        if (tokenTypeFactory != null) {
            imports.add(StringUtil.getPackageName((String)tokenTypeFactory));
        } else {
            ContainerUtil.addIfNotNull(imports, (Object)tokenTypeClass);
        }
        if (this.G.generatePsi) {
            imports.addAll(ContainerUtil.sorted((Collection)JBIterable.from(sortedCompositeTypes.values()).map(this::ruleInfo).map(o -> o.implPackage + ".*").toSet()));
            if (this.G.generatePsiClassesMap) {
                imports.add("java.util.Collections");
                imports.add("java.util.Set");
                imports.add("java.util.LinkedHashMap");
            }
            if (this.G.generatePsiFactory && JBIterable.from(this.myRuleInfos.values()).find(o -> o.mixedAST) != null) {
                imports.add("com.intellij.psi.impl.source.tree.CompositePsiElement");
            }
        }
        this.generateClassHeader(className, imports, "", Java.INTERFACE, new String[0]);
        if (this.G.generateElementTypes) {
            for (String elementType : sortedCompositeTypes.keySet()) {
                Trinity info = (Trinity)compositeToClassAndFactoryMap.get(elementType);
                String elementCreateCall = info.second == null ? "new " + this.shorten((String)info.first) : this.shorten(StringUtil.getPackageName((String)((String)info.second))) + "." + StringUtil.getShortName((String)((String)info.second));
                Iterator fieldType = useExactElements && info.first != null ? (String)info.first : "com.intellij.psi.tree.IElementType";
                String callFix = elementCreateCall.endsWith("IElementType") ? ", null" : "";
                this.out("%s %s = %s(\"%s\"%s);", this.shorten((String)((Object)fieldType)), elementType, elementCreateCall, elementType, callFix);
            }
        }
        if (this.G.generateTokenTypes) {
            String tokenCreateCall;
            this.newLine();
            String exactType = null;
            TreeMap<String, String> sortedTokens = new TreeMap<String, String>();
            if (tokenTypeFactory == null) {
                exactType = tokenTypeClass;
                tokenCreateCall = "new " + this.shorten(exactType);
            } else {
                tokenCreateCall = this.shorten(StringUtil.getPackageName((String)tokenTypeFactory)) + "." + StringUtil.getShortName((String)tokenTypeFactory);
            }
            String fieldType = (String)ObjectUtils.notNull((Object)(useExactTokens ? exactType : null), (Object)"com.intellij.psi.tree.IElementType");
            for (String tokenText : this.mySimpleTokens.keySet()) {
                String tokenName = (String)ObjectUtils.chooseNotNull((Object)this.mySimpleTokens.get(tokenText), (Object)tokenText);
                if (this.isIgnoredWhitespaceToken(tokenName, tokenText)) continue;
                sortedTokens.put(this.getElementType(tokenName), ParserGeneratorUtil.isRegexpToken(tokenText) ? tokenName : tokenText);
            }
            for (String tokenType : sortedTokens.keySet()) {
                String callFix = tokenCreateCall.endsWith("IElementType") ? ", null" : "";
                String tokenString = (String)sortedTokens.get(tokenType);
                this.out("%s %s = %s(\"%s\"%s);", this.shorten(fieldType), tokenType, tokenCreateCall, StringUtil.escapeStringCharacters((String)tokenString), callFix);
            }
            this.generateTokenSets();
        }
        if (this.G.generatePsi && this.G.generatePsiClassesMap) {
            String shortJC = this.shorten("java.lang.Class");
            String shortET = this.shorten("com.intellij.psi.tree.IElementType");
            this.newLine();
            this.out("class Classes {");
            this.newLine();
            this.out("public static %s<?> findClass(%s elementType) {", shortJC, shortET);
            this.out("return ourMap.get(elementType);");
            this.out("}");
            this.newLine();
            this.out("public static %s<%s> elementTypes() {", this.shorten("java.util.Set"), shortET);
            this.out("return %s.unmodifiableSet(ourMap.keySet());", this.shorten("java.util.Collections"));
            this.out("}");
            this.newLine();
            String type = this.shorten("java.util.LinkedHashMap<com.intellij.psi.tree.IElementType, java.lang.Class<?>>");
            this.out("private static final %s ourMap = new %1$s();", type);
            this.newLine();
            this.out("static {");
            for (String elementType : sortedCompositeTypes.keySet()) {
                BnfRule rule = sortedCompositeTypes.get(elementType);
                RuleInfo info = this.ruleInfo(rule);
                if (info.isAbstract) continue;
                String psiClass = ParserGeneratorUtil.getRulePsiClassName(rule, this.myImplClassFormat);
                this.out("ourMap.put(" + elementType + ", " + psiClass + ".class);");
            }
            this.out("}");
            this.out("}");
        }
        if (this.G.generatePsi && this.G.generatePsiFactory) {
            Object psiClass;
            RuleInfo info;
            BnfRule rule;
            this.newLine();
            this.out("class Factory {");
            boolean first1 = true;
            for (String elementType : sortedCompositeTypes.keySet()) {
                rule = sortedCompositeTypes.get(elementType);
                info = this.ruleInfo(rule);
                if (info.isAbstract || info.mixedAST) continue;
                if (first1) {
                    this.out("public static %s createElement(%s node) {", this.shorten("com.intellij.psi.PsiElement"), this.shorten("com.intellij.lang.ASTNode"));
                    this.out("%s type = node.getElementType();", this.shorten("com.intellij.psi.tree.IElementType"));
                }
                psiClass = ParserGeneratorUtil.getAttribute(rule, KnownAttribute.PSI_IMPL_PACKAGE) + "." + ParserGeneratorUtil.getRulePsiClassName(rule, this.myImplClassFormat);
                this.out((!first1 ? "else " : "") + "if (type == " + elementType + ") {");
                this.out("return new " + this.shorten((String)psiClass) + "(node);");
                first1 = false;
                this.out("}");
            }
            if (!first1) {
                this.out("throw new AssertionError(\"Unknown element type: \" + type);");
                this.out("}");
            }
            boolean first2 = true;
            for (String elementType : sortedCompositeTypes.keySet()) {
                rule = sortedCompositeTypes.get(elementType);
                info = this.ruleInfo(rule);
                if (info.isAbstract || !info.mixedAST) continue;
                if (first2) {
                    if (!first1) {
                        this.newLine();
                    }
                    this.out("public static %s createElement(%s type) {", this.shorten("com.intellij.psi.impl.source.tree.CompositePsiElement"), this.shorten("com.intellij.psi.tree.IElementType"));
                }
                psiClass = ParserGeneratorUtil.getRulePsiClassName(rule, this.myImplClassFormat);
                this.out((!first2 ? "else" : "") + " if (type == " + elementType + ") {");
                this.out("return new " + (String)psiClass + "(type);");
                first2 = false;
                this.out("}");
            }
            if (!first2) {
                this.out("throw new AssertionError(\"Unknown element type: \" + type);");
                this.out("}");
            }
            this.out("}");
        }
        this.out("}");
    }

    private boolean isIgnoredWhitespaceToken(@NotNull String tokenName, @NotNull String tokenText) {
        return ParserGeneratorUtil.isRegexpToken(tokenText) && !this.myTokensUsedInGrammar.contains(tokenName) && ParserGeneratorUtil.matchesAny(ParserGeneratorUtil.getRegexpTokenRegexp(tokenText), " ", "\n") && !ParserGeneratorUtil.matchesAny(ParserGeneratorUtil.getRegexpTokenRegexp(tokenText), "a", "1", "_", ".");
    }

    private void generateTokenSets() {
        if (this.myTokenSets.isEmpty()) {
            return;
        }
        this.newLine();
        this.out("interface %s {", "TokenSets");
        HashMap reverseMap = new HashMap();
        this.myTokenSets.forEach((name, tokens) -> {
            String value = String.format("TokenSet.create(%s)", ParserGeneratorUtil.tokenSetString(tokens));
            String alreadyRendered = reverseMap.putIfAbsent(value, name);
            this.out("TokenSet %s = %s;", name, ObjectUtils.chooseNotNull((Object)alreadyRendered, (Object)value));
        });
        this.out("}");
    }

    private void generatePsiIntf(BnfRule rule, RuleInfo info) {
        String psiClass = info.intfClass;
        String stubClass = info.stub;
        Set<String> psiSupers = info.superInterfaces;
        if (StringUtil.isNotEmpty((String)stubClass)) {
            psiSupers = new LinkedHashSet<String>(psiSupers);
            psiSupers.add("com.intellij.psi.StubBasedPsiElement<" + stubClass + ">");
        }
        LinkedHashSet<String> imports = new LinkedHashSet<String>();
        imports.addAll(Arrays.asList("java.util.List", "org.jetbrains.annotations.*", "com.intellij.psi.PsiElement"));
        imports.addAll(psiSupers);
        imports.addAll(this.getRuleMethodTypesToImport(rule));
        this.generateClassHeader(psiClass, imports, "", Java.INTERFACE, ArrayUtil.toStringArray(psiSupers));
        this.generatePsiClassMethods(rule, info, true);
        this.out("}");
    }

    private void generatePsiImpl(BnfRule rule, RuleInfo info) {
        String psiClass = info.implClass;
        String superInterface = info.intfClass;
        String stubName = info.realStubClass;
        String implSuper = info.realSuperClass;
        LinkedHashSet<String> imports = new LinkedHashSet<String>();
        if (!this.G.generateFQN) {
            imports.addAll(Arrays.asList("java.util.List", "org.jetbrains.annotations.*", "com.intellij.lang.ASTNode", "com.intellij.psi.PsiElement"));
            if (this.myVisitorClassName != null) {
                imports.add("com.intellij.psi.PsiElementVisitor");
            }
            imports.add(this.myPsiTreeUtilClass);
        } else {
            imports.add("#forced");
        }
        imports.add(ParserGeneratorUtil.staticStarImport(this.myTypeHolderClass));
        if (!this.G.generateFQN) {
            if (StringUtil.isNotEmpty((String)implSuper)) {
                imports.add(implSuper);
            }
            imports.add(StringUtil.getPackageName((String)superInterface) + ".*");
            imports.add(StringUtil.notNullize((String)this.myVisitorClassName));
            imports.add(StringUtil.notNullize((String)this.myPsiImplUtilClass));
            imports.addAll(this.getRuleMethodTypesToImport(rule));
        }
        Function substitutor = stubName == null ? ParserGeneratorUtil::unwrapTypeArgumentForParamList : o -> {
            String oo = ParserGeneratorUtil.unwrapTypeArgumentForParamList(o);
            if (oo.equals(o)) {
                return o;
            }
            int idx = oo.lastIndexOf(" ");
            return idx == -1 ? stubName : oo.substring(0, idx) + " " + stubName;
        };
        HashSet<BnfRule> visited = new HashSet<BnfRule>();
        List<Object> constructors = Collections.emptyList();
        Iterator<RuleMethodsHelper.MethodInfo> topSuperRule = null;
        String topSuperClass = null;
        Object next = rule;
        while (next != null && next != topSuperRule) {
            if (!visited.add((BnfRule)next)) {
                this.addWarning(rule.getName() + " employs cyclic inheritance");
                break;
            }
            topSuperRule = next;
            String string = this.ruleInfo((BnfRule)next).realSuperClass;
            if (string == null || (next = ParserGeneratorUtil.getEffectiveSuperRule(this.myFile, next)) != null && next != topSuperRule && ParserGeneratorUtil.getAttribute(topSuperRule, KnownAttribute.MIXIN) == null || (constructors = this.myJavaHelper.findClassMethods(topSuperClass = NameShortener.getRawClassName(string), JavaHelper.MethodType.CONSTRUCTOR, "*", -1, new String[0])).isEmpty()) continue;
            break;
        }
        if (!this.G.generateFQN) {
            for (NavigatablePsiElement navigatablePsiElement : constructors) {
                this.collectMethodTypesToImport(Collections.singletonList(navigatablePsiElement), false, imports);
            }
            if (stubName != null && constructors.isEmpty()) {
                imports.add("com.intellij.psi.stubs.IStubElementType");
            }
            if (stubName != null) {
                imports.add(stubName);
            }
        }
        if (!this.G.generateTokenTypes) {
            for (RuleMethodsHelper.MethodInfo methodInfo : this.myRulesMethodsHelper.getFor(rule)) {
                if (methodInfo.rule != null || StringUtil.isEmpty((String)methodInfo.name)) continue;
                for (String string : ParserGeneratorUtil.getRootAttribute((PsiElement)this.myFile, KnownAttribute.PARSER_IMPORTS).asStrings()) {
                    if (!string.startsWith("static ")) continue;
                    imports.add(string);
                }
            }
        }
        Java javaType = info.isAbstract ? Java.ABSTRACT_CLASS : Java.CLASS;
        this.generateClassHeader(psiClass, imports, "", javaType, implSuper, superInterface);
        String string = StringUtil.getShortName((String)psiClass);
        if (constructors.isEmpty()) {
            this.out("public " + string + "(" + this.shorten("com.intellij.lang.ASTNode") + " node) {");
            this.out("super(node);");
            this.out("}");
            this.newLine();
            if (stubName != null) {
                this.out("public " + string + "(" + this.shorten(stubName) + " stub, " + this.shorten("com.intellij.psi.stubs.IStubElementType") + " stubType) {");
                this.out("super(stub, stubType);");
                this.out("}");
                this.newLine();
            }
        } else {
            for (NavigatablePsiElement navigatablePsiElement : constructors) {
                List<String> types = this.myJavaHelper.getMethodTypes(navigatablePsiElement);
                Function annoProvider = i -> this.myJavaHelper.getParameterAnnotations(m, (i - 1) / 2);
                this.out("public " + string + "(" + ParserGeneratorUtil.getParametersString(types, 1, 3, (Function<? super String, String>)substitutor, (Function<? super Integer, ? extends List<String>>)annoProvider, this.myShortener) + ") {");
                this.out("super(" + ParserGeneratorUtil.getParametersString(types, 1, 2, (Function<? super String, String>)substitutor, (Function<? super Integer, ? extends List<String>>)annoProvider, this.myShortener) + ");");
                this.out("}");
                this.newLine();
            }
        }
        if (this.myVisitorClassName != null) {
            boolean addOverride;
            String shortened = this.shorten(this.myVisitorClassName);
            String string2 = this.G.visitorValue != null ? "<" + this.G.visitorValue + ">" : "";
            String t = this.G.visitorValue != null ? " " + this.G.visitorValue : "void";
            String ret = this.G.visitorValue != null ? "return " : "";
            boolean bl = addOverride = topSuperRule != rule && info.mixin == null;
            if (!addOverride && topSuperClass != null) {
                String curClass = topSuperClass;
                block5: while (curClass != null) {
                    for (NavigatablePsiElement m : this.myJavaHelper.findClassMethods(curClass, JavaHelper.MethodType.INSTANCE, "accept", 1, this.myVisitorClassName)) {
                        String paramType = this.myJavaHelper.getMethodTypes(m).get(1);
                        if (!NameShortener.getRawClassName(paramType).endsWith(StringUtil.getShortName((String)this.myVisitorClassName))) continue;
                        addOverride = true;
                        break block5;
                    }
                    curClass = this.myJavaHelper.getSuperClassName(curClass);
                }
            }
            if (addOverride) {
                this.out(this.shorten("@java.lang.Override"));
            }
            this.out("public " + string2 + t + " accept(" + this.shorten("@org.jetbrains.annotations.NotNull") + " " + shortened + string2 + " visitor) {");
            this.out(ret + "visitor.visit" + ParserGeneratorUtil.getRulePsiClassName(rule, null) + "(this);");
            this.out("}");
            this.newLine();
            this.out(this.shorten("@java.lang.Override"));
            this.out("public void accept(" + this.shorten("@org.jetbrains.annotations.NotNull") + " " + this.shorten("com.intellij.psi.PsiElementVisitor") + " visitor) {");
            this.out("if (visitor instanceof " + shortened + ") accept((" + shortened + ")visitor);");
            this.out("else super.accept(visitor);");
            this.out("}");
            this.newLine();
        }
        this.generatePsiClassMethods(rule, info, false);
        this.out("}");
    }

    private void generatePsiClassMethods(BnfRule rule, RuleInfo info, boolean intf) {
        TreeSet<String> visited = new TreeSet<String>();
        boolean mixedAST = info.mixedAST;
        block5: for (RuleMethodsHelper.MethodInfo methodInfo : this.myRulesMethodsHelper.getFor(rule)) {
            if (StringUtil.isEmpty((String)methodInfo.name)) continue;
            switch (methodInfo.type) {
                case RULE: 
                case TOKEN: {
                    this.generatePsiAccessor(rule, methodInfo, intf, mixedAST);
                    break;
                }
                case USER: {
                    this.generateUserPsiAccessors(rule, methodInfo, intf, mixedAST);
                    break;
                }
                case MIXIN: {
                    boolean found = false;
                    if (intf) {
                        String mixinClass = ParserGeneratorUtil.getAttribute(rule, KnownAttribute.MIXIN);
                        List<NavigatablePsiElement> methods = this.myJavaHelper.findClassMethods(mixinClass, JavaHelper.MethodType.INSTANCE, methodInfo.name, -1, new String[0]);
                        Iterator iterator = methods.iterator();
                        while (iterator.hasNext()) {
                            NavigatablePsiElement method = (NavigatablePsiElement)iterator.next();
                            this.generateUtilMethod(methodInfo.name, method, true, false, visited);
                            found = true;
                        }
                    }
                    List<NavigatablePsiElement> methods = ParserGeneratorUtil.findRuleImplMethods(this.myJavaHelper, this.myPsiImplUtilClass, methodInfo.name, rule);
                    for (NavigatablePsiElement method : methods) {
                        this.generateUtilMethod(methodInfo.name, method, intf, true, visited);
                        found = true;
                    }
                    if (!intf || found) continue block5;
                    String ruleClassName = this.shorten(info.intfClass);
                    String implClassName = StringUtil.getShortName((String)String.valueOf(this.myPsiImplUtilClass));
                    this.out("//WARNING: %s(...) is skipped\n//matching %s(%s, ...)\n//methods are not found in %s", methodInfo.name, methodInfo.name, ruleClassName, implClassName);
                    this.newLine();
                    this.addWarning(String.format("%s.%s(%s, ...) method not found", implClassName, methodInfo.name, ruleClassName));
                    break;
                }
                default: {
                    throw new AssertionError((Object)methodInfo.toString());
                }
            }
        }
    }

    public Collection<String> getRuleMethodTypesToImport(BnfRule rule) {
        TreeSet<String> result = new TreeSet<String>();
        Collection<RuleMethodsHelper.MethodInfo> methods = this.myRulesMethodsHelper.getFor(rule);
        for (RuleMethodsHelper.MethodInfo methodInfo : methods) {
            if (methodInfo.rule != null) {
                result.add(this.getAccessorType(methodInfo.rule));
                continue;
            }
            if (methodInfo.type != RuleMethodsHelper.MethodType.USER) continue;
            RuleMethodsHelper.MethodInfo targetInfo = null;
            for (Object m : this.resolveUserPsiPathMethods(rule, methodInfo.path.split("/"))) {
                if (m == null) break;
                if (m instanceof String) continue;
                targetInfo = (RuleMethodsHelper.MethodInfo)m;
            }
            if (targetInfo == null || targetInfo.rule == null) continue;
            result.add(this.getAccessorType(targetInfo.rule));
        }
        String mixinClass = ParserGeneratorUtil.getAttribute(rule, KnownAttribute.MIXIN);
        for (RuleMethodsHelper.MethodInfo methodInfo : methods) {
            if (methodInfo.type != RuleMethodsHelper.MethodType.MIXIN) continue;
            List<NavigatablePsiElement> mixinMethods = this.myJavaHelper.findClassMethods(mixinClass, JavaHelper.MethodType.INSTANCE, methodInfo.name, -1, new String[0]);
            List<NavigatablePsiElement> implMethods = ParserGeneratorUtil.findRuleImplMethods(this.myJavaHelper, this.myPsiImplUtilClass, methodInfo.name, rule);
            this.collectMethodTypesToImport(mixinMethods, false, result);
            this.collectMethodTypesToImport(implMethods, true, result);
        }
        return result;
    }

    private void collectMethodTypesToImport(@NotNull List<NavigatablePsiElement> methods, boolean isInPsiUtil, @NotNull Set<String> result) {
        for (NavigatablePsiElement method : methods) {
            List<String> types = this.myJavaHelper.getMethodTypes(method);
            String returnType = (String)ContainerUtil.getFirstItem(types);
            NameShortener.addTypeToImports(returnType, this.myJavaHelper.getAnnotations(method), result);
            for (JavaHelper.TypeParameterInfo generic : this.myJavaHelper.getGenericParameters(method)) {
                for (String type : generic.getExtendsList()) {
                    NameShortener.addTypeToImports(type, ContainerUtil.emptyList(), result);
                }
                for (String type : generic.getAnnotations()) {
                    NameShortener.addTypeToImports(type, ContainerUtil.emptyList(), result);
                }
            }
            int count = types.size();
            for (int i = isInPsiUtil ? 3 : 1; i < count; i += 2) {
                String type = types.get(i);
                NameShortener.addTypeToImports(type, this.myJavaHelper.getParameterAnnotations(method, (i - 1) / 2), result);
            }
            for (String exception : this.myJavaHelper.getExceptionList(method)) {
                NameShortener.addTypeToImports(exception, ContainerUtil.emptyList(), result);
            }
        }
    }

    private void generatePsiAccessor(BnfRule rule, RuleMethodsHelper.MethodInfo methodInfo, boolean intf, boolean mixedAST) {
        RuleGraphHelper.Cardinality type = methodInfo.cardinality;
        boolean isToken = methodInfo.rule == null;
        boolean many = type.many();
        String getterName = methodInfo.generateGetterName();
        if (!intf) {
            this.out(this.shorten("@java.lang.Override"));
        }
        if (type == RuleGraphHelper.Cardinality.REQUIRED) {
            this.out(this.shorten("@org.jetbrains.annotations.NotNull"));
        } else if (type == RuleGraphHelper.Cardinality.OPTIONAL) {
            this.out(this.shorten("@org.jetbrains.annotations.Nullable"));
        } else {
            this.out(this.shorten("@org.jetbrains.annotations.NotNull"));
        }
        String s = isToken ? "com.intellij.psi.PsiElement" : this.getAccessorType(methodInfo.rule);
        String className = this.shorten(s);
        String tail = intf ? "();" : "() {";
        this.out((intf ? "" : "public ") + (String)(many ? this.shorten("java.util.List") + "<" : "") + className + (many ? "> " : " ") + getterName + tail);
        if (!intf) {
            this.out("return " + this.generatePsiAccessorImplCall(rule, methodInfo, mixedAST) + ";");
            this.out("}");
        }
        this.newLine();
    }

    private String generatePsiAccessorImplCall(@NotNull BnfRule rule, @NotNull RuleMethodsHelper.MethodInfo methodInfo, boolean mixedAST) {
        Object result;
        boolean stubbed;
        boolean isToken = methodInfo.rule == null;
        RuleGraphHelper.Cardinality type = methodInfo.cardinality;
        boolean many = type.many();
        boolean required = type == RuleGraphHelper.Cardinality.REQUIRED && !many;
        boolean bl = stubbed = !isToken && this.ruleInfo((BnfRule)rule).realStubClass != null && this.ruleInfo((BnfRule)methodInfo.rule).realStubClass != null;
        if (!mixedAST && this.myNoStubs) {
            if (isToken) {
                return (type == RuleGraphHelper.Cardinality.REQUIRED ? "findNotNullChildByType" : "findChildByType") + "(" + this.getElementType(methodInfo.path) + ")";
            }
            String className = this.shorten(this.getAccessorType(methodInfo.rule));
            return many ? String.format("%s.getChildrenOfTypeAsList(this, %s.class)", this.shorten(this.myPsiTreeUtilClass), className) : (type == RuleGraphHelper.Cardinality.REQUIRED ? "findNotNullChildByClass" : "findChildByClass") + "(" + className + ".class)";
        }
        if (isToken) {
            String getterName = mixedAST ? "findPsiChildByType" : "findChildByType";
            result = getterName + "(" + this.getElementType(methodInfo.path) + ")";
        } else {
            String className = this.shorten(this.getAccessorType(methodInfo.rule));
            String getterName = stubbed && many ? "getStubChildrenOfTypeAsList" : (stubbed ? "getStubChildOfType" : (many ? "getChildrenOfTypeAsList" : "getChildOfType"));
            result = String.format("%s.%s(this, %s.class)", this.shorten(this.myPsiTreeUtilClass), getterName, className);
        }
        return required && !mixedAST ? "notNullChild(" + (String)result + ")" : result;
    }

    @NotNull
    private String getAccessorType(@NotNull BnfRule rule) {
        if (ParserGeneratorUtil.Rule.isExternal(rule)) {
            Pair first = (Pair)ContainerUtil.getFirstItem((List)ParserGeneratorUtil.getAttribute(rule, KnownAttribute.IMPLEMENTS));
            return (String)Objects.requireNonNull(first).second;
        }
        return this.ruleInfo((BnfRule)rule).intfClass;
    }

    private JBIterable<?> resolveUserPsiPathMethods(BnfRule startRule, String[] splitPath) {
        BnfRule[] targetRule = new BnfRule[]{startRule};
        return JBIterable.generate((Object)0, i -> i + 1).take(splitPath.length).map(i -> {
            String item;
            String pathElement = splitPath[i];
            int indexStart = pathElement.indexOf(91);
            String string = item = indexStart > -1 ? pathElement.substring(0, indexStart).trim() : pathElement.trim();
            if (item.isEmpty()) {
                return item;
            }
            if (targetRule[0] == null) {
                return null;
            }
            RuleMethodsHelper.MethodInfo targetInfo = this.myRulesMethodsHelper.getMethodInfo(targetRule[0], item);
            targetRule[0] = targetInfo == null ? null : targetInfo.rule;
            return targetInfo;
        });
    }

    private void generateUserPsiAccessors(BnfRule startRule, RuleMethodsHelper.MethodInfo methodInfo, boolean intf, boolean mixedAST) {
        StringBuilder sb = new StringBuilder();
        BnfRule targetRule = startRule;
        RuleGraphHelper.Cardinality cardinality = RuleGraphHelper.Cardinality.REQUIRED;
        Object context = "";
        String[] splitPath = methodInfo.path.split("/");
        int i = -1;
        int count = 1;
        boolean totalNullable = false;
        for (Object m : this.resolveUserPsiPathMethods(startRule, splitPath)) {
            String error;
            String pathElement = splitPath[++i];
            if (m instanceof String) continue;
            boolean last = i == splitPath.length - 1;
            int indexStart = pathElement.indexOf(91);
            int indexEnd = indexStart > 0 ? pathElement.lastIndexOf(93) : -1;
            String base = (indexStart > -1 ? pathElement.substring(0, indexStart) : pathElement).trim();
            Object index = indexEnd > -1 ? pathElement.substring(indexStart + 1, indexEnd).trim() : null;
            RuleMethodsHelper.MethodInfo targetInfo = (RuleMethodsHelper.MethodInfo)m;
            if (indexStart > 0 && (indexEnd == -1 || StringUtil.isNotEmpty((String)pathElement.substring(indexEnd + 1)))) {
                error = "'<name>[<index>]' expected, got '" + pathElement + "'";
            } else if (targetInfo == null) {
                Collection<String> available;
                Collection<String> collection = available = targetRule == null ? null : this.myRulesMethodsHelper.getMethodNames(targetRule);
                error = targetRule == null ? "'" + base + "' not found in '" + splitPath[i - 1] + "' (not a rule)" : (available == null || available.isEmpty() ? "'" + base + "' not found in '" + targetRule.getName() + "' (available: nothing)" : "'" + base + "' not found in '" + targetRule.getName() + "' (available: " + String.join((CharSequence)", ", available) + ")");
            } else {
                error = index != null && !targetInfo.cardinality.many() ? "'[" + (String)index + "]' unexpected after '" + base + RuleGraphHelper.getCardinalityText(targetInfo.cardinality) + "'" : (!last && index == null && targetInfo.cardinality.many() ? "'[<index>]' required after '" + base + RuleGraphHelper.getCardinalityText(targetInfo.cardinality) + "'" : (i > 0 && StringUtil.isEmpty((String)targetInfo.name) ? "'" + base + "' accessor suppressed in '" + splitPath[i - 1] + "'" : null));
            }
            if (error != null) {
                if (intf) {
                    this.addWarning(String.format("%s#%s(\"%s\"): %s", startRule.getName(), methodInfo.name, methodInfo.path, error));
                }
                return;
            }
            boolean many = targetInfo.cardinality.many();
            String className = this.shorten(targetInfo.rule == null ? "com.intellij.psi.PsiElement" : this.getAccessorType(targetInfo.rule));
            String type = (String)(many ? this.shorten("java.util.List") + "<" : "") + className + (many ? "> " : " ");
            String curId = this.N.psiLocal + count++;
            if (!((String)context).isEmpty()) {
                if (cardinality.optional()) {
                    sb.append("if (").append((String)context).append(" == null) return null;\n");
                }
                context = (String)context + ".";
            }
            if (last && index == null) {
                sb.append("return ");
            } else {
                sb.append(type).append(curId).append(" = ");
            }
            Object targetCall = StringUtil.isNotEmpty((String)targetInfo.name) ? targetInfo.generateGetterName() + "()" : this.generatePsiAccessorImplCall(startRule, targetInfo, mixedAST);
            sb.append((String)context).append((String)targetCall).append(";\n");
            context = curId;
            targetRule = targetInfo.rule;
            cardinality = targetInfo.cardinality;
            totalNullable |= cardinality.optional();
            if (index == null) continue;
            if ("first".equals(index)) {
                index = "0";
            }
            context = (String)context + ".";
            boolean isLast = ((String)index).equals("last");
            if (isLast) {
                index = (String)context + "size() - 1";
            }
            curId = this.N.psiLocal + count++;
            if (last) {
                sb.append("return ");
            } else {
                sb.append(className).append(" ").append(curId).append(" = ");
            }
            if (cardinality != RuleGraphHelper.Cardinality.AT_LEAST_ONE || !((String)index).equals("0")) {
                if (isLast) {
                    sb.append((String)context).append("isEmpty()? null : ");
                } else {
                    int val = StringUtil.parseInt((String)index, (int)Integer.MAX_VALUE);
                    sb.append((String)context).append("size()").append(val == Integer.MAX_VALUE ? " - 1 < " + (String)index : " < " + (val + 1)).append(" ? null : ");
                }
            }
            sb.append((String)context).append("get(").append((String)index).append(");\n");
            context = curId;
            cardinality = cardinality == RuleGraphHelper.Cardinality.AT_LEAST_ONE && ((String)index).equals("0") ? RuleGraphHelper.Cardinality.REQUIRED : RuleGraphHelper.Cardinality.OPTIONAL;
            totalNullable |= cardinality.optional();
        }
        if (!intf) {
            this.out(this.shorten("@java.lang.Override"));
        }
        if (!cardinality.many() && cardinality == RuleGraphHelper.Cardinality.REQUIRED && !totalNullable) {
            this.out(this.shorten("@org.jetbrains.annotations.NotNull"));
        } else {
            this.out(this.shorten("@org.jetbrains.annotations.Nullable"));
        }
        boolean many = cardinality.many();
        String s = targetRule == null ? "com.intellij.psi.PsiElement" : this.getAccessorType(targetRule);
        String className = this.shorten(s);
        String getterName = ParserGeneratorUtil.getGetterName(methodInfo.name);
        String tail = intf ? "();" : "() {";
        this.out((intf ? "" : "public ") + (String)(many ? this.shorten("java.util.List") + "<" : "") + className + (many ? "> " : " ") + getterName + tail);
        if (!intf) {
            this.out(sb.toString());
            this.out("}");
        }
        this.newLine();
    }

    private void generateUtilMethod(String methodName, NavigatablePsiElement method, boolean intf, boolean isInPsiUtil, Set<String> visited) {
        int offset;
        String returnType;
        List<String> methodTypes = method == null ? Collections.emptyList() : this.myJavaHelper.getMethodTypes(method);
        String string = returnType = methodTypes.isEmpty() ? "void" : this.shorten((String)methodTypes.get(0));
        int n = methodTypes.isEmpty() || isInPsiUtil && methodTypes.size() < 3 ? 0 : (offset = isInPsiUtil ? 3 : 1);
        if (!visited.add(methodName + methodTypes.subList(offset, methodTypes.size()))) {
            return;
        }
        if (intf && methodTypes.size() == offset && "toString".equals(methodName)) {
            return;
        }
        List<JavaHelper.TypeParameterInfo> genericParameters = this.myJavaHelper.getGenericParameters(method);
        List<String> exceptionList = this.myJavaHelper.getExceptionList(method);
        if (!intf) {
            this.out(this.shorten("@java.lang.Override"));
        }
        for (String s : this.myJavaHelper.getAnnotations(method)) {
            if ("java.lang.Override".equals(s) || s.startsWith("kotlin.")) continue;
            this.out("@" + this.shorten(s));
        }
        Function annoProvider = i -> this.myJavaHelper.getParameterAnnotations(method, (i - 1) / 2);
        Function substitutor = ParserGeneratorUtil::unwrapTypeArgumentForParamList;
        this.out("%s%s%s %s(%s)%s%s", intf ? "" : "public ", ParserGeneratorUtil.getGenericClauseString(genericParameters, this.myShortener), returnType, methodName, ParserGeneratorUtil.getParametersString(methodTypes, offset, 3, (Function<? super String, String>)substitutor, (Function<? super Integer, ? extends List<String>>)annoProvider, this.myShortener), ParserGeneratorUtil.getThrowsString(exceptionList, this.myShortener), intf ? ";" : " {");
        if (!intf) {
            String implUtilRef = this.shorten(StringUtil.notNullize((String)this.myPsiImplUtilClass, (String)KnownAttribute.PSI_IMPL_UTIL_CLASS.getName()));
            String string2 = ParserGeneratorUtil.getParametersString(methodTypes, offset, 2, (Function<? super String, String>)substitutor, (Function<? super Integer, ? extends List<String>>)annoProvider, this.myShortener);
            this.out("%s%s.%s(this%s);", "void".equals(returnType) ? "" : "return ", implUtilRef, methodName, string2.isEmpty() ? "" : ", " + string2);
            this.out("}");
        }
        this.newLine();
    }

    static class RuleInfo {
        final String name;
        final boolean isFake;
        final String elementType;
        final String parserClass;
        final String intfPackage;
        final String implPackage;
        final String intfClass;
        final String implClass;
        final String mixin;
        final String stub;
        String realStubClass;
        Set<String> superInterfaces;
        boolean mixedAST;
        String realSuperClass;
        boolean isAbstract;
        boolean isInElementType;

        RuleInfo(String name, boolean isFake, String elementType, String parserClass, String intfPackage, String implPackage, String intfClass, String implClass, String mixin, String stub) {
            this.name = name;
            this.isFake = isFake;
            this.elementType = elementType;
            this.parserClass = parserClass;
            this.intfPackage = intfPackage;
            this.implPackage = implPackage;
            this.stub = stub;
            this.intfClass = intfPackage + "." + intfClass;
            this.implClass = implPackage + "." + implClass;
            this.mixin = mixin;
        }
    }

    private static enum Java {
        CLASS,
        INTERFACE,
        ABSTRACT_CLASS;

    }
}

