/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.generator;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.intellij.grammar.KnownAttribute;
import org.intellij.grammar.generator.ExpressionHelper;
import org.intellij.grammar.generator.GenOptions;
import org.intellij.grammar.generator.ParserGeneratorUtil;
import org.intellij.grammar.generator.RuleGraphHelper;
import org.intellij.grammar.psi.BnfAttr;
import org.intellij.grammar.psi.BnfRule;
import org.intellij.grammar.psi.BnfTypes;
import org.intellij.grammar.psi.impl.GrammarUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RuleMethodsHelper {
    private final RuleGraphHelper myGraphHelper;
    private final ExpressionHelper myExpressionHelper;
    private final Map<String, String> mySimpleTokens;
    private final GenOptions G;
    private final Map<BnfRule, Pair<Map<String, MethodInfo>, Collection<MethodInfo>>> myMethods;

    public RuleMethodsHelper(RuleGraphHelper ruleGraphHelper, ExpressionHelper expressionHelper, Map<String, String> simpleTokens, GenOptions genOptions) {
        this.myGraphHelper = ruleGraphHelper;
        this.myExpressionHelper = expressionHelper;
        this.mySimpleTokens = Collections.unmodifiableMap(simpleTokens);
        this.G = genOptions;
        this.myMethods = new LinkedHashMap<BnfRule, Pair<Map<String, MethodInfo>, Collection<MethodInfo>>>();
    }

    public void buildMaps(Collection<BnfRule> sortedPsiRules) {
        Map<String, String> tokensReversed = RuleGraphHelper.computeTokens(this.myGraphHelper.getFile()).asMap();
        for (BnfRule rule : sortedPsiRules) {
            this.calcMethods(rule, tokensReversed);
        }
        for (BnfRule r0 : this.myGraphHelper.getRuleExtendsMap().keySet()) {
            if (!this.myMethods.containsKey(r0)) continue;
            Map p0 = (Map)this.myMethods.get((Object)r0).first;
            for (BnfRule r : this.myGraphHelper.getRuleExtendsMap().get((Object)r0)) {
                if (r0 == r || !this.myMethods.containsKey(r)) continue;
                Map p = (Map)this.myMethods.get((Object)r).first;
                for (String name : p.keySet()) {
                    MethodInfo m0 = (MethodInfo)p0.get(name);
                    if (m0 == null) continue;
                    MethodInfo m = (MethodInfo)p.get(name);
                    if (m0.cardinality != m.cardinality) continue;
                    m.name = "";
                }
            }
        }
    }

    @NotNull
    public Collection<MethodInfo> getFor(@NotNull BnfRule rule) {
        return (Collection)this.myMethods.get((Object)rule).second;
    }

    @Nullable
    public MethodInfo getMethodInfo(@NotNull BnfRule rule, String name) {
        return (MethodInfo)((Map)this.myMethods.get((Object)rule).first).get(name);
    }

    @Nullable
    public Collection<String> getMethodNames(@NotNull BnfRule rule) {
        return ((Map)this.myMethods.get((Object)rule).first).keySet();
    }

    protected void calcMethods(BnfRule rule, Map<String, String> tokensReversed) {
        ArrayList<MethodInfo> result = new ArrayList<MethodInfo>();
        Map<PsiElement, RuleGraphHelper.Cardinality> cardMap = this.myGraphHelper.getFor(rule);
        for (PsiElement element : cardMap.keySet()) {
            RuleGraphHelper.Cardinality c;
            String pathName = this.getRuleOrTokenNameForPsi(element, c = this.myExpressionHelper.fixCardinality(rule, element, cardMap.get(element)));
            if (pathName == null) continue;
            if (element instanceof BnfRule) {
                BnfRule resultType = (BnfRule)element;
                if (ParserGeneratorUtil.Rule.isPrivate(rule)) continue;
                result.add(new MethodInfo(MethodType.RULE, pathName, pathName, resultType, c));
                continue;
            }
            result.add(new MethodInfo(MethodType.TOKEN, pathName, pathName, null, c));
        }
        Collections.sort(result);
        BnfAttr attr = ParserGeneratorUtil.findAttribute(rule, KnownAttribute.GENERATE_TOKEN_ACCESSORS);
        boolean generateTokens = attr == null ? this.G.generateTokenAccessors : Boolean.TRUE.equals(ParserGeneratorUtil.getAttributeValue(attr.getExpression()));
        boolean generateTokensSet = attr != null || this.G.generateTokenAccessorsSet;
        LinkedHashMap<String, MethodInfo> basicMethods = new LinkedHashMap<String, MethodInfo>();
        for (MethodInfo methodInfo : result) {
            basicMethods.put(methodInfo.name, methodInfo);
            if (methodInfo.type != MethodType.TOKEN) continue;
            boolean registered = tokensReversed.containsKey(methodInfo.name);
            String pattern = tokensReversed.get(methodInfo.name);
            if (generateTokens || !generateTokensSet && registered && (pattern == null || ParserGeneratorUtil.isRegexpToken(pattern))) continue;
            methodInfo.name = "";
        }
        KnownAttribute.ListValue methods = ParserGeneratorUtil.getAttribute(rule, KnownAttribute.METHODS);
        for (Pair pair : methods) {
            if (StringUtil.isEmpty((String)((String)pair.first))) continue;
            MethodInfo methodInfo = (MethodInfo)basicMethods.get(pair.first);
            if (methodInfo != null) {
                methodInfo.name = "";
            }
            if (StringUtil.isNotEmpty((String)((String)pair.second))) {
                MethodInfo basicInfo = (MethodInfo)basicMethods.get(pair.second);
                if (basicInfo != null && (basicInfo.name.equals(pair.second) || basicInfo.name.isEmpty())) {
                    basicInfo.name = (String)pair.first;
                    result.remove(basicInfo);
                    result.add(basicInfo);
                    continue;
                }
                result.add(new MethodInfo(MethodType.USER, (String)pair.first, (String)pair.second, null, null));
                continue;
            }
            if (methodInfo != null) continue;
            result.add(new MethodInfo(MethodType.MIXIN, (String)pair.first, null, null, null));
        }
        this.myMethods.put(rule, (Pair<Map<String, MethodInfo>, Collection<MethodInfo>>)Pair.create(basicMethods, result));
    }

    @Nullable
    private String getRuleOrTokenNameForPsi(@NotNull PsiElement tree, @NotNull RuleGraphHelper.Cardinality type) {
        String result;
        if (!(tree instanceof BnfRule)) {
            if (type.many()) {
                return null;
            }
            IElementType effectiveType = ParserGeneratorUtil.getEffectiveType(tree);
            result = effectiveType == BnfTypes.BNF_STRING ? this.mySimpleTokens.get(GrammarUtil.unquote(tree.getText())) : (effectiveType == BnfTypes.BNF_REFERENCE_OR_TOKEN ? tree.getText() : null);
        } else {
            BnfRule asRule = (BnfRule)tree;
            result = asRule.getName();
            if (StringUtil.isEmpty((String)ParserGeneratorUtil.getElementType(asRule, this.G.generateElementCase))) {
                return null;
            }
        }
        return result;
    }

    public static class MethodInfo
    implements Comparable<MethodInfo> {
        final MethodType type;
        final String originalName;
        final String path;
        final BnfRule rule;
        final RuleGraphHelper.Cardinality cardinality;
        String name;

        private MethodInfo(MethodType type, String name, String path, BnfRule rule, RuleGraphHelper.Cardinality cardinality) {
            this.type = type;
            this.name = this.originalName = name;
            this.path = path;
            this.rule = rule;
            this.cardinality = cardinality;
        }

        @Override
        public int compareTo(@NotNull MethodInfo o) {
            if (this.type != o.type) {
                return this.type.compareTo(o.type);
            }
            return this.name.compareTo(o.name);
        }

        @NotNull
        public String generateGetterName() {
            boolean many = this.cardinality.many();
            boolean renamed = !Objects.equals(this.name, this.originalName);
            String getterNameBody = ParserGeneratorUtil.getGetterName(this.name);
            return getterNameBody + (many && !renamed ? "List" : "");
        }

        public String toString() {
            return "MethodInfo{type=" + this.type + ", name='" + this.name + "', path='" + this.path + "', rule=" + this.rule + ", cardinality=" + this.cardinality + "}";
        }
    }

    public static enum MethodType {
        RULE,
        TOKEN,
        USER,
        MIXIN;

    }
}

