/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElementVisitor;
import org.intellij.grammar.analysis.BnfFirstNextAnalyzer;
import org.intellij.grammar.generator.ExpressionGeneratorHelper;
import org.intellij.grammar.generator.ExpressionHelper;
import org.intellij.grammar.generator.ParserGeneratorUtil;
import org.intellij.grammar.psi.BnfFile;
import org.intellij.grammar.psi.BnfRule;
import org.intellij.grammar.psi.BnfVisitor;
import org.jetbrains.annotations.NotNull;

public class BnfLeftRecursionInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new BnfVisitor<Void>(){
            final BnfFirstNextAnalyzer analyzer = BnfFirstNextAnalyzer.createAnalyzer(false);

            @Override
            public Void visitRule(@NotNull BnfRule o) {
                boolean exprParsing;
                if (ParserGeneratorUtil.Rule.isFake(o)) {
                    return null;
                }
                BnfFile file = (BnfFile)o.getContainingFile();
                ExpressionHelper expressionHelper = ExpressionHelper.getCached(file);
                String ruleName = o.getName();
                boolean bl = exprParsing = ExpressionGeneratorHelper.getInfoForExpressionParsing(expressionHelper, o) != null;
                if (!exprParsing && BnfFirstNextAnalyzer.asStrings(this.analyzer.calcFirst(o)).contains(ruleName)) {
                    holder.registerProblem(o.getId(), "'" + ruleName + "' employs left-recursion unsupported by generator", new LocalQuickFix[0]);
                }
                return null;
            }
        };
    }
}

