/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.inspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import org.intellij.grammar.psi.BnfChoice;
import org.intellij.grammar.psi.BnfExpression;
import org.intellij.grammar.psi.BnfTypes;
import org.intellij.grammar.refactor.BnfExpressionOptimizer;
import org.jetbrains.annotations.NotNull;

public class BnfRemoveExpressionFix
implements LocalQuickFix {
    @NotNull
    public String getName() {
        return this.getFamilyName();
    }

    @NotNull
    public String getFamilyName() {
        return "Remove expression";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element = descriptor.getPsiElement();
        if (!element.isValid()) {
            return;
        }
        PsiElement parent = element.getParent();
        if (element instanceof BnfExpression && parent instanceof BnfChoice) {
            ASTNode node = element.getNode();
            ASTNode nextOr = TreeUtil.findSibling((ASTNode)node, (IElementType)BnfTypes.BNF_OP_OR);
            ASTNode prevOr = TreeUtil.findSiblingBackward((ASTNode)node, (IElementType)BnfTypes.BNF_OP_OR);
            assert (nextOr != null || prevOr != null) : "'|' missing in choice";
            if (nextOr != null && prevOr != null) {
                parent.deleteChildRange(prevOr.getTreeNext().getPsi(), nextOr.getPsi());
            } else {
                parent.deleteChildRange(prevOr == null ? element : prevOr.getPsi(), prevOr == null ? nextOr.getPsi() : element);
            }
        } else {
            element.delete();
        }
        BnfExpressionOptimizer.optimize(project, parent);
    }
}

