/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ThreeState;
import java.util.Objects;
import org.intellij.grammar.GrammarKitBundle;
import org.intellij.grammar.KnownAttribute;
import org.intellij.grammar.generator.ParserGeneratorUtil;
import org.intellij.grammar.psi.BnfAttr;
import org.intellij.grammar.psi.BnfAttrPattern;
import org.intellij.grammar.psi.BnfListEntry;
import org.intellij.grammar.psi.BnfReferenceOrToken;
import org.intellij.grammar.psi.BnfStringLiteralExpression;
import org.intellij.grammar.psi.BnfVisitor;
import org.intellij.grammar.psi.impl.BnfReferenceImpl;
import org.intellij.grammar.psi.impl.GrammarUtil;
import org.jetbrains.annotations.NotNull;

public class BnfResolveInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        return new BnfVisitor<Void>(){

            @Override
            public Void visitReferenceOrToken(@NotNull BnfReferenceOrToken o) {
                PsiElement parent = o.getParent();
                String text = o.getText();
                if (parent instanceof BnfAttr && "true".equals(text) || "false".equals(text)) {
                    return null;
                }
                if (parent instanceof BnfListEntry && ((BnfListEntry)parent).getId() == o) {
                    PsiElement resolve;
                    PsiReference reference = parent.findReferenceAt(o.getStartOffsetInParent());
                    PsiElement psiElement = resolve = reference == null ? null : reference.resolve();
                    if (resolve == null) {
                        holder.registerProblem((PsiElement)o, GrammarKitBundle.message("inspection.message.unresolved.method.reference", new Object[0]), new LocalQuickFix[0]);
                    }
                } else {
                    PsiElement resolve;
                    PsiReference reference = o.getReference();
                    PsiElement psiElement = resolve = reference == null ? null : reference.resolve();
                    if (resolve == null) {
                        if (parent instanceof BnfAttr) {
                            holder.registerProblem((PsiElement)o, GrammarKitBundle.message("inspection.message.unresolved.rule.reference", new Object[0]), new LocalQuickFix[0]);
                        } else if (GrammarUtil.isExternalReference(o)) {
                            holder.registerProblem((PsiElement)o, GrammarKitBundle.message("inspection.message.unresolved.rule.or.method.reference", new Object[0]), new LocalQuickFix[0]);
                        }
                    }
                }
                return null;
            }

            @Override
            public Void visitStringLiteralExpression(@NotNull BnfStringLiteralExpression o) {
                PsiElement parent = o.getParent();
                if (parent instanceof BnfAttrPattern) {
                    PsiReference reference = o.getReference();
                    if (reference instanceof PsiPolyVariantReference && ((PsiPolyVariantReference)reference).multiResolve(false).length == 0) {
                        holder.registerProblem((PsiElement)o, GrammarKitBundle.message("inspection.message.pattern.does.not.match.any.rule", new Object[0]), new LocalQuickFix[0]);
                    }
                } else if (parent instanceof BnfAttr || parent instanceof BnfListEntry) {
                    boolean checkReferences;
                    String attrName = Objects.requireNonNull((BnfAttr)PsiTreeUtil.getParentOfType((PsiElement)o, BnfAttr.class)).getName();
                    KnownAttribute<?> attribute = KnownAttribute.getCompatibleAttribute(attrName);
                    String value = StringUtil.unquoteString((String)o.getText());
                    boolean bl = checkReferences = attribute != null && attribute != KnownAttribute.NAME && !attribute.getName().endsWith("Factory") && (attribute != KnownAttribute.RECOVER_WHILE || !"#auto".equals(value) && (!GrammarUtil.isDoubleAngles(value) || !ParserGeneratorUtil.Rule.isMeta(ParserGeneratorUtil.Rule.of(o))));
                    if (checkReferences) {
                        TextRange valueRange = ElementManipulators.getValueTextRange((PsiElement)o);
                        ThreeState reportAtEnd = ThreeState.UNSURE;
                        PsiReference refAtEnd = null;
                        for (PsiReference reference : o.getReferences()) {
                            if (reference.isSoft()) continue;
                            boolean atEnd = valueRange.getEndOffset() == reference.getRangeInElement().getEndOffset();
                            PsiElement resolve = reference.resolve();
                            if (resolve != null) {
                                reportAtEnd = ThreeState.NO;
                                continue;
                            }
                            if (!atEnd) {
                                if (reference.getRangeInElement().getLength() == 1 && "?".equals(reference.getCanonicalText()) && !(reference instanceof BnfReferenceImpl)) continue;
                                reportAtEnd = ThreeState.NO;
                                holder.registerProblem(reference, ProblemsHolder.unresolvedReferenceMessage((PsiReference)reference), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                                continue;
                            }
                            if (reportAtEnd != ThreeState.NO) {
                                reportAtEnd = ThreeState.YES;
                            }
                            if (refAtEnd != null && refAtEnd.getRangeInElement().getLength() <= reference.getRangeInElement().getLength()) continue;
                            refAtEnd = reference;
                        }
                        if (reportAtEnd == ThreeState.YES) {
                            holder.registerProblem(refAtEnd, ProblemsHolder.unresolvedReferenceMessage(refAtEnd), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                        }
                    }
                }
                return null;
            }
        };
    }
}

