/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.intellij.grammar.analysis.BnfFirstNextAnalyzer;
import org.intellij.grammar.psi.BnfChoice;
import org.intellij.grammar.psi.BnfExpression;
import org.intellij.grammar.psi.BnfTypes;
import org.intellij.grammar.psi.BnfVisitor;
import org.jetbrains.annotations.NotNull;

public class BnfUnreachableChoiceBranchInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new BnfVisitor<Void>(){

            @Override
            public Void visitChoice(@NotNull BnfChoice o) {
                BnfUnreachableChoiceBranchInspection.checkChoice(o, holder);
                return null;
            }
        };
    }

    private static void checkChoice(BnfChoice choice, ProblemsHolder problemsHolder) {
        HashSet<BnfExpression> visited = new HashSet<BnfExpression>();
        HashSet<BnfExpression> first = new HashSet<BnfExpression>();
        BnfFirstNextAnalyzer analyzer = BnfFirstNextAnalyzer.createAnalyzer(true);
        List<BnfExpression> list = choice.getExpressionList();
        int listSize = list.size() - 1;
        for (int i = 0; i < listSize; ++i) {
            BnfExpression child = list.get(i);
            Set<BnfExpression> firstSet = analyzer.calcFirstInner(child, first, visited);
            if (firstSet.contains(BnfFirstNextAnalyzer.BNF_MATCHES_NOTHING)) {
                BnfUnreachableChoiceBranchInspection.registerProblem(choice, child, "Branch is unable to match anything due to & or ! conditions", problemsHolder, new LocalQuickFix[0]);
            } else if (firstSet.contains(BnfFirstNextAnalyzer.BNF_MATCHES_EOF)) {
                BnfUnreachableChoiceBranchInspection.registerProblem(choice, child, "Branch matches empty input making the rest branches unreachable", problemsHolder, new LocalQuickFix[0]);
                break;
            }
            first.clear();
            visited.clear();
        }
    }

    static void registerProblem(BnfExpression choice, BnfExpression branch, String message, ProblemsHolder problemsHolder, LocalQuickFix ... fixes) {
        TextRange textRange = branch.getTextRange();
        if (textRange.isEmpty()) {
            ASTNode nextOr = TreeUtil.findSibling((ASTNode)branch.getNode(), (IElementType)BnfTypes.BNF_OP_OR);
            ASTNode prevOr = TreeUtil.findSiblingBackward((ASTNode)branch.getNode(), (IElementType)BnfTypes.BNF_OP_OR);
            int shift = choice.getTextRange().getStartOffset();
            int startOffset = prevOr != null ? prevOr.getStartOffset() - shift : 0;
            TextRange range = new TextRange(startOffset, nextOr != null ? nextOr.getStartOffset() + 1 - shift : Math.min(startOffset + 2, choice.getTextLength()));
            problemsHolder.registerProblem((PsiElement)choice, range, message, fixes);
        } else {
            problemsHolder.registerProblem((PsiElement)branch, message, fixes);
        }
    }
}

