/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElementVisitor;
import org.intellij.grammar.KnownAttribute;
import org.intellij.grammar.psi.BnfAttr;
import org.intellij.grammar.psi.BnfVisitor;
import org.jetbrains.annotations.NotNull;

public class BnfUnusedAttributeInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        return new BnfVisitor<Void>(){

            @Override
            public Void visitAttr(@NotNull BnfAttr o) {
                String name = o.getName();
                if (!name.toUpperCase().equals(name) && KnownAttribute.getAttribute(name) == null) {
                    KnownAttribute<?> newAttr = KnownAttribute.getCompatibleAttribute(name);
                    String text = newAttr == null ? "Unused attribute" : "Deprecated attribute, use '" + newAttr.getName() + "' instead";
                    holder.registerProblem(o.getId(), text, new LocalQuickFix[0]);
                }
                return null;
            }
        };
    }
}

