/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.inspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.intellij.grammar.psi.BnfRule;
import org.intellij.grammar.refactor.BnfIntroduceRuleHandler;
import org.jetbrains.annotations.NotNull;

public class CreateRuleFromTokenFix
implements LocalQuickFix {
    private final String myName;

    public CreateRuleFromTokenFix(String name) {
        this.myName = name;
    }

    @NotNull
    public String getName() {
        return "Create '" + this.myName + "' rule";
    }

    @NotNull
    public String getFamilyName() {
        return "Create rule from usage";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        FileEditor selectedEditor;
        PsiElement element = descriptor.getPsiElement();
        BnfRule rule = (BnfRule)PsiTreeUtil.getParentOfType((PsiElement)element, BnfRule.class);
        if (rule == null) {
            return;
        }
        BnfRule addedRule = BnfIntroduceRuleHandler.addNextRule(project, rule, "private " + this.myName + " ::= ");
        VirtualFile virtualFile = rule.getContainingFile().getVirtualFile();
        FileEditor fileEditor = selectedEditor = virtualFile == null ? null : FileEditorManager.getInstance((Project)project).getSelectedEditor(virtualFile);
        if (selectedEditor instanceof TextEditor) {
            Editor editor = ((TextEditor)selectedEditor).getEditor();
            editor.getCaretModel().moveToOffset(addedRule.getTextRange().getEndOffset() - (BnfIntroduceRuleHandler.endsWithSemicolon(addedRule) ? 1 : 0));
            editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        }
    }
}

