/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.intention;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.intellij.grammar.GrammarKitBundle;
import org.intellij.grammar.psi.BnfChoice;
import org.intellij.grammar.psi.BnfExpression;
import org.intellij.grammar.psi.impl.BnfElementFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BnfFlipChoiceIntention
implements IntentionAction {
    @NotNull
    public String getText() {
        return GrammarKitBundle.message("intention.flip.arguments.text", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return GrammarKitBundle.message("intention.flip.arguments.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return BnfFlipChoiceIntention.getArguments(file, editor.getCaretModel().getOffset()) != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        Pair<PsiElement, PsiElement> arguments = BnfFlipChoiceIntention.getArguments(file, editor.getCaretModel().getOffset());
        if (arguments == null) {
            return;
        }
        BnfExpression newFirst = BnfElementFactory.createRuleFromText(project, "a ::=" + ((PsiElement)arguments.second).getText()).getExpression();
        BnfExpression newSecond = BnfElementFactory.createRuleFromText(project, "a ::=" + ((PsiElement)arguments.first).getText()).getExpression();
        ((PsiElement)arguments.second).replace((PsiElement)newSecond);
        ((PsiElement)arguments.first).replace((PsiElement)newFirst);
    }

    @Nullable
    private static Pair<PsiElement, PsiElement> getArguments(PsiFile file, int offset) {
        PsiElement element = file.getViewProvider().findElementAt(offset);
        BnfChoice choice = (BnfChoice)PsiTreeUtil.getParentOfType((PsiElement)element, BnfChoice.class);
        if (choice == null) {
            return null;
        }
        PsiElement prev = null;
        for (PsiElement cur = choice.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!(cur instanceof BnfExpression)) continue;
            int start = prev == null ? choice.getTextRange().getStartOffset() : prev.getTextRange().getEndOffset();
            int end = cur.getTextRange().getStartOffset();
            if (start <= offset && offset <= end) {
                return prev == null ? null : Pair.create((Object)cur, (Object)prev);
            }
            prev = cur;
        }
        return null;
    }

    public boolean startInWriteAction() {
        return true;
    }
}

