/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.java;

import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.intellij.grammar.KnownAttribute;
import org.intellij.grammar.generator.NameShortener;
import org.intellij.grammar.generator.ParserGeneratorUtil;
import org.intellij.grammar.psi.BnfAttr;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.TypePath;
import org.jetbrains.org.objectweb.asm.TypeReference;
import org.jetbrains.org.objectweb.asm.signature.SignatureReader;
import org.jetbrains.org.objectweb.asm.signature.SignatureVisitor;

public abstract class JavaHelper {
    public static JavaHelper getJavaHelper(@NotNull PsiElement context) {
        JavaHelper service = (JavaHelper)context.getProject().getService(JavaHelper.class);
        return service == null ? new AsmHelper() : service;
    }

    public abstract boolean isPublic(@Nullable NavigatablePsiElement var1);

    @Nullable
    public NavigatablePsiElement findClass(@Nullable String className) {
        return null;
    }

    @NotNull
    public List<NavigatablePsiElement> findClassMethods(@Nullable String className, @NotNull MethodType methodType, @Nullable String methodName, int paramCount, String ... paramTypes) {
        return Collections.emptyList();
    }

    @Nullable
    public String getSuperClassName(@Nullable String className) {
        return null;
    }

    @NotNull
    public List<String> getMethodTypes(@Nullable NavigatablePsiElement method) {
        return Collections.emptyList();
    }

    public List<TypeParameterInfo> getGenericParameters(NavigatablePsiElement method) {
        return Collections.emptyList();
    }

    public List<String> getExceptionList(NavigatablePsiElement method) {
        return Collections.emptyList();
    }

    @NotNull
    public String getDeclaringClass(@Nullable NavigatablePsiElement method) {
        return "";
    }

    @NotNull
    public List<String> getAnnotations(@Nullable NavigatablePsiElement element) {
        return Collections.emptyList();
    }

    @NotNull
    public List<String> getParameterAnnotations(@Nullable NavigatablePsiElement method, int paramIndex) {
        return Collections.emptyList();
    }

    public PsiReference @NotNull [] getClassReferences(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        return PsiReference.EMPTY_ARRAY;
    }

    @Nullable
    public NavigationItem findPackage(@Nullable String packageName) {
        return null;
    }

    private static boolean acceptsName(@Nullable String expected, @Nullable String actual) {
        return "*".equals(expected) || expected != null && expected.equals(actual);
    }

    private static boolean acceptsModifiers(int modifiers, MethodType methodType) {
        return !Modifier.isAbstract(modifiers) && (methodType != MethodType.CONSTRUCTOR || !Modifier.isPrivate(modifiers));
    }

    public static class AsmHelper
    extends JavaHelper {
        private static final int ASM_OPCODES = 589824;

        @Override
        public boolean isPublic(@Nullable NavigatablePsiElement element) {
            Object delegate;
            Object v0 = delegate = element instanceof MyElement ? ((MyElement)element).delegate : null;
            int access = delegate instanceof ClassInfo ? ((ClassInfo)delegate).modifiers : (delegate instanceof MethodInfo ? ((MethodInfo)delegate).modifiers : 0);
            return Modifier.isPublic(access);
        }

        @Override
        @Nullable
        public NavigatablePsiElement findClass(String className) {
            ClassInfo info = AsmHelper.findClassSafe(className);
            return info == null ? null : new MyElement<ClassInfo>(info);
        }

        @Override
        @NotNull
        public List<NavigatablePsiElement> findClassMethods(@Nullable String className, @NotNull MethodType methodType, @Nullable String methodName, int paramCount, String ... paramTypes) {
            ClassInfo aClass = AsmHelper.findClassSafe(className);
            if (aClass == null || methodName == null) {
                return Collections.emptyList();
            }
            ArrayList<NavigatablePsiElement> result = new ArrayList<NavigatablePsiElement>();
            for (MethodInfo method : aClass.methods) {
                if (!JavaHelper.acceptsName(methodName, method.name) || !AsmHelper.acceptsMethod(method, methodType) || !AsmHelper.acceptsMethod(method, paramCount, paramTypes)) continue;
                result.add(new MyElement<MethodInfo>(method));
            }
            return result;
        }

        @Override
        @Nullable
        public String getSuperClassName(@Nullable String className) {
            ClassInfo aClass = AsmHelper.findClassSafe(className);
            return aClass == null ? null : aClass.superClass;
        }

        private static boolean acceptsMethod(MethodInfo method, int paramCount, String ... paramTypes) {
            if (paramCount >= 0 && paramCount != (method.types.size() - 1) / 2) {
                return false;
            }
            if (paramTypes.length == 0) {
                return true;
            }
            if (paramTypes.length > (method.types.size() - 1) / 2) {
                return false;
            }
            for (int i = 0; i < paramTypes.length; ++i) {
                ClassInfo info;
                String paramType = paramTypes[i];
                String parameter = method.types.get(2 * i + 1);
                if (JavaHelper.acceptsName(paramType, NameShortener.getRawClassName(parameter)) || (info = AsmHelper.findClassSafe(paramType)) != null && (Objects.equals(info.superClass, parameter) || info.interfaces.contains(parameter))) continue;
                return false;
            }
            return true;
        }

        private static boolean acceptsMethod(MethodInfo method, MethodType methodType) {
            return method.methodType == methodType && JavaHelper.acceptsModifiers(method.modifiers, methodType);
        }

        @Override
        @NotNull
        public List<String> getMethodTypes(NavigatablePsiElement method) {
            Object delegate;
            Object v0 = delegate = method == null ? null : ((MyElement)method).delegate;
            if (!(delegate instanceof MethodInfo)) {
                return Collections.emptyList();
            }
            return ((MethodInfo)delegate).annotatedTypes;
        }

        @Override
        public List<TypeParameterInfo> getGenericParameters(NavigatablePsiElement method) {
            Object delegate;
            Object v0 = delegate = method == null ? null : ((MyElement)method).delegate;
            if (!(delegate instanceof MethodInfo)) {
                return Collections.emptyList();
            }
            return ((MethodInfo)delegate).generics;
        }

        @Override
        public List<String> getExceptionList(NavigatablePsiElement method) {
            Object delegate;
            Object v0 = delegate = method == null ? null : ((MyElement)method).delegate;
            if (!(delegate instanceof MethodInfo)) {
                return Collections.emptyList();
            }
            return ((MethodInfo)delegate).exceptions;
        }

        @Override
        @NotNull
        public String getDeclaringClass(@Nullable NavigatablePsiElement method) {
            Object delegate;
            Object v0 = delegate = method == null ? null : ((MyElement)method).delegate;
            if (!(delegate instanceof MethodInfo)) {
                return "";
            }
            return ((MethodInfo)delegate).declaringClass;
        }

        @Override
        @NotNull
        public List<String> getAnnotations(NavigatablePsiElement element) {
            Object delegate;
            Object v0 = delegate = element == null ? null : ((MyElement)element).delegate;
            if (delegate instanceof ClassInfo) {
                return ((ClassInfo)delegate).annotations;
            }
            if (delegate instanceof MethodInfo) {
                return ((MethodInfo)delegate).annotations.get(0);
            }
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public List<String> getParameterAnnotations(@Nullable NavigatablePsiElement method, int paramIndex) {
            Object delegate;
            Object v0 = delegate = method == null ? null : ((MyElement)method).delegate;
            if (!(delegate instanceof MethodInfo)) {
                return Collections.emptyList();
            }
            Map<Integer, List<String>> annotations = ((MethodInfo)delegate).annotations;
            if (paramIndex < 0 || paramIndex >= annotations.size()) {
                return Collections.emptyList();
            }
            List<String> result = annotations.get(paramIndex);
            return result == null ? Collections.emptyList() : result;
        }

        private static ClassInfo findClassSafe(String className) {
            if (className == null) {
                return null;
            }
            try {
                InputStream is;
                int lastDot = className.length();
                do {
                    String s = className.substring(0, lastDot).replace('.', '/') + className.substring(lastDot).replace('.', '$') + ".class";
                    is = JavaHelper.class.getClassLoader().getResourceAsStream(s);
                    lastDot = className.lastIndexOf(46, lastDot - 1);
                } while (is == null && lastDot > 0);
                if (is == null) {
                    return null;
                }
                byte[] bytes = FileUtil.loadBytes((InputStream)is);
                is.close();
                return AsmHelper.getClassInfo(className, bytes);
            }
            catch (Exception e) {
                AsmHelper.reportException(e, className, null);
                return null;
            }
        }

        private static ClassInfo getClassInfo(String className, byte[] bytes) {
            ClassInfo info = new ClassInfo();
            info.name = className;
            new ClassReader(bytes).accept((ClassVisitor)new MyClassVisitor(info), 0);
            return info;
        }

        private static MethodInfo getMethodInfo(String className, String methodName, String signature, String[] exceptions) {
            MethodInfo methodInfo = new MethodInfo();
            methodInfo.name = methodName;
            methodInfo.declaringClass = className;
            try {
                MySignatureVisitor visitor = new MySignatureVisitor(methodInfo);
                new SignatureReader(signature).accept((SignatureVisitor)visitor);
                visitor.finishElement(null);
                if (exceptions != null) {
                    for (String exception : exceptions) {
                        String fqn = AsmHelper.fixClassName(exception);
                        methodInfo.exceptions.add(fqn);
                    }
                }
            }
            catch (Exception e) {
                AsmHelper.reportException(e, className + "#" + methodName + "()", signature);
            }
            return methodInfo;
        }

        private static void reportException(Exception e, String target, String signature) {
            AsmHelper.reportException(e.getClass().getSimpleName() + " while reading " + target + (String)(signature == null ? "" : " signature " + signature));
        }

        private static void reportException(String text) {
            System.err.println(text);
        }

        private static String fixClassName(String s) {
            return s == null ? null : s.replace('/', '.').replace('$', '.');
        }

        private static class MyClassVisitor
        extends ClassVisitor {
            private final ClassInfo myInfo;

            MyClassVisitor(ClassInfo info) {
                super(589824);
                this.myInfo = info;
            }

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                this.myInfo.modifiers = access;
                this.myInfo.superClass = AsmHelper.fixClassName(superName);
                for (String s : interfaces) {
                    this.myInfo.interfaces.add(AsmHelper.fixClassName(s));
                }
                if (signature != null) {
                    new SignatureReader(signature).accept(new SignatureVisitor(589824){

                        public void visitFormalTypeParameter(String name) {
                            myInfo.typeParameters.add(name);
                        }
                    });
                }
            }

            public void visitEnd() {
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                final MethodInfo m = AsmHelper.getMethodInfo(this.myInfo.name, name, (String)ObjectUtils.chooseNotNull((Object)signature, (Object)desc), exceptions);
                m.modifiers = access;
                m.methodType = "<init>".equals(name) ? MethodType.CONSTRUCTOR : (Modifier.isStatic(access) ? MethodType.STATIC : MethodType.INSTANCE);
                this.myInfo.methods.add(m);
                SmartList typeAnnos = new SmartList();
                return new MethodVisitor(589824, (List)typeAnnos){
                    final /* synthetic */ List val$typeAnnos;
                    {
                        this.val$typeAnnos = list;
                        super(arg0);
                    }

                    public void visitEnd() {
                        m.annotatedTypes.addAll(m.types);
                        int[] plainOffsets = new int[m.types.size()];
                        class ParamTypeAnno {
                            int index;
                            String anno;
                            TypePath path;

                            ParamTypeAnno() {
                            }
                        }
                        for (ParamTypeAnno ta : this.val$typeAnnos) {
                            String newType;
                            int idx = ta.index == 0 ? 0 : 2 * (ta.index - 1) + 1;
                            String prevType = m.annotatedTypes.get(idx);
                            boolean isArray = false;
                            if (ta.path != null) {
                                isArray = true;
                                int typePtr = prevType.length();
                                int i = 0;
                                while (i < ta.path.getLength()) {
                                    if (ta.path.getStep(i) != 0 || typePtr <= 2 || prevType.charAt(typePtr - 2) != '[' || prevType.charAt(typePtr - 1) != ']') {
                                        isArray = false;
                                        break;
                                    }
                                    ++i;
                                    typePtr -= 2;
                                }
                                if (isArray && typePtr > 2 && prevType.charAt(typePtr - 1) == ']') {
                                    isArray = false;
                                }
                            }
                            if (ta.path != null && !isArray) continue;
                            int bracketIdx = prevType.indexOf(91);
                            if (!isArray && bracketIdx > 0) {
                                boolean addSpace = prevType.charAt(bracketIdx - 1) != ' ';
                                newType = prevType.substring(0, bracketIdx) + (addSpace ? " " : "") + "@" + ta.anno + " " + prevType.substring(bracketIdx);
                            } else {
                                int offset = plainOffsets[idx];
                                newType = prevType.substring(0, offset) + "@" + ta.anno + " " + prevType.substring(offset);
                                int n = idx;
                                plainOffsets[n] = plainOffsets[n] + (2 + ta.anno.length());
                            }
                            m.annotatedTypes.set(idx, newType);
                            if (!isArray && bracketIdx >= 1) continue;
                            m.annotations.get(ta.index).remove(ta.anno);
                        }
                    }

                    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                        final String anno = AsmHelper.fixClassName(desc.substring(1, desc.length() - 1));
                        return new MyAnnotationVisitor(){

                            public void visitEnd() {
                                if (this.annoParamCounter != 0) {
                                    return;
                                }
                                m.annotations.get(0).add(anno);
                            }
                        };
                    }

                    public AnnotationVisitor visitParameterAnnotation(final int parameter, String desc, boolean visible) {
                        final String anno = AsmHelper.fixClassName(desc.substring(1, desc.length() - 1));
                        return new MyAnnotationVisitor(){

                            public void visitEnd() {
                                if (this.annoParamCounter != 0) {
                                    return;
                                }
                                m.annotations.get(parameter + 1).add(anno);
                            }
                        };
                    }

                    public AnnotationVisitor visitTypeAnnotation(int typeRef, final TypePath typePath, String desc, boolean visible) {
                        final String anno = AsmHelper.fixClassName(desc.substring(1, desc.length() - 1));
                        final TypeReference typeReference = new TypeReference(typeRef);
                        return new MyAnnotationVisitor(){

                            public void visitEnd() {
                                if (this.annoParamCounter != 0) {
                                    return;
                                }
                                if (typeReference.getSort() == 1) {
                                    m.generics.get(typeReference.getTypeParameterIndex()).getAnnotations().add(anno);
                                } else if (typeReference.getSort() == 20 || typeReference.getSort() == 22) {
                                    ParamTypeAnno o = new ParamTypeAnno();
                                    o.index = typeReference.getSort() == 20 ? 0 : typeReference.getFormalParameterIndex() + 1;
                                    o.anno = anno;
                                    o.path = typePath;
                                    val$typeAnnos.add(o);
                                } else if (typeReference.getSort() == 18) {
                                    List<String> bounds = m.generics.get((int)typeReference.getTypeParameterIndex()).extendsList;
                                    if (typeReference.getTypeParameterBoundIndex() <= bounds.size()) {
                                        String prev = bounds.get(typeReference.getTypeParameterBoundIndex() - 1);
                                        bounds.set(typeReference.getTypeParameterBoundIndex() - 1, "@" + anno + " " + prev);
                                    }
                                }
                            }
                        };
                    }
                };
            }

            static class MyAnnotationVisitor
            extends AnnotationVisitor {
                int annoParamCounter;

                MyAnnotationVisitor() {
                    super(589824);
                }

                public void visit(String s, Object o) {
                    ++this.annoParamCounter;
                }

                public void visitEnum(String s, String s2, String s3) {
                    ++this.annoParamCounter;
                }

                public AnnotationVisitor visitAnnotation(String s, String s2) {
                    ++this.annoParamCounter;
                    return null;
                }

                public AnnotationVisitor visitArray(String s) {
                    ++this.annoParamCounter;
                    return null;
                }
            }
        }

        private static class MySignatureVisitor
        extends SignatureVisitor {
            final MethodInfo methodInfo;
            final Deque<State> states = new ArrayDeque<State>();
            final StringBuilder sb = new StringBuilder();

            MySignatureVisitor(MethodInfo methodInfo) {
                super(589824);
                this.methodInfo = methodInfo;
            }

            public void visitFormalTypeParameter(String s) {
                this.finishElement(null);
                this.methodInfo.generics.add(new TypeParameterInfo(s));
            }

            public SignatureVisitor visitInterfaceBound() {
                this.finishElement(null);
                this.states.push(State.BOUNDS);
                return this;
            }

            public SignatureVisitor visitClassBound() {
                this.finishElement(null);
                this.states.push(State.BOUNDS);
                return this;
            }

            public SignatureVisitor visitSuperclass() {
                this.finishElement(null);
                this.states.push(State.BOUNDS);
                return this;
            }

            public SignatureVisitor visitInterface() {
                this.finishElement(null);
                this.states.push(State.BOUNDS);
                return this;
            }

            public SignatureVisitor visitParameterType() {
                this.finishElement(null);
                this.states.push(State.PARAM);
                return this;
            }

            public SignatureVisitor visitReturnType() {
                this.finishElement(null);
                this.states.push(State.RETURN);
                return this;
            }

            public SignatureVisitor visitExceptionType() {
                this.finishElement(null);
                this.states.push(State.EXCEPTION);
                return this;
            }

            public void visitBaseType(char c) {
                this.sb.append(org.jetbrains.org.objectweb.asm.Type.getType((String)String.valueOf(c)).getClassName());
            }

            public void visitTypeVariable(String s) {
                this.sb.append("<").append(s).append(">");
            }

            public SignatureVisitor visitArrayType() {
                this.states.push(State.ARRAY);
                return this;
            }

            public void visitClassType(String s) {
                this.states.push(State.CLASS);
                this.sb.append(AsmHelper.fixClassName(s));
            }

            public void visitInnerClassType(String s) {
            }

            public void visitTypeArgument() {
                if (this.states.peekFirst() != State.GENERIC) {
                    this.states.push(State.GENERIC);
                    this.sb.append("<");
                } else {
                    this.sb.append(", ");
                }
                this.sb.append("?");
            }

            public SignatureVisitor visitTypeArgument(char c) {
                if (this.states.peekFirst() != State.GENERIC) {
                    this.states.push(State.GENERIC);
                    this.sb.append("<");
                } else {
                    this.sb.append(", ");
                }
                if (c == '+') {
                    this.sb.append("? extends ");
                } else if (c == '-') {
                    this.sb.append("? super ");
                }
                return this;
            }

            public void visitEnd() {
                this.finishElement(State.CLASS);
                this.states.pop();
            }

            /*
             * Enabled aggressive block sorting
             */
            private void finishElement(State finishState) {
                if (this.sb.length() == 0) {
                    return;
                }
                while (!this.states.isEmpty()) {
                    if (finishState == this.states.peekFirst()) {
                        return;
                    }
                    State state = this.states.pop();
                    switch (state) {
                        case PARAM: {
                            this.methodInfo.types.add(this.sb());
                            this.methodInfo.types.add("p" + this.methodInfo.types.size() / 2);
                            return;
                        }
                        case RETURN: {
                            this.methodInfo.types.add(0, this.sb());
                            return;
                        }
                        case ARRAY: {
                            this.sb.append("[]");
                            break;
                        }
                        case GENERIC: {
                            this.sb.append(">");
                            break;
                        }
                        case BOUNDS: {
                            String bound = this.sb();
                            if ("java.lang.Object".equals(bound)) break;
                            TypeParameterInfo currentGeneric = (TypeParameterInfo)ContainerUtil.getLastItem(this.methodInfo.generics);
                            if (currentGeneric != null) {
                                currentGeneric.extendsList.add(bound);
                                break;
                            }
                            AsmHelper.reportException("current generic must not be null");
                            break;
                        }
                        case EXCEPTION: {
                            this.methodInfo.exceptions.add(this.sb());
                        }
                    }
                }
            }

            @NotNull
            private String sb() {
                String s = this.sb.toString();
                this.sb.setLength(0);
                return s;
            }

            static enum State {
                PARAM,
                RETURN,
                CLASS,
                ARRAY,
                GENERIC,
                BOUNDS,
                EXCEPTION;

            }
        }
    }

    public static enum MethodType {
        STATIC,
        INSTANCE,
        CONSTRUCTOR;

    }

    public static class TypeParameterInfo {
        private final String name;
        private final List<String> extendsList;
        private final List<String> annotations;

        public TypeParameterInfo(@Nullable String name, @NotNull List<String> extendsList, @NotNull List<String> annotations) {
            this.name = name;
            this.extendsList = extendsList;
            this.annotations = annotations;
        }

        public TypeParameterInfo(@NotNull String name) {
            this(name, (List<String>)new SmartList(), (List<String>)new SmartList());
        }

        public String getName() {
            return this.name;
        }

        public List<String> getExtendsList() {
            return this.extendsList;
        }

        public List<String> getAnnotations() {
            return this.annotations;
        }
    }

    private static class MethodInfo {
        MethodType methodType;
        String name;
        String declaringClass;
        int modifiers;
        final List<String> types = new SmartList();
        final List<String> annotatedTypes = new SmartList();
        final Map<Integer, List<String>> annotations = FactoryMap.create(o -> new SmartList());
        final List<TypeParameterInfo> generics = new SmartList();
        final List<String> exceptions = new SmartList();

        private MethodInfo() {
        }

        public String toString() {
            return "MethodInfo{" + this.name + this.types + ", @" + this.annotations.get(0) + "<" + this.generics + "> throws " + this.exceptions + "}";
        }
    }

    private static class ClassInfo {
        String name;
        String superClass;
        int modifiers;
        final List<String> typeParameters = new SmartList();
        final List<String> interfaces = new SmartList();
        final List<String> annotations = new SmartList();
        final List<MethodInfo> methods = new SmartList();

        private ClassInfo() {
        }
    }

    private static class MyElement<T>
    extends FakePsiElement
    implements NavigatablePsiElement {
        final T delegate;

        MyElement(T delegate) {
            this.delegate = delegate;
        }

        public PsiElement getParent() {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            MyElement element = (MyElement)((Object)o);
            return this.delegate.equals(element.delegate);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    public static class ReflectionHelper
    extends JavaHelper {
        @Override
        public boolean isPublic(@Nullable NavigatablePsiElement element) {
            Object delegate;
            Object v0 = delegate = element instanceof MyElement ? ((MyElement)element).delegate : null;
            int modifiers = delegate instanceof Class ? ((Class)delegate).getModifiers() : (delegate instanceof Method ? ((Method)delegate).getModifiers() : 0);
            return Modifier.isPublic(modifiers);
        }

        @Override
        @Nullable
        public NavigatablePsiElement findClass(String className) {
            Class<?> aClass = ReflectionHelper.findClassSafe(className);
            return aClass == null ? null : new MyElement(aClass);
        }

        @Nullable
        private static Class<?> findClassSafe(String className) {
            if (className == null) {
                return null;
            }
            try {
                return Class.forName(className);
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        @NotNull
        public List<NavigatablePsiElement> findClassMethods(@Nullable String className, @NotNull MethodType methodType, @Nullable String methodName, int paramCount, String ... paramTypes) {
            Executable[] methods;
            Class<?> aClass = ReflectionHelper.findClassSafe(className);
            if (aClass == null || methodName == null) {
                return Collections.emptyList();
            }
            ArrayList<NavigatablePsiElement> result = new ArrayList<NavigatablePsiElement>();
            for (Executable method : methods = methodType == MethodType.CONSTRUCTOR ? aClass.getDeclaredConstructors() : aClass.getDeclaredMethods()) {
                if (!JavaHelper.acceptsName(methodName, method.getName()) || !ReflectionHelper.acceptsMethod(method, methodType) || !ReflectionHelper.acceptsMethod(method, paramCount, paramTypes)) continue;
                result.add(new MyElement<Executable>(method));
            }
            return result;
        }

        @Override
        @Nullable
        public String getSuperClassName(@Nullable String className) {
            Class<?> aClass = ReflectionHelper.findClassSafe(className);
            Class<?> superClass = aClass == null ? null : aClass.getSuperclass();
            return superClass != null && superClass != Object.class ? superClass.getName() : null;
        }

        private static boolean acceptsMethod(Member method, int paramCount, String ... paramTypes) {
            Class<?>[] parameterTypes;
            Class<Object>[] classArray = method instanceof Method ? ((Method)method).getParameterTypes() : (parameterTypes = method instanceof Constructor ? ((Constructor)method).getParameterTypes() : ArrayUtil.EMPTY_CLASS_ARRAY);
            if (paramCount >= 0 && paramCount != parameterTypes.length) {
                return false;
            }
            if (paramTypes.length == 0) {
                return true;
            }
            if (paramTypes.length > parameterTypes.length) {
                return false;
            }
            for (int i = 0; i < paramTypes.length; ++i) {
                Class<?> paramClass;
                String paramType = paramTypes[i];
                Class<?> parameter = parameterTypes[i];
                if (JavaHelper.acceptsName(paramType, parameter.getCanonicalName()) || (paramClass = ReflectionHelper.findClassSafe(paramType)) != null && parameter.isAssignableFrom(paramClass)) continue;
                return false;
            }
            return true;
        }

        private static boolean acceptsMethod(Member method, MethodType methodType) {
            int modifiers = method.getModifiers();
            return methodType == MethodType.STATIC == Modifier.isStatic(modifiers) && JavaHelper.acceptsModifiers(modifiers, methodType);
        }

        @Override
        @NotNull
        public List<String> getMethodTypes(NavigatablePsiElement method) {
            if (method == null) {
                return Collections.emptyList();
            }
            Method delegate = (Method)((MyElement)method).delegate;
            Type[] parameterTypes = delegate.getGenericParameterTypes();
            ArrayList<String> result = new ArrayList<String>(parameterTypes.length + 1);
            result.add(delegate.getGenericReturnType().toString());
            int paramCounter = 0;
            for (Type parameterType : parameterTypes) {
                result.add(parameterType.toString());
                result.add("p" + paramCounter++);
            }
            return result;
        }

        @Override
        public List<TypeParameterInfo> getGenericParameters(NavigatablePsiElement method) {
            if (method == null) {
                return Collections.emptyList();
            }
            Method delegate = (Method)((MyElement)method).delegate;
            Object[] typeParameters = delegate.getTypeParameters();
            return ContainerUtil.map((Object[])typeParameters, param -> new TypeParameterInfo(param.getName(), ContainerUtil.mapNotNull((Object[])param.getBounds(), type -> {
                String typeName = type.getTypeName();
                return "java.lang.Object".equals(typeName) ? null : typeName;
            }), ContainerUtil.mapNotNull((Object[])param.getAnnotations(), o -> o.annotationType().getCanonicalName())));
        }

        @Override
        public List<String> getExceptionList(NavigatablePsiElement method) {
            if (method == null) {
                return Collections.emptyList();
            }
            Method delegate = (Method)((MyElement)method).delegate;
            Object[] exceptionTypes = delegate.getExceptionTypes();
            return ContainerUtil.map((Object[])exceptionTypes, Class::getName);
        }

        @Override
        @NotNull
        public String getDeclaringClass(@Nullable NavigatablePsiElement method) {
            if (method == null) {
                return "";
            }
            return ((Method)((MyElement)method).delegate).getDeclaringClass().getName();
        }

        @Override
        @NotNull
        public List<String> getAnnotations(NavigatablePsiElement element) {
            if (element == null) {
                return Collections.emptyList();
            }
            AnnotatedElement delegate = (AnnotatedElement)((MyElement)element).delegate;
            return ReflectionHelper.getAnnotationsInner(delegate);
        }

        @Override
        @NotNull
        public List<String> getParameterAnnotations(@Nullable NavigatablePsiElement method, int paramIndex) {
            if (method == null) {
                return Collections.emptyList();
            }
            Method delegate = (Method)((MyElement)method).delegate;
            AnnotatedType[] parameterTypes = delegate.getAnnotatedParameterTypes();
            if (paramIndex < 0 || paramIndex >= parameterTypes.length) {
                return Collections.emptyList();
            }
            return ReflectionHelper.getAnnotationsInner(delegate);
        }

        @NotNull
        private static List<String> getAnnotationsInner(@NotNull AnnotatedElement delegate) {
            Annotation[] annotations = delegate.getDeclaredAnnotations();
            ArrayList<String> result = new ArrayList<String>(annotations.length);
            for (Annotation annotation : annotations) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                ContainerUtil.addIfNotNull(result, (Object)annotationType.getCanonicalName());
            }
            return result;
        }
    }

    private static class PsiHelper
    extends AsmHelper {
        private final JavaPsiFacade myFacade;
        private final PsiElementFactory myElementFactory;

        private PsiHelper(@NotNull Project project) {
            this.myFacade = JavaPsiFacade.getInstance((Project)project);
            this.myElementFactory = PsiElementFactory.getInstance((Project)project);
        }

        @Override
        public PsiReference @NotNull [] getClassReferences(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            BnfAttr bnfAttr = (BnfAttr)PsiTreeUtil.getParentOfType((PsiElement)element, BnfAttr.class);
            KnownAttribute<?> attr = bnfAttr == null ? null : KnownAttribute.getAttribute(bnfAttr.getName());
            JavaClassReferenceProvider provider = new JavaClassReferenceProvider();
            provider.setOption(JavaClassReferenceProvider.ALLOW_DOLLAR_NAMES, (Object)false);
            provider.setOption(JavaClassReferenceProvider.ADVANCED_RESOLVE, (Object)true);
            if (attr == KnownAttribute.EXTENDS || attr == KnownAttribute.IMPLEMENTS || attr == KnownAttribute.STUB_CLASS) {
                provider.setOption(JavaClassReferenceProvider.IMPORTS, Arrays.asList("java.lang", ParserGeneratorUtil.getRootAttribute(element, KnownAttribute.PSI_PACKAGE)));
            } else if (attr == KnownAttribute.MIXIN) {
                provider.setOption(JavaClassReferenceProvider.IMPORTS, Arrays.asList("java.lang", ParserGeneratorUtil.getRootAttribute(element, KnownAttribute.PSI_PACKAGE), ParserGeneratorUtil.getRootAttribute(element, KnownAttribute.PSI_IMPL_PACKAGE)));
            } else if (attr != null && attr.getName().endsWith("Class")) {
                provider.setOption(JavaClassReferenceProvider.IMPORTS, Collections.singletonList("java.lang"));
            }
            provider.setSoft(false);
            return provider.getReferencesByElement(element, context);
        }

        @Override
        public boolean isPublic(@Nullable NavigatablePsiElement element) {
            return element instanceof PsiModifierListOwner && ((PsiModifierListOwner)element).hasModifierProperty("public");
        }

        @Override
        public NavigatablePsiElement findClass(String className) {
            PsiClass aClass = this.findClassSafe(className);
            return aClass != null ? aClass : super.findClass(className);
        }

        private PsiClass findClassSafe(String className) {
            if (className == null) {
                return null;
            }
            try {
                return this.myFacade.findClass(className, GlobalSearchScope.allScope((Project)this.myFacade.getProject()));
            }
            catch (IndexNotReadyException e) {
                return null;
            }
        }

        @Override
        public NavigationItem findPackage(String packageName) {
            return this.myFacade.findPackage(packageName);
        }

        @Override
        @NotNull
        public List<NavigatablePsiElement> findClassMethods(@Nullable String className, @NotNull MethodType methodType, @Nullable String methodName, int paramCount, String ... paramTypes) {
            PsiMethod[] methods;
            if (methodName == null) {
                return Collections.emptyList();
            }
            PsiClass aClass = this.findClassSafe(className);
            if (aClass == null) {
                return super.findClassMethods(className, methodType, methodName, paramCount, paramTypes);
            }
            ArrayList<NavigatablePsiElement> result = new ArrayList<NavigatablePsiElement>();
            for (PsiMethod method : methods = methodType == MethodType.CONSTRUCTOR ? aClass.getConstructors() : aClass.getMethods()) {
                if (!JavaHelper.acceptsName(methodName, method.getName()) || !PsiHelper.acceptsMethod(method, methodType) || !PsiHelper.acceptsMethod(this.myElementFactory, method, paramCount, paramTypes)) continue;
                result.add((NavigatablePsiElement)method);
            }
            return result;
        }

        @Override
        @Nullable
        public String getSuperClassName(@Nullable String className) {
            PsiClass aClass = this.findClassSafe(className);
            PsiClass superClass = aClass != null ? aClass.getSuperClass() : null;
            return superClass != null ? superClass.getQualifiedName() : super.getSuperClassName(className);
        }

        private static boolean acceptsMethod(PsiElementFactory elementFactory, PsiMethod method, int paramCount, String ... paramTypes) {
            boolean varArgs = method.isVarArgs();
            PsiParameterList parameterList = method.getParameterList();
            if (paramCount >= 0 && (!varArgs && paramCount != parameterList.getParametersCount() || varArgs && paramCount < parameterList.getParametersCount() - 1)) {
                return false;
            }
            if (paramTypes.length == 0) {
                return true;
            }
            if (parameterList.getParametersCount() < paramTypes.length) {
                return false;
            }
            PsiParameter[] psiParameters = parameterList.getParameters();
            for (int i = 0; i < paramTypes.length; ++i) {
                String paramType = paramTypes[i];
                PsiParameter parameter = psiParameters[i];
                PsiType psiType = parameter.getType();
                if (JavaHelper.acceptsName(paramType, psiType.getCanonicalText())) continue;
                try {
                    if (psiType.isAssignableFrom(elementFactory.createTypeFromText(paramType, (PsiElement)parameter))) {
                        continue;
                    }
                }
                catch (IncorrectOperationException incorrectOperationException) {
                    // empty catch block
                }
                return false;
            }
            return true;
        }

        private static boolean acceptsMethod(PsiMethod method, MethodType methodType) {
            PsiModifierList modifierList = method.getModifierList();
            return methodType == MethodType.STATIC == modifierList.hasModifierProperty("static") && !modifierList.hasModifierProperty("abstract") && (methodType != MethodType.CONSTRUCTOR || !modifierList.hasModifierProperty("private"));
        }

        @Override
        @NotNull
        public List<String> getMethodTypes(NavigatablePsiElement method) {
            if (!(method instanceof PsiMethod)) {
                return super.getMethodTypes(method);
            }
            PsiMethod psiMethod = (PsiMethod)method;
            PsiType returnType = psiMethod.getReturnType();
            ArrayList<String> strings = new ArrayList<String>();
            strings.add(returnType == null ? "" : returnType.getCanonicalText(true));
            for (PsiParameter parameter : psiMethod.getParameterList().getParameters()) {
                PsiType type = parameter.getType();
                boolean generic = type instanceof PsiClassType && ((PsiClassType)type).resolve() instanceof PsiTypeParameter;
                String typeText = (generic ? "<" : "") + type.getCanonicalText(true) + (generic ? ">" : "");
                strings.add(typeText);
                strings.add(parameter.getName());
            }
            return strings;
        }

        @Override
        public List<TypeParameterInfo> getGenericParameters(NavigatablePsiElement method) {
            if (!(method instanceof PsiMethod)) {
                return super.getGenericParameters(method);
            }
            PsiMethod psiMethod = (PsiMethod)method;
            Object[] typeParameters = psiMethod.getTypeParameters();
            return ContainerUtil.map((Object[])typeParameters, param -> new TypeParameterInfo(param.getName(), ContainerUtil.map((Object[])param.getExtendsListTypes(), bound -> bound.getCanonicalText(false)), PsiHelper.getAnnotationsInner((PsiModifierListOwner)param)));
        }

        @Override
        public List<String> getExceptionList(NavigatablePsiElement method) {
            if (!(method instanceof PsiMethod)) {
                return super.getExceptionList(method);
            }
            PsiMethod psiMethod = (PsiMethod)method;
            Object[] types = psiMethod.getThrowsList().getReferencedTypes();
            return ContainerUtil.map((Object[])types, type -> type.getCanonicalText(false));
        }

        @Override
        @NotNull
        public String getDeclaringClass(@Nullable NavigatablePsiElement method) {
            if (!(method instanceof PsiMethod)) {
                return super.getDeclaringClass(method);
            }
            PsiMethod psiMethod = (PsiMethod)method;
            PsiClass aClass = psiMethod.getContainingClass();
            return aClass == null ? "" : StringUtil.notNullize((String)aClass.getQualifiedName());
        }

        @Override
        @NotNull
        public List<String> getAnnotations(NavigatablePsiElement element) {
            if (!(element instanceof PsiModifierListOwner)) {
                return super.getAnnotations(element);
            }
            return PsiHelper.getAnnotationsInner((PsiModifierListOwner)element);
        }

        @Override
        @NotNull
        public List<String> getParameterAnnotations(@Nullable NavigatablePsiElement method, int paramIndex) {
            if (!(method instanceof PsiMethod)) {
                return super.getParameterAnnotations(method, paramIndex);
            }
            PsiMethod psiMethod = (PsiMethod)method;
            PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
            if (paramIndex < 0 || paramIndex >= parameters.length) {
                return Collections.emptyList();
            }
            return PsiHelper.getAnnotationsInner((PsiModifierListOwner)parameters[paramIndex]);
        }

        @NotNull
        private static List<String> getAnnotationsInner(PsiModifierListOwner element) {
            PsiType typeToSkip;
            PsiModifierList modifierList = element.getModifierList();
            if (modifierList == null) {
                return Collections.emptyList();
            }
            Object object = element instanceof PsiMethod ? ((PsiMethod)element).getReturnType() : (typeToSkip = element instanceof PsiVariable ? ((PsiVariable)element).getType() : null);
            Object[] annoToSkip = typeToSkip == null ? null : (typeToSkip instanceof PsiArrayType ? ((PsiArrayType)typeToSkip).getComponentType().getAnnotations() : typeToSkip.getAnnotations());
            Object[] textToSkip = annoToSkip == null ? null : (String[])ContainerUtil.map((Object[])annoToSkip, PsiElement::getText, (Object[])ArrayUtil.EMPTY_STRING_ARRAY);
            ArrayList<String> result = new ArrayList<String>();
            for (PsiAnnotation annotation : modifierList.getAnnotations()) {
                if (annotation.getParameterList().getAttributes().length > 0 || textToSkip != null && ArrayUtil.indexOf((Object[])textToSkip, (Object)annotation.getText()) != -1) continue;
                ContainerUtil.addIfNotNull(result, (Object)annotation.getQualifiedName());
            }
            return result;
        }
    }
}

