/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.livePreview;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.util.ObjectUtils;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.intellij.grammar.parser.GeneratedParserUtilBase;
import org.jetbrains.annotations.NotNull;

public class LiveHooksHelper {
    private static final Map<String, Object> ourHooks = new HashMap<String, Object>();
    private static final Map<String, Object> ourBinders = new HashMap<String, Object>();

    public static void registerHook(PsiBuilder builder, String name, String value) {
        GeneratedParserUtilBase.Hook<Object> hookObj = LiveHooksHelper.getHook(name);
        if (hookObj == null) {
            return;
        }
        Object hookParam = ObjectUtils.notNull((Object)LiveHooksHelper.getHookParam(value), (Object)value);
        GeneratedParserUtilBase.register_hook_(builder, (builder1, marker, param) -> {
            try {
                return hookObj.run(builder1, marker, param);
            }
            catch (Exception e) {
                builder1.error("hook crashed: " + e);
                return marker;
            }
        }, hookParam);
    }

    public static GeneratedParserUtilBase.Hook<Object> getHook(String name) {
        return (GeneratedParserUtilBase.Hook)ourHooks.get(name);
    }

    public static Object getHookParam(@NotNull String value) {
        String[] args = value.trim().split("\\s*,\\s*");
        if (args.length == 1) {
            return ourBinders.get(args[0]);
        }
        WhitespacesAndCommentsBinder[] res = new WhitespacesAndCommentsBinder[args.length];
        for (int i = 0; i < args.length; ++i) {
            if (!ourBinders.containsKey(args[i])) {
                return null;
            }
            res[i] = ourBinders.get(args[i]);
        }
        return res;
    }

    private static void collectStaticFields(Class<?> where, Class<?> what, Map<String, Object> result) {
        for (Field field : where.getFields()) {
            int m = field.getModifiers();
            if ((m & 8) == 0 || (m & 0x10) == 0 || (m & 1) == 0 || !what.isAssignableFrom(field.getType())) continue;
            try {
                result.put(field.getName(), field.get(null));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    static {
        LiveHooksHelper.collectStaticFields(GeneratedParserUtilBase.class, GeneratedParserUtilBase.Hook.class, ourHooks);
        LiveHooksHelper.collectStaticFields(WhitespacesBinders.class, WhitespacesAndCommentsBinder.class, ourBinders);
        ourBinders.put("null", null);
    }
}

