/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.livePreview;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import java.util.Objects;
import org.intellij.grammar.livePreview.LivePreviewLanguage;
import org.intellij.grammar.livePreview.LivePreviewParserDefinition;
import org.intellij.grammar.psi.BnfFile;
import org.intellij.grammar.psi.BnfRule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LivePreviewElementType
extends IElementType {
    public LivePreviewElementType(@NotNull String debugName, @NotNull LivePreviewLanguage language) {
        super(debugName, (Language)language, false);
    }

    @NotNull
    public LivePreviewLanguage getLanguage() {
        return (LivePreviewLanguage)super.getLanguage();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LivePreviewElementType t = (LivePreviewElementType)((Object)o);
        return Objects.equals(this.toString(), o.toString()) && this.getLanguage() == t.getLanguage();
    }

    public int hashCode() {
        return 31 * this.toString().hashCode() + ((Object)((Object)this.getLanguage())).hashCode();
    }

    public static class RuleType
    extends LivePreviewElementType {
        final String ruleName;

        RuleType(@NotNull String elementType, @NotNull BnfRule rule, @NotNull LivePreviewLanguage language) {
            super(elementType, language);
            this.ruleName = rule.getName();
        }

        @Nullable
        public BnfRule getRule(Project project) {
            BnfFile file = this.getLanguage().getGrammar(project);
            return file != null ? file.getRule(this.ruleName) : null;
        }
    }

    public static class KeywordType
    extends TokenType {
        KeywordType(@NotNull String name, @NotNull LivePreviewLanguage language) {
            super(LivePreviewParserDefinition.KEYWORD, name, language);
        }
    }

    public static class TokenType
    extends LivePreviewElementType {
        final IElementType delegate;

        TokenType(@Nullable IElementType delegate, @NotNull String name, @NotNull LivePreviewLanguage language) {
            super(name, language);
            this.delegate = (IElementType)ObjectUtils.chooseNotNull((Object)delegate, (Object)((Object)this));
        }
    }
}

