/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.livePreview;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.PsiStructureViewFactory;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.PairProcessor;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.LinkedHashSet;
import java.util.Map;
import org.intellij.grammar.BnfFileType;
import org.intellij.grammar.livePreview.LivePreviewLanguage;
import org.intellij.grammar.livePreview.LivePreviewLexer;
import org.intellij.grammar.livePreview.LivePreviewParser;
import org.intellij.grammar.livePreview.LivePreviewParserDefinition;
import org.intellij.grammar.livePreview.LivePreviewStructureViewFactory;
import org.intellij.grammar.parser.GeneratedParserUtilBase;
import org.intellij.grammar.psi.BnfExpression;
import org.intellij.grammar.psi.BnfFile;
import org.intellij.grammar.psi.BnfRule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class LivePreviewHelper
implements Disposable {
    private final MergingUpdateQueue myQueue = new MergingUpdateQueue("LivePreview update queue", 500, true, null, (Disposable)this, null, Alarm.ThreadToUse.SWING_THREAD);

    public static LivePreviewHelper getInstance() {
        return (LivePreviewHelper)ApplicationManager.getApplication().getService(LivePreviewHelper.class);
    }

    public LivePreviewHelper() {
        final FileDocumentManager fileManager = FileDocumentManager.getInstance();
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                Document document = e.getDocument();
                VirtualFile file = fileManager.getFile(document);
                if (file == null) {
                    return;
                }
                if (FileTypeManager.getInstance().getFileTypeByFileName(file.getName()) != BnfFileType.INSTANCE) {
                    return;
                }
                LivePreviewHelper.this.myQueue.run(Update.create((Object)file, () -> LivePreviewHelper.reparseAllLivePreviews(file, document)));
            }
        }, (Disposable)this);
    }

    public void dispose() {
    }

    public void showFor(@NotNull BnfFile bnfFile) {
        VirtualFile virtualFile;
        Project project = bnfFile.getProject();
        PsiFile psiFile = LivePreviewHelper.parseFile(bnfFile, "");
        VirtualFile virtualFile2 = virtualFile = psiFile == null ? null : psiFile.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        FileEditorManagerEx fileEditorManager = FileEditorManagerEx.getInstanceEx((Project)project);
        EditorWindow curWindow = fileEditorManager.getCurrentWindow();
        curWindow.split(0, false, virtualFile, true);
        fileEditorManager.openFile(virtualFile, true);
    }

    @Nullable
    public static PsiFile parseFile(BnfFile bnfFile, String text) {
        Language language = LivePreviewHelper.getLanguageFor(bnfFile);
        String fileName = bnfFile.getName() + ".preview";
        LightVirtualFile virtualFile = new LightVirtualFile(fileName, language, (CharSequence)text);
        Project project = bnfFile.getProject();
        return PsiManager.getInstance((Project)project).findFile((VirtualFile)virtualFile);
    }

    @NotNull
    public static Language getLanguageFor(BnfFile psiFile) {
        LivePreviewLanguage existing = LivePreviewLanguage.findInstance(psiFile);
        if (existing != null) {
            return existing;
        }
        LivePreviewLanguage language = LivePreviewLanguage.newInstance(psiFile);
        LivePreviewHelper.registerLanguageExtensions(language);
        return language;
    }

    public static void registerLanguageExtensions(LivePreviewLanguage language) {
        LanguageStructureViewBuilder.INSTANCE.addExplicitExtension((Language)language, (Object)new LivePreviewStructureViewFactory());
        LanguageParserDefinitions.INSTANCE.addExplicitExtension((Language)language, (Object)new LivePreviewParserDefinition(language));
    }

    public static void unregisterLanguageExtensions(LivePreviewLanguage language) {
        LanguageStructureViewBuilder.INSTANCE.removeExplicitExtension((Language)language, (Object)((PsiStructureViewFactory)LanguageStructureViewBuilder.INSTANCE.forLanguage((Language)language)));
        LanguageParserDefinitions.INSTANCE.removeExplicitExtension((Language)language, (Object)((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)language)));
    }

    private static void reparseAllLivePreviews(@NotNull VirtualFile bnfFile, @NotNull Document document) {
        LinkedHashSet<VirtualFile> files = new LinkedHashSet<VirtualFile>();
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
            boolean committed = false;
            for (VirtualFile file : fileEditorManager.getOpenFiles()) {
                LivePreviewLanguage previewLanguage;
                Language language;
                Language language2 = language = file instanceof LightVirtualFile ? ((LightVirtualFile)file).getLanguage() : null;
                if (!(language instanceof LivePreviewLanguage) || !bnfFile.equals((previewLanguage = (LivePreviewLanguage)language).getGrammarFile())) continue;
                files.add(file);
                if (committed) continue;
                PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                committed = true;
            }
        }
        if (files.isEmpty()) {
            return;
        }
        FileContentUtilCore.reparseFiles(files);
    }

    public static void collectExpressionsAtOffset(Project project, Editor previewEditor, LivePreviewLanguage language, final PairProcessor<? super BnfExpression, ? super Boolean> processor) {
        LivePreviewLexer lexer = new LivePreviewLexer(project, language);
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)language);
        PsiBuilder builder = PsiBuilderFactory.getInstance().createBuilder(parserDefinition, (Lexer)lexer, (CharSequence)previewEditor.getDocument().getText());
        final int caretOffset = previewEditor.getCaretModel().getOffset();
        LivePreviewParser parser = new LivePreviewParser(project, language){

            @Override
            protected boolean generateNodeCall(PsiBuilder builder, int level, BnfRule rule, @Nullable BnfExpression node, String nextName, Map<String, GeneratedParserUtilBase.Parser> externalArguments) {
                int finalOffset;
                int tokenStartOffset = builder.getCurrentOffset();
                int initialOffset = builder.rawLookup(-1) == TokenType.WHITE_SPACE ? builder.rawTokenTypeStart(-1) : builder.getCurrentOffset();
                String tokenText = builder.getTokenText();
                int tokenEndOffset = tokenText == null ? tokenStartOffset : tokenStartOffset + tokenText.length();
                boolean result = super.generateNodeCall(builder, level, rule, node, nextName, externalArguments);
                builder.getCurrentOffset();
                int n = finalOffset = builder.rawLookup(-1) == TokenType.WHITE_SPACE ? builder.rawTokenTypeStart(-1) : builder.getCurrentOffset();
                if (node != null && (result && initialOffset <= caretOffset && finalOffset > caretOffset || !result && initialOffset <= caretOffset && tokenEndOffset > caretOffset)) {
                    boolean inWhitespace = this.isTokenExpression(node) && tokenStartOffset > caretOffset;
                    if (!processor.process((Object)node, (Object)(result && !inWhitespace ? 1 : 0))) {
                        throw new ProcessCanceledException();
                    }
                }
                return result;
            }
        };
        parser.parse((IElementType)parserDefinition.getFileNodeType(), builder);
    }
}

