/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.livePreview;

import com.intellij.lang.DependentLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.intellij.grammar.GrammarKitBundle;
import org.intellij.grammar.livePreview.LivePreviewHelper;
import org.intellij.grammar.psi.BnfFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public class LivePreviewLanguage
extends Language
implements DependentLanguage {
    private final VirtualFilePointer myFilePointer;
    private final SoftReference<BnfFile> myBnfFile;
    public static final Language BASE_INSTANCE = new Language("BNF_LP"){

        @NotNull
        public String getDisplayName() {
            return GrammarKitBundle.message("language.name.bnf.live.preview", new Object[0]);
        }
    };
    private static final MyClassLoader ourClassLoader = new MyClassLoader();

    protected LivePreviewLanguage(@NotNull BnfFile grammarFile) {
        super(BASE_INSTANCE, Objects.requireNonNull(grammarFile.getVirtualFile()).getPath(), new String[0]);
        VirtualFile virtualFile = Objects.requireNonNull(grammarFile.getVirtualFile());
        Application app = ApplicationManager.getApplication();
        if (app.isUnitTestMode()) {
            this.myBnfFile = new SoftReference<BnfFile>(grammarFile);
            this.myFilePointer = null;
        } else {
            this.myFilePointer = VirtualFilePointerManager.getInstance().create(virtualFile, (Disposable)LivePreviewHelper.getInstance(), null);
            this.myBnfFile = null;
        }
    }

    @NotNull
    public String getDisplayName() {
        VirtualFile file = this.getGrammarFile();
        return file == null ? this.getID() : "'" + file.getName() + "' grammar";
    }

    @Nullable
    public VirtualFile getGrammarFile() {
        if (this.myBnfFile != null) {
            BnfFile file = this.myBnfFile.get();
            return file == null ? null : file.getVirtualFile();
        }
        return this.myFilePointer.getFile();
    }

    @Nullable
    public BnfFile getGrammar(@Nullable Project project) {
        if (this.myBnfFile != null) {
            return this.myBnfFile.get();
        }
        VirtualFile file = project == null ? null : this.getGrammarFile();
        PsiFile psiFile = file == null ? null : PsiManager.getInstance((Project)project).findFile(file);
        return psiFile instanceof BnfFile ? (BnfFile)psiFile : null;
    }

    @NotNull
    public static LivePreviewLanguage newInstance(PsiFile psiFile) {
        try {
            return (LivePreviewLanguage)((Object)ourClassLoader.createClass().getDeclaredConstructors()[0].newInstance(psiFile));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public static LivePreviewLanguage findInstance(PsiFile psiFile) {
        VirtualFile vFile = psiFile.getVirtualFile();
        if (vFile == null) {
            return null;
        }
        for (Language language : Language.getRegisteredLanguages()) {
            if (!(language instanceof LivePreviewLanguage) || !vFile.equals(((LivePreviewLanguage)language).getGrammarFile())) continue;
            return (LivePreviewLanguage)language;
        }
        return null;
    }

    @NotNull
    public List<Editor> getGrammarEditors(@NotNull Project project) {
        VirtualFile file = this.getGrammarFile();
        if (file == null) {
            return Collections.emptyList();
        }
        FileEditor[] editors = FileEditorManager.getInstance((Project)project).getAllEditors(file);
        if (editors.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Editor> result = new ArrayList<Editor>();
        for (FileEditor editor : editors) {
            if (!(editor instanceof TextEditor)) continue;
            result.add(((TextEditor)editor).getEditor());
        }
        return result;
    }

    @NotNull
    public List<Editor> getPreviewEditors(@NotNull Project project) {
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        VirtualFile[] files = fileEditorManager.getOpenFiles();
        if (files.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Editor> result = new ArrayList<Editor>();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        for (VirtualFile file : files) {
            Language language;
            PsiFile psiFile = psiManager.findFile(file);
            Language language2 = language = psiFile == null ? null : psiFile.getLanguage();
            if (language != this) continue;
            for (FileEditor editor : fileEditorManager.getAllEditors(file)) {
                if (!(editor instanceof TextEditor)) continue;
                result.add(((TextEditor)editor).getEditor());
            }
        }
        return result;
    }

    private static class MyClassLoader
    extends ClassLoader {
        private final AtomicInteger myCounter = new AtomicInteger();

        MyClassLoader() {
            super(LivePreviewHelper.class.getClassLoader());
        }

        Class<LivePreviewLanguage> createClass() {
            int index = this.myCounter.incrementAndGet();
            String className = LivePreviewLanguage.class.getName() + "$$_" + index;
            byte[] b = MyClassLoader.dump(className);
            return this.defineClass(className, b, 0, b.length);
        }

        public static byte[] dump(String className) {
            ClassWriter cw = new ClassWriter(0);
            cw.visit(50, 33, className.replace(".", "/"), null, "org/intellij/grammar/livePreview/LivePreviewLanguage", null);
            MethodVisitor mv = cw.visitMethod(1, "<init>", "(Lorg/intellij/grammar/psi/BnfFile;)V", null, null);
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(183, "org/intellij/grammar/livePreview/LivePreviewLanguage", "<init>", "(Lorg/intellij/grammar/psi/BnfFile;)V", false);
            mv.visitInsn(177);
            Label l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLocalVariable("this", "L" + className.replace(".", "/") + ";", null, l0, l1, 0);
            mv.visitLocalVariable("grammarFile", "Lorg/intellij/grammar/psi/BnfFile;", null, l0, l1, 1);
            mv.visitMaxs(3, 2);
            mv.visitEnd();
            cw.visitEnd();
            return cw.toByteArray();
        }
    }
}

