/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.livePreview;

import com.intellij.lexer.LexerBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.grammar.KnownAttribute;
import org.intellij.grammar.generator.Case;
import org.intellij.grammar.generator.ParserGeneratorUtil;
import org.intellij.grammar.livePreview.LivePreviewElementType;
import org.intellij.grammar.livePreview.LivePreviewLanguage;
import org.intellij.grammar.livePreview.LivePreviewParserDefinition;
import org.intellij.grammar.psi.BnfFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LivePreviewLexer
extends LexerBase {
    private CharSequence myBuffer;
    private int myEndOffset;
    private int myPosition;
    private int myTokenEnd;
    private IElementType myTokenType;
    private final Token[] myTokens;
    private Matcher[] myMatchers;

    public LivePreviewLexer(Project project, LivePreviewLanguage language) {
        BnfFile bnfFile = language.getGrammar(project);
        this.myTokens = bnfFile == null ? new Token[]{} : (Token[])CachedValuesManager.getCachedValue((PsiElement)bnfFile, () -> {
            LinkedHashSet<String> usedInGrammar = new LinkedHashSet<String>();
            Map<String, String> map = LivePreviewLexer.collectTokenPattern2Name(bnfFile, usedInGrammar);
            Token[] tokens = new Token[map.size()];
            int i = 0;
            String tokenConstantPrefix = ParserGeneratorUtil.getRootAttribute((PsiElement)bnfFile, KnownAttribute.ELEMENT_TYPE_PREFIX);
            for (String pattern : map.keySet()) {
                String tokenName = map.get(pattern);
                tokens[i++] = new Token(pattern, tokenName, usedInGrammar.contains(tokenName), tokenConstantPrefix, language);
            }
            return CachedValueProvider.Result.create((Object)tokens, (Object[])new Object[]{bnfFile});
        });
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        this.myBuffer = buffer;
        this.myEndOffset = endOffset;
        this.myTokenEnd = this.myPosition = startOffset;
        this.myTokenType = null;
        this.myMatchers = new Matcher[this.myTokens.length];
        for (int i = 0; i < this.myMatchers.length; ++i) {
            Pattern pattern = this.myTokens[i].pattern;
            if (pattern == null) continue;
            this.myMatchers[i] = pattern.matcher(buffer);
        }
        this.nextToken();
    }

    private void nextToken() {
        this.myTokenEnd = this.myPosition;
        if (this.myPosition >= this.myEndOffset) {
            this.myTokenType = null;
            return;
        }
        if (!this.findAtOffset(this.myPosition)) {
            int nextOffset = this.myPosition;
            while (++nextOffset < this.myEndOffset && !this.findAtOffset(nextOffset)) {
            }
            this.myTokenEnd = nextOffset;
            this.myTokenType = TokenType.BAD_CHARACTER;
        }
    }

    private boolean findAtOffset(int position) {
        this.myTokenEnd = position;
        this.myTokenType = null;
        for (int i = 0; i < this.myMatchers.length; ++i) {
            int end;
            Matcher matcher;
            if (this.myMatchers[i] == null || !(matcher = this.myMatchers[i].region(position, this.myEndOffset)).lookingAt() || (end = matcher.end()) <= this.myTokenEnd) continue;
            this.myTokenEnd = end;
            this.myTokenType = this.myTokens[i].tokenType;
        }
        return this.myTokenType != null;
    }

    public int getState() {
        return 0;
    }

    @Nullable
    public IElementType getTokenType() {
        if (this.myTokenType == null && this.myPosition != this.myEndOffset) {
            this.nextToken();
            assert (false) : "not lexed: '" + this.myBuffer.subSequence(this.myPosition, this.myEndOffset) + "'";
        }
        return this.myTokenType;
    }

    public int getTokenStart() {
        return this.myPosition;
    }

    public int getTokenEnd() {
        return this.myTokenEnd;
    }

    public void advance() {
        if (this.myTokenType != null) {
            this.myPosition = this.myTokenEnd;
            this.nextToken();
        }
    }

    @NotNull
    public CharSequence getBufferSequence() {
        return this.myBuffer;
    }

    public int getBufferEnd() {
        return this.myEndOffset;
    }

    public Collection<Token> getTokens() {
        return Arrays.asList(this.myTokens);
    }

    @Nullable
    private static IElementType guessDelegateType(@NotNull String tokenName, @Nullable Pattern pattern, boolean usedInGrammar) {
        if (pattern != null) {
            if (!usedInGrammar && (pattern.matcher(" ").matches() || pattern.matcher("\n").matches())) {
                return TokenType.WHITE_SPACE;
            }
            if (pattern.matcher("1234").matches()) {
                return LivePreviewParserDefinition.NUMBER;
            }
            if (pattern.matcher("\"sdf\"").matches() || pattern.matcher("'sdf'").matches()) {
                return LivePreviewParserDefinition.STRING;
            }
        }
        if (!usedInGrammar && StringUtil.endsWithIgnoreCase((String)tokenName, (String)"comment")) {
            return LivePreviewParserDefinition.COMMENT;
        }
        return null;
    }

    @NotNull
    public static Map<String, String> collectTokenPattern2Name(@NotNull BnfFile file, @Nullable Set<String> usedInGrammar) {
        return ParserGeneratorUtil.collectTokenPattern2Name(file, true, new LinkedHashMap<String, String>(), usedInGrammar);
    }

    static class Token {
        final String constantName;
        final Pattern pattern;
        final IElementType tokenType;

        Token(String pattern, String mappedName, boolean usedInGrammar, String constantPrefix, LivePreviewLanguage language) {
            IElementType delegate;
            boolean keyword;
            String tokenName;
            this.constantName = constantPrefix + Case.UPPER.apply(mappedName);
            if (ParserGeneratorUtil.isRegexpToken(pattern)) {
                String patternText = ParserGeneratorUtil.getRegexpTokenRegexp(pattern);
                this.pattern = ParserGeneratorUtil.compilePattern(patternText);
                tokenName = mappedName;
                keyword = false;
            } else {
                this.pattern = ParserGeneratorUtil.compilePattern(StringUtil.escapeToRegexp((String)pattern));
                tokenName = pattern;
                keyword = StringUtil.isJavaIdentifier((String)pattern);
            }
            IElementType iElementType = delegate = keyword ? null : LivePreviewLexer.guessDelegateType(tokenName, this.pattern, usedInGrammar);
            this.tokenType = keyword ? new LivePreviewElementType.KeywordType(tokenName, language) : (delegate == TokenType.WHITE_SPACE || delegate == LivePreviewParserDefinition.COMMENT ? delegate : new LivePreviewElementType.TokenType(delegate, tokenName, language));
        }

        public String toString() {
            return "Token{" + this.constantName + ", pattern=" + this.pattern + ", tokenType=" + this.tokenType + "}";
        }
    }
}

