/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.psi;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import org.intellij.grammar.psi.BnfAttr;
import org.intellij.grammar.psi.BnfAttrPattern;
import org.intellij.grammar.psi.BnfAttrs;
import org.intellij.grammar.psi.BnfFile;
import org.intellij.grammar.psi.BnfRule;
import org.intellij.grammar.psi.BnfStringLiteralExpression;
import org.intellij.grammar.psi.impl.BnfStringImpl;
import org.jetbrains.annotations.NotNull;

public class BnfAttrPatternRefSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public BnfAttrPatternRefSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        PsiElement target = queryParameters.getElementToSearch();
        if (!(target instanceof BnfRule)) {
            return;
        }
        SearchScope scope = queryParameters.getEffectiveSearchScope();
        if (!(scope instanceof LocalSearchScope)) {
            return;
        }
        PsiFile file = target.getContainingFile();
        if (!(file instanceof BnfFile)) {
            return;
        }
        for (BnfAttrs attrs : ((BnfFile)file).getAttributes()) {
            for (BnfAttr attr : attrs.getAttrList()) {
                BnfStringLiteralExpression patternExpression;
                PsiReference ref;
                BnfAttrPattern pattern = attr.getAttrPattern();
                if (pattern == null || (ref = BnfStringImpl.matchesElement(patternExpression = pattern.getLiteralExpression(), target) ? patternExpression.getReference() : null) == null || !ref.isReferenceTo(target) || consumer.process((Object)ref)) continue;
                return;
            }
        }
    }
}

