/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.psi.impl;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.AtomicClearableLazyValue;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.intellij.grammar.BnfFileType;
import org.intellij.grammar.BnfLanguage;
import org.intellij.grammar.KnownAttribute;
import org.intellij.grammar.generator.ParserGeneratorUtil;
import org.intellij.grammar.psi.BnfAttr;
import org.intellij.grammar.psi.BnfAttrPattern;
import org.intellij.grammar.psi.BnfAttrs;
import org.intellij.grammar.psi.BnfExpression;
import org.intellij.grammar.psi.BnfFile;
import org.intellij.grammar.psi.BnfRule;
import org.intellij.grammar.psi.BnfStringLiteralExpression;
import org.intellij.grammar.psi.impl.GrammarUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BnfFileImpl
extends PsiFileBase
implements BnfFile {
    private final ClearableLazyValue<Map<String, BnfRule>> myRules = BnfFileImpl.lazyValue(this::calcRules);
    private final ClearableLazyValue<List<BnfAttrs>> myGlobalAttributes = BnfFileImpl.lazyValue(this::calcAttributes);
    private final ClearableLazyValue<Map<String, List<AttributeInfo>>> myAttributeValues = BnfFileImpl.lazyValue(this::calcAttributeValues);
    private static final Pattern SUB_EXPRESSION = Pattern.compile(".*(_\\d+)+");

    public BnfFileImpl(FileViewProvider fileViewProvider) {
        super(fileViewProvider, (Language)BnfLanguage.INSTANCE);
    }

    public void clearCaches() {
        super.clearCaches();
        this.myRules.drop();
        this.myGlobalAttributes.drop();
        this.myAttributeValues.drop();
    }

    @Override
    @NotNull
    public List<BnfRule> getRules() {
        return new ArrayList<BnfRule>(((Map)this.myRules.getValue()).values());
    }

    @Override
    @Nullable
    public BnfRule getRule(@Nullable String ruleName) {
        return ruleName == null ? null : (BnfRule)((Map)this.myRules.getValue()).get(ruleName);
    }

    @Override
    @NotNull
    public List<BnfAttrs> getAttributes() {
        return (List)this.myGlobalAttributes.getValue();
    }

    @Override
    @Nullable
    public BnfAttr findAttribute(@Nullable BnfRule rule, @NotNull KnownAttribute<?> knownAttribute, @Nullable String match) {
        AttributeInfo result = (AttributeInfo)this.getMatchingAttributes(rule, knownAttribute, match).first();
        if (result == null) {
            return null;
        }
        return (BnfAttr)PsiTreeUtil.getParentOfType((PsiElement)this.findElementAt(result.attrOffset), BnfAttr.class);
    }

    @Override
    public <T> T findAttributeValue(@Nullable BnfRule rule, @NotNull KnownAttribute<T> knownAttribute, @Nullable String match) {
        KnownAttribute.ListValue combined = null;
        boolean copied = false;
        for (AttributeInfo info : this.getMatchingAttributes(rule, knownAttribute, match)) {
            T cur = knownAttribute.ensureValue(info.value);
            if (combined != null && info.pattern == null) continue;
            if (knownAttribute == KnownAttribute.PIN && match != null && info.pattern == null && !info.global && SUB_EXPRESSION.matcher(match).matches()) {
                return null;
            }
            if (!(cur instanceof KnownAttribute.ListValue)) {
                return cur;
            }
            if (combined == null) {
                combined = (KnownAttribute.ListValue)cur;
                continue;
            }
            if (copied) {
                ((KnownAttribute.ListValue)combined).addAll((KnownAttribute.ListValue)cur);
                continue;
            }
            copied = true;
            KnownAttribute.ListValue copy = new KnownAttribute.ListValue();
            copy.addAll(combined);
            copy.addAll((KnownAttribute.ListValue)cur);
            combined = copy;
        }
        return (T)(combined != null ? combined : (KnownAttribute.ListValue)knownAttribute.getDefaultValue());
    }

    @NotNull
    private <T> JBIterable<AttributeInfo> getMatchingAttributes(@Nullable BnfRule rule, @NotNull KnownAttribute<T> knownAttribute, @Nullable String match) {
        int ruleStartOffset;
        int offset;
        BnfAttrs globalAttrs;
        List list = (List)((Map)this.myAttributeValues.getValue()).get(knownAttribute.getName());
        if (list == null) {
            return JBIterable.empty();
        }
        BnfAttrs bnfAttrs = globalAttrs = rule == null ? (BnfAttrs)ContainerUtil.getFirstItem(this.getAttributes()) : null;
        int n = rule == null ? (globalAttrs == null ? 0 : globalAttrs.getTextRange().getEndOffset()) : (offset = rule.getTextRange().getEndOffset());
        if (offset == 0) {
            return JBIterable.empty();
        }
        AttributeInfo key = new AttributeInfo(0, offset, true, null, null);
        int index = Collections.binarySearch(list, key);
        int n2 = ruleStartOffset = rule == null ? offset : rule.getTextRange().getStartOffset();
        String toMatch = match == null ? (rule == null ? null : rule.getName()) : match;
        return JBIterable.generate((Object)Math.min(list.size() - 1, index < 0 ? -index - 1 : index), i -> i > 0 ? Integer.valueOf(i - 1) : null).map(i -> {
            AttributeInfo info = (AttributeInfo)list.get((int)i);
            if (offset < info.offset || !info.global && ruleStartOffset > info.offset) {
                return null;
            }
            if (info.pattern == null || toMatch != null && info.pattern.matcher(toMatch).matches()) {
                return info;
            }
            return null;
        }).filter(Conditions.notNull());
    }

    @NotNull
    public FileType getFileType() {
        return BnfFileType.INSTANCE;
    }

    public String toString() {
        return "BnfFile:" + this.getName();
    }

    private Map<String, BnfRule> calcRules() {
        LinkedHashMap<String, BnfRule> result = new LinkedHashMap<String, BnfRule>();
        for (BnfRule o : GrammarUtil.bnfTraverser((PsiElement)this).filter(BnfRule.class)) {
            if (result.containsKey(o.getName())) continue;
            result.put(o.getName(), o);
        }
        return result;
    }

    private List<BnfAttrs> calcAttributes() {
        return ((SyntaxTraverser)GrammarUtil.bnfTraverser((PsiElement)this).expand(Conditions.notInstanceOf(BnfRule.class))).filter(BnfAttrs.class).toList();
    }

    private Map<String, List<AttributeInfo>> calcAttributeValues() {
        HashMap<String, List<AttributeInfo>> result = new HashMap<String, List<AttributeInfo>>();
        JBIterable allAttrs = ((SyntaxTraverser)GrammarUtil.bnfTraverser((PsiElement)this).expand(Conditions.notInstanceOf(BnfExpression.class))).filter(BnfAttrs.class);
        for (BnfAttrs attrs : allAttrs) {
            boolean isRule = attrs.getParent() instanceof BnfRule;
            TextRange baseRange = attrs.getTextRange();
            List<BnfAttr> attrList = attrs.getAttrList();
            for (int pass = 0; pass < 2; ++pass) {
                for (int i = attrList.size() - 1; i >= 0; --i) {
                    ArrayList<AttributeInfo> list;
                    BnfAttr attr;
                    BnfAttrPattern attrPattern;
                    if (pass == 0 == ((attrPattern = (attr = attrList.get(i)).getAttrPattern()) != null)) continue;
                    Pattern pattern = null;
                    if (attrPattern != null) {
                        BnfStringLiteralExpression expression = attrPattern.getLiteralExpression();
                        Pattern pattern2 = pattern = expression == null ? null : ParserGeneratorUtil.compilePattern(GrammarUtil.unquote(expression.getText()));
                    }
                    if ((list = (ArrayList<AttributeInfo>)result.get(attr.getName())) == null) {
                        list = new ArrayList<AttributeInfo>();
                        result.put(attr.getName(), list);
                    }
                    Object value = ParserGeneratorUtil.getAttributeValue(attr.getExpression());
                    int offset = attr.getTextRange().getStartOffset();
                    int infoOffset = pattern == null ? baseRange.getStartOffset() + 1 : baseRange.getStartOffset() + (baseRange.getEndOffset() - offset);
                    list.add(new AttributeInfo(offset, infoOffset, !isRule, pattern, value));
                }
            }
        }
        return result;
    }

    @NotNull
    private static <T> AtomicClearableLazyValue<T> lazyValue(final Supplier<T> producer) {
        return new AtomicClearableLazyValue<T>(){

            @NotNull
            protected T compute() {
                return producer.get();
            }
        };
    }

    private static class AttributeInfo
    implements Comparable<AttributeInfo> {
        final int attrOffset;
        final int offset;
        final boolean global;
        final Pattern pattern;
        final Object value;

        private AttributeInfo(int attrOffset, int offset, boolean global, Pattern pattern, Object value) {
            this.attrOffset = attrOffset;
            this.offset = offset;
            this.global = global;
            this.pattern = pattern;
            this.value = value;
        }

        @Override
        public int compareTo(@NotNull AttributeInfo o) {
            return this.offset - o.offset;
        }

        public String toString() {
            return (this.global ? "" : "rule:") + this.offset + (String)(this.pattern == null ? "" : " (" + this.pattern + ")") + " = " + this.value;
        }
    }
}

