/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.psi.impl;

import com.intellij.psi.PsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.ui.RowIcon;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.intellij.grammar.BnfIcons;
import org.intellij.grammar.psi.BnfAttr;
import org.intellij.grammar.psi.BnfModifier;
import org.intellij.grammar.psi.BnfNamedElement;
import org.intellij.grammar.psi.BnfRule;
import org.intellij.grammar.psi.BnfTypes;
import org.intellij.grammar.psi.impl.BnfCompositeImpl;
import org.intellij.grammar.psi.impl.BnfElementFactory;
import org.intellij.grammar.psi.impl.GrammarUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class BnfNamedImpl
extends BnfCompositeImpl
implements BnfNamedElement {
    private volatile String myCachedName;

    public BnfNamedImpl(IElementType elementType) {
        super(elementType);
    }

    public void clearCaches() {
        super.clearCaches();
        this.myCachedName = null;
    }

    @Override
    @NotNull
    public String getName() {
        if (this.myCachedName == null) {
            this.myCachedName = GrammarUtil.getIdText(this.getId());
        }
        return this.myCachedName;
    }

    public PsiElement setName(@NonNls @NotNull String s) throws IncorrectOperationException {
        this.getId().replace(BnfElementFactory.createLeafFromText(this.getProject(), s));
        return this;
    }

    public int getTextOffset() {
        return this.getId().getTextOffset();
    }

    @NotNull
    public SearchScope getUseScope() {
        return new LocalSearchScope((PsiElement)this.getContainingFile());
    }

    public Icon getIcon(int flags) {
        if (this instanceof BnfRule) {
            Icon base = BnfNamedImpl.hasModifier((BnfRule)((Object)this), "external") ? BnfIcons.EXTERNAL_RULE : BnfIcons.RULE;
            Icon visibility = BnfNamedImpl.hasModifier((BnfRule)((Object)this), "private") ? PlatformIcons.PRIVATE_ICON : PlatformIcons.PUBLIC_ICON;
            RowIcon row = new RowIcon(2);
            row.setIcon(base, 0);
            row.setIcon(visibility, 1);
            return row;
        }
        if (this instanceof BnfAttr) {
            return BnfIcons.ATTRIBUTE;
        }
        return super.getIcon(flags);
    }

    public PsiElement getNameIdentifier() {
        return this.getId();
    }

    public static boolean hasModifier(BnfRule rule, String modifier) {
        for (BnfModifier o : rule.getModifierList()) {
            if (!modifier.equals(o.getText())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        PsiElement nullableId = this.findPsiChildByType(BnfTypes.BNF_ID);
        return super.toString() + ":" + (nullableId == null ? null : nullableId.getText());
    }
}

