/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.psi.impl;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.intellij.grammar.KnownAttribute;
import org.intellij.grammar.generator.ParserGeneratorUtil;
import org.intellij.grammar.java.JavaHelper;
import org.intellij.grammar.psi.BnfExpression;
import org.intellij.grammar.psi.BnfExternalExpression;
import org.intellij.grammar.psi.BnfFile;
import org.intellij.grammar.psi.BnfNamedElement;
import org.intellij.grammar.psi.BnfRule;
import org.intellij.grammar.psi.BnfSequence;
import org.intellij.grammar.psi.BnfVisitor;
import org.intellij.grammar.psi.impl.GrammarUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BnfReferenceImpl<T extends BnfExpression>
extends PsiReferenceBase<T>
implements EmptyResolveMessageProvider {
    public BnfReferenceImpl(@NotNull T element, TextRange range) {
        super(element, range);
    }

    public PsiElement resolve() {
        BnfRule targetRule;
        PsiFile containingFile = ((BnfExpression)this.myElement).getContainingFile();
        String referenceName = this.getRangeInElement().substring(((BnfExpression)this.myElement).getText());
        boolean isExternal = GrammarUtil.isExternalReference(this.myElement);
        BnfRule bnfRule = targetRule = containingFile instanceof BnfFile ? ((BnfFile)containingFile).getRule(referenceName) : null;
        if (!isExternal) {
            return targetRule;
        }
        BnfRule rule = ParserGeneratorUtil.Rule.of((BnfExpression)this.myElement);
        if (!ParserGeneratorUtil.Rule.isMeta(rule) && !ParserGeneratorUtil.Rule.isExternal(rule)) {
            return targetRule != null ? targetRule : this.resolveMethod();
        }
        BnfExternalExpression externalExpr = (BnfExternalExpression)ObjectUtils.tryCast((Object)((BnfExpression)this.myElement).getParent(), BnfExternalExpression.class);
        if (externalExpr != null && externalExpr.getArguments().isEmpty()) {
            return new MetaParameter(rule, ((BnfExpression)this.myElement).getText());
        }
        return targetRule != null ? targetRule : this.resolveMethod();
    }

    @Nullable
    private PsiElement resolveMethod() {
        String referenceName = this.getRangeInElement().substring(((BnfExpression)this.myElement).getText());
        PsiElement parent = ((BnfExpression)this.myElement).getParent();
        int paramCount = parent instanceof BnfSequence ? ((BnfSequence)parent).getExpressionList().size() - 1 : (parent instanceof BnfExternalExpression ? ((BnfExternalExpression)parent).getArguments().size() : 0);
        BnfRule rule = Objects.requireNonNull((BnfRule)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, BnfRule.class));
        String parserClass = ParserGeneratorUtil.getAttribute(rule, KnownAttribute.PARSER_UTIL_CLASS);
        JavaHelper helper = JavaHelper.getJavaHelper(this.myElement);
        String className = parserClass;
        while (className != null) {
            List<NavigatablePsiElement> methods = helper.findClassMethods(className, JavaHelper.MethodType.STATIC, referenceName, paramCount + 2, new String[0]);
            PsiElement first = (PsiElement)ContainerUtil.getFirstItem(methods);
            if (first != null) {
                return first;
            }
            className = helper.getSuperClassName(className);
        }
        return null;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        return GrammarUtil.isExternalReference(this.myElement) ? "Unresolved meta rule or method ''{0}''" : "Unresolved rule ''{0}''";
    }

    public static class MetaParameter
    extends RenameableFakePsiElement
    implements BnfNamedElement {
        private final String myName;

        MetaParameter(BnfRule rule, String name) {
            super((PsiElement)rule);
            this.myName = name;
        }

        @Override
        public <R> R accept(@NotNull BnfVisitor<R> visitor) {
            return visitor.visitNamedElement(this);
        }

        public void accept(@NotNull PsiElementVisitor visitor) {
            if (visitor instanceof BnfVisitor) {
                this.accept((BnfVisitor)visitor);
            } else {
                super.accept(visitor);
            }
        }

        @Override
        @NotNull
        public PsiElement getId() {
            return Objects.requireNonNull(this.getNameIdentifier());
        }

        @Override
        @NotNull
        public String getName() {
            return this.myName;
        }

        @Nullable
        @Nls
        public String getTypeName() {
            return "Meta Rule Parameter";
        }

        @Nullable
        public Icon getIcon() {
            return null;
        }

        @Nullable
        public PsiElement getNameIdentifier() {
            for (BnfExternalExpression o : GrammarUtil.bnfTraverserNoAttrs(this.getParent()).filter(BnfExternalExpression.class)) {
                if (!o.getArguments().isEmpty() || !Objects.equals(this.myName, o.getRefElement().getText())) continue;
                return o.getRefElement();
            }
            return null;
        }

        @NotNull
        public PsiElement getNavigationElement() {
            PsiElement identifier = this.getNameIdentifier();
            if (identifier != null) {
                return identifier;
            }
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }

        public boolean isEquivalentTo(PsiElement another) {
            return another instanceof MetaParameter && Objects.equals(this.myName, ((MetaParameter)another).myName) && this.getManager().areElementsEquivalent(this.getParent(), another.getParent());
        }

        @NotNull
        public SearchScope getUseScope() {
            return new LocalSearchScope((PsiElement)this.getContainingFile());
        }
    }
}

