/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PairProcessor;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.intellij.grammar.KnownAttribute;
import org.intellij.grammar.generator.ParserGeneratorUtil;
import org.intellij.grammar.psi.BnfAttr;
import org.intellij.grammar.psi.BnfAttrPattern;
import org.intellij.grammar.psi.BnfAttrs;
import org.intellij.grammar.psi.BnfComposite;
import org.intellij.grammar.psi.BnfExpression;
import org.intellij.grammar.psi.BnfFile;
import org.intellij.grammar.psi.BnfLiteralExpression;
import org.intellij.grammar.psi.BnfRule;
import org.intellij.grammar.psi.BnfSequence;
import org.intellij.grammar.psi.BnfStringLiteralExpression;
import org.intellij.grammar.psi.BnfVisitor;
import org.intellij.grammar.psi.impl.BnfElementFactory;
import org.intellij.grammar.psi.impl.BnfExpressionImpl;
import org.intellij.grammar.psi.impl.BnfReferenceImpl;
import org.intellij.grammar.psi.impl.BnfStringLiteralEscaper;
import org.intellij.grammar.psi.impl.BnfStringManipulator;
import org.intellij.grammar.psi.impl.BnfStringRefContributor;
import org.intellij.grammar.psi.impl.GrammarUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BnfStringImpl
extends BnfExpressionImpl
implements BnfStringLiteralExpression,
PsiLanguageInjectionHost {
    private static final Key<PsiReference> REF_KEY = Key.create((String)"BNF_REF_KEY");
    private static final Map<ElementPattern<? extends PsiElement>, PsiReferenceProvider> ourProviders = new LinkedHashMap<ElementPattern<? extends PsiElement>, PsiReferenceProvider>();

    @NotNull
    public static PsiReference createPatternReference(@NotNull BnfStringImpl e) {
        Object ref = (PsiReference)e.getUserData(REF_KEY);
        if (ref == null) {
            ref = new MyPatternReference(e);
            e.putUserData(REF_KEY, ref);
        }
        return ref;
    }

    @NotNull
    public static PsiReference createRuleReference(@NotNull BnfStringImpl e) {
        Object ref = (PsiReference)e.getUserData(REF_KEY);
        if (ref == null) {
            ref = new MyRuleReference(e);
            e.putUserData(REF_KEY, ref);
        }
        return ref;
    }

    public BnfStringImpl(IElementType type) {
        super(type);
    }

    @Override
    public PsiElement getNumber() {
        return null;
    }

    public PsiReference @NotNull [] getReferences() {
        SmartList result = new SmartList();
        for (Map.Entry<ElementPattern<? extends PsiElement>, PsiReferenceProvider> e : ourProviders.entrySet()) {
            ProcessingContext context = new ProcessingContext();
            if (!e.getKey().accepts((Object)this, context)) continue;
            result.addAll(Arrays.asList(e.getValue().getReferencesByElement((PsiElement)this, context)));
        }
        return result.isEmpty() ? PsiReference.EMPTY_ARRAY : result.toArray(PsiReference.EMPTY_ARRAY);
    }

    public PsiReference getReference() {
        return (PsiReference)ArrayUtil.getFirstElement((Object[])this.getReferences());
    }

    public boolean isValidHost() {
        return true;
    }

    public BnfStringImpl updateText(@NotNull String text) {
        BnfExpression expression = BnfElementFactory.createExpressionFromText(this.getProject(), text);
        assert (expression instanceof BnfStringImpl) : text + "-->" + expression;
        return (BnfStringImpl)this.replace(expression);
    }

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        return new BnfStringLiteralEscaper(this);
    }

    @Nullable
    private static Pattern getPattern(BnfLiteralExpression expression) {
        return ParserGeneratorUtil.compilePattern(GrammarUtil.unquote(expression.getText()));
    }

    public static boolean matchesElement(@Nullable BnfLiteralExpression e1, @NotNull PsiElement e2) {
        if (e1 == null) {
            return false;
        }
        if (e2 instanceof PsiNamedElement) {
            String name = ((PsiNamedElement)e2).getName();
            Pattern pattern = BnfStringImpl.getPattern(e1);
            return name != null && pattern != null && pattern.matcher(name).matches();
        }
        return true;
    }

    static {
        new BnfStringRefContributor().registerReferenceProviders(new PsiReferenceRegistrar(){

            public <T extends PsiElement> void registerReferenceProvider(@NotNull ElementPattern<T> pattern, @NotNull PsiReferenceProvider provider, double priority) {
                ourProviders.put(pattern, provider);
            }
        });
    }

    private static class MyPatternReference
    extends PsiPolyVariantReferenceBase<BnfStringImpl> {
        private static final ResolveCache.PolyVariantResolver<MyPatternReference> RESOLVER = (reference, b) -> reference.multiResolveInner();

        MyPatternReference(BnfStringImpl element) {
            super((PsiElement)element);
        }

        @NotNull
        public TextRange getRangeInElement() {
            return BnfStringManipulator.getStringTokenRange((BnfStringImpl)this.getElement());
        }

        public boolean isReferenceTo(@NotNull PsiElement element) {
            return BnfStringImpl.matchesElement((BnfLiteralExpression)this.getElement(), element) && super.isReferenceTo(element);
        }

        public ResolveResult @NotNull [] multiResolve(boolean b) {
            return ResolveCache.getInstance((Project)((BnfStringImpl)this.getElement()).getProject()).resolveWithCaching((PsiPolyVariantReference)this, RESOLVER, false, b);
        }

        public ResolveResult @NotNull [] multiResolveInner() {
            Pattern pattern = BnfStringImpl.getPattern((BnfLiteralExpression)this.getElement());
            if (pattern == null) {
                return ResolveResult.EMPTY_ARRAY;
            }
            ArrayList<BnfRule> result = new ArrayList<BnfRule>();
            BnfAttr thisAttr = Objects.requireNonNull((BnfAttr)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), BnfAttr.class));
            BnfAttrs thisAttrs = Objects.requireNonNull((BnfAttrs)PsiTreeUtil.getParentOfType((PsiElement)thisAttr, BnfAttrs.class));
            BnfRule thisRule = (BnfRule)PsiTreeUtil.getParentOfType((PsiElement)thisAttrs, BnfRule.class);
            String thisAttrName = thisAttr.getName();
            KnownAttribute<?> knownAttribute = KnownAttribute.getAttribute(thisAttrName);
            SmartList otherPatterns = new SmartList();
            if (knownAttribute != null && !(knownAttribute.getDefaultValue() instanceof KnownAttribute.ListValue)) {
                for (BnfAttr attr : thisAttrs.getAttrList()) {
                    BnfAttrPattern attrPattern;
                    Object expression2;
                    Pattern p;
                    if (attr == thisAttr) break;
                    if (!thisAttrName.equals(attr.getName()) || (p = (expression2 = (attrPattern = attr.getAttrPattern()) != null ? attrPattern.getLiteralExpression() : null) == null ? null : BnfStringImpl.getPattern((BnfLiteralExpression)expression2)) == null) continue;
                    otherPatterns.add(p);
                }
            }
            BnfFile file = (BnfFile)thisAttrs.getContainingFile();
            int thisOffset = (thisRule != null ? thisRule : thisAttrs).getTextRange().getStartOffset();
            ArrayList rules = thisRule != null ? Collections.singletonList(thisRule) : file.getRules();
            block1: for (BnfRule rule : rules) {
                String ruleName;
                if (rule.getTextRange().getStartOffset() < thisOffset || !pattern.matcher(ruleName = rule.getName()).matches()) continue;
                for (Pattern otherPattern : otherPatterns) {
                    if (!otherPattern.matcher(ruleName).matches()) continue;
                    continue block1;
                }
                result.add(rule);
            }
            if (knownAttribute == KnownAttribute.PIN) {
                HashSet visited = new HashSet();
                for (Object o : thisRule != null ? rules : new ArrayList(result)) {
                    BnfRule rule = (BnfRule)o;
                    GrammarUtil.processExpressionNames(rule, ParserGeneratorUtil.getFuncName(rule), rule.getExpression(), (PairProcessor<? super String, ? super BnfExpression>)((PairProcessor)(funcName, expression) -> {
                        if (!(expression instanceof BnfSequence)) {
                            return true;
                        }
                        if (!visited.add(funcName)) {
                            return true;
                        }
                        PsiElement firstNotTrivial = ParserGeneratorUtil.Rule.firstNotTrivial(ParserGeneratorUtil.Rule.of(expression));
                        if (firstNotTrivial == expression) {
                            return true;
                        }
                        if (pattern.matcher((CharSequence)funcName).matches()) {
                            result.add((BnfRule)((Object)new MyFakePsiElement((String)funcName, (BnfExpression)expression)));
                        }
                        return true;
                    }));
                }
            }
            return PsiElementResolveResult.createResults(result);
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            return this.myElement;
        }

        public Object @NotNull [] getVariants() {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
    }

    private static class MyRuleReference
    extends BnfReferenceImpl<BnfStringImpl> {
        MyRuleReference(BnfStringImpl element) {
            super(element, null);
        }

        @NotNull
        public TextRange getRangeInElement() {
            return BnfStringManipulator.getStringTokenRange((BnfStringImpl)this.getElement());
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            BnfStringImpl element = (BnfStringImpl)this.getElement();
            PsiElement string = element.getString();
            char quote = string.getText().charAt(0);
            return string.replace(BnfElementFactory.createLeafFromText(element.getProject(), quote + newElementName + quote));
        }
    }

    private static class MyFakePsiElement
    extends FakePsiElement
    implements BnfComposite {
        private final String myFuncName;
        private final BnfExpression myExpression;

        MyFakePsiElement(String funcName, BnfExpression expression) {
            this.myFuncName = funcName;
            this.myExpression = expression;
        }

        public String getName() {
            return this.myFuncName;
        }

        @NotNull
        public PsiElement getNavigationElement() {
            return this.myExpression;
        }

        public TextRange getTextRange() {
            return this.myExpression.getTextRange();
        }

        public PsiElement getParent() {
            return this.myExpression.getParent();
        }

        @Override
        public <R> R accept(@NotNull BnfVisitor<R> visitor) {
            return null;
        }

        public void accept(@NotNull PsiElementVisitor visitor) {
        }

        public boolean isEquivalentTo(PsiElement another) {
            return another instanceof MyFakePsiElement && Objects.equals(this.myFuncName, ((MyFakePsiElement)another).myFuncName) && this.myExpression.getManager().areElementsEquivalent((PsiElement)this.myExpression, (PsiElement)((MyFakePsiElement)another).myExpression);
        }
    }
}

