/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.psi.impl;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.intellij.grammar.KnownAttribute;
import org.intellij.grammar.generator.ParserGeneratorUtil;
import org.intellij.grammar.java.JavaHelper;
import org.intellij.grammar.psi.BnfAttr;
import org.intellij.grammar.psi.BnfExpression;
import org.intellij.grammar.psi.BnfExternalExpression;
import org.intellij.grammar.psi.BnfListEntry;
import org.intellij.grammar.psi.BnfRule;
import org.intellij.grammar.psi.BnfStringLiteralExpression;
import org.intellij.grammar.psi.impl.BnfElementFactory;
import org.jetbrains.annotations.NotNull;

public class GrammarPsiImplUtil {
    public static PsiReference @NotNull [] getReferences(BnfListEntry o) {
        BnfAttr attr = (BnfAttr)PsiTreeUtil.getParentOfType((PsiElement)o, BnfAttr.class);
        if (attr == null || !Objects.equals(KnownAttribute.METHODS.getName(), attr.getName())) {
            return PsiReference.EMPTY_ARRAY;
        }
        PsiElement id = o.getId();
        BnfStringLiteralExpression value = o.getLiteralExpression();
        if (id == null || value != null) {
            return PsiReference.EMPTY_ARRAY;
        }
        final String psiImplUtilClass = ParserGeneratorUtil.getRootAttribute(attr, KnownAttribute.PSI_IMPL_UTIL_CLASS);
        final JavaHelper javaHelper = JavaHelper.getJavaHelper(o);
        return new PsiReference[]{new PsiPolyVariantReferenceBase<BnfListEntry>(o, TextRange.from((int)id.getStartOffsetInParent(), (int)id.getTextLength())){

            private List<NavigatablePsiElement> getTargetMethods(String methodName) {
                BnfRule rule = (BnfRule)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), BnfRule.class);
                String mixinClass = rule == null ? null : ParserGeneratorUtil.getAttribute(rule, KnownAttribute.MIXIN);
                List<NavigatablePsiElement> implMethods = ParserGeneratorUtil.findRuleImplMethods(javaHelper, psiImplUtilClass, methodName, rule);
                if (!implMethods.isEmpty()) {
                    return implMethods;
                }
                List<NavigatablePsiElement> mixinMethods = javaHelper.findClassMethods(mixinClass, JavaHelper.MethodType.INSTANCE, methodName, -1, new String[0]);
                return ContainerUtil.concat(implMethods, mixinMethods);
            }

            public ResolveResult @NotNull [] multiResolve(boolean b) {
                return PsiElementResolveResult.createResults(this.getTargetMethods(((BnfListEntry)this.getElement()).getText()));
            }

            public Object @NotNull [] getVariants() {
                ArrayList<LookupElementBuilder> list = new ArrayList<LookupElementBuilder>();
                for (NavigatablePsiElement element : this.getTargetMethods("*")) {
                    list.add(LookupElementBuilder.createWithIcon((PsiNamedElement)((PsiNamedElement)element)));
                }
                return ArrayUtil.toObjectArray(list);
            }

            public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
                BnfListEntry element = (BnfListEntry)this.getElement();
                PsiElement id = Objects.requireNonNull(element.getId());
                id.replace(BnfElementFactory.createLeafFromText(element.getProject(), newElementName));
                return element;
            }
        }};
    }

    @NotNull
    public static List<BnfExpression> getArguments(@NotNull BnfExternalExpression expr) {
        List<BnfExpression> expressions = expr.getExpressionList();
        return expressions.subList(1, expressions.size());
    }
}

