/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.psi.impl;

import com.intellij.lang.Language;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import org.intellij.grammar.KnownAttribute;
import org.intellij.grammar.generator.ParserGeneratorUtil;
import org.intellij.grammar.parser.GeneratedParserUtilBase;
import org.intellij.grammar.psi.BnfAttrs;
import org.intellij.grammar.psi.BnfComposite;
import org.intellij.grammar.psi.BnfExpression;
import org.intellij.grammar.psi.BnfExternalExpression;
import org.intellij.grammar.psi.BnfLiteralExpression;
import org.intellij.grammar.psi.BnfReferenceOrToken;
import org.intellij.grammar.psi.BnfRule;
import org.intellij.grammar.psi.BnfSequence;
import org.intellij.grammar.psi.BnfTypes;
import org.intellij.grammar.psi.BnfVisitor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GrammarUtil {
    public static final BnfExpression[] EMPTY_EXPRESSIONS_ARRAY = new BnfExpression[0];

    public static PsiElement getDummyAwarePrevSibling(PsiElement child) {
        PsiElement prevSibling = child.getPrevSibling();
        while (prevSibling instanceof GeneratedParserUtilBase.DummyBlock) {
            prevSibling = prevSibling.getLastChild();
        }
        if (prevSibling != null) {
            return prevSibling;
        }
        PsiElement parent = child.getParent();
        while (parent instanceof GeneratedParserUtilBase.DummyBlock && parent.getPrevSibling() == null) {
            parent = parent.getParent();
        }
        return parent == null ? null : parent.getPrevSibling();
    }

    public static boolean equalsElement(BnfExpression e1, BnfExpression e2) {
        if (e1 == null) {
            return e2 == null;
        }
        if (e2 == null) {
            return false;
        }
        if (ParserGeneratorUtil.getEffectiveType(e1) != ParserGeneratorUtil.getEffectiveType(e2)) {
            return false;
        }
        if (GrammarUtil.isOneTokenExpression(e1)) {
            return e1.getText().equals(e2.getText());
        }
        PsiElement c1 = e1.getFirstChild();
        PsiElement c2 = e2.getFirstChild();
        do {
            boolean f2;
            boolean f1 = c1 == null || c1 instanceof BnfExpression;
            boolean bl = f2 = c2 == null || c2 instanceof BnfExpression;
            if (f1 && f2 && !GrammarUtil.equalsElement((BnfExpression)c1, (BnfExpression)c2)) {
                return false;
            }
            if (!f1 || f2) {
                PsiElement psiElement = c1 = c1 == null ? null : c1.getNextSibling();
            }
            if (!f1 && f2) continue;
            PsiElement psiElement = c2 = c2 == null ? null : c2.getNextSibling();
        } while (c1 != null || c2 != null);
        return true;
    }

    public static boolean isInAttributesReference(@Nullable PsiElement element) {
        return PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{BnfRule.class, BnfAttrs.class}) instanceof BnfAttrs;
    }

    public static boolean isOneTokenExpression(@Nullable BnfExpression e1) {
        return e1 instanceof BnfLiteralExpression || e1 instanceof BnfReferenceOrToken;
    }

    public static boolean isExternalReference(@Nullable PsiElement psiElement) {
        PsiElement parent;
        PsiElement psiElement2 = parent = psiElement == null ? null : psiElement.getParent();
        if (parent instanceof BnfExternalExpression && ((BnfExternalExpression)parent).getRefElement() == psiElement) {
            return true;
        }
        if (parent instanceof BnfSequence && parent.getFirstChild() == psiElement) {
            parent = parent.getParent();
        }
        return parent instanceof BnfRule && ParserGeneratorUtil.Rule.isExternal((BnfRule)parent);
    }

    public static List<BnfExpression> getExternalRuleExpressions(@NotNull BnfRule subRule) {
        BnfExpression expression = subRule.getExpression();
        return expression instanceof BnfSequence ? ((BnfSequence)expression).getExpressionList() : Collections.singletonList(expression);
    }

    public static List<String> collectMetaParameters(BnfRule rule, BnfExpression expression) {
        String attr;
        if (!ParserGeneratorUtil.Rule.isMeta(rule) && !ParserGeneratorUtil.Rule.isExternal(rule)) {
            return Collections.emptyList();
        }
        SmartList result = new SmartList();
        for (BnfExternalExpression o : GrammarUtil.bnfTraverserNoAttrs(expression).filter(BnfExternalExpression.class)) {
            String text;
            if (!o.getArguments().isEmpty() || result.contains(text = "<<" + o.getRefElement().getText() + ">>")) continue;
            result.add(text);
        }
        if (ParserGeneratorUtil.Rule.isMeta(rule) && GrammarUtil.isDoubleAngles(attr = ParserGeneratorUtil.getAttribute(rule, KnownAttribute.RECOVER_WHILE)) && !result.contains(attr)) {
            result.add(attr);
        }
        return result;
    }

    @NotNull
    public static String unquote(@NotNull String str) {
        return StringUtil.unquoteString((String)str);
    }

    public static boolean isDoubleAngles(@Nullable String str) {
        return str != null && str.startsWith("<<") && str.endsWith(">>");
    }

    public static boolean processExpressionNames(BnfRule rule, String funcName, BnfExpression expression, PairProcessor<? super String, ? super BnfExpression> processor) {
        if (GrammarUtil.isAtomicExpression(expression)) {
            return true;
        }
        BnfExpression nonTrivialExpression = expression;
        BnfExpression e = expression;
        BnfExpression n = ParserGeneratorUtil.getTrivialNodeChild(e);
        while (n != null) {
            if (!processor.process((Object)funcName, (Object)e)) {
                return false;
            }
            nonTrivialExpression = n;
            e = n;
            n = ParserGeneratorUtil.getTrivialNodeChild(e);
        }
        boolean isMeta = nonTrivialExpression instanceof BnfExternalExpression;
        List<BnfExpression> children = ParserGeneratorUtil.getChildExpressions(nonTrivialExpression);
        int size = children.size();
        for (int i = isMeta ? 1 : 0; i < size; ++i) {
            String nextName;
            BnfExpression child = children.get(i);
            if (GrammarUtil.isAtomicExpression(child)) continue;
            String string = ParserGeneratorUtil.isTokenSequence(rule, child) ? funcName : (nextName = ParserGeneratorUtil.getNextName(funcName, isMeta ? i - 1 : i));
            if (GrammarUtil.processExpressionNames(rule, nextName, child, processor)) continue;
            return false;
        }
        return processor.process((Object)funcName, (Object)nonTrivialExpression);
    }

    public static boolean processPinnedExpressions(BnfRule rule, Processor<? super BnfExpression> processor) {
        return GrammarUtil.processPinnedExpressions(rule, (PairProcessor<? super BnfExpression, ? super ParserGeneratorUtil.PinMatcher>)((PairProcessor)(bnfExpression, pinMatcher) -> processor.process(bnfExpression)));
    }

    public static boolean processPinnedExpressions(BnfRule rule, PairProcessor<? super BnfExpression, ? super ParserGeneratorUtil.PinMatcher> processor) {
        return GrammarUtil.processExpressionNames(rule, ParserGeneratorUtil.getFuncName(rule), rule.getExpression(), (PairProcessor<? super String, ? super BnfExpression>)((PairProcessor)(funcName, expression) -> {
            if (!(expression instanceof BnfSequence)) {
                return true;
            }
            List<BnfExpression> children = ParserGeneratorUtil.getChildExpressions(expression);
            if (children.size() < 2) {
                return true;
            }
            ParserGeneratorUtil.PinMatcher pinMatcher = new ParserGeneratorUtil.PinMatcher(rule, BnfTypes.BNF_SEQUENCE, (String)funcName);
            boolean pinApplied = false;
            int childExpressionsSize = children.size();
            for (int i = 0; i < childExpressionsSize; ++i) {
                BnfExpression child = children.get(i);
                if (pinApplied || !pinMatcher.matches(i, child)) continue;
                pinApplied = true;
                if (processor.process((Object)child, (Object)pinMatcher)) continue;
                return false;
            }
            return true;
        }));
    }

    public static boolean isAtomicExpression(BnfExpression tree) {
        return tree instanceof BnfReferenceOrToken || tree instanceof BnfLiteralExpression;
    }

    public static SyntaxTraverser<PsiElement> bnfTraverser(PsiElement root) {
        return (SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)root)).forceDisregardTypes(Conditions.equalTo((Object)GeneratedParserUtilBase.DUMMY_BLOCK)).filter(Conditions.instanceOf(BnfComposite.class));
    }

    public static SyntaxTraverser<PsiElement> bnfTraverserNoAttrs(PsiElement root) {
        return (SyntaxTraverser)GrammarUtil.bnfTraverser(root).forceIgnore(Conditions.instanceOf(BnfAttrs.class));
    }

    public static String getMethodName(BnfRule rule, PsiElement element) {
        BnfExpression target = (BnfExpression)PsiTreeUtil.getParentOfType((PsiElement)element, BnfExpression.class, (boolean)false);
        String funcName = ParserGeneratorUtil.getFuncName(rule);
        if (target == null) {
            return funcName;
        }
        Ref ref = Ref.create(null);
        GrammarUtil.processExpressionNames(rule, funcName, rule.getExpression(), (PairProcessor<? super String, ? super BnfExpression>)((PairProcessor)(funcName1, expression) -> {
            if (target == expression) {
                ref.set(funcName1);
                return false;
            }
            return true;
        }));
        return (String)ref.get();
    }

    @NotNull
    public static String getIdText(@Nullable PsiElement id) {
        return id == null ? "" : GrammarUtil.stripQuotesAroundId(id.getText());
    }

    @Contract(value="!null->!null")
    public static String stripQuotesAroundId(String text) {
        return GrammarUtil.isIdQuoted(text) ? text.substring(1, text.length() - 1) : text;
    }

    public static boolean isIdQuoted(@Nullable String text) {
        return text != null && text.startsWith("<") && text.endsWith(">");
    }

    public static class FakeBnfExpression
    extends LeafPsiElement
    implements BnfExpression {
        public FakeBnfExpression(@NotNull String text) {
            this(BnfTypes.BNF_EXPRESSION, text);
        }

        public FakeBnfExpression(@NotNull IElementType elementType, @NotNull String text) {
            super(elementType, (CharSequence)text);
        }

        @Override
        public <R> R accept(@NotNull BnfVisitor<R> visitor) {
            return visitor.visitExpression(this);
        }

        public void accept(@NotNull PsiElementVisitor visitor) {
            if (visitor instanceof BnfVisitor) {
                this.accept((BnfVisitor)visitor);
            } else {
                super.accept(visitor);
            }
        }

        public String toString() {
            return this.getText();
        }
    }

    public static class FakeElementType
    extends IElementType {
        public FakeElementType(String debugName, Language language) {
            super(debugName, language, false);
        }
    }
}

