/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.refactor;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.intellij.grammar.generator.ParserGeneratorUtil;
import org.intellij.grammar.psi.BnfExpression;
import org.intellij.grammar.psi.BnfExternalExpression;
import org.intellij.grammar.psi.BnfModifier;
import org.intellij.grammar.psi.BnfRule;
import org.intellij.grammar.psi.BnfSequence;
import org.intellij.grammar.psi.impl.BnfElementFactory;
import org.intellij.grammar.psi.impl.GrammarUtil;
import org.intellij.grammar.refactor.BnfExpressionOptimizer;
import org.intellij.grammar.refactor.BnfInlineViewDescriptor;
import org.jetbrains.annotations.NotNull;

public class BnfInlineRuleProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance(BnfInlineRuleProcessor.class);
    private BnfRule myRule;
    private final PsiReference myReference;
    private final boolean myInlineThisOnly;

    public BnfInlineRuleProcessor(BnfRule rule, Project project, PsiReference ref, boolean isInlineThisOnly) {
        super(project);
        this.myRule = rule;
        this.myReference = ref;
        this.myInlineThisOnly = isInlineThisOnly;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        return new BnfInlineViewDescriptor(this.myRule);
    }

    @NotNull
    protected String getCommandName() {
        return "Inline rule '" + this.myRule.getName() + "'";
    }

    protected UsageInfo @NotNull [] findUsages() {
        if (this.myInlineThisOnly) {
            return new UsageInfo[]{new UsageInfo(this.myReference.getElement())};
        }
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        for (PsiReference reference : ReferencesSearch.search((PsiElement)this.myRule, (SearchScope)this.myRule.getUseScope(), (boolean)false)) {
            PsiElement element = reference.getElement();
            if (GrammarUtil.isInAttributesReference(element)) continue;
            result.add(new UsageInfo(element));
        }
        return result.toArray(UsageInfo.EMPTY_ARRAY);
    }

    protected void refreshElements(PsiElement @NotNull [] elements) {
        LOG.assertTrue(elements.length == 1 && elements[0] instanceof BnfRule);
        this.myRule = (BnfRule)elements[0];
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        BnfExpression expression = this.myRule.getExpression();
        boolean meta = ParserGeneratorUtil.Rule.isMeta(this.myRule);
        CommonRefactoringUtil.sortDepthFirstRightLeftOrder((UsageInfo[])usages);
        for (UsageInfo info : usages) {
            try {
                BnfExpression element = (BnfExpression)info.getElement();
                boolean metaRuleRef = GrammarUtil.isExternalReference(element);
                if (meta && metaRuleRef) {
                    BnfInlineRuleProcessor.inlineMetaRuleUsage(this.myProject, element, expression);
                    continue;
                }
                if (meta || metaRuleRef) continue;
                BnfInlineRuleProcessor.inlineExpressionUsage(this.myProject, element, expression);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        if (!this.myInlineThisOnly) {
            try {
                this.myRule.delete();
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private static void inlineExpressionUsage(Project project, BnfExpression place, BnfExpression ruleExpr) throws IncorrectOperationException {
        BnfExpression replacement = BnfElementFactory.createExpressionFromText(project, "(" + ruleExpr.getText() + ")");
        BnfExpressionOptimizer.optimize(project, place.replace(replacement));
    }

    private static void inlineMetaRuleUsage(Project project, BnfExpression place, BnfExpression expression) {
        List<BnfExpression> expressionList;
        BnfRule rule = (BnfRule)PsiTreeUtil.getParentOfType((PsiElement)place, BnfRule.class);
        PsiElement parent = place.getParent();
        if (parent instanceof BnfExternalExpression) {
            expressionList = ((BnfExternalExpression)parent).getExpressionList();
        } else if (parent instanceof BnfSequence) {
            expressionList = ((BnfSequence)parent).getExpressionList();
        } else if (parent instanceof BnfRule) {
            expressionList = Collections.emptyList();
        } else {
            LOG.error("Unexpected element: " + (parent == null ? "null" : parent.getClass().getName()));
            return;
        }
        Object2IntOpenHashMap visited = new Object2IntOpenHashMap();
        LinkedList work = new LinkedList();
        expression = (BnfExpression)expression.copy();
        expression.acceptChildren((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor((Object2IntMap)visited, expressionList, work){
            final /* synthetic */ Object2IntMap val$visited;
            final /* synthetic */ List val$expressionList;
            final /* synthetic */ LinkedList val$work;
            {
                this.val$visited = object2IntMap;
                this.val$expressionList = list;
                this.val$work = linkedList;
            }

            public void visitElement(@NotNull PsiElement element) {
                if (element instanceof BnfExternalExpression) {
                    List<BnfExpression> list = ((BnfExternalExpression)element).getExpressionList();
                    if (list.size() == 1) {
                        String text = list.get(0).getText();
                        int idx = this.val$visited.getInt((Object)text);
                        if (idx == 0) {
                            idx = this.val$visited.size() + 1;
                            this.val$visited.put((Object)text, idx);
                        }
                        if (idx < this.val$expressionList.size()) {
                            this.val$work.addFirst(Pair.create((Object)element, (Object)((PsiElement)this.val$expressionList.get(idx))));
                        }
                    }
                } else {
                    super.visitElement(element);
                }
            }
        });
        for (Pair pair : work) {
            BnfExpressionOptimizer.optimize(project, ((PsiElement)pair.first).replace((PsiElement)pair.second));
        }
        BnfInlineRuleProcessor.inlineExpressionUsage(project, (BnfExpression)parent, expression);
        if (!(parent instanceof BnfExternalExpression)) {
            for (BnfModifier modifier : rule.getModifierList()) {
                if (!modifier.getText().equals("external")) continue;
                modifier.getNextSibling().delete();
                modifier.delete();
                break;
            }
        }
    }
}

