/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.refactor;

import com.intellij.codeInsight.unwrap.UnwrapDescriptor;
import com.intellij.codeInsight.unwrap.Unwrapper;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.intellij.grammar.psi.BnfParenthesized;
import org.intellij.grammar.psi.BnfPredicate;
import org.intellij.grammar.psi.BnfPredicateSign;
import org.intellij.grammar.psi.BnfQuantified;
import org.intellij.grammar.psi.BnfQuantifier;
import org.intellij.grammar.psi.impl.BnfElementFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BnfUnwrapDescriptor
implements UnwrapDescriptor,
Unwrapper {
    @NotNull
    public List<Pair<PsiElement, Unwrapper>> collectUnwrappers(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        ArrayList<Pair<PsiElement, Unwrapper>> result = new ArrayList<Pair<PsiElement, Unwrapper>>();
        for (PsiElement element = BnfUnwrapDescriptor.findTargetElement(editor, file); element != null; element = element.getParent()) {
            if (!(element instanceof BnfParenthesized)) continue;
            result.add((Pair<PsiElement, Unwrapper>)new Pair((Object)element, (Object)this));
        }
        return result;
    }

    public boolean showOptionsDialog() {
        return true;
    }

    public boolean shouldTryToRestoreCaretPosition() {
        return true;
    }

    public boolean isApplicableTo(@NotNull PsiElement e) {
        return e instanceof BnfParenthesized && !PsiUtilCore.hasErrorElementChild((PsiElement)e);
    }

    public void collectElementsToIgnore(@NotNull PsiElement element, @NotNull Set<PsiElement> result) {
    }

    @NotNull
    public String getDescription(PsiElement e) {
        PsiElement parent = e.getParent();
        BnfQuantifier quantifier = parent instanceof BnfQuantified ? ((BnfQuantified)parent).getQuantifier() : null;
        BnfPredicateSign sign = parent instanceof BnfPredicate ? ((BnfPredicate)parent).getPredicateSign() : null;
        String prefix = sign == null ? "" : sign.getText();
        String suffix = quantifier == null ? "" : quantifier.getText();
        return "Unwrap " + prefix + e.getFirstChild().getText() + "..." + e.getLastChild().getText() + suffix;
    }

    public PsiElement collectAffectedElements(@NotNull PsiElement element, @NotNull List<PsiElement> toExtract) {
        PsiElement last = element.getLastChild();
        PsiElement first = element.getFirstChild();
        if (element instanceof BnfParenthesized) {
            last = last.getPrevSibling();
            first = first.getNextSibling();
        }
        while (first != last && first instanceof PsiWhiteSpace) {
            first = first.getNextSibling();
        }
        while (last != first && last instanceof PsiWhiteSpace) {
            last = last.getPrevSibling();
        }
        if (first == null || last == null || first == last && last instanceof PsiWhiteSpace) {
            return null;
        }
        for (PsiElement c = first; c != last && c != null; c = c.getNextSibling()) {
            toExtract.add(c);
        }
        PsiElement parent = element.getParent();
        return parent instanceof BnfQuantified || parent instanceof BnfPredicate ? parent : element;
    }

    @NotNull
    public List<PsiElement> unwrap(@NotNull Editor editor, PsiElement element) throws IncorrectOperationException {
        Project project = element.getProject();
        PsiElement last = element.getLastChild();
        PsiElement first = element.getFirstChild();
        if (element instanceof BnfParenthesized) {
            last = last.getPrevSibling();
            first = first.getNextSibling();
        }
        while (first != last && first instanceof PsiWhiteSpace) {
            first = first.getNextSibling();
        }
        while (last != first && last instanceof PsiWhiteSpace) {
            last = last.getPrevSibling();
        }
        if (first == null || last == null || first == last && last instanceof PsiWhiteSpace) {
            return Collections.emptyList();
        }
        PsiElement parent = element.getParent();
        PsiElement target = parent instanceof BnfQuantified || parent instanceof BnfPredicate ? parent : element;
        return Collections.singletonList(target.replace((PsiElement)BnfElementFactory.createExpressionFromText(project, element.getContainingFile().getText().substring(first.getTextRange().getStartOffset(), last.getTextRange().getEndOffset()))));
    }

    @Nullable
    private static PsiElement findTargetElement(Editor editor, PsiFile file) {
        PsiElement startElement;
        int offset = editor.getCaretModel().getOffset();
        PsiElement endElement = file.findElementAt(offset);
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection() && selectionModel.getSelectionStart() < offset && (startElement = file.findElementAt(selectionModel.getSelectionStart())) != null && startElement != endElement && startElement.getTextRange().getEndOffset() == offset) {
            return startElement;
        }
        return endElement;
    }
}

