/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.jflex.editor;

import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Map;
import javax.swing.Icon;
import org.intellij.grammar.GrammarKitBundle;
import org.intellij.jflex.editor.JFlexSyntaxHighlighterFactory;
import org.intellij.jflex.parser.JFlexFileType;
import org.jetbrains.annotations.NotNull;

public class JFlexColorSettingsPage
implements ColorSettingsPage {
    private static final AttributesDescriptor[] ATTRS = new AttributesDescriptor[]{new AttributesDescriptor("Illegal symbol", JFlexSyntaxHighlighterFactory.ILLEGAL), new AttributesDescriptor("Macro", JFlexSyntaxHighlighterFactory.MACRO), new AttributesDescriptor("State", JFlexSyntaxHighlighterFactory.STATE), new AttributesDescriptor("Character class", JFlexSyntaxHighlighterFactory.CLASS), new AttributesDescriptor("Pattern operator", JFlexSyntaxHighlighterFactory.PATTERN_OP), new AttributesDescriptor("Character class operator", JFlexSyntaxHighlighterFactory.CLASS_OP), new AttributesDescriptor("Comment", JFlexSyntaxHighlighterFactory.COMMENT), new AttributesDescriptor("Lexer option", JFlexSyntaxHighlighterFactory.OPTION), new AttributesDescriptor("Java code", JFlexSyntaxHighlighterFactory.RAW_CODE), new AttributesDescriptor("Section divider", JFlexSyntaxHighlighterFactory.SECT_DIV), new AttributesDescriptor("String", JFlexSyntaxHighlighterFactory.STRING), new AttributesDescriptor("Character", JFlexSyntaxHighlighterFactory.CHAR), new AttributesDescriptor("Character escape", JFlexSyntaxHighlighterFactory.CHAR_ESC), new AttributesDescriptor("Number", JFlexSyntaxHighlighterFactory.NUMBER), new AttributesDescriptor("Predefined character class", JFlexSyntaxHighlighterFactory.CLASS_STD), new AttributesDescriptor("EOF matcher", JFlexSyntaxHighlighterFactory.EOF), new AttributesDescriptor("Lookahead separator", JFlexSyntaxHighlighterFactory.LOOKAHEAD), new AttributesDescriptor("Comma", JFlexSyntaxHighlighterFactory.COMMA), new AttributesDescriptor("Dot", JFlexSyntaxHighlighterFactory.DOT), new AttributesDescriptor("Equal sign", JFlexSyntaxHighlighterFactory.OP_EQUAL), new AttributesDescriptor("Range operator", JFlexSyntaxHighlighterFactory.OP_RANGE), new AttributesDescriptor("Parentheses", JFlexSyntaxHighlighterFactory.PARENS), new AttributesDescriptor("Curly braces", JFlexSyntaxHighlighterFactory.BRACES), new AttributesDescriptor("Square brackets", JFlexSyntaxHighlighterFactory.BRACKETS), new AttributesDescriptor("Angle brackets", JFlexSyntaxHighlighterFactory.ANGLES)};

    @NotNull
    public String getDisplayName() {
        return GrammarKitBundle.message("language.name.jflex", new Object[0]);
    }

    public Icon getIcon() {
        return JFlexFileType.INSTANCE.getIcon();
    }

    public AttributesDescriptor @NotNull [] getAttributeDescriptors() {
        return ATTRS;
    }

    public ColorDescriptor @NotNull [] getColorDescriptors() {
        return ColorDescriptor.EMPTY_ARRAY;
    }

    @NotNull
    public SyntaxHighlighter getHighlighter() {
        return new JFlexSyntaxHighlighterFactory().getSyntaxHighlighter(null, null);
    }

    @NotNull
    public String getDemoText() {
        return "/* Header comment */\npackage sample.lexer;\n\n%%\n%public\n%class _MyLexer\n%unicode\n%{\n  private int parenCount;\n%}\n\n// lexer states\n%state <s>BLOCK</s>, <s>QUALIFICATION</s>\n\n// macro definitions\n<m>WHITESPACE</m>=<c>[ \\n\\r\\t]</c>\n<m>ESCAPED_CHAR</m>=\\\\.\n<m>STRING</m>=\\\"(<c>[^\\\"\\\\]</c>|\\\\.)*\\\"\n<m>ID</m> = [a-z_&&[A-Z]]([:letter:]|[:digit:]|_)*\n<m>BLOCK_COMMENT</m>=\"//\".* | \"/*\" !(<c>[^]</c>* \"*/\" <c>[^]</c>*) (\"*/\")?\n<m>NUMBER</m>=<c>[+-]</c>[:digit:]+\n<m>FLOAT</m>=<m>{NUMBER}</m>(\\.[:digit:]){1, 3}\n\n%%\n<<s>YYINITIAL</s>, <s>BLOCK</s>> {\n    <m>{WHITESPACE}</m>      { return WHITESPACE; }\n    <m>{STRING}</m>          { return STRING; }\n    \"(\"               { return PAREN1; }\n    \")\"               { return PAREN2; }\n    \".\" / !<<EOF>>    { yybegin(QUALIFICATION); return DOT; }\n    <c>[^]</c>               { return BAD_CHARACTER; }\n}\n";
    }

    public Map<String, TextAttributesKey> getAdditionalHighlightingTagToDescriptorMap() {
        return ContainerUtil.newHashMap(Arrays.asList("s", "m", "c"), Arrays.asList(JFlexSyntaxHighlighterFactory.STATE, JFlexSyntaxHighlighterFactory.MACRO, JFlexSyntaxHighlighterFactory.CLASS));
    }
}

