/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.jflex.editor;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import java.util.Collection;
import java.util.Collections;
import org.intellij.grammar.parser.GeneratedParserUtilBase;
import org.intellij.jflex.psi.JFlexComposite;
import org.intellij.jflex.psi.JFlexDeclarationsSection;
import org.intellij.jflex.psi.JFlexExpression;
import org.intellij.jflex.psi.JFlexJavaCode;
import org.intellij.jflex.psi.JFlexJavaType;
import org.intellij.jflex.psi.JFlexRule;
import org.intellij.jflex.psi.JFlexTypes;
import org.intellij.jflex.psi.JFlexUserCodeSection;
import org.intellij.jflex.psi.impl.JFlexFileImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JFlexCompletionContributor
extends CompletionContributor {
    public JFlexCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inFile((ElementPattern)StandardPatterns.instanceOf(JFlexFileImpl.class)), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                boolean inJava;
                PsiElement position = parameters.getPosition();
                JFlexComposite parent = (JFlexComposite)PsiTreeUtil.getParentOfType((PsiElement)position, (Class[])new Class[]{JFlexDeclarationsSection.class, JFlexRule.class, JFlexJavaCode.class, JFlexJavaType.class});
                boolean bl = inJava = parent instanceof JFlexJavaCode || parent instanceof JFlexJavaType;
                if (!inJava && parameters.getInvocationCount() < 2) {
                    int start = position.getTextRange().getStartOffset();
                    CompletionResultSet result2 = start > 0 && parameters.getEditor().getDocument().getText().charAt(start - 1) == '%' ? result.withPrefixMatcher(result.getPrefixMatcher().cloneWithPrefix("%" + result.getPrefixMatcher().getPrefix())) : result;
                    for (String keyword : JFlexCompletionContributor.suggestKeywords(parameters.getPosition())) {
                        result2.addElement(JFlexCompletionContributor.createKeywordLookupItem(parameters.getOriginalFile(), keyword));
                    }
                }
            }
        });
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        context.setDummyIdentifier(CompletionUtil.DUMMY_IDENTIFIER_TRIMMED);
    }

    private static Collection<String> suggestKeywords(PsiElement position) {
        if (position instanceof LeafPsiElement && ((LeafPsiElement)position).getElementType() == JFlexTypes.FLEX_STRING) {
            return Collections.emptySet();
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)position, JFlexUserCodeSection.class) != null) {
            return Collections.emptySet();
        }
        boolean inDeclare = PsiTreeUtil.getParentOfType((PsiElement)position, JFlexDeclarationsSection.class) != null;
        PsiFile flexFile = position.getContainingFile();
        Language language = flexFile.getLanguage();
        String flexFileText = flexFile.getText();
        int positionOffset = position.getTextRange().getEndOffset();
        JFlexExpression expr = (JFlexExpression)PsiTreeUtil.getParentOfType((PsiElement)position, JFlexExpression.class);
        final boolean inMacro = expr != null && expr.getText().substring(0, positionOffset - expr.getTextRange().getStartOffset()).indexOf(10) == -1;
        String fragment = (inDeclare ? "%%\n" : "%%\n%%\n") + flexFileText.substring(flexFileText.lastIndexOf("%%", positionOffset - 1) + 2, positionOffset);
        boolean empty = StringUtil.isEmptyOrSpaces((String)fragment);
        Object text = empty ? "IntellijIdeaRulezzz " : fragment;
        int completionOffset = empty ? 0 : fragment.length();
        PsiFile file = PsiFileFactory.getInstance((Project)flexFile.getProject()).createFileFromText("a.flex", language, (CharSequence)text, true, false);
        GeneratedParserUtilBase.CompletionState state = new GeneratedParserUtilBase.CompletionState(completionOffset){

            @Override
            @Nullable
            public String convertItem(Object o) {
                if (o == null) {
                    return null;
                }
                if (o instanceof IElementType[]) {
                    return super.convertItem(o);
                }
                if (o == JFlexTypes.FLEX_ID || o == JFlexTypes.FLEX_CHAR || o == JFlexTypes.FLEX_STRING || o == JFlexTypes.FLEX_NUMBER || o == JFlexTypes.FLEX_RAW || o == JFlexTypes.FLEX_VERSION) {
                    return null;
                }
                String text = o.toString();
                return text.length() == 1 || inMacro && text.startsWith("%") || !inMacro && text.startsWith("[") ? null : text;
            }
        };
        file.putUserData(GeneratedParserUtilBase.COMPLETION_STATE_KEY, (Object)state);
        TreeUtil.ensureParsed((ASTNode)file.getNode());
        return state.items;
    }

    private static LookupElement createKeywordLookupItem(PsiFile psiFile, String keyword) {
        boolean braces;
        LookupElementBuilder builder = LookupElementBuilder.create((String)keyword.toLowerCase()).withCaseSensitivity(false).bold();
        boolean bl = braces = keyword.endsWith("{") || keyword.endsWith("}");
        if (!braces) {
            return keyword.startsWith("%") ? TailTypeDecorator.withTail((LookupElement)builder, (TailType)TailType.SPACE) : builder;
        }
        String closing = keyword.endsWith("{") ? keyword.substring(0, keyword.length() - 1) + "}" : null;
        return PrioritizedLookupElement.withPriority((LookupElement)builder.withInsertHandler((context, item) -> {
            int caret = context.getTailOffset();
            Document document = context.getDocument();
            StringBuilder sb = new StringBuilder("\n");
            caret += sb.length();
            if (closing != null) {
                int indentSize = ((CommonCodeStyleSettings.IndentOptions)ObjectUtils.notNull((Object)CodeStyle.getLanguageSettings((PsiFile)psiFile).getIndentOptions(), (Object)CommonCodeStyleSettings.IndentOptions.DEFAULT_INDENT_OPTIONS)).INDENT_SIZE;
                sb.append(StringUtil.repeat((String)" ", (int)indentSize));
                caret += indentSize;
                sb.append("\n").append(closing).append("\n");
            }
            document.insertString(context.getTailOffset(), (CharSequence)sb);
            context.getEditor().getCaretModel().moveToOffset(caret);
        }), (double)(1.0 / (double)keyword.length()));
    }
}

