/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.jflex.editor;

import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewModelBase;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.util.treeView.smartTree.SortableTreeElement;
import com.intellij.lang.PsiStructureViewFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import org.intellij.jflex.psi.JFlexExpression;
import org.intellij.jflex.psi.JFlexFileSection;
import org.intellij.jflex.psi.JFlexMacroDefinition;
import org.intellij.jflex.psi.JFlexOption;
import org.intellij.jflex.psi.JFlexRule;
import org.intellij.jflex.psi.JFlexStateList;
import org.intellij.jflex.psi.impl.JFlexFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JFlexStructureViewFactory
implements PsiStructureViewFactory {
    public StructureViewBuilder getStructureViewBuilder(final @NotNull PsiFile psiFile) {
        return new TreeBasedStructureViewBuilder(){

            @NotNull
            public StructureViewModel createStructureViewModel(@Nullable Editor editor) {
                return new MyModel(psiFile);
            }

            public boolean isRootNodeShown() {
                return false;
            }
        };
    }

    static class MyElement
    extends PsiTreeElementBase<PsiElement>
    implements SortableTreeElement {
        MyElement(PsiElement element) {
            super(element);
        }

        @NotNull
        public String getAlphaSortKey() {
            return StringUtil.notNullize((String)this.getPresentableText());
        }

        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            PsiElement o = this.getElement();
            if (o == null) {
                return Collections.emptyList();
            }
            if (o instanceof JFlexFile) {
                return ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)o).expand(Conditions.instanceOf((Class[])new Class[]{JFlexFile.class, JFlexFileSection.class}))).traverse().filter(Conditions.instanceOf((Class[])MyModel.CLASSES)).map(MyElement::new).addAllTo(new ArrayList());
            }
            if (o instanceof JFlexRule) {
                return SyntaxTraverser.psiApi().children((Object)o).filter(Conditions.instanceOf((Class[])MyModel.CLASSES)).map(MyElement::new).addAllTo(new ArrayList());
            }
            return Collections.emptyList();
        }

        public String getPresentableText() {
            PsiElement o = this.getElement();
            if (o == null) {
                return null;
            }
            if (o instanceof JFlexFile) {
                return ((JFlexFile)o).getName();
            }
            if (o instanceof JFlexOption) {
                return StringUtil.trimEnd((String)o.getFirstChild().getText(), (String)"{");
            }
            if (o instanceof JFlexMacroDefinition) {
                return ((JFlexMacroDefinition)o).getName();
            }
            if (o instanceof JFlexRule) {
                JFlexStateList states = ((JFlexRule)o).getStateList();
                JFlexExpression expr = ((JFlexRule)o).getExpression();
                StringBuilder sb = new StringBuilder();
                if (states != null) {
                    sb.append("<");
                    sb.append(StringUtil.join((Iterable)JBIterable.from(states.getStateReferenceList()).map(PsiElement::getText), (String)", "));
                    sb.append(">");
                }
                if (expr != null) {
                    if (states != null) {
                        sb.append(" ");
                    }
                    sb.append(StringUtil.firstLast((String)expr.getText(), (int)40));
                }
                return sb.toString();
            }
            return o.getClass().getSimpleName();
        }

        public Icon getIcon(boolean open) {
            PsiElement o = this.getElement();
            if (o == null) {
                return null;
            }
            return o.getIcon(0);
        }
    }

    static class MyModel
    extends StructureViewModelBase
    implements StructureViewModel.ElementInfoProvider {
        static final Class<?>[] CLASSES = new Class[]{JFlexOption.class, JFlexMacroDefinition.class, JFlexRule.class};

        protected MyModel(@NotNull PsiFile psiFile) {
            super(psiFile, (StructureViewTreeElement)new MyElement((PsiElement)psiFile));
            this.withSuitableClasses(CLASSES);
        }

        public boolean isAlwaysShowsPlus(StructureViewTreeElement element) {
            return false;
        }

        public boolean isAlwaysLeaf(StructureViewTreeElement element) {
            Object o = element.getValue();
            return o instanceof JFlexOption || o instanceof JFlexMacroDefinition;
        }

        public boolean shouldEnterElement(Object element) {
            return false;
        }
    }
}

